/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jeecg.dingtalk.api.base.JdtBaseAPI;
import com.jeecg.dingtalk.api.core.response.Response;
import com.jeecg.dingtalk.api.core.vo.AccessToken;
import com.jeecg.dingtalk.api.core.vo.PageResult;
import com.jeecg.dingtalk.api.department.JdtDepartmentAPI;
import com.jeecg.dingtalk.api.department.vo.Department;
import com.jeecg.dingtalk.api.message.JdtMessageAPI;
import com.jeecg.dingtalk.api.message.vo.ActionCardMessage;
import com.jeecg.dingtalk.api.message.vo.Message;
import com.jeecg.dingtalk.api.message.vo.SuperMessage;
import com.jeecg.dingtalk.api.message.vo.TextMessage;
import com.jeecg.dingtalk.api.user.JdtUserAPI;
import com.jeecg.dingtalk.api.user.body.GetUserListBody;
import com.jeecg.dingtalk.api.user.vo.User;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jeecg.common.api.dto.message.MessageDTO;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.util.PasswordUtil;
import org.jeecg.common.util.RestUtil;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.thirdapp.ThirdAppConfig;
import org.jeecg.modules.system.entity.SysAnnouncement;
import org.jeecg.modules.system.entity.SysAnnouncementSend;
import org.jeecg.modules.system.entity.SysDepart;
import org.jeecg.modules.system.entity.SysPosition;
import org.jeecg.modules.system.entity.SysThirdAccount;
import org.jeecg.modules.system.entity.SysUser;
import org.jeecg.modules.system.entity.SysUserDepart;
import org.jeecg.modules.system.mapper.SysAnnouncementSendMapper;
import org.jeecg.modules.system.model.SysDepartTreeModel;
import org.jeecg.modules.system.service.ISysDepartService;
import org.jeecg.modules.system.service.ISysPositionService;
import org.jeecg.modules.system.service.ISysThirdAccountService;
import org.jeecg.modules.system.service.ISysUserDepartService;
import org.jeecg.modules.system.service.ISysUserService;
import org.jeecg.modules.system.service.IThirdAppService;
import org.jeecg.modules.system.vo.thirdapp.JdtDepartmentTreeVo;
import org.jeecg.modules.system.vo.thirdapp.SyncInfoVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;

@Service
public class ThirdAppDingtalkServiceImpl
implements IThirdAppService {
    private static final Logger log = LoggerFactory.getLogger(ThirdAppDingtalkServiceImpl.class);
    @Autowired
    ThirdAppConfig thirdAppConfig;
    @Autowired
    private ISysDepartService sysDepartService;
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private ISysThirdAccountService sysThirdAccountService;
    @Autowired
    private ISysUserDepartService sysUserDepartService;
    @Autowired
    private ISysPositionService sysPositionService;
    @Autowired
    private SysAnnouncementSendMapper sysAnnouncementSendMapper;

    @Override
    public String getAccessToken() {
        String appSecret;
        String appKey = this.thirdAppConfig.getDingtalk().getClientId();
        AccessToken accessToken = JdtBaseAPI.getAccessToken((String)appKey, (String)(appSecret = this.thirdAppConfig.getDingtalk().getClientSecret()));
        if (accessToken != null) {
            return accessToken.getAccessToken();
        }
        log.warn("\u83b7\u53d6AccessToken\u5931\u8d25");
        return null;
    }

    @Override
    public boolean syncLocalDepartmentToThirdApp(String ids) {
        String accessToken = this.getAccessToken();
        if (accessToken == null) {
            return false;
        }
        List departments = JdtDepartmentAPI.listAll((String)accessToken);
        List sysDepartList = this.sysDepartService.list();
        block0: for (Department department : departments) {
            for (SysDepart depart : sysDepartList) {
                String sourceIdentifier = department.getSource_identifier();
                if (sourceIdentifier == null || !sourceIdentifier.equals(depart.getId())) continue;
                continue block0;
            }
            int deptId = department.getDept_id();
            Response userIdRes = JdtUserAPI.getUserListIdByDeptId((int)deptId, (String)accessToken);
            if (userIdRes.isSuccess() && ((List)userIdRes.getResult()).size() > 0) {
                for (String userId : (List)userIdRes.getResult()) {
                    User updateUser = new User();
                    updateUser.setUserid(userId);
                    updateUser.setDept_id_list(new Integer[]{1});
                    JdtUserAPI.update((User)updateUser, (String)accessToken);
                }
            }
            JdtDepartmentAPI.delete((int)deptId, (String)accessToken);
        }
        List<SysDepartTreeModel> sysDepartsTree = this.sysDepartService.queryTreeList();
        Department parent = new Department();
        parent.setDept_id(Integer.valueOf(1));
        departments = JdtDepartmentAPI.listAll((String)accessToken);
        this.syncDepartmentRecursion(sysDepartsTree, departments, parent, accessToken);
        return true;
    }

    public void syncDepartmentRecursion(List<SysDepartTreeModel> sysDepartsTree, List<Department> departments, Department parent, String accessToken) {
        if (sysDepartsTree != null && sysDepartsTree.size() != 0) {
            block0: for (SysDepartTreeModel depart : sysDepartsTree) {
                for (Department department : departments) {
                    String sourceIdentifier = department.getSource_identifier();
                    if (sourceIdentifier == null || !sourceIdentifier.equals(depart.getId())) continue;
                    this.sysDepartToDtDepartment(depart, department, parent.getDept_id());
                    JdtDepartmentAPI.update((Department)department, (String)accessToken);
                    this.syncDepartmentRecursion(depart.getChildren(), departments, department, accessToken);
                    continue block0;
                }
                Department newDepartment = this.sysDepartToDtDepartment(depart, parent.getDept_id());
                Response response = JdtDepartmentAPI.create((Department)newDepartment, (String)accessToken);
                if (response.getResult() == null) continue;
                Department newParent = new Department();
                newParent.setDept_id((Integer)response.getResult());
                this.syncDepartmentRecursion(depart.getChildren(), departments, newParent, accessToken);
            }
        }
    }

    @Override
    public SyncInfoVo syncThirdAppDepartmentToLocal(String ids) {
        SyncInfoVo syncInfo = new SyncInfoVo();
        String accessToken = this.getAccessToken();
        if (accessToken == null) {
            syncInfo.addFailInfo("accessToken\u83b7\u53d6\u5931\u8d25\uff01");
            return syncInfo;
        }
        List departments = JdtDepartmentAPI.listAll((String)accessToken);
        String username = JwtUtil.getUserNameByToken((HttpServletRequest)SpringContextUtils.getHttpServletRequest());
        List<JdtDepartmentTreeVo> departmentTreeList = JdtDepartmentTreeVo.listToTree(departments);
        this.syncDepartmentToLocalRecursion(departmentTreeList, null, username, syncInfo, accessToken);
        return syncInfo;
    }

    public void syncDepartmentToLocalRecursion(List<JdtDepartmentTreeVo> departmentTreeList, String sysParentId, String username, SyncInfoVo syncInfo, String accessToken) {
        if (departmentTreeList != null && departmentTreeList.size() != 0) {
            for (JdtDepartmentTreeVo departmentTree : departmentTreeList) {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(SysDepart::getId, (Object)departmentTree.getSource_identifier());
                SysDepart sysDepart = (SysDepart)this.sysDepartService.getOne((Wrapper)queryWrapper);
                if (sysDepart != null) {
                    SysDepart updateSysDepart = this.dtDepartmentToSysDepart(departmentTree, sysDepart);
                    if (sysParentId != null) {
                        updateSysDepart.setParentId(sysParentId);
                    }
                    try {
                        this.sysDepartService.updateDepartDataById(updateSysDepart, username);
                        String str = String.format("\u90e8\u95e8 %s \u66f4\u65b0\u6210\u529f\uff01", updateSysDepart.getDepartName());
                        syncInfo.addSuccessInfo(str);
                    }
                    catch (Exception e) {
                        this.syncDepartCollectErrInfo(e, departmentTree, syncInfo);
                    }
                    if (!departmentTree.hasChildren()) continue;
                    this.syncDepartmentToLocalRecursion(departmentTree.getChildren(), updateSysDepart.getId(), username, syncInfo, accessToken);
                    continue;
                }
                SysDepart newSysDepart = this.dtDepartmentToSysDepart(departmentTree, null);
                if (sysParentId != null) {
                    newSysDepart.setParentId(sysParentId);
                }
                try {
                    this.sysDepartService.saveDepartData(newSysDepart, username);
                    Department updateDtDepart = new Department();
                    updateDtDepart.setDept_id(departmentTree.getDept_id());
                    updateDtDepart.setSource_identifier(newSysDepart.getId());
                    Response response = JdtDepartmentAPI.update((Department)updateDtDepart, (String)accessToken);
                    if (!response.isSuccess()) {
                        throw new RuntimeException(response.getErrmsg());
                    }
                    String str = String.format("\u90e8\u95e8 %s \u521b\u5efa\u6210\u529f\uff01", newSysDepart.getDepartName());
                    syncInfo.addSuccessInfo(str);
                }
                catch (Exception e) {
                    this.syncDepartCollectErrInfo(e, departmentTree, syncInfo);
                }
                if (!departmentTree.hasChildren()) continue;
                this.syncDepartmentToLocalRecursion(departmentTree.getChildren(), newSysDepart.getId(), username, syncInfo, accessToken);
            }
        }
    }

    private boolean syncDepartCollectErrInfo(Exception e, Department department, SyncInfoVo syncInfo) {
        String msg = e instanceof DuplicateKeyException ? e.getCause().getMessage() : e.getMessage();
        String str = String.format("\u90e8\u95e8 %s(%s) \u540c\u6b65\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a%s", department.getName(), department.getDept_id(), msg);
        syncInfo.addFailInfo(str);
        return false;
    }

    @Override
    public SyncInfoVo syncLocalUserToThirdApp(String ids) {
        List sysUsers;
        SyncInfoVo syncInfo = new SyncInfoVo();
        String accessToken = this.getAccessToken();
        if (accessToken == null) {
            syncInfo.addFailInfo("accessToken\u83b7\u53d6\u5931\u8d25\uff01");
            return syncInfo;
        }
        if (StringUtils.isNotBlank((String)ids)) {
            String[] idList = ids.split(",");
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(SysUser::getId, (Object[])idList);
            sysUsers = this.sysUserService.list((Wrapper)queryWrapper);
        } else {
            sysUsers = this.sysUserService.list();
        }
        List allDepartment = JdtDepartmentAPI.listAll((String)accessToken);
        for (SysUser sysUser : sysUsers) {
            boolean apiSuccess;
            String dtUserId;
            Response thirdUserId;
            if ("_reserve_user_external".equals(sysUser.getUsername())) continue;
            SysThirdAccount sysThirdAccount = this.sysThirdAccountService.getOneBySysUserId(sysUser.getId(), "DINGTALK".toLowerCase());
            Response dtUserInfo = sysThirdAccount != null && oConvertUtils.isNotEmpty((Object)sysThirdAccount.getThirdUserId()) ? JdtUserAPI.getUserById((String)sysThirdAccount.getThirdUserId(), (String)accessToken) : ((thirdUserId = JdtUserAPI.getUseridByMobile((String)sysUser.getPhone(), (String)accessToken)).isSuccess() && oConvertUtils.isNotEmpty((Object)thirdUserId.getResult()) ? JdtUserAPI.getUserById((String)((String)thirdUserId.getResult()), (String)accessToken) : JdtUserAPI.getUserById((String)sysUser.getUsername(), (String)accessToken));
            if (dtUserInfo != null && dtUserInfo.isSuccess() && dtUserInfo.getResult() != null) {
                User dtUser = (User)dtUserInfo.getResult();
                dtUserId = dtUser.getUserid();
                User updateQwUser = this.sysUserToDtUser(sysUser, dtUser, allDepartment);
                Response updateRes = JdtUserAPI.update((User)updateQwUser, (String)accessToken);
                apiSuccess = this.syncUserCollectErrInfo(updateRes, sysUser, syncInfo);
            } else {
                User newQwUser = this.sysUserToDtUser(sysUser, allDepartment);
                Response createRes = JdtUserAPI.create((User)newQwUser, (String)accessToken);
                dtUserId = (String)createRes.getResult();
                apiSuccess = this.syncUserCollectErrInfo(createRes, sysUser, syncInfo);
            }
            if (!apiSuccess || sysThirdAccount != null && !oConvertUtils.isEmpty((Object)sysThirdAccount.getThirdUserId())) continue;
            if (sysThirdAccount == null) {
                sysThirdAccount = new SysThirdAccount();
                sysThirdAccount.setSysUserId(sysUser.getId());
                sysThirdAccount.setStatus(1);
                sysThirdAccount.setDelFlag(0);
                sysThirdAccount.setThirdType("DINGTALK".toLowerCase());
            }
            sysThirdAccount.setThirdUserId(dtUserId);
            this.sysThirdAccountService.saveOrUpdate(sysThirdAccount);
        }
        return syncInfo;
    }

    @Override
    public SyncInfoVo syncThirdAppUserToLocal() {
        SyncInfoVo syncInfo = new SyncInfoVo();
        String accessToken = this.getAccessToken();
        if (accessToken == null) {
            syncInfo.addFailInfo("accessToken\u83b7\u53d6\u5931\u8d25\uff01");
            return syncInfo;
        }
        List sysUsersList = this.sysUserService.list();
        List allDepartment = JdtDepartmentAPI.listAll((String)accessToken);
        List<User> ddUserList = this.getDtAllUserByDepartment(allDepartment, accessToken);
        for (User dtUserInfo : ddUserList) {
            SysThirdAccount sysThirdAccount = this.sysThirdAccountService.getOneByThirdUserId(dtUserInfo.getUserid(), "DINGTALK".toLowerCase());
            List collect = sysUsersList.stream().filter(user -> dtUserInfo.getMobile().equals(user.getPhone()) || dtUserInfo.getUserid().equals(user.getUsername())).collect(Collectors.toList());
            if (collect != null && collect.size() > 0) {
                SysUser sysUserTemp = (SysUser)collect.get(0);
                SysUser updateSysUser = this.dtUserToSysUser(dtUserInfo, sysUserTemp);
                try {
                    this.sysUserService.updateById(updateSysUser);
                    String str = String.format("\u7528\u6237 %s(%s) \u66f4\u65b0\u6210\u529f\uff01", updateSysUser.getRealname(), updateSysUser.getUsername());
                    syncInfo.addSuccessInfo(str);
                }
                catch (Exception e) {
                    this.syncUserCollectErrInfo(e, dtUserInfo, syncInfo);
                }
                this.thirdAccountSaveOrUpdate(sysThirdAccount, updateSysUser.getId(), dtUserInfo.getUserid());
                continue;
            }
            SysUser newSysUser = this.dtUserToSysUser(dtUserInfo);
            try {
                this.sysUserService.save(newSysUser);
                String str = String.format("\u7528\u6237 %s(%s) \u521b\u5efa\u6210\u529f\uff01", newSysUser.getRealname(), newSysUser.getUsername());
                syncInfo.addSuccessInfo(str);
            }
            catch (Exception e) {
                this.syncUserCollectErrInfo(e, dtUserInfo, syncInfo);
            }
            this.thirdAccountSaveOrUpdate(null, newSysUser.getId(), dtUserInfo.getUserid());
        }
        return syncInfo;
    }

    private List<User> getDtAllUserByDepartment(List<Department> allDepartment, String accessToken) {
        ArrayList<User> userList = new ArrayList<User>();
        for (Department department : allDepartment) {
            this.getUserListByDeptIdRecursion(department.getDept_id(), 0, userList, accessToken);
        }
        return userList;
    }

    private void getUserListByDeptIdRecursion(int deptId, int cursor, List<User> userList, String accessToken) {
        GetUserListBody getUserListBody = new GetUserListBody(deptId, cursor, 100);
        Response response = JdtUserAPI.getUserListByDeptId((GetUserListBody)getUserListBody, (String)accessToken);
        if (response.isSuccess()) {
            PageResult page = (PageResult)response.getResult();
            userList.addAll(page.getList());
            if (page.getHas_more().booleanValue()) {
                this.getUserListByDeptIdRecursion(deptId, page.getNext_cursor(), userList, accessToken);
            }
        }
    }

    private void thirdAccountSaveOrUpdate(SysThirdAccount sysThirdAccount, String sysUserId, String dtUserId) {
        if (sysThirdAccount == null) {
            sysThirdAccount = new SysThirdAccount();
            sysThirdAccount.setSysUserId(sysUserId);
            sysThirdAccount.setStatus(1);
            sysThirdAccount.setDelFlag(0);
            sysThirdAccount.setThirdType("DINGTALK".toLowerCase());
        }
        sysThirdAccount.setThirdUserId(dtUserId);
        this.sysThirdAccountService.saveOrUpdate(sysThirdAccount);
    }

    private boolean syncUserCollectErrInfo(Response<?> response, SysUser sysUser, SyncInfoVo syncInfo) {
        if (!response.isSuccess()) {
            String str = String.format("\u7528\u6237 %s(%s) \u540c\u6b65\u5931\u8d25\uff01\u9519\u8bef\u7801\uff1a%s\u2014\u2014%s", sysUser.getUsername(), sysUser.getRealname(), response.getErrcode(), response.getErrmsg());
            syncInfo.addFailInfo(str);
            return false;
        }
        String str = String.format("\u7528\u6237 %s(%s) \u540c\u6b65\u6210\u529f\uff01", sysUser.getUsername(), sysUser.getRealname());
        syncInfo.addSuccessInfo(str);
        return true;
    }

    private boolean syncUserCollectErrInfo(Exception e, User dtUser, SyncInfoVo syncInfo) {
        String msg = e instanceof DuplicateKeyException ? e.getCause().getMessage() : e.getMessage();
        String str = String.format("\u7528\u6237 %s(%s) \u540c\u6b65\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a%s", dtUser.getUserid(), dtUser.getName(), msg);
        syncInfo.addFailInfo(str);
        return false;
    }

    private User sysUserToDtUser(SysUser sysUser, List<Department> allDepartment) {
        User user = new User();
        user.setUserid(sysUser.getUsername());
        return this.sysUserToDtUser(sysUser, user, allDepartment);
    }

    private User sysUserToDtUser(SysUser sysUser, User user, List<Department> allDepartment) {
        SysPosition position;
        user.setName(sysUser.getRealname());
        user.setMobile(sysUser.getPhone());
        user.setTelephone(sysUser.getTelephone());
        user.setJob_number(sysUser.getWorkNo());
        if (oConvertUtils.isNotEmpty((Object)sysUser.getPost()) && (position = this.sysPositionService.getByCode(sysUser.getPost())) != null) {
            user.setTitle(position.getName());
        }
        user.setEmail(sysUser.getEmail());
        List<SysDepart> departList = this.getUserDepart(sysUser);
        if (departList != null) {
            ArrayList<Integer> departmentIdList = new ArrayList<Integer>();
            for (SysDepart sysDepart : departList) {
                Department department = this.getDepartmentByDepartId(sysDepart.getId(), allDepartment);
                if (department == null) continue;
                departmentIdList.add(department.getDept_id());
            }
            user.setDept_id_list(departmentIdList.toArray(new Integer[0]));
            user.setDept_order_list(null);
        }
        if (oConvertUtils.isEmpty((Object)user.getDept_id_list())) {
            user.setDept_id_list(new Integer[]{1});
            user.setDept_order_list(null);
        }
        return user;
    }

    private SysUser dtUserToSysUser(User dtUser) {
        SysUser sysUser = new SysUser();
        sysUser.setDelFlag(0);
        sysUser.setUsername(dtUser.getUserid());
        String password = "123456";
        String salt = oConvertUtils.randomGen((int)8);
        String passwordEncode = PasswordUtil.encrypt((String)sysUser.getUsername(), (String)password, (String)salt);
        sysUser.setSalt(salt);
        sysUser.setPassword(passwordEncode);
        return this.dtUserToSysUser(dtUser, sysUser);
    }

    private SysUser dtUserToSysUser(User dtUser, SysUser oldSysUser) {
        SysUser sysUser = new SysUser();
        BeanUtils.copyProperties((Object)oldSysUser, (Object)sysUser);
        sysUser.setRealname(dtUser.getName());
        sysUser.setPhone(dtUser.getMobile());
        sysUser.setTelephone(dtUser.getTelephone());
        if (oConvertUtils.isNotEmpty((Object)dtUser.getEmail()) && !dtUser.getEmail().equals(sysUser.getEmail())) {
            sysUser.setEmail(dtUser.getEmail());
        } else {
            sysUser.setEmail(null);
        }
        if (oConvertUtils.isNotEmpty((Object)dtUser.getMobile()) && !dtUser.getMobile().equals(sysUser.getPhone())) {
            sysUser.setPhone(dtUser.getMobile());
        } else {
            sysUser.setPhone(null);
        }
        sysUser.setWorkNo(null);
        return sysUser;
    }

    private List<SysDepart> getUserDepart(SysUser sysUser) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysUserDepart::getUserId, (Object)sysUser.getId());
        List sysUserDepartList = this.sysUserDepartService.list((Wrapper)queryWrapper);
        if (sysUserDepartList.size() == 0) {
            return null;
        }
        LambdaQueryWrapper departQueryWrapper = new LambdaQueryWrapper();
        List departIdList = sysUserDepartList.stream().map(SysUserDepart::getDepId).collect(Collectors.toList());
        departQueryWrapper.in(SysDepart::getId, departIdList);
        List departList = this.sysDepartService.list((Wrapper)departQueryWrapper);
        return departList.size() == 0 ? null : departList;
    }

    private Department getDepartmentByDepartId(String departId, List<Department> allDepartment) {
        for (Department department : allDepartment) {
            if (!departId.equals(department.getSource_identifier())) continue;
            return department;
        }
        return null;
    }

    private Department sysDepartToDtDepartment(SysDepartTreeModel departTree, Integer parentId) {
        Department department = new Department();
        department.setSource_identifier(departTree.getId());
        return this.sysDepartToDtDepartment(departTree, department, parentId);
    }

    private Department sysDepartToDtDepartment(SysDepartTreeModel departTree, Department department, Integer parentId) {
        department.setName(departTree.getDepartName());
        department.setParent_id(parentId);
        department.setOrder(departTree.getDepartOrder());
        return department;
    }

    private SysDepart dtDepartmentToSysDepart(Department department, SysDepart departTree) {
        SysDepart sysDepart = new SysDepart();
        if (departTree != null) {
            BeanUtils.copyProperties((Object)departTree, (Object)sysDepart);
        }
        sysDepart.setDepartName(department.getName());
        sysDepart.setDepartOrder(department.getOrder());
        return sysDepart;
    }

    @Override
    public int removeThirdAppUser(List<String> userIdList) {
        if (!this.thirdAppConfig.isDingtalkEnabled()) {
            return -1;
        }
        int count = 0;
        if (userIdList != null && userIdList.size() > 0) {
            String accessToken = this.getAccessToken();
            if (accessToken == null) {
                return count;
            }
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysThirdAccount::getThirdType, (Object)"DINGTALK".toLowerCase());
            queryWrapper.in(SysThirdAccount::getSysUserId, userIdList);
            List thirdAccountList = this.sysThirdAccountService.list((Wrapper)queryWrapper);
            List thirdUserIdList = thirdAccountList.stream().map(SysThirdAccount::getThirdUserId).collect(Collectors.toList());
            for (String thirdUserId : thirdUserIdList) {
                Response response;
                if (!oConvertUtils.isNotEmpty((Object)thirdUserId) || (response = JdtUserAPI.delete((String)thirdUserId, (String)accessToken)).getErrcode() != 0) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public boolean sendMessage(MessageDTO message) {
        return this.sendMessage(message, false);
    }

    @Override
    public boolean sendMessage(MessageDTO message, boolean verifyConfig) {
        Response<String> response = this.sendMessageResponse(message, verifyConfig);
        if (response != null) {
            return response.isSuccess();
        }
        return false;
    }

    public Response<String> sendMessageResponse(MessageDTO message, boolean verifyConfig) {
        if (verifyConfig && !this.thirdAppConfig.isDingtalkEnabled()) {
            return null;
        }
        String accessToken = this.getAccessToken();
        if (accessToken == null) {
            return null;
        }
        String content = message.getContent();
        int agentId = this.thirdAppConfig.getDingtalk().getAgentIdInt();
        Message textMessage = new Message(Integer.valueOf(agentId), (SuperMessage)new TextMessage(content));
        if (message.isToAll()) {
            textMessage.setTo_all_user(Boolean.valueOf(true));
        } else {
            String[] toUsers = message.getToUser().split(",");
            List<SysThirdAccount> thirdAccountList = this.sysThirdAccountService.listThirdUserIdByUsername(toUsers, "DINGTALK".toLowerCase());
            List dtUserIds = thirdAccountList.stream().map(SysThirdAccount::getThirdUserId).collect(Collectors.toList());
            textMessage.setUserid_list(dtUserIds);
        }
        return JdtMessageAPI.sendTextMessage((Message)textMessage, (String)accessToken);
    }

    public boolean recallMessage(String msg_task_id) {
        Response<JSONObject> response = this.recallMessageResponse(msg_task_id);
        if (response == null) {
            return false;
        }
        return response.isSuccess();
    }

    public Response<JSONObject> recallMessageResponse(String msg_task_id) {
        String accessToken = this.getAccessToken();
        if (accessToken == null) {
            return null;
        }
        int agentId = this.thirdAppConfig.getDingtalk().getAgentIdInt();
        return JdtMessageAPI.recallMessage((int)agentId, (String)msg_task_id, (String)this.getAccessToken());
    }

    public Response<String> sendActionCardMessage(SysAnnouncement announcement, boolean verifyConfig) {
        if (verifyConfig && !this.thirdAppConfig.isDingtalkEnabled()) {
            return null;
        }
        String accessToken = this.getAccessToken();
        if (accessToken == null) {
            return null;
        }
        int agentId = this.thirdAppConfig.getDingtalk().getAgentIdInt();
        String markdown = "### " + announcement.getTitile() + "\n" + oConvertUtils.getString((String)announcement.getMsgAbstract(), (String)"\u7a7a");
        ActionCardMessage actionCard = new ActionCardMessage(markdown);
        actionCard.setTitle(announcement.getTitile());
        actionCard.setSingle_title("\u8be6\u60c5");
        actionCard.setSingle_url(RestUtil.getBaseUrl() + "/sys/annountCement/show/" + announcement.getId());
        Message actionCardMessage = new Message(Integer.valueOf(agentId), (SuperMessage)actionCard);
        if ("ALL".equals(announcement.getMsgType())) {
            actionCardMessage.setTo_all_user(Boolean.valueOf(true));
            return JdtMessageAPI.sendActionCardMessage((Message)actionCardMessage, (String)accessToken);
        }
        String[] userIds = null;
        String userId = announcement.getUserIds();
        if (oConvertUtils.isNotEmpty((Object)userId)) {
            userIds = userId.substring(0, userId.length() - 1).split(",");
        } else {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysAnnouncementSend::getAnntId, (Object)announcement.getId());
            SysAnnouncementSend sysAnnouncementSend = (SysAnnouncementSend)this.sysAnnouncementSendMapper.selectOne((Wrapper)queryWrapper);
            userIds = new String[]{sysAnnouncementSend.getUserId()};
        }
        if (userIds != null) {
            String[] usernameList = this.sysUserService.userIdToUsername(Arrays.asList(userIds)).toArray(new String[0]);
            List<SysThirdAccount> thirdAccountList = this.sysThirdAccountService.listThirdUserIdByUsername(usernameList, "DINGTALK".toLowerCase());
            List dtUserIds = thirdAccountList.stream().map(SysThirdAccount::getThirdUserId).collect(Collectors.toList());
            actionCardMessage.setUserid_list(dtUserIds);
            return JdtMessageAPI.sendActionCardMessage((Message)actionCardMessage, (String)accessToken);
        }
        return null;
    }
}

