/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.system.vo.SysUserCacheInfo;
import org.jeecg.common.util.PasswordUtil;
import org.jeecg.common.util.UUIDGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.base.service.BaseCommonService;
import org.jeecg.modules.system.entity.SysDepart;
import org.jeecg.modules.system.entity.SysDepartRole;
import org.jeecg.modules.system.entity.SysDepartRoleUser;
import org.jeecg.modules.system.entity.SysPermission;
import org.jeecg.modules.system.entity.SysRole;
import org.jeecg.modules.system.entity.SysThirdAccount;
import org.jeecg.modules.system.entity.SysUser;
import org.jeecg.modules.system.entity.SysUserDepart;
import org.jeecg.modules.system.entity.SysUserRole;
import org.jeecg.modules.system.mapper.SysDepartMapper;
import org.jeecg.modules.system.mapper.SysDepartRoleMapper;
import org.jeecg.modules.system.mapper.SysDepartRoleUserMapper;
import org.jeecg.modules.system.mapper.SysPermissionMapper;
import org.jeecg.modules.system.mapper.SysRoleMapper;
import org.jeecg.modules.system.mapper.SysThirdAccountMapper;
import org.jeecg.modules.system.mapper.SysUserDepartMapper;
import org.jeecg.modules.system.mapper.SysUserMapper;
import org.jeecg.modules.system.mapper.SysUserRoleMapper;
import org.jeecg.modules.system.model.SysUserSysDepartModel;
import org.jeecg.modules.system.service.ISysUserService;
import org.jeecg.modules.system.service.impl.ThirdAppDingtalkServiceImpl;
import org.jeecg.modules.system.service.impl.ThirdAppWechatEnterpriseServiceImpl;
import org.jeecg.modules.system.vo.SysUserDepVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysUserServiceImpl
extends ServiceImpl<SysUserMapper, SysUser>
implements ISysUserService {
    private static final Logger log = LoggerFactory.getLogger(SysUserServiceImpl.class);
    @Autowired
    private SysUserMapper userMapper;
    @Autowired
    private SysPermissionMapper sysPermissionMapper;
    @Autowired
    private SysUserRoleMapper sysUserRoleMapper;
    @Autowired
    private SysUserDepartMapper sysUserDepartMapper;
    @Autowired
    private ISysBaseAPI sysBaseAPI;
    @Autowired
    private SysDepartMapper sysDepartMapper;
    @Autowired
    private SysRoleMapper sysRoleMapper;
    @Autowired
    private SysDepartRoleUserMapper departRoleUserMapper;
    @Autowired
    private SysDepartRoleMapper sysDepartRoleMapper;
    @Resource
    private BaseCommonService baseCommonService;
    @Autowired
    private SysThirdAccountMapper sysThirdAccountMapper;
    @Autowired
    ThirdAppWechatEnterpriseServiceImpl wechatEnterpriseService;
    @Autowired
    ThirdAppDingtalkServiceImpl dingtalkService;

    @Override
    @CacheEvict(value={"sys:cache:user"}, allEntries=true)
    public Result<?> resetPassword(String username, String oldpassword, String newpassword, String confirmpassword) {
        SysUser user = this.userMapper.getUserByName(username);
        String passwordEncode = PasswordUtil.encrypt((String)username, (String)oldpassword, (String)user.getSalt());
        if (!user.getPassword().equals(passwordEncode)) {
            return Result.error((String)"\u65e7\u5bc6\u7801\u8f93\u5165\u9519\u8bef!");
        }
        if (oConvertUtils.isEmpty((Object)newpassword)) {
            return Result.error((String)"\u65b0\u5bc6\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a!");
        }
        if (!newpassword.equals(confirmpassword)) {
            return Result.error((String)"\u4e24\u6b21\u8f93\u5165\u5bc6\u7801\u4e0d\u4e00\u81f4!");
        }
        String password = PasswordUtil.encrypt((String)username, (String)newpassword, (String)user.getSalt());
        this.userMapper.update(new SysUser().setPassword(password), (Wrapper)new LambdaQueryWrapper().eq(SysUser::getId, (Object)user.getId()));
        return Result.ok((String)"\u5bc6\u7801\u91cd\u7f6e\u6210\u529f!");
    }

    @Override
    @CacheEvict(value={"sys:cache:user"}, allEntries=true)
    public Result<?> changePassword(SysUser sysUser) {
        String salt = oConvertUtils.randomGen((int)8);
        sysUser.setSalt(salt);
        String password = sysUser.getPassword();
        String passwordEncode = PasswordUtil.encrypt((String)sysUser.getUsername(), (String)password, (String)salt);
        sysUser.setPassword(passwordEncode);
        this.userMapper.updateById(sysUser);
        return Result.ok((String)"\u5bc6\u7801\u4fee\u6539\u6210\u529f!");
    }

    @Override
    @CacheEvict(value={"sys:cache:user"}, allEntries=true)
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteUser(String userId) {
        this.removeById((Serializable)((Object)userId));
        return false;
    }

    @Override
    @CacheEvict(value={"sys:cache:user"}, allEntries=true)
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteBatchUsers(String userIds) {
        this.removeByIds(Arrays.asList(userIds.split(",")));
        return false;
    }

    @Override
    public SysUser getUserByName(String username) {
        return this.userMapper.getUserByName(username);
    }

    @Override
    @Transactional
    public void addUserWithRole(SysUser user, String roles) {
        this.save(user);
        if (oConvertUtils.isNotEmpty((Object)roles)) {
            String[] arr;
            for (String roleId : arr = roles.split(",")) {
                SysUserRole userRole = new SysUserRole(user.getId(), roleId);
                this.sysUserRoleMapper.insert(userRole);
            }
        }
    }

    @Override
    @CacheEvict(value={"sys:cache:user"}, allEntries=true)
    @Transactional
    public void editUserWithRole(SysUser user, String roles) {
        this.updateById(user);
        this.sysUserRoleMapper.delete((Wrapper)new QueryWrapper().lambda().eq(SysUserRole::getUserId, (Object)user.getId()));
        if (oConvertUtils.isNotEmpty((Object)roles)) {
            String[] arr;
            for (String roleId : arr = roles.split(",")) {
                SysUserRole userRole = new SysUserRole(user.getId(), roleId);
                this.sysUserRoleMapper.insert(userRole);
            }
        }
    }

    @Override
    public List<String> getRole(String username) {
        return this.sysUserRoleMapper.getRoleByUserName(username);
    }

    @Override
    public Set<String> getUserRolesSet(String username) {
        List<String> roles = this.sysUserRoleMapper.getRoleByUserName(username);
        log.info("-------\u901a\u8fc7\u6570\u636e\u5e93\u8bfb\u53d6\u7528\u6237\u62e5\u6709\u7684\u89d2\u8272Rules------username\uff1a " + username + ",Roles size: " + (roles == null ? 0 : roles.size()));
        return new HashSet<String>(roles);
    }

    @Override
    public Set<String> getUserPermissionsSet(String username) {
        HashSet<String> permissionSet = new HashSet<String>();
        List<SysPermission> permissionList = this.sysPermissionMapper.queryByUser(username);
        for (SysPermission po : permissionList) {
            if (!oConvertUtils.isNotEmpty((Object)po.getPerms())) continue;
            permissionSet.add(po.getPerms());
        }
        log.info("-------\u901a\u8fc7\u6570\u636e\u5e93\u8bfb\u53d6\u7528\u6237\u62e5\u6709\u7684\u6743\u9650Perms------username\uff1a " + username + ",Perms size: " + (permissionSet == null ? 0 : permissionSet.size()));
        return permissionSet;
    }

    @Override
    public SysUserCacheInfo getCacheUser(String username) {
        SysUserCacheInfo info = new SysUserCacheInfo();
        info.setOneDepart(true);
        LoginUser user = this.sysBaseAPI.getUserByName(username);
        if (user != null) {
            info.setSysUserCode(user.getUsername());
            info.setSysUserName(user.getRealname());
            info.setSysOrgCode(user.getOrgCode());
        }
        List<SysDepart> list = this.sysDepartMapper.queryUserDeparts(user.getId());
        ArrayList<String> sysMultiOrgCode = new ArrayList<String>();
        if (list != null && list.size() != 0) {
            if (list.size() == 1) {
                sysMultiOrgCode.add(list.get(0).getOrgCode());
            } else {
                info.setOneDepart(false);
                for (SysDepart dpt : list) {
                    sysMultiOrgCode.add(dpt.getOrgCode());
                }
            }
        }
        info.setSysMultiOrgCode(sysMultiOrgCode);
        return info;
    }

    @Override
    public IPage<SysUser> getUserByDepId(Page<SysUser> page, String departId, String username) {
        return this.userMapper.getUserByDepId(page, departId, username);
    }

    @Override
    public IPage<SysUser> getUserByDepIds(Page<SysUser> page, List<String> departIds, String username) {
        return this.userMapper.getUserByDepIds(page, departIds, username);
    }

    @Override
    public Map<String, String> getDepNamesByUserIds(List<String> userIds) {
        List<SysUserDepVo> list = ((SysUserMapper)this.baseMapper).getDepNamesByUserIds(userIds);
        HashMap<String, String> res = new HashMap<String, String>();
        list.forEach(item -> {
            if (res.get(item.getUserId()) == null) {
                res.put(item.getUserId(), item.getDepartName());
            } else {
                res.put(item.getUserId(), (String)res.get(item.getUserId()) + "," + item.getDepartName());
            }
        });
        return res;
    }

    @Override
    public IPage<SysUser> getUserByDepartIdAndQueryWrapper(Page<SysUser> page, String departId, QueryWrapper<SysUser> queryWrapper) {
        LambdaQueryWrapper lambdaQueryWrapper = queryWrapper.lambda();
        lambdaQueryWrapper.eq(SysUser::getDelFlag, (Object)CommonConstant.DEL_FLAG_0);
        lambdaQueryWrapper.inSql(SysUser::getId, "SELECT user_id FROM sys_user_depart WHERE dep_id = '" + departId + "'");
        return this.userMapper.selectPage((IPage)page, (Wrapper)lambdaQueryWrapper);
    }

    @Override
    public IPage<SysUserSysDepartModel> queryUserByOrgCode(String orgCode, SysUser userParams, IPage page) {
        List<SysUserSysDepartModel> list = ((SysUserMapper)this.baseMapper).getUserByOrgCode(page, orgCode, userParams);
        Integer total = ((SysUserMapper)this.baseMapper).getUserByOrgCodeTotal(orgCode, userParams);
        Page result = new Page(page.getCurrent(), page.getSize(), (long)total.intValue());
        result.setRecords(list);
        return result;
    }

    @Override
    public IPage<SysUser> getUserByRoleId(Page<SysUser> page, String roleId, String username) {
        return this.userMapper.getUserByRoleId(page, roleId, username);
    }

    @Override
    @CacheEvict(value={"sys:cache:user"}, key="#username")
    public void updateUserDepart(String username, String orgCode) {
        ((SysUserMapper)this.baseMapper).updateUserDepart(username, orgCode);
    }

    @Override
    public SysUser getUserByPhone(String phone) {
        return this.userMapper.getUserByPhone(phone);
    }

    @Override
    public SysUser getUserByEmail(String email) {
        return this.userMapper.getUserByEmail(email);
    }

    @Override
    @Transactional
    public void addUserWithDepart(SysUser user, String selectedParts) {
        if (oConvertUtils.isNotEmpty((Object)selectedParts)) {
            String[] arr;
            for (String deaprtId : arr = selectedParts.split(",")) {
                SysUserDepart userDeaprt = new SysUserDepart(user.getId(), deaprtId);
                this.sysUserDepartMapper.insert(userDeaprt);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(value={"sys:cache:user"}, allEntries=true)
    public void editUserWithDepart(SysUser user, String departs) {
        List userDepartList;
        this.updateById(user);
        String[] arr = new String[]{};
        if (oConvertUtils.isNotEmpty((Object)departs)) {
            arr = departs.split(",");
        }
        if ((userDepartList = this.sysUserDepartMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(SysUserDepart::getUserId, (Object)user.getId()))) != null && userDepartList.size() > 0) {
            for (SysUserDepart depart : userDepartList) {
                List sysDepartRoleList;
                List roleIds;
                if (Arrays.asList(arr).contains(depart.getDepId()) || (roleIds = (sysDepartRoleList = this.sysDepartRoleMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(SysDepartRole::getDepartId, (Object)depart.getDepId()))).stream().map(SysDepartRole::getId).collect(Collectors.toList())) == null || roleIds.size() <= 0) continue;
                this.departRoleUserMapper.delete((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysDepartRoleUser::getUserId, (Object)user.getId())).in(SysDepartRoleUser::getDroleId, roleIds));
            }
        }
        this.sysUserDepartMapper.delete((Wrapper)new QueryWrapper().lambda().eq(SysUserDepart::getUserId, (Object)user.getId()));
        if (oConvertUtils.isNotEmpty((Object)departs)) {
            for (String departId : arr) {
                SysUserDepart userDepart = new SysUserDepart(user.getId(), departId);
                this.sysUserDepartMapper.insert(userDepart);
            }
        }
    }

    public Result<?> checkUserIsEffective(SysUser sysUser) {
        Result result = new Result();
        if (sysUser == null) {
            result.error500("\u8be5\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u8bf7\u6ce8\u518c");
            this.baseCommonService.addLog("\u7528\u6237\u767b\u5f55\u5931\u8d25\uff0c\u7528\u6237\u4e0d\u5b58\u5728\uff01", Integer.valueOf(1), null);
            return result;
        }
        if (CommonConstant.DEL_FLAG_1.equals(sysUser.getDelFlag())) {
            this.baseCommonService.addLog("\u7528\u6237\u767b\u5f55\u5931\u8d25\uff0c\u7528\u6237\u540d:" + sysUser.getUsername() + "\u5df2\u6ce8\u9500\uff01", Integer.valueOf(1), null);
            result.error500("\u8be5\u7528\u6237\u5df2\u6ce8\u9500");
            return result;
        }
        if (CommonConstant.USER_FREEZE.equals(sysUser.getStatus())) {
            this.baseCommonService.addLog("\u7528\u6237\u767b\u5f55\u5931\u8d25\uff0c\u7528\u6237\u540d:" + sysUser.getUsername() + "\u5df2\u51bb\u7ed3\uff01", Integer.valueOf(1), null);
            result.error500("\u8be5\u7528\u6237\u5df2\u51bb\u7ed3");
            return result;
        }
        return result;
    }

    @Override
    public List<SysUser> queryLogicDeleted() {
        return this.queryLogicDeleted(null);
    }

    @Override
    public List<SysUser> queryLogicDeleted(LambdaQueryWrapper<SysUser> wrapper) {
        if (wrapper == null) {
            wrapper = new LambdaQueryWrapper();
        }
        wrapper.eq(SysUser::getDelFlag, (Object)CommonConstant.DEL_FLAG_1);
        return this.userMapper.selectLogicDeleted((Wrapper<SysUser>)wrapper);
    }

    @Override
    public boolean revertLogicDeleted(List<String> userIds, SysUser updateEntity) {
        String ids = String.format("'%s'", String.join((CharSequence)"','", userIds));
        return this.userMapper.revertLogicDeleted(ids, updateEntity) > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean removeLogicDeleted(List<String> userIds) {
        String ids = String.format("'%s'", String.join((CharSequence)"','", userIds));
        int line = this.userMapper.deleteLogicDeleted(ids);
        line += this.sysUserDepartMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysUserDepart::getUserId, userIds));
        line += this.sysUserRoleMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysUserRole::getUserId, userIds));
        try {
            this.dingtalkService.removeThirdAppUser(userIds);
            this.wechatEnterpriseService.removeThirdAppUser(userIds);
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u5220\u9664\u7b2c\u4e09\u65b9App\u7684\u7528\u6237\u5931\u8d25\uff1a", (Throwable)e);
        }
        return (line += this.sysThirdAccountMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysThirdAccount::getSysUserId, userIds))) != 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateNullPhoneEmail() {
        this.userMapper.updateNullByEmptyString("email");
        this.userMapper.updateNullByEmptyString("phone");
        return true;
    }

    @Override
    public void saveThirdUser(SysUser sysUser) {
        String userid = UUIDGenerator.generate();
        sysUser.setId(userid);
        ((SysUserMapper)this.baseMapper).insert(sysUser);
        SysRole sysRole = (SysRole)this.sysRoleMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysRole::getRoleCode, (Object)"third_role"));
        SysUserRole userRole = new SysUserRole();
        userRole.setRoleId(sysRole.getId());
        userRole.setUserId(userid);
        this.sysUserRoleMapper.insert(userRole);
    }

    @Override
    public List<SysUser> queryByDepIds(List<String> departIds, String username) {
        return this.userMapper.queryByDepIds(departIds, username);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveUser(SysUser user, String selectedRoles, String selectedDeparts) {
        String[] arr;
        this.save(user);
        if (oConvertUtils.isNotEmpty((Object)selectedRoles)) {
            for (String roleId : arr = selectedRoles.split(",")) {
                SysUserRole userRole = new SysUserRole(user.getId(), roleId);
                this.sysUserRoleMapper.insert(userRole);
            }
        }
        if (oConvertUtils.isNotEmpty((Object)selectedDeparts)) {
            for (String deaprtId : arr = selectedDeparts.split(",")) {
                SysUserDepart userDeaprt = new SysUserDepart(user.getId(), deaprtId);
                this.sysUserDepartMapper.insert(userDeaprt);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(value={"sys:cache:user"}, allEntries=true)
    public void editUser(SysUser user, String roles, String departs) {
        List userDepartList;
        String[] arr;
        this.updateById(user);
        this.sysUserRoleMapper.delete((Wrapper)new QueryWrapper().lambda().eq(SysUserRole::getUserId, (Object)user.getId()));
        if (oConvertUtils.isNotEmpty((Object)roles)) {
            for (String roleId : arr = roles.split(",")) {
                SysUserRole userRole = new SysUserRole(user.getId(), roleId);
                this.sysUserRoleMapper.insert(userRole);
            }
        }
        arr = new String[]{};
        if (oConvertUtils.isNotEmpty((Object)departs)) {
            arr = departs.split(",");
        }
        if ((userDepartList = this.sysUserDepartMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(SysUserDepart::getUserId, (Object)user.getId()))) != null && userDepartList.size() > 0) {
            for (SysUserDepart depart : userDepartList) {
                List sysDepartRoleList;
                List roleIds;
                if (Arrays.asList(arr).contains(depart.getDepId()) || (roleIds = (sysDepartRoleList = this.sysDepartRoleMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(SysDepartRole::getDepartId, (Object)depart.getDepId()))).stream().map(SysDepartRole::getId).collect(Collectors.toList())) == null || roleIds.size() <= 0) continue;
                this.departRoleUserMapper.delete((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysDepartRoleUser::getUserId, (Object)user.getId())).in(SysDepartRoleUser::getDroleId, roleIds));
            }
        }
        this.sysUserDepartMapper.delete((Wrapper)new QueryWrapper().lambda().eq(SysUserDepart::getUserId, (Object)user.getId()));
        if (oConvertUtils.isNotEmpty((Object)departs)) {
            for (String departId : arr) {
                SysUserDepart userDepart = new SysUserDepart(user.getId(), departId);
                this.sysUserDepartMapper.insert(userDepart);
            }
        }
        this.userMapper.updateNullByEmptyString("email");
        this.userMapper.updateNullByEmptyString("phone");
    }

    @Override
    public List<String> userIdToUsername(Collection<String> userIdList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysUser::getId, userIdList);
        List userList = super.list((Wrapper)queryWrapper);
        return userList.stream().map(SysUser::getUsername).collect(Collectors.toList());
    }
}

