/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.jeecg.common.util.IPUtils;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysRolePermission;
import org.jeecg.modules.system.mapper.SysRolePermissionMapper;
import org.jeecg.modules.system.service.ISysRolePermissionService;
import org.springframework.stereotype.Service;

@Service
public class SysRolePermissionServiceImpl
extends ServiceImpl<SysRolePermissionMapper, SysRolePermission>
implements ISysRolePermissionService {
    @Override
    public void saveRolePermission(String roleId, String permissionIds) {
        String[] arr;
        String ip = "";
        try {
            HttpServletRequest request = SpringContextUtils.getHttpServletRequest();
            ip = IPUtils.getIpAddr((HttpServletRequest)request);
        }
        catch (Exception e) {
            ip = "127.0.0.1";
        }
        LambdaQueryWrapper query = (LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysRolePermission::getRoleId, (Object)roleId);
        this.remove((Wrapper)query);
        ArrayList<SysRolePermission> list = new ArrayList<SysRolePermission>();
        for (String p : arr = permissionIds.split(",")) {
            if (!oConvertUtils.isNotEmpty((Object)p)) continue;
            SysRolePermission rolepms = new SysRolePermission(roleId, p);
            rolepms.setOperateDate(new Date());
            rolepms.setOperateIp(ip);
            list.add(rolepms);
        }
        this.saveBatch(list);
    }

    @Override
    public void saveRolePermission(String roleId, String permissionIds, String lastPermissionIds) {
        List<String> delete;
        String ip = "";
        try {
            HttpServletRequest request = SpringContextUtils.getHttpServletRequest();
            ip = IPUtils.getIpAddr((HttpServletRequest)request);
        }
        catch (Exception e) {
            ip = "127.0.0.1";
        }
        List<String> add = this.getDiff(lastPermissionIds, permissionIds);
        if (add != null && add.size() > 0) {
            ArrayList<SysRolePermission> list = new ArrayList<SysRolePermission>();
            for (String p : add) {
                if (!oConvertUtils.isNotEmpty((Object)p)) continue;
                SysRolePermission rolepms = new SysRolePermission(roleId, p);
                rolepms.setOperateDate(new Date());
                rolepms.setOperateIp(ip);
                list.add(rolepms);
            }
            this.saveBatch(list);
        }
        if ((delete = this.getDiff(permissionIds, lastPermissionIds)) != null && delete.size() > 0) {
            for (String permissionId : delete) {
                this.remove((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysRolePermission::getRoleId, (Object)roleId)).eq(SysRolePermission::getPermissionId, (Object)permissionId));
            }
        }
    }

    private List<String> getDiff(String main, String diff) {
        if (oConvertUtils.isEmpty((Object)diff)) {
            return null;
        }
        if (oConvertUtils.isEmpty((Object)main)) {
            return Arrays.asList(diff.split(","));
        }
        String[] mainArr = main.split(",");
        String[] diffArr = diff.split(",");
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String string : mainArr) {
            map.put(string, 1);
        }
        ArrayList<String> res = new ArrayList<String>();
        for (String key : diffArr) {
            if (!oConvertUtils.isNotEmpty((Object)key) || map.containsKey(key)) continue;
            res.add(key);
        }
        return res;
    }
}

