/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import io.netty.util.internal.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.util.FillRuleUtil;
import org.jeecg.common.util.YouBianCodeUtil;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysDepart;
import org.jeecg.modules.system.entity.SysDepartPermission;
import org.jeecg.modules.system.entity.SysDepartRole;
import org.jeecg.modules.system.entity.SysDepartRolePermission;
import org.jeecg.modules.system.entity.SysDepartRoleUser;
import org.jeecg.modules.system.entity.SysUserDepart;
import org.jeecg.modules.system.mapper.SysDepartMapper;
import org.jeecg.modules.system.mapper.SysDepartPermissionMapper;
import org.jeecg.modules.system.mapper.SysDepartRoleMapper;
import org.jeecg.modules.system.mapper.SysDepartRolePermissionMapper;
import org.jeecg.modules.system.mapper.SysDepartRoleUserMapper;
import org.jeecg.modules.system.mapper.SysUserDepartMapper;
import org.jeecg.modules.system.mapper.SysUserMapper;
import org.jeecg.modules.system.model.DepartIdModel;
import org.jeecg.modules.system.model.SysDepartTreeModel;
import org.jeecg.modules.system.service.ISysDepartService;
import org.jeecg.modules.system.util.FindsDepartsChildrenUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysDepartServiceImpl
extends ServiceImpl<SysDepartMapper, SysDepart>
implements ISysDepartService {
    @Autowired
    private SysUserDepartMapper userDepartMapper;
    @Autowired
    private SysDepartRoleMapper sysDepartRoleMapper;
    @Autowired
    private SysDepartPermissionMapper departPermissionMapper;
    @Autowired
    private SysDepartRolePermissionMapper departRolePermissionMapper;
    @Autowired
    private SysDepartRoleUserMapper departRoleUserMapper;
    @Autowired
    private SysUserMapper sysUserMapper;

    @Override
    public List<SysDepartTreeModel> queryMyDeptTreeList(String departIds) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        String[] codeArr = this.getMyDeptParentOrgCode(departIds);
        for (int i = 0; i < codeArr.length; ++i) {
            ((LambdaQueryWrapper)query.or()).likeRight(SysDepart::getOrgCode, (Object)codeArr[i]);
        }
        query.eq(SysDepart::getDelFlag, (Object)CommonConstant.DEL_FLAG_0.toString());
        query.orderByAsc(SysDepart::getDepartOrder);
        List listDepts = this.list((Wrapper)query);
        for (int i = 0; i < codeArr.length; ++i) {
            for (SysDepart dept : listDepts) {
                if (!dept.getOrgCode().equals(codeArr[i])) continue;
                dept.setParentId(null);
            }
        }
        List<SysDepartTreeModel> listResult = FindsDepartsChildrenUtil.wrapTreeDataToTreeList(listDepts);
        return listResult;
    }

    @Override
    @Cacheable(value={"sys:cache:depart:alldata"})
    public List<SysDepartTreeModel> queryTreeList() {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysDepart::getDelFlag, (Object)CommonConstant.DEL_FLAG_0.toString());
        query.orderByAsc(SysDepart::getDepartOrder);
        List list = this.list((Wrapper)query);
        List<SysDepartTreeModel> listResult = FindsDepartsChildrenUtil.wrapTreeDataToTreeList(list);
        return listResult;
    }

    @Override
    @Cacheable(value={"sys:cache:depart:allids"})
    public List<DepartIdModel> queryDepartIdTreeList() {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysDepart::getDelFlag, (Object)CommonConstant.DEL_FLAG_0.toString());
        query.orderByAsc(SysDepart::getDepartOrder);
        List list = this.list((Wrapper)query);
        List<DepartIdModel> listResult = FindsDepartsChildrenUtil.wrapTreeDataToDepartIdTreeList(list);
        return listResult;
    }

    @Override
    @Transactional
    public void saveDepartData(SysDepart sysDepart, String username) {
        if (sysDepart != null && username != null) {
            if (sysDepart.getParentId() == null) {
                sysDepart.setParentId("");
            }
            String s = UUID.randomUUID().toString().replace("-", "");
            sysDepart.setId(s);
            String parentId = sysDepart.getParentId();
            JSONObject formData = new JSONObject();
            formData.put("parentId", (Object)parentId);
            String[] codeArray = (String[])FillRuleUtil.executeRule((String)"org_num_role", (JSONObject)formData);
            sysDepart.setOrgCode(codeArray[0]);
            String orgType = codeArray[1];
            sysDepart.setOrgType(String.valueOf(orgType));
            sysDepart.setCreateTime(new Date());
            sysDepart.setDelFlag(CommonConstant.DEL_FLAG_0.toString());
            this.save(sysDepart);
        }
    }

    private String[] generateOrgCode(String parentId) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        LambdaQueryWrapper query1 = new LambdaQueryWrapper();
        String[] strArray = new String[2];
        List departList = new ArrayList();
        String newOrgCode = "";
        String oldOrgCode = "";
        String orgType = "";
        if (StringUtil.isNullOrEmpty((String)parentId)) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)query1.eq(SysDepart::getParentId, (Object)"")).or()).isNull(SysDepart::getParentId);
            query1.orderByDesc(SysDepart::getOrgCode);
            departList = this.list((Wrapper)query1);
            if (departList == null || departList.size() == 0) {
                strArray[0] = YouBianCodeUtil.getNextYouBianCode(null);
                strArray[1] = "1";
                return strArray;
            }
            SysDepart depart = (SysDepart)departList.get(0);
            oldOrgCode = depart.getOrgCode();
            orgType = depart.getOrgType();
            newOrgCode = YouBianCodeUtil.getNextYouBianCode((String)oldOrgCode);
        } else {
            query.eq(SysDepart::getParentId, (Object)parentId);
            query.orderByDesc(SysDepart::getOrgCode);
            List parentList = this.list((Wrapper)query);
            SysDepart depart = (SysDepart)this.getById((Serializable)((Object)parentId));
            String parentCode = depart.getOrgCode();
            orgType = String.valueOf(Integer.valueOf(depart.getOrgType()) + 1);
            if (parentList == null || parentList.size() == 0) {
                newOrgCode = YouBianCodeUtil.getSubYouBianCode((String)parentCode, null);
            } else {
                String subCode = ((SysDepart)parentList.get(0)).getOrgCode();
                newOrgCode = YouBianCodeUtil.getSubYouBianCode((String)parentCode, (String)subCode);
            }
        }
        strArray[0] = newOrgCode;
        strArray[1] = orgType;
        return strArray;
    }

    @Override
    @Transactional
    public Boolean updateDepartDataById(SysDepart sysDepart, String username) {
        if (sysDepart != null && username != null) {
            sysDepart.setUpdateTime(new Date());
            sysDepart.setUpdateBy(username);
            this.updateById(sysDepart);
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatchWithChildren(List<String> ids) {
        ArrayList<String> idList = new ArrayList<String>();
        for (String id : ids) {
            idList.add(id);
            this.checkChildrenExists(id, idList);
        }
        this.removeByIds(idList);
        ArrayList<String> roleIdList = new ArrayList<String>();
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.select(new SFunction[]{SysDepartRole::getId}).in(SysDepartRole::getDepartId, idList);
        List depRoleList = this.sysDepartRoleMapper.selectList((Wrapper)query);
        for (SysDepartRole deptRole : depRoleList) {
            roleIdList.add(deptRole.getId());
        }
        this.userDepartMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysUserDepart::getDepId, idList));
        this.departPermissionMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysDepartPermission::getDepartId, idList));
        this.sysDepartRoleMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysDepartRole::getDepartId, idList));
        if (roleIdList != null && roleIdList.size() > 0) {
            this.departRolePermissionMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysDepartRolePermission::getRoleId, roleIdList));
            this.departRoleUserMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysDepartRoleUser::getDroleId, roleIdList));
        }
    }

    @Override
    public List<String> getSubDepIdsByDepId(String departId) {
        return ((SysDepartMapper)this.baseMapper).getSubDepIdsByDepId(departId);
    }

    @Override
    public List<String> getMySubDepIdsByDepId(String departIds) {
        String[] codeArr = this.getMyDeptParentOrgCode(departIds);
        return ((SysDepartMapper)this.baseMapper).getSubDepIdsByOrgCodes(codeArr);
    }

    @Override
    public List<SysDepartTreeModel> searhBy(String keyWord, String myDeptSearch, String departIds) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        ArrayList<SysDepartTreeModel> newList = new ArrayList<SysDepartTreeModel>();
        if (!StringUtil.isNullOrEmpty((String)myDeptSearch)) {
            if (StringUtil.isNullOrEmpty((String)departIds)) {
                return newList;
            }
            String[] codeArr = this.getMyDeptParentOrgCode(departIds);
            for (int i = 0; i < codeArr.length; ++i) {
                ((LambdaQueryWrapper)query.or()).likeRight(SysDepart::getOrgCode, (Object)codeArr[i]);
            }
            query.eq(SysDepart::getDelFlag, (Object)CommonConstant.DEL_FLAG_0.toString());
        }
        query.like(SysDepart::getDepartName, (Object)keyWord);
        SysDepartTreeModel model = new SysDepartTreeModel();
        List departList = this.list((Wrapper)query);
        if (departList.size() > 0) {
            for (SysDepart depart : departList) {
                model = new SysDepartTreeModel(depart);
                model.setChildren(null);
                newList.add(model);
            }
            return newList;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean delete(String id) {
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(id);
        this.checkChildrenExists(id, idList);
        boolean ok = this.removeByIds(idList);
        ArrayList<String> roleIdList = new ArrayList<String>();
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.select(new SFunction[]{SysDepartRole::getId}).in(SysDepartRole::getDepartId, idList);
        List depRoleList = this.sysDepartRoleMapper.selectList((Wrapper)query);
        for (SysDepartRole deptRole : depRoleList) {
            roleIdList.add(deptRole.getId());
        }
        this.userDepartMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysUserDepart::getDepId, idList));
        this.departPermissionMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysDepartPermission::getDepartId, idList));
        this.sysDepartRoleMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysDepartRole::getDepartId, idList));
        if (roleIdList != null && roleIdList.size() > 0) {
            this.departRolePermissionMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysDepartRolePermission::getRoleId, roleIdList));
            this.departRoleUserMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysDepartRoleUser::getDroleId, roleIdList));
        }
        return ok;
    }

    private void checkChildrenExists(String id, List<String> idList) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysDepart::getParentId, (Object)id);
        List departList = this.list((Wrapper)query);
        if (departList != null && departList.size() > 0) {
            for (SysDepart depart : departList) {
                idList.add(depart.getId());
                this.checkChildrenExists(depart.getId(), idList);
            }
        }
    }

    @Override
    public List<SysDepart> queryUserDeparts(String userId) {
        return ((SysDepartMapper)this.baseMapper).queryUserDeparts(userId);
    }

    @Override
    public List<SysDepart> queryDepartsByUsername(String username) {
        return ((SysDepartMapper)this.baseMapper).queryDepartsByUsername(username);
    }

    private String[] getMyDeptParentOrgCode(String departIds) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysDepart::getDelFlag, (Object)CommonConstant.DEL_FLAG_0.toString());
        query.in(SysDepart::getId, Arrays.asList(departIds.split(",")));
        query.orderByAsc(SysDepart::getOrgCode);
        List list = this.list((Wrapper)query);
        if (list == null || list.size() == 0) {
            return null;
        }
        String orgCode = this.getMyDeptParentNode(list);
        String[] codeArr = orgCode.split(",");
        return codeArr;
    }

    private String getMyDeptParentNode(List<SysDepart> list) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (SysDepart dept : list) {
            String code = dept.getOrgCode().substring(0, 3);
            if (map.containsKey(code)) {
                String mapCode = (String)map.get(code) + "," + dept.getOrgCode();
                map.put(code, mapCode);
                continue;
            }
            map.put(code, dept.getOrgCode());
        }
        StringBuffer parentOrgCode = new StringBuffer();
        for (String str : map.values()) {
            String[] arrStr = str.split(",");
            parentOrgCode.append(",").append(this.getMinLengthNode(arrStr));
        }
        return parentOrgCode.substring(1);
    }

    private String getMinLengthNode(String[] str) {
        int min = str[0].length();
        String orgCode = str[0];
        for (int i = 1; i < str.length; ++i) {
            if (str[i].length() > min) continue;
            min = str[i].length();
            orgCode = orgCode + "," + str[i];
        }
        return orgCode;
    }

    @Override
    public List<SysDepartTreeModel> queryTreeByKeyWord(String keyWord) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysDepart::getDelFlag, (Object)CommonConstant.DEL_FLAG_0.toString());
        query.orderByAsc(SysDepart::getDepartOrder);
        List list = this.list((Wrapper)query);
        List<SysDepartTreeModel> listResult = FindsDepartsChildrenUtil.wrapTreeDataToTreeList(list);
        ArrayList<SysDepartTreeModel> treelist = new ArrayList<SysDepartTreeModel>();
        if (!StringUtils.isNotBlank((String)keyWord)) {
            return listResult;
        }
        this.getTreeByKeyWord(keyWord, listResult, treelist);
        return treelist;
    }

    @Override
    public List<SysDepartTreeModel> queryTreeListByPid(String parentId) {
        List<SysDepart> list = ((SysDepartMapper)this.baseMapper).queryTreeListByPid(parentId);
        ArrayList<SysDepartTreeModel> records = new ArrayList<SysDepartTreeModel>();
        for (int i = 0; i < list.size(); ++i) {
            SysDepart depart = list.get(i);
            SysDepartTreeModel treeModel = new SysDepartTreeModel(depart);
            treeModel.setKey(treeModel.getKey());
            Integer count = ((SysDepartMapper)this.baseMapper).queryCountByPid(depart.getId());
            if (count > 0) {
                treeModel.setIsLeaf(false);
            } else {
                treeModel.setIsLeaf(true);
            }
            records.add(treeModel);
        }
        return records;
    }

    @Override
    public JSONObject queryAllParentIdByDepartId(String departId) {
        JSONObject result = new JSONObject();
        for (String id : departId.split(",")) {
            JSONObject all = this.queryAllParentId("id", id);
            result.put(id, (Object)all);
        }
        return result;
    }

    @Override
    public JSONObject queryAllParentIdByOrgCode(String orgCode) {
        JSONObject result = new JSONObject();
        for (String code : orgCode.split(",")) {
            JSONObject all = this.queryAllParentId("org_code", code);
            result.put(code, (Object)all);
        }
        return result;
    }

    private JSONObject queryAllParentId(String fieldName, String value) {
        JSONObject data = new JSONObject();
        data.put("parentIds", (Object)new JSONArray());
        data.put("parentMap", (Object)new JSONObject());
        this.queryAllParentIdRecursion(fieldName, value, data);
        return data;
    }

    private void queryAllParentIdRecursion(String fieldName, String value, JSONObject data) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)fieldName, (Object)value);
        SysDepart depart = (SysDepart)super.getOne((Wrapper)queryWrapper);
        if (depart != null) {
            data.getJSONArray("parentIds").add(0, (Object)depart.getId());
            data.getJSONObject("parentMap").put(depart.getId(), (Object)depart);
            if (oConvertUtils.isNotEmpty((Object)depart.getParentId())) {
                this.queryAllParentIdRecursion("id", depart.getParentId(), data);
            }
        }
    }

    @Override
    public SysDepart queryCompByOrgCode(String orgCode) {
        int length = 3;
        String compyOrgCode = orgCode.substring(0, length);
        return ((SysDepartMapper)this.baseMapper).queryCompByOrgCode(compyOrgCode);
    }

    @Override
    public List<SysDepart> queryDeptByPid(String pid) {
        return ((SysDepartMapper)this.baseMapper).queryDeptByPid(pid);
    }

    public void getTreeByKeyWord(String keyWord, List<SysDepartTreeModel> allResult, List<SysDepartTreeModel> newResult) {
        for (SysDepartTreeModel model : allResult) {
            if (model.getDepartName().contains(keyWord)) {
                newResult.add(model);
                continue;
            }
            if (model.getChildren() == null) continue;
            this.getTreeByKeyWord(keyWord, model.getChildren(), newResult);
        }
    }
}

