/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.base.Joiner;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.dto.OnlineAuthDTO;
import org.jeecg.common.api.dto.message.BusMessageDTO;
import org.jeecg.common.api.dto.message.BusTemplateMessageDTO;
import org.jeecg.common.api.dto.message.MessageDTO;
import org.jeecg.common.api.dto.message.TemplateDTO;
import org.jeecg.common.api.dto.message.TemplateMessageDTO;
import org.jeecg.common.aspect.UrlMatchEnum;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.vo.ComboModel;
import org.jeecg.common.system.vo.DictModel;
import org.jeecg.common.system.vo.DynamicDataSourceModel;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.system.vo.SysCategoryModel;
import org.jeecg.common.system.vo.SysDepartModel;
import org.jeecg.common.system.vo.SysPermissionDataRuleModel;
import org.jeecg.common.system.vo.SysUserCacheInfo;
import org.jeecg.common.util.SysAnnmentTypeEnum;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.message.entity.SysMessageTemplate;
import org.jeecg.modules.message.handle.impl.EmailSendMsgHandle;
import org.jeecg.modules.message.service.ISysMessageTemplateService;
import org.jeecg.modules.message.websocket.WebSocket;
import org.jeecg.modules.system.entity.SysAnnouncement;
import org.jeecg.modules.system.entity.SysAnnouncementSend;
import org.jeecg.modules.system.entity.SysDataSource;
import org.jeecg.modules.system.entity.SysDepart;
import org.jeecg.modules.system.entity.SysDict;
import org.jeecg.modules.system.entity.SysPermission;
import org.jeecg.modules.system.entity.SysPermissionDataRule;
import org.jeecg.modules.system.entity.SysRole;
import org.jeecg.modules.system.entity.SysUser;
import org.jeecg.modules.system.entity.SysUserDepart;
import org.jeecg.modules.system.mapper.SysAnnouncementMapper;
import org.jeecg.modules.system.mapper.SysAnnouncementSendMapper;
import org.jeecg.modules.system.mapper.SysCategoryMapper;
import org.jeecg.modules.system.mapper.SysDepartMapper;
import org.jeecg.modules.system.mapper.SysLogMapper;
import org.jeecg.modules.system.mapper.SysPermissionMapper;
import org.jeecg.modules.system.mapper.SysRoleMapper;
import org.jeecg.modules.system.mapper.SysUserMapper;
import org.jeecg.modules.system.mapper.SysUserRoleMapper;
import org.jeecg.modules.system.service.ISysDataSourceService;
import org.jeecg.modules.system.service.ISysDepartService;
import org.jeecg.modules.system.service.ISysDictService;
import org.jeecg.modules.system.service.ISysPermissionDataRuleService;
import org.jeecg.modules.system.service.ISysUserDepartService;
import org.jeecg.modules.system.service.impl.ThirdAppDingtalkServiceImpl;
import org.jeecg.modules.system.service.impl.ThirdAppWechatEnterpriseServiceImpl;
import org.jeecg.modules.system.util.SecurityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.util.AntPathMatcher;

@Service
public class SysBaseApiImpl
implements ISysBaseAPI {
    private static final Logger log = LoggerFactory.getLogger(SysBaseApiImpl.class);
    private static String DB_TYPE = "";
    @Autowired
    private ISysMessageTemplateService sysMessageTemplateService;
    @Resource
    private SysLogMapper sysLogMapper;
    @Resource
    private SysUserMapper userMapper;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Autowired
    private ISysDepartService sysDepartService;
    @Autowired
    private ISysDictService sysDictService;
    @Resource
    private SysAnnouncementMapper sysAnnouncementMapper;
    @Resource
    private SysAnnouncementSendMapper sysAnnouncementSendMapper;
    @Resource
    private WebSocket webSocket;
    @Resource
    private SysRoleMapper roleMapper;
    @Resource
    private SysDepartMapper departMapper;
    @Resource
    private SysCategoryMapper categoryMapper;
    @Autowired
    private ISysDataSourceService dataSourceService;
    @Autowired
    private ISysUserDepartService sysUserDepartService;
    @Resource
    private SysPermissionMapper sysPermissionMapper;
    @Autowired
    private ISysPermissionDataRuleService sysPermissionDataRuleService;
    @Autowired
    private ThirdAppWechatEnterpriseServiceImpl wechatEnterpriseService;
    @Autowired
    private ThirdAppDingtalkServiceImpl dingtalkService;

    @Cacheable(cacheNames={"sys:cache:user"}, key="#username")
    public LoginUser getUserByName(String username) {
        if (oConvertUtils.isEmpty((Object)username)) {
            return null;
        }
        LoginUser loginUser = new LoginUser();
        SysUser sysUser = this.userMapper.getUserByName(username);
        if (sysUser == null) {
            return null;
        }
        BeanUtils.copyProperties((Object)sysUser, (Object)loginUser);
        return loginUser;
    }

    public String translateDictFromTable(String table, String text, String code, String key) {
        return this.sysDictService.queryTableDictTextByKey(table, text, code, key);
    }

    public String translateDict(String code, String key) {
        return this.sysDictService.queryDictTextByKey(code, key);
    }

    public List<SysPermissionDataRuleModel> queryPermissionDataRule(String component, String requestPath, String username) {
        LambdaQueryWrapper query;
        List currentSyspermission = null;
        if (oConvertUtils.isNotEmpty((Object)component)) {
            query = new LambdaQueryWrapper();
            query.eq(SysPermission::getDelFlag, (Object)0);
            query.eq(SysPermission::getComponent, (Object)component);
            currentSyspermission = this.sysPermissionMapper.selectList((Wrapper)query);
        } else {
            String regUrl;
            query = new LambdaQueryWrapper();
            query.eq(SysPermission::getMenuType, (Object)2);
            query.eq(SysPermission::getDelFlag, (Object)0);
            query.eq(SysPermission::getUrl, (Object)requestPath);
            currentSyspermission = this.sysPermissionMapper.selectList((Wrapper)query);
            if (currentSyspermission == null || currentSyspermission.size() == 0) {
                String userMatchUrl = UrlMatchEnum.getMatchResultByUrl((String)requestPath);
                LambdaQueryWrapper queryQserMatch = new LambdaQueryWrapper();
                queryQserMatch.eq(SysPermission::getMenuType, (Object)1);
                queryQserMatch.eq(SysPermission::getDelFlag, (Object)0);
                queryQserMatch.eq(SysPermission::getUrl, (Object)userMatchUrl);
                if (oConvertUtils.isNotEmpty((Object)userMatchUrl)) {
                    currentSyspermission = this.sysPermissionMapper.selectList((Wrapper)queryQserMatch);
                }
            }
            if ((currentSyspermission == null || currentSyspermission.size() == 0) && (regUrl = this.getRegexpUrl(requestPath)) != null) {
                currentSyspermission = this.sysPermissionMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPermission::getMenuType, (Object)2)).eq(SysPermission::getUrl, (Object)regUrl)).eq(SysPermission::getDelFlag, (Object)0));
            }
        }
        if (currentSyspermission != null && currentSyspermission.size() > 0) {
            List<Object> dataRules = new ArrayList<SysPermissionDataRuleModel>();
            for (SysPermission sysPermission : currentSyspermission) {
                List<SysPermissionDataRule> temp = this.sysPermissionDataRuleService.queryPermissionDataRules(username, sysPermission.getId());
                if (temp == null || temp.size() <= 0) continue;
                dataRules = oConvertUtils.entityListToModelList(temp, SysPermissionDataRuleModel.class);
            }
            return dataRules;
        }
        return null;
    }

    private String getRegexpUrl(String url) {
        List<String> list = this.sysPermissionMapper.queryPermissionUrlWithStar();
        if (list != null && list.size() > 0) {
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                AntPathMatcher matcher = new AntPathMatcher();
                String p = iterator.next();
                if (!matcher.match(p, url)) continue;
                return p;
            }
        }
        return null;
    }

    public SysUserCacheInfo getCacheUser(String username) {
        SysUserCacheInfo info = new SysUserCacheInfo();
        info.setOneDepart(true);
        LoginUser user = this.getUserByName(username);
        if (user == null) {
            return null;
        }
        info.setSysUserCode(user.getUsername());
        info.setSysUserName(user.getRealname());
        info.setSysOrgCode(user.getOrgCode());
        List<SysDepart> list = this.departMapper.queryUserDeparts(user.getId());
        ArrayList<String> sysMultiOrgCode = new ArrayList<String>();
        if (list != null && list.size() != 0) {
            if (list.size() == 1) {
                sysMultiOrgCode.add(list.get(0).getOrgCode());
            } else {
                info.setOneDepart(false);
                for (SysDepart dpt : list) {
                    sysMultiOrgCode.add(dpt.getOrgCode());
                }
            }
        }
        info.setSysMultiOrgCode(sysMultiOrgCode);
        return info;
    }

    public LoginUser getUserById(String id) {
        if (oConvertUtils.isEmpty((Object)id)) {
            return null;
        }
        LoginUser loginUser = new LoginUser();
        SysUser sysUser = (SysUser)this.userMapper.selectById((Serializable)((Object)id));
        if (sysUser == null) {
            return null;
        }
        BeanUtils.copyProperties((Object)sysUser, (Object)loginUser);
        return loginUser;
    }

    public List<String> getRolesByUsername(String username) {
        return this.sysUserRoleMapper.getRoleByUserName(username);
    }

    public List<String> getDepartIdsByUsername(String username) {
        List<SysDepart> list = this.sysDepartService.queryDepartsByUsername(username);
        ArrayList<String> result = new ArrayList<String>(list.size());
        for (SysDepart depart : list) {
            result.add(depart.getId());
        }
        return result;
    }

    public List<String> getDepartNamesByUsername(String username) {
        List<SysDepart> list = this.sysDepartService.queryDepartsByUsername(username);
        ArrayList<String> result = new ArrayList<String>(list.size());
        for (SysDepart depart : list) {
            result.add(depart.getDepartName());
        }
        return result;
    }

    public DictModel getParentDepartId(String departId) {
        SysDepart depart = this.departMapper.getParentDepartId(departId);
        DictModel model = new DictModel(depart.getId(), depart.getParentId());
        return model;
    }

    @Cacheable(value={"sys:cache:dict"}, key="#code", unless="#result == null ")
    public List<DictModel> queryDictItemsByCode(String code) {
        return this.sysDictService.queryDictItemsByCode(code);
    }

    public List<DictModel> queryTableDictItemsByCode(String table, String text, String code) {
        if (table.indexOf("#{") >= 0) {
            table = QueryGenerator.getSqlRuleValue((String)table);
        }
        return this.sysDictService.queryTableDictItemsByCode(table, text, code);
    }

    public List<DictModel> queryAllDepartBackDictModel() {
        return this.sysDictService.queryAllDepartBackDictModel();
    }

    public void sendSysAnnouncement(MessageDTO message) {
        this.sendSysAnnouncement(message.getFromUser(), message.getToUser(), message.getTitle(), message.getContent(), message.getCategory());
        try {
            this.wechatEnterpriseService.sendMessage(message, true);
            this.dingtalkService.sendMessage(message, true);
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u53d1\u9001\u7b2c\u4e09\u65b9APP\u6d88\u606f\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    public void sendBusAnnouncement(BusMessageDTO message) {
        this.sendBusAnnouncement(message.getFromUser(), message.getToUser(), message.getTitle(), message.getContent(), message.getCategory(), message.getBusType(), message.getBusId());
        try {
            this.wechatEnterpriseService.sendMessage((MessageDTO)message, true);
            this.dingtalkService.sendMessage((MessageDTO)message, true);
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u53d1\u9001\u7b2c\u4e09\u65b9APP\u6d88\u606f\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    public void sendTemplateAnnouncement(TemplateMessageDTO message) {
        String templateCode = message.getTemplateCode();
        String title = message.getTitle();
        Map map = message.getTemplateParam();
        String fromUser = message.getFromUser();
        String toUser = message.getToUser();
        List<SysMessageTemplate> sysSmsTemplates = this.sysMessageTemplateService.selectByCode(templateCode);
        if (sysSmsTemplates == null || sysSmsTemplates.size() == 0) {
            throw new JeecgBootException("\u6d88\u606f\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u6a21\u677f\u7f16\u7801\uff1a" + templateCode);
        }
        SysMessageTemplate sysSmsTemplate = sysSmsTemplates.get(0);
        title = title == null ? sysSmsTemplate.getTemplateName() : title;
        String content = sysSmsTemplate.getTemplateContent();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                String str = "${" + (String)entry.getKey() + "}";
                if (oConvertUtils.isNotEmpty((Object)title)) {
                    title = title.replace(str, (CharSequence)entry.getValue());
                }
                content = content.replace(str, (CharSequence)entry.getValue());
            }
        }
        SysAnnouncement announcement = new SysAnnouncement();
        announcement.setTitile(title);
        announcement.setMsgContent(content);
        announcement.setSender(fromUser);
        announcement.setPriority("M");
        announcement.setMsgType("USER");
        announcement.setSendStatus("1");
        announcement.setSendTime(new Date());
        announcement.setMsgCategory("2");
        announcement.setDelFlag(String.valueOf(CommonConstant.DEL_FLAG_0));
        this.sysAnnouncementMapper.insert(announcement);
        String userId = toUser;
        String[] userIds = userId.split(",");
        String anntId = announcement.getId();
        for (int i = 0; i < userIds.length; ++i) {
            SysUser sysUser;
            if (!oConvertUtils.isNotEmpty((Object)userIds[i]) || (sysUser = this.userMapper.getUserByName(userIds[i])) == null) continue;
            SysAnnouncementSend announcementSend = new SysAnnouncementSend();
            announcementSend.setAnntId(anntId);
            announcementSend.setUserId(sysUser.getId());
            announcementSend.setReadFlag("0");
            this.sysAnnouncementSendMapper.insert(announcementSend);
            JSONObject obj = new JSONObject();
            obj.put("cmd", (Object)"user");
            obj.put("userId", (Object)sysUser.getId());
            obj.put("msgId", (Object)announcement.getId());
            obj.put("msgTxt", (Object)announcement.getTitile());
            this.webSocket.sendMessage(sysUser.getId(), obj.toJSONString());
        }
        try {
            this.dingtalkService.sendActionCardMessage(announcement, true);
            this.wechatEnterpriseService.sendTextCardMessage(announcement, true);
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u53d1\u9001\u7b2c\u4e09\u65b9APP\u6d88\u606f\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    public void sendBusTemplateAnnouncement(BusTemplateMessageDTO message) {
        String templateCode = message.getTemplateCode();
        String title = message.getTitle();
        Map map = message.getTemplateParam();
        String fromUser = message.getFromUser();
        String toUser = message.getToUser();
        String busId = message.getBusId();
        String busType = message.getBusType();
        List<SysMessageTemplate> sysSmsTemplates = this.sysMessageTemplateService.selectByCode(templateCode);
        if (sysSmsTemplates == null || sysSmsTemplates.size() == 0) {
            throw new JeecgBootException("\u6d88\u606f\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u6a21\u677f\u7f16\u7801\uff1a" + templateCode);
        }
        SysMessageTemplate sysSmsTemplate = sysSmsTemplates.get(0);
        title = title == null ? sysSmsTemplate.getTemplateName() : title;
        String content = sysSmsTemplate.getTemplateContent();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                String str = "${" + (String)entry.getKey() + "}";
                title = title.replace(str, (CharSequence)entry.getValue());
                content = content.replace(str, (CharSequence)entry.getValue());
            }
        }
        SysAnnouncement announcement = new SysAnnouncement();
        announcement.setTitile(title);
        announcement.setMsgContent(content);
        announcement.setSender(fromUser);
        announcement.setPriority("M");
        announcement.setMsgType("USER");
        announcement.setSendStatus("1");
        announcement.setSendTime(new Date());
        announcement.setMsgCategory("2");
        announcement.setDelFlag(String.valueOf(CommonConstant.DEL_FLAG_0));
        announcement.setBusId(busId);
        announcement.setBusType(busType);
        announcement.setOpenType(SysAnnmentTypeEnum.getByType((String)busType).getOpenType());
        announcement.setOpenPage(SysAnnmentTypeEnum.getByType((String)busType).getOpenPage());
        this.sysAnnouncementMapper.insert(announcement);
        String userId = toUser;
        String[] userIds = userId.split(",");
        String anntId = announcement.getId();
        for (int i = 0; i < userIds.length; ++i) {
            SysUser sysUser;
            if (!oConvertUtils.isNotEmpty((Object)userIds[i]) || (sysUser = this.userMapper.getUserByName(userIds[i])) == null) continue;
            SysAnnouncementSend announcementSend = new SysAnnouncementSend();
            announcementSend.setAnntId(anntId);
            announcementSend.setUserId(sysUser.getId());
            announcementSend.setReadFlag("0");
            this.sysAnnouncementSendMapper.insert(announcementSend);
            JSONObject obj = new JSONObject();
            obj.put("cmd", (Object)"user");
            obj.put("userId", (Object)sysUser.getId());
            obj.put("msgId", (Object)announcement.getId());
            obj.put("msgTxt", (Object)announcement.getTitile());
            this.webSocket.sendMessage(sysUser.getId(), obj.toJSONString());
        }
        try {
            this.dingtalkService.sendActionCardMessage(announcement, true);
            this.wechatEnterpriseService.sendTextCardMessage(announcement, true);
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u53d1\u9001\u7b2c\u4e09\u65b9APP\u6d88\u606f\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    public String parseTemplateByCode(TemplateDTO templateDTO) {
        String templateCode = templateDTO.getTemplateCode();
        Map map = templateDTO.getTemplateParam();
        List<SysMessageTemplate> sysSmsTemplates = this.sysMessageTemplateService.selectByCode(templateCode);
        if (sysSmsTemplates == null || sysSmsTemplates.size() == 0) {
            throw new JeecgBootException("\u6d88\u606f\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u6a21\u677f\u7f16\u7801\uff1a" + templateCode);
        }
        SysMessageTemplate sysSmsTemplate = sysSmsTemplates.get(0);
        String content = sysSmsTemplate.getTemplateContent();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                String str = "${" + (String)entry.getKey() + "}";
                content = content.replace(str, (CharSequence)entry.getValue());
            }
        }
        return content;
    }

    public void updateSysAnnounReadFlag(String busType, String busId) {
        SysAnnouncement announcement = (SysAnnouncement)this.sysAnnouncementMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"bus_type", (Object)busType)).eq((Object)"bus_id", (Object)busId));
        if (announcement != null) {
            LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            String userId = sysUser.getId();
            LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
            updateWrapper.set(SysAnnouncementSend::getReadFlag, (Object)"1");
            updateWrapper.set(SysAnnouncementSend::getReadTime, (Object)new Date());
            updateWrapper.last("where annt_id ='" + announcement.getId() + "' and user_id ='" + userId + "'");
            SysAnnouncementSend announcementSend = new SysAnnouncementSend();
            this.sysAnnouncementSendMapper.update(announcementSend, (Wrapper)updateWrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDatabaseTypeByDataSource(DataSource dataSource) throws SQLException {
        if ("".equals(DB_TYPE)) {
            try (Connection connection = dataSource.getConnection();){
                DatabaseMetaData md = connection.getMetaData();
                String dbType = md.getDatabaseProductName().toLowerCase();
                if (dbType.indexOf("mysql") >= 0) {
                    DB_TYPE = "MYSQL";
                } else if (dbType.indexOf("oracle") >= 0) {
                    DB_TYPE = "ORACLE";
                } else if (dbType.indexOf("sqlserver") >= 0 || dbType.indexOf("sql server") >= 0) {
                    DB_TYPE = "SQLSERVER";
                } else if (dbType.indexOf("postgresql") >= 0) {
                    DB_TYPE = "POSTGRESQL";
                } else if (dbType.indexOf("mariadb") >= 0) {
                    DB_TYPE = "MARIADB";
                } else {
                    log.error("\u6570\u636e\u5e93\u7c7b\u578b:[" + dbType + "]\u4e0d\u8bc6\u522b!");
                }
            }
        }
        return DB_TYPE;
    }

    public List<DictModel> queryAllDict() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByAsc((Object)"create_time");
        List dicts = this.sysDictService.list((Wrapper)queryWrapper);
        ArrayList<DictModel> list = new ArrayList<DictModel>();
        for (SysDict dict : dicts) {
            list.add(new DictModel(dict.getDictCode(), dict.getDictName()));
        }
        return list;
    }

    public List<SysCategoryModel> queryAllDSysCategory() {
        List ls = this.categoryMapper.selectList(null);
        List res = oConvertUtils.entityListToModelList((List)ls, SysCategoryModel.class);
        return res;
    }

    public List<DictModel> queryFilterTableDictInfo(String table, String text, String code, String filterSql) {
        return this.sysDictService.queryTableDictItemsByCodeAndFilter(table, text, code, filterSql);
    }

    public List<String> queryTableDictByKeys(String table, String text, String code, String[] keyArray) {
        return this.sysDictService.queryTableDictByKeys(table, text, code, Joiner.on((String)",").join((Object[])keyArray));
    }

    public List<ComboModel> queryAllUserBackCombo() {
        ArrayList<ComboModel> list = new ArrayList<ComboModel>();
        List userList = this.userMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"status", (Object)1)).eq((Object)"del_flag", (Object)0));
        for (SysUser user : userList) {
            ComboModel model = new ComboModel();
            model.setTitle(user.getRealname());
            model.setId(user.getId());
            model.setUsername(user.getUsername());
            list.add(model);
        }
        return list;
    }

    public JSONObject queryAllUser(String userIds, Integer pageNo, Integer pageSize) {
        JSONObject json = new JSONObject();
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"status", (Object)1)).eq((Object)"del_flag", (Object)0);
        ArrayList<ComboModel> list = new ArrayList<ComboModel>();
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.userMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        for (SysUser user : pageList.getRecords()) {
            ComboModel model = new ComboModel();
            model.setUsername(user.getUsername());
            model.setTitle(user.getRealname());
            model.setId(user.getId());
            model.setEmail(user.getEmail());
            if (oConvertUtils.isNotEmpty((Object)userIds)) {
                String[] temp = userIds.split(",");
                for (int i = 0; i < temp.length; ++i) {
                    if (!temp[i].equals(user.getId())) continue;
                    model.setChecked(true);
                }
            }
            list.add(model);
        }
        json.put("list", list);
        json.put("total", (Object)pageList.getTotal());
        return json;
    }

    public List<ComboModel> queryAllRole() {
        ArrayList<ComboModel> list = new ArrayList<ComboModel>();
        List roleList = this.roleMapper.selectList((Wrapper)new QueryWrapper());
        for (SysRole role : roleList) {
            ComboModel model = new ComboModel();
            model.setTitle(role.getRoleName());
            model.setId(role.getId());
            list.add(model);
        }
        return list;
    }

    public List<ComboModel> queryAllRole(String[] roleIds) {
        ArrayList<ComboModel> list = new ArrayList<ComboModel>();
        List roleList = this.roleMapper.selectList((Wrapper)new QueryWrapper());
        for (SysRole role : roleList) {
            ComboModel model = new ComboModel();
            model.setTitle(role.getRoleName());
            model.setId(role.getId());
            model.setRoleCode(role.getRoleCode());
            if (oConvertUtils.isNotEmpty((Object)roleIds)) {
                for (int i = 0; i < roleIds.length; ++i) {
                    if (!roleIds[i].equals(role.getId())) continue;
                    model.setChecked(true);
                }
            }
            list.add(model);
        }
        return list;
    }

    public List<String> getRoleIdsByUsername(String username) {
        return this.sysUserRoleMapper.getRoleIdByUserName(username);
    }

    public String getDepartIdsByOrgCode(String orgCode) {
        return this.departMapper.queryDepartIdByOrgCode(orgCode);
    }

    public List<SysDepartModel> getAllSysDepart() {
        ArrayList<SysDepartModel> departModelList = new ArrayList<SysDepartModel>();
        List departList = this.departMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"del_flag", (Object)"0"));
        for (SysDepart depart : departList) {
            SysDepartModel model = new SysDepartModel();
            BeanUtils.copyProperties((Object)depart, (Object)model);
            departModelList.add(model);
        }
        return departModelList;
    }

    public DynamicDataSourceModel getDynamicDbSourceById(String dbSourceId) {
        SysDataSource dbSource = (SysDataSource)this.dataSourceService.getById((Serializable)((Object)dbSourceId));
        if (dbSource != null && StringUtils.isNotBlank((String)dbSource.getDbPassword())) {
            String dbPassword = dbSource.getDbPassword();
            String decodedStr = SecurityUtil.jiemi(dbPassword);
            dbSource.setDbPassword(decodedStr);
        }
        return new DynamicDataSourceModel((Object)dbSource);
    }

    public DynamicDataSourceModel getDynamicDbSourceByCode(String dbSourceCode) {
        SysDataSource dbSource = (SysDataSource)this.dataSourceService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysDataSource::getCode, (Object)dbSourceCode));
        if (dbSource != null && StringUtils.isNotBlank((String)dbSource.getDbPassword())) {
            String dbPassword = dbSource.getDbPassword();
            String decodedStr = SecurityUtil.jiemi(dbPassword);
            dbSource.setDbPassword(decodedStr);
        }
        return new DynamicDataSourceModel((Object)dbSource);
    }

    public List<String> getDeptHeadByDepId(String deptId) {
        List userList = this.userMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().like((Object)"depart_ids", (Object)deptId)).eq((Object)"status", (Object)1)).eq((Object)"del_flag", (Object)0));
        ArrayList<String> list = new ArrayList<String>();
        for (SysUser user : userList) {
            list.add(user.getUsername());
        }
        return list;
    }

    public void sendWebSocketMsg(String[] userIds, String cmd) {
        JSONObject obj = new JSONObject();
        obj.put("cmd", (Object)cmd);
        this.webSocket.sendMessage(userIds, obj.toJSONString());
    }

    public List<LoginUser> queryAllUserByIds(String[] userIds) {
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"status", (Object)1)).eq((Object)"del_flag", (Object)0);
        queryWrapper.in((Object)"id", (Object[])userIds);
        ArrayList<LoginUser> loginUsers = new ArrayList<LoginUser>();
        List sysUsers = this.userMapper.selectList((Wrapper)queryWrapper);
        for (SysUser user : sysUsers) {
            LoginUser loginUser = new LoginUser();
            BeanUtils.copyProperties((Object)user, (Object)loginUser);
            loginUsers.add(loginUser);
        }
        return loginUsers;
    }

    public void meetingSignWebsocket(String userId) {
        JSONObject obj = new JSONObject();
        obj.put("cmd", (Object)"sign");
        obj.put("userId", (Object)userId);
        this.webSocket.sendMessage(obj.toJSONString());
    }

    public List<LoginUser> queryUserByNames(String[] userNames) {
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"status", (Object)1)).eq((Object)"del_flag", (Object)0);
        queryWrapper.in((Object)"username", (Object[])userNames);
        ArrayList<LoginUser> loginUsers = new ArrayList<LoginUser>();
        List sysUsers = this.userMapper.selectList((Wrapper)queryWrapper);
        for (SysUser user : sysUsers) {
            LoginUser loginUser = new LoginUser();
            BeanUtils.copyProperties((Object)user, (Object)loginUser);
            loginUsers.add(loginUser);
        }
        return loginUsers;
    }

    public SysDepartModel selectAllById(String id) {
        SysDepart sysDepart = (SysDepart)this.sysDepartService.getById((Serializable)((Object)id));
        SysDepartModel sysDepartModel = new SysDepartModel();
        BeanUtils.copyProperties((Object)sysDepart, (Object)sysDepartModel);
        return sysDepartModel;
    }

    public List<String> queryDeptUsersByUserId(String userId) {
        ArrayList<String> userIds = new ArrayList<String>();
        List userDepartList = this.sysUserDepartService.list((Wrapper)new QueryWrapper().eq((Object)"user_id", (Object)userId));
        if (userDepartList != null) {
            String orgCodes = "";
            for (SysUserDepart userDepart : userDepartList) {
                SysDepart depart = (SysDepart)this.sysDepartService.getById((Serializable)((Object)userDepart.getDepId()));
                int length = 3;
                String compyOrgCode = "";
                if (depart == null || depart.getOrgCode() == null || orgCodes.indexOf(compyOrgCode = depart.getOrgCode().substring(0, length)) != -1) continue;
                orgCodes = orgCodes + "," + compyOrgCode;
            }
            if (oConvertUtils.isNotEmpty((Object)orgCodes)) {
                orgCodes = orgCodes.substring(1);
                List<String> listIds = this.departMapper.getSubDepIdsByOrgCodes(orgCodes.split(","));
                List userList = this.sysUserDepartService.list((Wrapper)new QueryWrapper().in((Object)"dep_id", listIds));
                for (SysUserDepart userDepart : userList) {
                    if (userIds.contains(userDepart.getUserId())) continue;
                    userIds.add(userDepart.getUserId());
                }
            }
        }
        return userIds;
    }

    public Set<String> getUserRoleSet(String username) {
        List<String> roles = this.sysUserRoleMapper.getRoleByUserName(username);
        log.info("-------\u901a\u8fc7\u6570\u636e\u5e93\u8bfb\u53d6\u7528\u6237\u62e5\u6709\u7684\u89d2\u8272Rules------username\uff1a " + username + ",Roles size: " + (roles == null ? 0 : roles.size()));
        return new HashSet<String>(roles);
    }

    public Set<String> getUserPermissionSet(String username) {
        HashSet<String> permissionSet = new HashSet<String>();
        List<SysPermission> permissionList = this.sysPermissionMapper.queryByUser(username);
        for (SysPermission po : permissionList) {
            if (!oConvertUtils.isNotEmpty((Object)po.getPerms())) continue;
            permissionSet.add(po.getPerms());
        }
        log.info("-------\u901a\u8fc7\u6570\u636e\u5e93\u8bfb\u53d6\u7528\u6237\u62e5\u6709\u7684\u6743\u9650Perms------username\uff1a " + username + ",Perms size: " + (permissionSet == null ? 0 : permissionSet.size()));
        return permissionSet;
    }

    public boolean hasOnlineAuth(OnlineAuthDTO onlineAuthDTO) {
        String username = onlineAuthDTO.getUsername();
        List possibleUrl = onlineAuthDTO.getPossibleUrl();
        String onlineFormUrl = onlineAuthDTO.getOnlineFormUrl();
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysPermission::getDelFlag, (Object)0);
        query.in(SysPermission::getUrl, (Collection)possibleUrl);
        List permissionList = this.sysPermissionMapper.selectList((Wrapper)query);
        if (permissionList == null || permissionList.size() == 0) {
            SysPermission sysPermission = new SysPermission();
            sysPermission.setUrl(onlineFormUrl);
            int count = this.sysPermissionMapper.queryCountByUsername(username, sysPermission);
            return count > 0;
        }
        boolean has = false;
        for (SysPermission p : permissionList) {
            int count = this.sysPermissionMapper.queryCountByUsername(username, p);
            has = has || count > 0;
        }
        return has;
    }

    public Set<String> queryUserRoles(String username) {
        return this.getUserRoleSet(username);
    }

    public Set<String> queryUserAuths(String username) {
        return this.getUserPermissionSet(username);
    }

    public List<JSONObject> queryUsersByUsernames(String usernames) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysUser::getUsername, (Object[])usernames.split(","));
        return JSON.parseArray((String)JSON.toJSONString((Object)this.userMapper.selectList((Wrapper)queryWrapper))).toJavaList(JSONObject.class);
    }

    public List<JSONObject> queryUsersByIds(String ids) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysUser::getId, (Object[])ids.split(","));
        return JSON.parseArray((String)JSON.toJSONString((Object)this.userMapper.selectList((Wrapper)queryWrapper))).toJavaList(JSONObject.class);
    }

    public List<JSONObject> queryDepartsByOrgcodes(String orgCodes) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysDepart::getOrgCode, (Object[])orgCodes.split(","));
        return JSON.parseArray((String)JSON.toJSONString((Object)this.sysDepartService.list((Wrapper)queryWrapper))).toJavaList(JSONObject.class);
    }

    public List<JSONObject> queryDepartsByIds(String ids) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysDepart::getId, (Object[])ids.split(","));
        return JSON.parseArray((String)JSON.toJSONString((Object)this.sysDepartService.list((Wrapper)queryWrapper))).toJavaList(JSONObject.class);
    }

    private void sendSysAnnouncement(String fromUser, String toUser, String title, String msgContent, String setMsgCategory) {
        SysAnnouncement announcement = new SysAnnouncement();
        announcement.setTitile(title);
        announcement.setMsgContent(msgContent);
        announcement.setSender(fromUser);
        announcement.setPriority("M");
        announcement.setMsgType("USER");
        announcement.setSendStatus("1");
        announcement.setSendTime(new Date());
        announcement.setMsgCategory(setMsgCategory);
        announcement.setDelFlag(String.valueOf(CommonConstant.DEL_FLAG_0));
        this.sysAnnouncementMapper.insert(announcement);
        String userId = toUser;
        String[] userIds = userId.split(",");
        String anntId = announcement.getId();
        for (int i = 0; i < userIds.length; ++i) {
            SysUser sysUser;
            if (!oConvertUtils.isNotEmpty((Object)userIds[i]) || (sysUser = this.userMapper.getUserByName(userIds[i])) == null) continue;
            SysAnnouncementSend announcementSend = new SysAnnouncementSend();
            announcementSend.setAnntId(anntId);
            announcementSend.setUserId(sysUser.getId());
            announcementSend.setReadFlag("0");
            this.sysAnnouncementSendMapper.insert(announcementSend);
            JSONObject obj = new JSONObject();
            obj.put("cmd", (Object)"user");
            obj.put("userId", (Object)sysUser.getId());
            obj.put("msgId", (Object)announcement.getId());
            obj.put("msgTxt", (Object)announcement.getTitile());
            this.webSocket.sendMessage(sysUser.getId(), obj.toJSONString());
        }
    }

    private void sendBusAnnouncement(String fromUser, String toUser, String title, String msgContent, String setMsgCategory, String busType, String busId) {
        SysAnnouncement announcement = new SysAnnouncement();
        announcement.setTitile(title);
        announcement.setMsgContent(msgContent);
        announcement.setSender(fromUser);
        announcement.setPriority("M");
        announcement.setMsgType("USER");
        announcement.setSendStatus("1");
        announcement.setSendTime(new Date());
        announcement.setMsgCategory(setMsgCategory);
        announcement.setDelFlag(String.valueOf(CommonConstant.DEL_FLAG_0));
        announcement.setBusId(busId);
        announcement.setBusType(busType);
        announcement.setOpenType(SysAnnmentTypeEnum.getByType((String)busType).getOpenType());
        announcement.setOpenPage(SysAnnmentTypeEnum.getByType((String)busType).getOpenPage());
        this.sysAnnouncementMapper.insert(announcement);
        String userId = toUser;
        String[] userIds = userId.split(",");
        String anntId = announcement.getId();
        for (int i = 0; i < userIds.length; ++i) {
            SysUser sysUser;
            if (!oConvertUtils.isNotEmpty((Object)userIds[i]) || (sysUser = this.userMapper.getUserByName(userIds[i])) == null) continue;
            SysAnnouncementSend announcementSend = new SysAnnouncementSend();
            announcementSend.setAnntId(anntId);
            announcementSend.setUserId(sysUser.getId());
            announcementSend.setReadFlag("0");
            this.sysAnnouncementSendMapper.insert(announcementSend);
            JSONObject obj = new JSONObject();
            obj.put("cmd", (Object)"user");
            obj.put("userId", (Object)sysUser.getId());
            obj.put("msgId", (Object)announcement.getId());
            obj.put("msgTxt", (Object)announcement.getTitile());
            this.webSocket.sendMessage(sysUser.getId(), obj.toJSONString());
        }
    }

    public void sendEmailMsg(String email, String title, String content) {
        EmailSendMsgHandle emailHandle = new EmailSendMsgHandle();
        emailHandle.SendMsg(email, title, content);
    }

    public List<Map> getDeptUserByOrgCode(String orgCode) {
        SysDepart comp = this.sysDepartService.queryCompByOrgCode(orgCode);
        if (comp != null) {
            List<SysDepart> departs = this.sysDepartService.queryDeptByPid(comp.getId());
            ArrayList<Map> list = new ArrayList<Map>();
            for (SysDepart dept : departs) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                String departName = dept.getDepartName();
                List<String> listIds = this.departMapper.getSubDepIdsByDepId(dept.getId());
                List userList = this.sysUserDepartService.list((Wrapper)new QueryWrapper().in((Object)"dep_id", listIds));
                ArrayList<String> userIds = new ArrayList<String>();
                for (SysUserDepart userDepart : userList) {
                    if (userIds.contains(userDepart.getUserId())) continue;
                    userIds.add(userDepart.getUserId());
                }
                map.put("name", departName);
                map.put("ids", userIds);
                list.add(map);
            }
            return list;
        }
        return null;
    }
}

