/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.xkcoding.justauth.AuthRequestFactory;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.request.AuthRequest;
import me.zhyd.oauth.utils.AuthStateUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.util.PasswordUtil;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.base.service.BaseCommonService;
import org.jeecg.modules.system.entity.SysThirdAccount;
import org.jeecg.modules.system.entity.SysUser;
import org.jeecg.modules.system.model.ThirdLoginModel;
import org.jeecg.modules.system.service.ISysThirdAccountService;
import org.jeecg.modules.system.service.ISysUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sys/thirdLogin"})
public class ThirdLoginController {
    private static final Logger log = LoggerFactory.getLogger(ThirdLoginController.class);
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private ISysThirdAccountService sysThirdAccountService;
    @Autowired
    private BaseCommonService baseCommonService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private AuthRequestFactory factory;

    @RequestMapping(value={"/render/{source}"})
    public void render(@PathVariable(value="source") String source, HttpServletResponse response) throws IOException {
        log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165render\uff1a" + source);
        AuthRequest authRequest = this.factory.get(source);
        String authorizeUrl = authRequest.authorize(AuthStateUtils.createState());
        log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8ba4\u8bc1\u5730\u5740\uff1a" + authorizeUrl);
        response.sendRedirect(authorizeUrl);
    }

    @RequestMapping(value={"/{source}/callback"})
    public String loginThird(@PathVariable(value="source") String source, AuthCallback callback, ModelMap modelMap) {
        log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165callback\uff1a" + source + " params\uff1a" + JSONObject.toJSONString((Object)callback));
        AuthRequest authRequest = this.factory.get(source);
        AuthResponse response = authRequest.login(callback);
        log.info(JSONObject.toJSONString((Object)response));
        Result result = new Result();
        if (response.getCode() == 2000) {
            JSONObject data = JSONObject.parseObject((String)JSONObject.toJSONString((Object)response.getData()));
            String username = data.getString("username");
            String avatar = data.getString("avatar");
            String uuid = data.getString("uuid");
            ThirdLoginModel tlm = new ThirdLoginModel(source, uuid, username, avatar);
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(SysThirdAccount::getThirdUserUuid, (Object)uuid);
            query.eq(SysThirdAccount::getThirdType, (Object)source);
            List thridList = this.sysThirdAccountService.list((Wrapper)query);
            SysThirdAccount user = null;
            user = thridList == null || thridList.size() == 0 ? this.saveThirdUser(tlm) : (SysThirdAccount)thridList.get(0);
            if (oConvertUtils.isNotEmpty((Object)user.getSysUserId())) {
                String sysUserId = user.getSysUserId();
                SysUser sysUser = (SysUser)this.sysUserService.getById((Serializable)((Object)sysUserId));
                String token = this.saveToken(sysUser);
                modelMap.addAttribute("token", (Object)token);
            } else {
                modelMap.addAttribute("token", (Object)("\u7ed1\u5b9a\u624b\u673a\u53f7," + uuid));
            }
        } else {
            modelMap.addAttribute("token", (Object)"\u767b\u5f55\u5931\u8d25");
        }
        result.setSuccess(false);
        result.setMessage("\u7b2c\u4e09\u65b9\u767b\u5f55\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        return "thirdLogin";
    }

    @PostMapping(value={"/user/create"})
    @ResponseBody
    public Result<String> thirdUserCreate(@RequestBody ThirdLoginModel model) {
        log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u521b\u5efa\u65b0\u8d26\u53f7\uff1a");
        Result res = new Result();
        Object operateCode = this.redisUtil.get("third_login_code");
        if (operateCode == null || !operateCode.toString().equals(model.getOperateCode())) {
            res.setSuccess(false);
            res.setMessage("\u6821\u9a8c\u5931\u8d25");
            return res;
        }
        SysThirdAccount user = this.saveThirdUser(model);
        if (oConvertUtils.isNotEmpty((Object)user.getSysUserId())) {
            String sysUserId = user.getSysUserId();
            SysUser sysUser = (SysUser)this.sysUserService.getById((Serializable)((Object)sysUserId));
            String token = this.saveToken(sysUser);
            res.setResult((Object)token);
            res.setSuccess(true);
        }
        return res;
    }

    @PostMapping(value={"/user/checkPassword"})
    @ResponseBody
    public Result<String> checkPassword(@RequestBody JSONObject json) {
        Result result = new Result();
        Object operateCode = this.redisUtil.get("third_login_code");
        if (operateCode == null || !operateCode.toString().equals(json.getString("operateCode"))) {
            result.setSuccess(false);
            result.setMessage("\u6821\u9a8c\u5931\u8d25");
            return result;
        }
        String username = json.getString("uuid");
        SysUser user = this.sysUserService.getUserByName(username);
        if (user == null) {
            result.setMessage("\u7528\u6237\u672a\u627e\u5230");
            result.setSuccess(false);
            return result;
        }
        String password = json.getString("password");
        String salt = user.getSalt();
        String passwordEncode = PasswordUtil.encrypt((String)user.getUsername(), (String)password, (String)salt);
        if (!passwordEncode.equals(user.getPassword())) {
            result.setMessage("\u5bc6\u7801\u4e0d\u6b63\u786e");
            result.setSuccess(false);
            return result;
        }
        this.sysUserService.updateById(user);
        result.setSuccess(true);
        String token = this.saveToken(user);
        result.setResult((Object)token);
        return result;
    }

    private SysThirdAccount saveThirdUser(ThirdLoginModel tlm) {
        SysThirdAccount user = new SysThirdAccount();
        user.setDelFlag(CommonConstant.DEL_FLAG_0);
        user.setStatus(1);
        user.setThirdType(tlm.getSource());
        user.setAvatar(tlm.getAvatar());
        user.setRealname(tlm.getUsername());
        user.setThirdUserUuid(tlm.getUuid());
        this.sysThirdAccountService.save(user);
        return user;
    }

    private String saveToken(SysUser user) {
        String token = JwtUtil.sign((String)user.getUsername(), (String)user.getPassword());
        this.redisUtil.set("prefix_user_token_" + token, (Object)token);
        this.redisUtil.expire("prefix_user_token_" + token, 1800L);
        return token;
    }

    @RequestMapping(value={"/getLoginUser/{token}/{thirdType}"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<JSONObject> getThirdLoginUser(@PathVariable(value="token") String token, @PathVariable(value="thirdType") String thirdType) throws Exception {
        Result result = new Result();
        String username = JwtUtil.getUsername((String)token);
        SysUser sysUser = this.sysUserService.getUserByName(username);
        result = this.sysUserService.checkUserIsEffective(sysUser);
        if (!result.isSuccess()) {
            return result;
        }
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysThirdAccount::getSysUserId, (Object)sysUser.getId());
        query.eq(SysThirdAccount::getThirdType, (Object)thirdType);
        SysThirdAccount account = (SysThirdAccount)this.sysThirdAccountService.getOne((Wrapper)query);
        if (oConvertUtils.isEmpty((Object)sysUser.getRealname())) {
            sysUser.setRealname(account.getRealname());
        }
        if (oConvertUtils.isEmpty((Object)sysUser.getAvatar())) {
            sysUser.setAvatar(account.getAvatar());
        }
        JSONObject obj = new JSONObject();
        obj.put("userInfo", (Object)sysUser);
        obj.put("token", (Object)token);
        result.setResult((Object)obj);
        result.setSuccess(true);
        result.setCode(Integer.valueOf(200));
        this.baseCommonService.addLog("\u7528\u6237\u540d: " + username + ",\u767b\u5f55\u6210\u529f[\u7b2c\u4e09\u65b9\u7528\u6237]\uff01", Integer.valueOf(1), null);
        return result;
    }

    @ApiOperation(value="\u624b\u673a\u53f7\u767b\u5f55\u63a5\u53e3")
    @PostMapping(value={"/bindingThirdPhone"})
    @ResponseBody
    public Result<String> bindingThirdPhone(@RequestBody JSONObject jsonObject) {
        Result result = new Result();
        String phone = jsonObject.getString("mobile");
        String thirdUserUuid = jsonObject.getString("thirdUserUuid");
        SysUser sysUser = this.sysUserService.getUserByPhone(phone);
        if (sysUser != null) {
            this.sysThirdAccountService.updateThirdUserId(sysUser, thirdUserUuid);
        } else {
            Object code;
            String smscode = jsonObject.getString("captcha");
            if (!smscode.equals(code = this.redisUtil.get(phone))) {
                result.setMessage("\u624b\u673a\u9a8c\u8bc1\u7801\u9519\u8bef");
                result.setSuccess(false);
                return result;
            }
            sysUser = this.sysThirdAccountService.createUser(phone, thirdUserUuid);
        }
        String token = this.saveToken(sysUser);
        result.setSuccess(true);
        result.setResult((Object)token);
        return result;
    }
}

