/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.system.entity.SysDictItem;
import org.jeecg.modules.system.service.ISysDictItemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/dictItem"})
public class SysDictItemController {
    private static final Logger log = LoggerFactory.getLogger(SysDictItemController.class);
    @Autowired
    private ISysDictItemService sysDictItemService;

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public Result<IPage<SysDictItem>> queryPageList(SysDictItem sysDictItem, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result result = new Result();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysDictItem, (Map)req.getParameterMap());
        queryWrapper.orderByAsc((Object)"sort_order");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.sysDictItemService.page((IPage)page, (Wrapper)queryWrapper);
        result.setSuccess(true);
        result.setResult((Object)pageList);
        return result;
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    @CacheEvict(value={"sys:cache:dict"}, allEntries=true)
    public Result<SysDictItem> add(@RequestBody SysDictItem sysDictItem) {
        Result result = new Result();
        try {
            sysDictItem.setCreateTime(new Date());
            this.sysDictItemService.save(sysDictItem);
            result.success("\u4fdd\u5b58\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.PUT})
    @CacheEvict(value={"sys:cache:dict"}, allEntries=true)
    public Result<SysDictItem> edit(@RequestBody SysDictItem sysDictItem) {
        Result result = new Result();
        SysDictItem sysdict = (SysDictItem)this.sysDictItemService.getById((Serializable)((Object)sysDictItem.getId()));
        if (sysdict == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            sysDictItem.setUpdateTime(new Date());
            boolean ok = this.sysDictItemService.updateById(sysDictItem);
            if (ok) {
                result.success("\u7f16\u8f91\u6210\u529f!");
            }
        }
        return result;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.DELETE})
    @CacheEvict(value={"sys:cache:dict"}, allEntries=true)
    public Result<SysDictItem> delete(@RequestParam(name="id", required=true) String id) {
        Result result = new Result();
        SysDictItem joinSystem = (SysDictItem)this.sysDictItemService.getById((Serializable)((Object)id));
        if (joinSystem == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            boolean ok = this.sysDictItemService.removeById((Serializable)((Object)id));
            if (ok) {
                result.success("\u5220\u9664\u6210\u529f!");
            }
        }
        return result;
    }

    @RequestMapping(value={"/deleteBatch"}, method={RequestMethod.DELETE})
    @CacheEvict(value={"sys:cache:dict"}, allEntries=true)
    public Result<SysDictItem> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        Result result = new Result();
        if (ids == null || "".equals(ids.trim())) {
            result.error500("\u53c2\u6570\u4e0d\u8bc6\u522b\uff01");
        } else {
            this.sysDictItemService.removeByIds(Arrays.asList(ids.split(",")));
            result.success("\u5220\u9664\u6210\u529f!");
        }
        return result;
    }

    @RequestMapping(value={"/dictItemCheck"}, method={RequestMethod.GET})
    @ApiOperation(value="\u5b57\u5178\u91cd\u590d\u6821\u9a8c\u63a5\u53e3")
    public Result<Object> doDictItemCheck(SysDictItem sysDictItem, HttpServletRequest request) {
        int num = 0;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysDictItem::getItemValue, (Object)sysDictItem.getItemValue());
        queryWrapper.eq(SysDictItem::getDictId, (Object)sysDictItem.getDictId());
        if (StringUtils.isNotBlank((String)sysDictItem.getId())) {
            queryWrapper.ne(SysDictItem::getId, (Object)sysDictItem.getId());
        }
        if ((num = this.sysDictItemService.count((Wrapper)queryWrapper)) == 0) {
            return Result.ok((String)"\u8be5\u503c\u53ef\u7528\uff01");
        }
        log.info("\u8be5\u503c\u4e0d\u53ef\u7528\uff0c\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff01");
        return Result.error((String)"\u8be5\u503c\u4e0d\u53ef\u7528\uff0c\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff01");
    }
}

