/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.vo.DictModel;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysCategory;
import org.jeecg.modules.system.model.TreeSelectModel;
import org.jeecg.modules.system.service.ISysCategoryService;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@RestController
@RequestMapping(value={"/sys/category"})
public class SysCategoryController {
    private static final Logger log = LoggerFactory.getLogger(SysCategoryController.class);
    @Autowired
    private ISysCategoryService sysCategoryService;

    @GetMapping(value={"/rootList"})
    public Result<IPage<SysCategory>> queryPageList(SysCategory sysCategory, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        if (oConvertUtils.isEmpty((Object)sysCategory.getPid())) {
            sysCategory.setPid("0");
        }
        Result result = new Result();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"pid", (Object)sysCategory.getPid());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.sysCategoryService.page((IPage)page, (Wrapper)queryWrapper);
        result.setSuccess(true);
        result.setResult((Object)pageList);
        return result;
    }

    @GetMapping(value={"/childList"})
    public Result<List<SysCategory>> queryPageList(SysCategory sysCategory, HttpServletRequest req) {
        Result result = new Result();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysCategory, (Map)req.getParameterMap());
        List list = this.sysCategoryService.list((Wrapper)queryWrapper);
        result.setSuccess(true);
        result.setResult((Object)list);
        return result;
    }

    @PostMapping(value={"/add"})
    public Result<SysCategory> add(@RequestBody SysCategory sysCategory) {
        Result result = new Result();
        try {
            this.sysCategoryService.addSysCategory(sysCategory);
            result.success("\u6dfb\u52a0\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @PutMapping(value={"/edit"})
    public Result<SysCategory> edit(@RequestBody SysCategory sysCategory) {
        Result result = new Result();
        SysCategory sysCategoryEntity = (SysCategory)this.sysCategoryService.getById((Serializable)((Object)sysCategory.getId()));
        if (sysCategoryEntity == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            this.sysCategoryService.updateSysCategory(sysCategory);
            result.success("\u4fee\u6539\u6210\u529f!");
        }
        return result;
    }

    @DeleteMapping(value={"/delete"})
    public Result<SysCategory> delete(@RequestParam(name="id", required=true) String id) {
        Result result = new Result();
        SysCategory sysCategory = (SysCategory)this.sysCategoryService.getById((Serializable)((Object)id));
        if (sysCategory == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            this.sysCategoryService.deleteSysCategory(id);
            result.success("\u5220\u9664\u6210\u529f!");
        }
        return result;
    }

    @DeleteMapping(value={"/deleteBatch"})
    public Result<SysCategory> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        Result result = new Result();
        if (ids == null || "".equals(ids.trim())) {
            result.error500("\u53c2\u6570\u4e0d\u8bc6\u522b\uff01");
        } else {
            this.sysCategoryService.deleteSysCategory(ids);
            result.success("\u5220\u9664\u6210\u529f!");
        }
        return result;
    }

    @GetMapping(value={"/queryById"})
    public Result<SysCategory> queryById(@RequestParam(name="id", required=true) String id) {
        Result result = new Result();
        SysCategory sysCategory = (SysCategory)this.sysCategoryService.getById((Serializable)((Object)id));
        if (sysCategory == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            result.setResult((Object)sysCategory);
            result.setSuccess(true);
        }
        return result;
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, SysCategory sysCategory) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysCategory, (Map)request.getParameterMap());
        List pageList = this.sysCategoryService.list((Wrapper)queryWrapper);
        ModelAndView mv = new ModelAndView((View)new JeecgEntityExcelView());
        String selections = request.getParameter("selections");
        if (oConvertUtils.isEmpty((Object)selections)) {
            mv.addObject("data", (Object)pageList);
        } else {
            List<String> selectionList = Arrays.asList(selections.split(","));
            List exportList = pageList.stream().filter(item -> selectionList.contains(item.getId())).collect(Collectors.toList());
            mv.addObject("data", exportList);
        }
        mv.addObject("fileName", (Object)"\u5206\u7c7b\u5b57\u5178\u5217\u8868");
        mv.addObject("entity", SysCategory.class);
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        mv.addObject("params", (Object)new ExportParams("\u5206\u7c7b\u5b57\u5178\u5217\u8868\u6570\u636e", "\u5bfc\u51fa\u4eba:" + user.getRealname(), "\u5bfc\u51fa\u4fe1\u606f"));
        return mv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Iterator iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entity = iterator.next();
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                List listSysCategorys = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), SysCategory.class, (ImportParams)params);
                Collections.sort(listSysCategorys);
                log.info("\u6392\u5e8f\u540e\u7684list====>", (Object)listSysCategorys);
                for (SysCategory sysCategoryExcel : listSysCategorys) {
                    String code = sysCategoryExcel.getCode();
                    if (code.length() > 3) {
                        String pCode = sysCategoryExcel.getCode().substring(0, code.length() - 3);
                        log.info("pCode====>", (Object)pCode);
                        String pId = this.sysCategoryService.queryIdByCode(pCode);
                        log.info("pId====>", (Object)pId);
                        if (StringUtils.isNotBlank((String)pId)) {
                            sysCategoryExcel.setPid(pId);
                        }
                    } else {
                        sysCategoryExcel.setPid("0");
                    }
                    this.sysCategoryService.save(sysCategoryExcel);
                }
                Result result = Result.ok((String)("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01\u6570\u636e\u884c\u6570\uff1a" + listSysCategorys.size()));
                return result;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Result result = Result.error((String)("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage()));
                return result;
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return Result.error((String)"\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/loadOne"}, method={RequestMethod.GET})
    public Result<SysCategory> loadOne(@RequestParam(name="field") String field, @RequestParam(name="val") String val) {
        Result result = new Result();
        try {
            QueryWrapper query = new QueryWrapper();
            query.eq((Object)field, (Object)val);
            List ls = this.sysCategoryService.list((Wrapper)query);
            if (ls == null || ls.size() == 0) {
                result.setMessage("\u67e5\u8be2\u65e0\u679c");
                result.setSuccess(false);
            } else if (ls.size() > 1) {
                result.setMessage("\u67e5\u8be2\u6570\u636e\u5f02\u5e38,[" + field + "]\u5b58\u5728\u591a\u4e2a\u503c:" + val);
                result.setSuccess(false);
            } else {
                result.setSuccess(true);
                result.setResult((Object)((SysCategory)ls.get(0)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result.setMessage(e.getMessage());
            result.setSuccess(false);
        }
        return result;
    }

    @RequestMapping(value={"/loadTreeChildren"}, method={RequestMethod.GET})
    public Result<List<TreeSelectModel>> loadTreeChildren(@RequestParam(name="pid") String pid) {
        Result result = new Result();
        try {
            List<TreeSelectModel> ls = this.sysCategoryService.queryListByPid(pid);
            result.setResult(ls);
            result.setSuccess(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            result.setMessage(e.getMessage());
            result.setSuccess(false);
        }
        return result;
    }

    @RequestMapping(value={"/loadTreeRoot"}, method={RequestMethod.GET})
    public Result<List<TreeSelectModel>> loadTreeRoot(@RequestParam(name="async") Boolean async, @RequestParam(name="pcode") String pcode) {
        Result result = new Result();
        try {
            List<TreeSelectModel> ls = this.sysCategoryService.queryListByCode(pcode);
            if (!async.booleanValue()) {
                this.loadAllCategoryChildren(ls);
            }
            result.setResult(ls);
            result.setSuccess(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            result.setMessage(e.getMessage());
            result.setSuccess(false);
        }
        return result;
    }

    private void loadAllCategoryChildren(List<TreeSelectModel> ls) {
        for (TreeSelectModel tsm : ls) {
            List<TreeSelectModel> temp = this.sysCategoryService.queryListByPid(tsm.getKey());
            if (temp == null || temp.size() <= 0) continue;
            tsm.setChildren(temp);
            this.loadAllCategoryChildren(temp);
        }
    }

    @GetMapping(value={"/checkCode"})
    public Result<?> checkCode(@RequestParam(name="pid", required=false) String pid, @RequestParam(name="code", required=false) String code) {
        if (oConvertUtils.isEmpty((Object)code)) {
            return Result.error((String)"\u9519\u8bef,\u7c7b\u578b\u7f16\u7801\u4e3a\u7a7a!");
        }
        if (oConvertUtils.isEmpty((Object)pid)) {
            return Result.ok();
        }
        SysCategory parent = (SysCategory)this.sysCategoryService.getById((Serializable)((Object)pid));
        if (code.startsWith(parent.getCode())) {
            return Result.ok();
        }
        return Result.error((String)("\u7f16\u7801\u4e0d\u7b26\u5408\u89c4\u8303,\u987b\u4ee5\"" + parent.getCode() + "\"\u5f00\u5934!"));
    }

    @RequestMapping(value={"/loadTreeData"}, method={RequestMethod.GET})
    public Result<List<TreeSelectModel>> loadDict(@RequestParam(name="pid", required=false) String pid, @RequestParam(name="pcode", required=false) String pcode, @RequestParam(name="condition", required=false) String condition) {
        Result result = new Result();
        if (oConvertUtils.isEmpty((Object)pid)) {
            if (oConvertUtils.isEmpty((Object)pcode)) {
                result.setSuccess(false);
                result.setMessage("\u52a0\u8f7d\u5206\u7c7b\u5b57\u5178\u6811\u53c2\u6570\u6709\u8bef.[null]!");
                return result;
            }
            pid = "0".equals(pcode) ? "0" : this.sysCategoryService.queryIdByCode(pcode);
            if (oConvertUtils.isEmpty((Object)pid)) {
                result.setSuccess(false);
                result.setMessage("\u52a0\u8f7d\u5206\u7c7b\u5b57\u5178\u6811\u53c2\u6570\u6709\u8bef.[code]!");
                return result;
            }
        }
        Map query = null;
        if (oConvertUtils.isNotEmpty((Object)condition)) {
            query = (Map)JSON.parseObject((String)condition, Map.class);
        }
        List<TreeSelectModel> ls = this.sysCategoryService.queryListByPid(pid, query);
        result.setSuccess(true);
        result.setResult(ls);
        return result;
    }

    @RequestMapping(value={"/loadDictItem"}, method={RequestMethod.GET})
    public Result<List<String>> loadDictItem(@RequestParam(name="ids") String ids, @RequestParam(name="delNotExist", required=false, defaultValue="true") boolean delNotExist) {
        Result result = new Result();
        if (StringUtils.isBlank((String)ids)) {
            result.setSuccess(false);
            result.setMessage("ids \u4e0d\u80fd\u4e3a\u7a7a");
            return result;
        }
        List<String> textList = this.sysCategoryService.loadDictItem(ids, delNotExist);
        result.setSuccess(true);
        result.setResult(textList);
        return result;
    }

    @RequestMapping(value={"/loadAllData"}, method={RequestMethod.GET})
    public Result<List<DictModel>> loadAllData(@RequestParam(name="code", required=true) String code) {
        List list;
        Result result = new Result();
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        if (oConvertUtils.isNotEmpty((Object)code) && !"0".equals(code)) {
            query.likeRight(SysCategory::getCode, (Object)code);
        }
        if ((list = this.sysCategoryService.list((Wrapper)query)) == null || list.size() == 0) {
            result.setMessage("\u65e0\u6570\u636e,\u53c2\u6570\u6709\u8bef.[code]");
            result.setSuccess(false);
            return result;
        }
        ArrayList<DictModel> rdList = new ArrayList<DictModel>();
        for (SysCategory c : list) {
            rdList.add(new DictModel(c.getId(), c.getName()));
        }
        result.setSuccess(true);
        result.setResult(rdList);
        return result;
    }

    @GetMapping(value={"/getChildListBatch"})
    public Result getChildListBatch(@RequestParam(value="parentIds") String parentIds) {
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            List<String> parentIdList = Arrays.asList(parentIds.split(","));
            queryWrapper.in((Object)"pid", parentIdList);
            List list = this.sysCategoryService.list((Wrapper)queryWrapper);
            Page pageList = new Page(1L, 10L, (long)list.size());
            pageList.setRecords(list);
            return Result.OK((Object)pageList);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)("\u6279\u91cf\u67e5\u8be2\u5b50\u8282\u70b9\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }
}

