/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.util.CommonUtils;
import org.jeecg.common.util.RestUtil;
import org.jeecg.common.util.TokenUtils;
import org.jeecg.common.util.oConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/sys/common"})
public class CommonController {
    private static final Logger log = LoggerFactory.getLogger(CommonController.class);
    @Autowired
    private ISysBaseAPI sysBaseAPI;
    @Value(value="${jeecg.path.upload}")
    private String uploadpath;
    @Value(value="${jeecg.uploadType}")
    private String uploadType;

    @GetMapping(value={"/403"})
    public Result<?> noauth() {
        return Result.error((String)"\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743");
    }

    @PostMapping(value={"/upload"})
    public Result<?> upload(HttpServletRequest request, HttpServletResponse response) {
        Result result = new Result();
        String savePath = "";
        String bizPath = request.getParameter("biz");
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        MultipartFile file = multipartRequest.getFile("file");
        if (oConvertUtils.isEmpty((Object)bizPath)) {
            bizPath = "alioss".equals(this.uploadType) ? "upload" : "";
        }
        if (oConvertUtils.isNotEmpty((Object)(savePath = "local".equals(this.uploadType) ? this.uploadLocal(file, bizPath) : CommonUtils.upload((MultipartFile)file, (String)bizPath, (String)this.uploadType)))) {
            result.setMessage(savePath);
            result.setSuccess(true);
        } else {
            result.setMessage("\u4e0a\u4f20\u5931\u8d25\uff01");
            result.setSuccess(false);
        }
        return result;
    }

    private String uploadLocal(MultipartFile mf, String bizPath) {
        try {
            String ctxPath = this.uploadpath;
            String fileName = null;
            File file = new File(ctxPath + File.separator + bizPath + File.separator);
            if (!file.exists()) {
                file.mkdirs();
            }
            String orgName = mf.getOriginalFilename();
            fileName = (orgName = CommonUtils.getFileName((String)orgName)).indexOf(".") != -1 ? orgName.substring(0, orgName.lastIndexOf(".")) + "_" + System.currentTimeMillis() + orgName.substring(orgName.lastIndexOf(".")) : orgName + "_" + System.currentTimeMillis();
            String savePath = file.getPath() + File.separator + fileName;
            File savefile = new File(savePath);
            FileCopyUtils.copy((byte[])mf.getBytes(), (File)savefile);
            String dbpath = null;
            dbpath = oConvertUtils.isNotEmpty((Object)bizPath) ? bizPath + File.separator + fileName : fileName;
            if (dbpath.contains("\\")) {
                dbpath = dbpath.replace("\\", "/");
            }
            return dbpath;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/static/**"})
    public void view(HttpServletRequest request, HttpServletResponse response) {
        String imgPath = CommonController.extractPathFromPattern(request);
        if (oConvertUtils.isEmpty((Object)imgPath) || imgPath == "null") {
            return;
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int len;
            String filePath;
            File file;
            imgPath = imgPath.replace("..", "");
            if (imgPath.endsWith(",")) {
                imgPath = imgPath.substring(0, imgPath.length() - 1);
            }
            if (!(file = new File(filePath = this.uploadpath + File.separator + imgPath)).exists()) {
                response.setStatus(404);
                throw new RuntimeException("\u6587\u4ef6[" + imgPath + "]\u4e0d\u5b58\u5728..");
            }
            response.setContentType("application/force-download");
            response.addHeader("Content-Disposition", "attachment;fileName=" + new String(file.getName().getBytes("UTF-8"), "iso-8859-1"));
            inputStream = new BufferedInputStream(new FileInputStream(filePath));
            outputStream = response.getOutputStream();
            byte[] buf = new byte[1024];
            while ((len = inputStream.read(buf)) > 0) {
                outputStream.write(buf, 0, len);
            }
            response.flushBuffer();
        }
        catch (IOException e) {
            log.error("\u9884\u89c8\u6587\u4ef6\u5931\u8d25" + e.getMessage());
            response.setStatus(404);
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @RequestMapping(value={"/pdf/pdfPreviewIframe"})
    public ModelAndView pdfPreviewIframe(ModelAndView modelAndView) {
        modelAndView.setViewName("pdfPreviewIframe");
        return modelAndView;
    }

    private static String extractPathFromPattern(HttpServletRequest request) {
        String path = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        String bestMatchPattern = (String)request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        return new AntPathMatcher().extractPathWithinPattern(bestMatchPattern, path);
    }

    @RequestMapping(value={"/transitRESTful"})
    public Result transitRESTful(@RequestParam(value="url") String url, HttpServletRequest request) {
        try {
            JSONObject params;
            ServletServerHttpRequest httpRequest = new ServletServerHttpRequest(request);
            HttpMethod method = httpRequest.getMethod();
            try {
                params = JSON.parseObject((String)JSON.toJSONString((Object)httpRequest.getBody()));
            }
            catch (Exception e) {
                params = new JSONObject();
            }
            JSONObject variables = JSON.parseObject((String)JSON.toJSONString((Object)request.getParameterMap()));
            variables.remove((Object)"url");
            String token = TokenUtils.getTokenByRequest((HttpServletRequest)request);
            HttpHeaders headers = new HttpHeaders();
            headers.set("X-Access-Token", token);
            String httpURL = URLDecoder.decode(url, "UTF-8");
            ResponseEntity response = RestUtil.request((String)httpURL, (HttpMethod)method, (HttpHeaders)headers, (JSONObject)variables, (Object)params, String.class);
            Result result = new Result();
            int statusCode = response.getStatusCodeValue();
            result.setCode(Integer.valueOf(statusCode));
            result.setSuccess(statusCode == 200);
            String responseBody = (String)response.getBody();
            try {
                Object json = JSON.parse((String)responseBody);
                result.setResult(json);
            }
            catch (Exception e) {
                result.setResult((Object)responseBody);
            }
            return result;
        }
        catch (Exception e) {
            log.debug("\u4e2d\u8f6cHTTP\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

