/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config.mybatis;

import com.baomidou.mybatisplus.extension.plugins.tenant.TenantSqlParser;
import java.util.List;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.SupportsOldOracleJoinSyntax;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SubSelect;

public class JeecgTenantParser
extends TenantSqlParser {
    protected Expression processTableAlias(Expression expression, Table table) {
        Between between;
        String tableAliasName = table.getAlias() == null ? table.getName() : table.getAlias().getName();
        if (expression instanceof InExpression) {
            InExpression in = (InExpression)expression;
            if (in.getLeftExpression() instanceof Column) {
                this.setTableAliasNameForColumn((Column)in.getLeftExpression(), tableAliasName);
            }
        } else if (expression instanceof BinaryExpression) {
            BinaryExpression compare = (BinaryExpression)expression;
            if (compare.getLeftExpression() instanceof Column) {
                this.setTableAliasNameForColumn((Column)compare.getLeftExpression(), tableAliasName);
            } else if (compare.getRightExpression() instanceof Column) {
                this.setTableAliasNameForColumn((Column)compare.getRightExpression(), tableAliasName);
            }
        } else if (expression instanceof Between && (between = (Between)expression).getLeftExpression() instanceof Column) {
            this.setTableAliasNameForColumn((Column)between.getLeftExpression(), tableAliasName);
        }
        return expression;
    }

    private void setTableAliasNameForColumn(Column column, String tableAliasName) {
        column.setColumnName(tableAliasName + "." + column.getColumnName());
    }

    protected Expression builderExpression(Expression currentExpression, Table table) {
        InExpression inExp;
        ItemsList rightItems;
        EqualsTo appendExpression;
        Expression tenantExpression = this.getTenantHandler().getTenantId(true);
        if (!(tenantExpression instanceof SupportsOldOracleJoinSyntax)) {
            appendExpression = new EqualsTo();
            appendExpression.setLeftExpression((Expression)this.getAliasColumn(table));
            appendExpression.setRightExpression(tenantExpression);
        } else {
            appendExpression = this.processTableAlias(tenantExpression, table);
        }
        if (currentExpression == null) {
            return appendExpression;
        }
        if (currentExpression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)currentExpression;
            if (binaryExpression.getLeftExpression() instanceof FromItem) {
                this.processFromItem((FromItem)binaryExpression.getLeftExpression());
            }
            if (binaryExpression.getRightExpression() instanceof FromItem) {
                this.processFromItem((FromItem)binaryExpression.getRightExpression());
            }
        } else if (currentExpression instanceof InExpression && (rightItems = (inExp = (InExpression)currentExpression).getRightItemsList()) instanceof SubSelect) {
            this.processSelectBody(((SubSelect)rightItems).getSelectBody());
        }
        if (currentExpression instanceof OrExpression) {
            return new AndExpression((Expression)new Parenthesis(currentExpression), (Expression)appendExpression);
        }
        return new AndExpression(currentExpression, (Expression)appendExpression);
    }

    protected void processPlainSelect(PlainSelect plainSelect, boolean addColumn) {
        FromItem fromItem = plainSelect.getFromItem();
        if (fromItem instanceof Table) {
            Table fromTable = (Table)fromItem;
            if (!this.getTenantHandler().doTableFilter(fromTable.getName())) {
                plainSelect.setWhere(this.builderExpression(plainSelect.getWhere(), fromTable));
                if (addColumn) {
                    plainSelect.getSelectItems().add(new SelectExpressionItem((Expression)new Column(this.getTenantHandler().getTenantIdColumn())));
                }
            }
        } else {
            this.processFromItem(fromItem);
        }
        List joins = plainSelect.getJoins();
        if (joins != null && joins.size() > 0) {
            joins.forEach(j -> {
                this.processJoin((Join)j);
                this.processFromItem(j.getRightItem());
            });
        }
    }
}

