/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.system.util;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.common.base.Joiner;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.util.JeecgDataAutorUtils;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.system.vo.SysUserCacheInfo;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;

public class JwtUtil {
    public static final long EXPIRE_TIME = 1800000L;

    public static boolean verify(String token, String username, String secret) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)secret);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withClaim("username", username).build();
            DecodedJWT jwt = verifier.verify(token);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getUsername(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("username").asString();
        }
        catch (JWTDecodeException e) {
            return null;
        }
    }

    public static String sign(String username, String secret) {
        Date date = new Date(System.currentTimeMillis() + 1800000L);
        Algorithm algorithm = Algorithm.HMAC256((String)secret);
        return JWT.create().withClaim("username", username).withExpiresAt(date).sign(algorithm);
    }

    public static String getUserNameByToken(HttpServletRequest request) throws JeecgBootException {
        String accessToken = request.getHeader("X-Access-Token");
        String username = JwtUtil.getUsername(accessToken);
        if (oConvertUtils.isEmpty(username)) {
            throw new JeecgBootException("\u672a\u83b7\u53d6\u5230\u7528\u6237");
        }
        return username;
    }

    public static String getSessionData(String key) {
        String moshi = "";
        if (key.indexOf("}") != -1) {
            moshi = key.substring(key.indexOf("}") + 1);
        }
        String returnValue = null;
        if (key.contains("#{")) {
            key = key.substring(2, key.indexOf("}"));
        }
        if (oConvertUtils.isNotEmpty(key)) {
            HttpSession session = SpringContextUtils.getHttpServletRequest().getSession();
            returnValue = (String)session.getAttribute(key);
        }
        if (returnValue != null) {
            returnValue = returnValue + moshi;
        }
        return returnValue;
    }

    public static String getUserSystemData(String key, SysUserCacheInfo user) {
        if (user == null) {
            user = JeecgDataAutorUtils.loadUserInfo();
        }
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String moshi = "";
        if (key.indexOf("}") != -1) {
            moshi = key.substring(key.indexOf("}") + 1);
        }
        String returnValue = null;
        if (key.contains("#{")) {
            key = key.substring(2, key.indexOf("}"));
        }
        if (key.equals("sysUserCode") || key.toLowerCase().equals("sys_user_code")) {
            returnValue = user == null ? sysUser.getUsername() : user.getSysUserCode();
        } else if (key.equals("sysUserName") || key.toLowerCase().equals("sys_user_name")) {
            returnValue = user == null ? sysUser.getRealname() : user.getSysUserName();
        } else if (key.equals("sysOrgCode") || key.toLowerCase().equals("sys_org_code")) {
            returnValue = user == null ? sysUser.getOrgCode() : user.getSysOrgCode();
        } else if (key.equals("sysMultiOrgCode") || key.toLowerCase().equals("sys_multi_org_code")) {
            returnValue = user == null ? sysUser.getOrgCode() : (user.isOneDepart() ? user.getSysMultiOrgCode().get(0) : Joiner.on((String)",").join(user.getSysMultiOrgCode()));
        } else if (key.equals("sysDate") || key.toLowerCase().equals("sys_date")) {
            returnValue = DateUtils.formatDate();
        } else if (key.equals("sysTime") || key.toLowerCase().equals("sys_time")) {
            returnValue = DateUtils.now();
        } else if (key.equals("bpmStatus") || key.toLowerCase().equals("bpm_status")) {
            returnValue = "1";
        } else if ((key.equals("tenantId") || key.toLowerCase().equals("tenant_id")) && (oConvertUtils.isEmpty(returnValue = sysUser.getRelTenantIds()) || returnValue != null && returnValue.indexOf(",") > 0)) {
            returnValue = SpringContextUtils.getHttpServletRequest().getHeader("tenant-id");
        }
        if (returnValue != null) {
            returnValue = returnValue + moshi;
        }
        return returnValue;
    }
}

