/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.system.base.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.oConvertUtils;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.entity.enmus.ExcelType;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public class JeecgController<T, S extends IService<T>> {
    private static final Logger log = LoggerFactory.getLogger(JeecgController.class);
    @Autowired
    S service;
    @Value(value="${jeecg.path.upload}")
    private String upLoadPath;

    protected ModelAndView exportXls(HttpServletRequest request, T object, Class<T> clazz, String title) {
        QueryWrapper<T> queryWrapper = QueryGenerator.initQueryWrapper(object, request.getParameterMap());
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        List pageList = this.service.list(queryWrapper);
        List exportList = null;
        String selections = request.getParameter("selections");
        if (oConvertUtils.isNotEmpty(selections)) {
            List<String> selectionList = Arrays.asList(selections.split(","));
            exportList = pageList.stream().filter(item -> selectionList.contains(this.getId(item))).collect(Collectors.toList());
        } else {
            exportList = pageList;
        }
        ModelAndView mv = new ModelAndView((View)new JeecgEntityExcelView());
        mv.addObject("fileName", (Object)title);
        mv.addObject("entity", clazz);
        ExportParams exportParams = new ExportParams(title + "\u62a5\u8868", "\u5bfc\u51fa\u4eba:" + sysUser.getRealname(), title);
        exportParams.setImageBasePath(this.upLoadPath);
        mv.addObject("params", (Object)exportParams);
        mv.addObject("data", exportList);
        return mv;
    }

    protected ModelAndView exportXlsSheet(HttpServletRequest request, T object, Class<T> clazz, String title, String exportFields, Integer pageNum) {
        QueryWrapper<T> queryWrapper = QueryGenerator.initQueryWrapper(object, request.getParameterMap());
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        double total = this.service.count();
        int count = (int)Math.ceil(total / (double)pageNum.intValue());
        ArrayList listMap = new ArrayList();
        for (int i = 1; i <= count; ++i) {
            Page page = new Page((long)i, (long)pageNum.intValue());
            IPage pageList = this.service.page((IPage)page, queryWrapper);
            List records = pageList.getRecords();
            List exportList = null;
            String selections = request.getParameter("selections");
            if (oConvertUtils.isNotEmpty(selections)) {
                List<String> selectionList = Arrays.asList(selections.split(","));
                exportList = records.stream().filter(item -> selectionList.contains(this.getId(item))).collect(Collectors.toList());
            } else {
                exportList = records;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            ExportParams exportParams = new ExportParams(title + "\u62a5\u8868", "\u5bfc\u51fa\u4eba:" + sysUser.getRealname(), title + i, this.upLoadPath);
            exportParams.setType(ExcelType.XSSF);
            map.put("params", exportParams);
            map.put("entity", clazz);
            map.put("data", exportList);
            listMap.add(map);
        }
        ModelAndView mv = new ModelAndView((View)new JeecgEntityExcelView());
        mv.addObject("fileName", (Object)title);
        mv.addObject("mapList", listMap);
        return mv;
    }

    protected ModelAndView exportXls(HttpServletRequest request, T object, Class<T> clazz, String title, String exportFields) {
        ModelAndView mv = this.exportXls(request, object, clazz, title);
        mv.addObject("exportFields", (Object)exportFields);
        return mv;
    }

    private String getId(T item) {
        try {
            return PropertyUtils.getProperty(item, (String)"id").toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Result<?> importExcel(HttpServletRequest request, HttpServletResponse response, Class<T> clazz) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Iterator iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entity = iterator.next();
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                List list = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), clazz, (ImportParams)params);
                long start = System.currentTimeMillis();
                this.service.saveBatch((Collection)list);
                log.info("\u6d88\u8017\u65f6\u95f4" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
                Result<Object> result = Result.ok("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01\u6570\u636e\u884c\u6570\uff1a" + list.size());
                return result;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Result<Object> result = Result.error("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:" + e.getMessage());
                return result;
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return Result.error("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
    }
}

