/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.util;

import java.util.ArrayList;
import java.util.List;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysDepart;
import org.jeecg.modules.system.model.DepartIdModel;
import org.jeecg.modules.system.model.SysDepartTreeModel;

public class FindsDepartsChildrenUtil {
    public static List<SysDepartTreeModel> wrapTreeDataToTreeList(List<SysDepart> recordList) {
        ArrayList<DepartIdModel> idList = new ArrayList<DepartIdModel>();
        ArrayList<SysDepartTreeModel> records = new ArrayList<SysDepartTreeModel>();
        for (int i = 0; i < recordList.size(); ++i) {
            SysDepart depart = recordList.get(i);
            records.add(new SysDepartTreeModel(depart));
        }
        List<SysDepartTreeModel> tree = FindsDepartsChildrenUtil.findChildren(records, idList);
        FindsDepartsChildrenUtil.setEmptyChildrenAsNull(tree);
        return tree;
    }

    public static List<DepartIdModel> wrapTreeDataToDepartIdTreeList(List<SysDepart> recordList) {
        ArrayList<DepartIdModel> idList = new ArrayList<DepartIdModel>();
        ArrayList<SysDepartTreeModel> records = new ArrayList<SysDepartTreeModel>();
        for (int i = 0; i < recordList.size(); ++i) {
            SysDepart depart = recordList.get(i);
            records.add(new SysDepartTreeModel(depart));
        }
        FindsDepartsChildrenUtil.findChildren(records, idList);
        return idList;
    }

    private static List<SysDepartTreeModel> findChildren(List<SysDepartTreeModel> recordList, List<DepartIdModel> departIdList) {
        ArrayList<SysDepartTreeModel> treeList = new ArrayList<SysDepartTreeModel>();
        for (int i = 0; i < recordList.size(); ++i) {
            SysDepartTreeModel branch = recordList.get(i);
            if (!oConvertUtils.isEmpty((Object)branch.getParentId())) continue;
            treeList.add(branch);
            DepartIdModel departIdModel = new DepartIdModel().convert(branch);
            departIdList.add(departIdModel);
        }
        FindsDepartsChildrenUtil.getGrandChildren(treeList, recordList, departIdList);
        return treeList;
    }

    private static void getGrandChildren(List<SysDepartTreeModel> treeList, List<SysDepartTreeModel> recordList, List<DepartIdModel> idList) {
        for (int i = 0; i < treeList.size(); ++i) {
            SysDepartTreeModel model = treeList.get(i);
            DepartIdModel idModel = idList.get(i);
            for (int i1 = 0; i1 < recordList.size(); ++i1) {
                SysDepartTreeModel m = recordList.get(i1);
                if (m.getParentId() == null || !m.getParentId().equals(model.getId())) continue;
                model.getChildren().add(m);
                DepartIdModel dim = new DepartIdModel().convert(m);
                idModel.getChildren().add(dim);
            }
            FindsDepartsChildrenUtil.getGrandChildren(treeList.get(i).getChildren(), recordList, idList.get(i).getChildren());
        }
    }

    private static void setEmptyChildrenAsNull(List<SysDepartTreeModel> treeList) {
        for (int i = 0; i < treeList.size(); ++i) {
            SysDepartTreeModel model = treeList.get(i);
            if (model.getChildren().size() == 0) {
                model.setChildren(null);
                model.setIsLeaf(true);
                continue;
            }
            FindsDepartsChildrenUtil.setEmptyChildrenAsNull(model.getChildren());
            model.setIsLeaf(false);
        }
    }
}

