/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jeecg.qywx.api.base.JwAccessTokenAPI;
import com.jeecg.qywx.api.core.common.AccessToken;
import com.jeecg.qywx.api.department.JwDepartmentAPI;
import com.jeecg.qywx.api.department.vo.DepartMsgResponse;
import com.jeecg.qywx.api.department.vo.Department;
import com.jeecg.qywx.api.message.JwMessageAPI;
import com.jeecg.qywx.api.message.vo.Text;
import com.jeecg.qywx.api.message.vo.TextCard;
import com.jeecg.qywx.api.message.vo.TextCardEntity;
import com.jeecg.qywx.api.message.vo.TextEntity;
import com.jeecg.qywx.api.user.JwUserAPI;
import com.jeecg.qywx.api.user.vo.User;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jeecg.common.api.dto.message.MessageDTO;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.util.PasswordUtil;
import org.jeecg.common.util.RestUtil;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.thirdapp.ThirdAppConfig;
import org.jeecg.modules.system.entity.SysAnnouncement;
import org.jeecg.modules.system.entity.SysAnnouncementSend;
import org.jeecg.modules.system.entity.SysDepart;
import org.jeecg.modules.system.entity.SysPosition;
import org.jeecg.modules.system.entity.SysThirdAccount;
import org.jeecg.modules.system.entity.SysUser;
import org.jeecg.modules.system.entity.SysUserDepart;
import org.jeecg.modules.system.mapper.SysAnnouncementSendMapper;
import org.jeecg.modules.system.model.SysDepartTreeModel;
import org.jeecg.modules.system.service.ISysDepartService;
import org.jeecg.modules.system.service.ISysPositionService;
import org.jeecg.modules.system.service.ISysThirdAccountService;
import org.jeecg.modules.system.service.ISysUserDepartService;
import org.jeecg.modules.system.service.ISysUserService;
import org.jeecg.modules.system.service.IThirdAppService;
import org.jeecg.modules.system.vo.thirdapp.JwDepartmentTreeVo;
import org.jeecg.modules.system.vo.thirdapp.SyncInfoVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;

@Service
public class ThirdAppWechatEnterpriseServiceImpl
implements IThirdAppService {
    private static final Logger log = LoggerFactory.getLogger(ThirdAppWechatEnterpriseServiceImpl.class);
    @Autowired
    ThirdAppConfig thirdAppConfig;
    @Autowired
    private ISysDepartService sysDepartService;
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private ISysThirdAccountService sysThirdAccountService;
    @Autowired
    private ISysUserDepartService sysUserDepartService;
    @Autowired
    private ISysPositionService sysPositionService;
    @Autowired
    private SysAnnouncementSendMapper sysAnnouncementSendMapper;

    @Override
    public String getAccessToken() {
        String SECRET;
        String CORP_ID = this.thirdAppConfig.getWechatEnterprise().getClientId();
        AccessToken accessToken = JwAccessTokenAPI.getAccessToken((String)CORP_ID, (String)(SECRET = this.thirdAppConfig.getWechatEnterprise().getClientSecret()));
        if (accessToken != null) {
            return accessToken.getAccesstoken();
        }
        log.warn("\u83b7\u53d6AccessToken\u5931\u8d25");
        return null;
    }

    public String getAppAccessToken() {
        AccessToken accessToken;
        String CORP_ID = this.thirdAppConfig.getWechatEnterprise().getClientId();
        String SECRET = this.thirdAppConfig.getWechatEnterprise().getAgentAppSecret();
        if (oConvertUtils.isEmpty((Object)SECRET)) {
            SECRET = this.thirdAppConfig.getWechatEnterprise().getClientSecret();
        }
        if ((accessToken = JwAccessTokenAPI.getAccessToken((String)CORP_ID, (String)SECRET)) != null) {
            return accessToken.getAccesstoken();
        }
        log.warn("\u83b7\u53d6AccessToken\u5931\u8d25");
        return null;
    }

    @Override
    public boolean syncLocalDepartmentToThirdApp(String ids) {
        String accessToken = this.getAccessToken();
        if (accessToken == null) {
            return false;
        }
        List departments = JwDepartmentAPI.getAllDepartment((String)accessToken);
        if (departments == null) {
            return false;
        }
        List<JwDepartmentTreeVo> departmentTreeList = JwDepartmentTreeVo.listToTree(departments);
        this.deleteDepartRecursion(departmentTreeList, accessToken, true);
        List<SysDepartTreeModel> sysDepartsTree = this.sysDepartService.queryTreeList();
        Department parent = new Department();
        parent.setId("1");
        departments = JwDepartmentAPI.getAllDepartment((String)accessToken);
        this.syncDepartmentRecursion(sysDepartsTree, departments, parent, accessToken);
        return true;
    }

    private void deleteDepartRecursion(List<JwDepartmentTreeVo> children, String accessToken, boolean ifLocal) {
        for (JwDepartmentTreeVo departmentTree : children) {
            List departUserList;
            String depId = departmentTree.getId();
            if ("1".equals(depId)) continue;
            if (ifLocal) {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(SysDepart::getQywxIdentifier, (Object)depId);
                SysDepart sysDepart = (SysDepart)this.sysDepartService.getOne((Wrapper)queryWrapper);
                if (sysDepart != null) {
                    if (!departmentTree.hasChildren()) continue;
                    this.deleteDepartRecursion(departmentTree.getChildren(), accessToken, true);
                    continue;
                }
            }
            if ((departUserList = JwUserAPI.getUsersByDepartid((String)depId, (String)"1", null, (String)accessToken)) != null && departUserList.size() > 0) {
                for (User user : departUserList) {
                    User updateUser = new User();
                    updateUser.setUserid(user.getUserid());
                    updateUser.setDepartment(new Integer[]{1});
                    JwUserAPI.updateUser((User)updateUser, (String)accessToken);
                }
            }
            if (departmentTree.hasChildren()) {
                this.deleteDepartRecursion(departmentTree.getChildren(), accessToken, false);
            }
            JwDepartmentAPI.deleteDepart((String)depId, (String)accessToken);
        }
    }

    private void syncDepartmentRecursion(List<SysDepartTreeModel> sysDepartsTree, List<Department> departments, Department parent, String accessToken) {
        if (sysDepartsTree != null && sysDepartsTree.size() != 0) {
            block0: for (SysDepartTreeModel depart : sysDepartsTree) {
                for (Department department : departments) {
                    if (!department.getId().equals(depart.getQywxIdentifier())) continue;
                    this.sysDepartToQwDepartment(depart, department, parent.getId());
                    JwDepartmentAPI.updateDepart((Department)department, (String)accessToken);
                    this.syncDepartmentRecursion(depart.getChildren(), departments, department, accessToken);
                    continue block0;
                }
                Department newDepartment = this.sysDepartToQwDepartment(depart, parent.getId());
                DepartMsgResponse response = JwDepartmentAPI.createDepartment((Department)newDepartment, (String)accessToken);
                if (response == null || response.getId() == null) continue;
                SysDepart sysDepart = new SysDepart();
                sysDepart.setId(depart.getId());
                sysDepart.setQywxIdentifier(response.getId().toString());
                this.sysDepartService.updateById(sysDepart);
                Department newParent = new Department();
                newParent.setId(response.getId().toString());
                this.syncDepartmentRecursion(depart.getChildren(), departments, newParent, accessToken);
            }
        }
    }

    @Override
    public SyncInfoVo syncThirdAppDepartmentToLocal(String ids) {
        SyncInfoVo syncInfo = new SyncInfoVo();
        String accessToken = this.getAccessToken();
        if (accessToken == null) {
            syncInfo.addFailInfo("accessToken\u83b7\u53d6\u5931\u8d25\uff01");
            return syncInfo;
        }
        List departments = JwDepartmentAPI.getAllDepartment((String)accessToken);
        if (departments == null) {
            syncInfo.addFailInfo("\u4f01\u4e1a\u5fae\u4fe1\u90e8\u95e8\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\uff01");
            return syncInfo;
        }
        String username = JwtUtil.getUserNameByToken((HttpServletRequest)SpringContextUtils.getHttpServletRequest());
        List<JwDepartmentTreeVo> departmentTreeList = JwDepartmentTreeVo.listToTree(departments);
        this.syncDepartmentToLocalRecursion(departmentTreeList, null, username, syncInfo);
        return syncInfo;
    }

    private void syncDepartmentToLocalRecursion(List<JwDepartmentTreeVo> departmentTreeList, String sysParentId, String username, SyncInfoVo syncInfo) {
        if (departmentTreeList != null && departmentTreeList.size() != 0) {
            for (JwDepartmentTreeVo departmentTree : departmentTreeList) {
                String str;
                String depId = departmentTree.getId();
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(SysDepart::getQywxIdentifier, (Object)depId);
                SysDepart sysDepart = (SysDepart)this.sysDepartService.getOne((Wrapper)queryWrapper);
                if (sysDepart != null) {
                    SysDepart updateSysDepart = this.qwDepartmentToSysDepart(departmentTree, sysDepart);
                    if (sysParentId != null) {
                        updateSysDepart.setParentId(sysParentId);
                    }
                    try {
                        this.sysDepartService.updateDepartDataById(updateSysDepart, username);
                        str = String.format("\u90e8\u95e8 %s \u66f4\u65b0\u6210\u529f\uff01", updateSysDepart.getDepartName());
                        syncInfo.addSuccessInfo(str);
                    }
                    catch (Exception e) {
                        this.syncDepartCollectErrInfo(e, departmentTree, syncInfo);
                    }
                    if (!departmentTree.hasChildren()) continue;
                    this.syncDepartmentToLocalRecursion(departmentTree.getChildren(), updateSysDepart.getId(), username, syncInfo);
                    continue;
                }
                SysDepart newSysDepart = this.qwDepartmentToSysDepart(departmentTree, null);
                if (sysParentId != null) {
                    newSysDepart.setParentId(sysParentId);
                }
                try {
                    this.sysDepartService.saveDepartData(newSysDepart, username);
                    str = String.format("\u90e8\u95e8 %s \u521b\u5efa\u6210\u529f\uff01", newSysDepart.getDepartName());
                    syncInfo.addSuccessInfo(str);
                }
                catch (Exception e) {
                    this.syncDepartCollectErrInfo(e, departmentTree, syncInfo);
                }
                if (!departmentTree.hasChildren()) continue;
                this.syncDepartmentToLocalRecursion(departmentTree.getChildren(), newSysDepart.getId(), username, syncInfo);
            }
        }
    }

    @Override
    public SyncInfoVo syncLocalUserToThirdApp(String ids) {
        List sysUsers;
        SyncInfoVo syncInfo = new SyncInfoVo();
        String accessToken = this.getAccessToken();
        if (accessToken == null) {
            syncInfo.addFailInfo("accessToken\u83b7\u53d6\u5931\u8d25\uff01");
            return syncInfo;
        }
        List qwUsers = JwUserAPI.getDetailUsersByDepartid((String)"1", null, null, (String)accessToken);
        if (qwUsers == null) {
            syncInfo.addFailInfo("\u4f01\u4e1a\u5fae\u4fe1\u7528\u6237\u5217\u8868\u67e5\u8be2\u5931\u8d25\uff01");
            return syncInfo;
        }
        if (StringUtils.isNotBlank((String)ids)) {
            String[] idList = ids.split(",");
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(SysUser::getId, (Object[])idList);
            sysUsers = this.sysUserService.list((Wrapper)queryWrapper);
        } else {
            sysUsers = this.sysUserService.list();
        }
        block0: for (SysUser sysUser : sysUsers) {
            User qwUser;
            if ("_reserve_user_external".equals(sysUser.getUsername())) continue;
            SysThirdAccount sysThirdAccount = this.sysThirdAccountService.getOneBySysUserId(sysUser.getId(), "WECHAT_ENTERPRISE".toLowerCase());
            for (User qwUserTemp : qwUsers) {
                String username;
                String phone;
                if ((sysThirdAccount == null || oConvertUtils.isEmpty((Object)sysThirdAccount.getThirdUserId()) || !sysThirdAccount.getThirdUserId().equals(qwUserTemp.getUserid())) && !oConvertUtils.isEmpty((Object)(phone = sysUser.getPhone())) && !phone.equals(qwUserTemp.getMobile()) && !oConvertUtils.isEmpty((Object)(username = sysUser.getUsername())) && !username.equals(qwUserTemp.getUserid())) continue;
                qwUser = this.sysUserToQwUser(sysUser, qwUserTemp);
                int errCode = JwUserAPI.updateUser((User)qwUser, (String)accessToken);
                this.syncUserCollectErrInfo(errCode, sysUser, syncInfo);
                this.thirdAccountSaveOrUpdate(sysThirdAccount, sysUser.getId(), qwUser.getUserid());
                continue block0;
            }
            qwUser = this.sysUserToQwUser(sysUser);
            int errCode = JwUserAPI.createUser((User)qwUser, (String)accessToken);
            boolean apiSuccess = this.syncUserCollectErrInfo(errCode, sysUser, syncInfo);
            if (!apiSuccess) continue;
            this.thirdAccountSaveOrUpdate(sysThirdAccount, sysUser.getId(), qwUser.getUserid());
        }
        return syncInfo;
    }

    @Override
    public SyncInfoVo syncThirdAppUserToLocal() {
        SyncInfoVo syncInfo = new SyncInfoVo();
        String accessToken = this.getAccessToken();
        if (accessToken == null) {
            syncInfo.addFailInfo("accessToken\u83b7\u53d6\u5931\u8d25\uff01");
            return syncInfo;
        }
        List qwUsersList = JwUserAPI.getDetailUsersByDepartid((String)"1", null, null, (String)accessToken);
        if (qwUsersList == null) {
            syncInfo.addFailInfo("\u4f01\u4e1a\u5fae\u4fe1\u7528\u6237\u5217\u8868\u67e5\u8be2\u5931\u8d25\uff01");
            return syncInfo;
        }
        List sysUsersList = this.sysUserService.list();
        for (User qwUser : qwUsersList) {
            SysThirdAccount sysThirdAccount = this.sysThirdAccountService.getOneByThirdUserId(qwUser.getUserid(), "WECHAT_ENTERPRISE".toLowerCase());
            List collect = sysUsersList.stream().filter(user -> qwUser.getMobile().equals(user.getPhone()) || qwUser.getUserid().equals(user.getUsername())).collect(Collectors.toList());
            if (collect != null && collect.size() > 0) {
                SysUser sysUserTemp = (SysUser)collect.get(0);
                SysUser updateSysUser = this.qwUserToSysUser(qwUser, sysUserTemp);
                try {
                    this.sysUserService.updateById(updateSysUser);
                    String str = String.format("\u7528\u6237 %s(%s) \u66f4\u65b0\u6210\u529f\uff01", updateSysUser.getRealname(), updateSysUser.getUsername());
                    syncInfo.addSuccessInfo(str);
                }
                catch (Exception e) {
                    this.syncUserCollectErrInfo(e, qwUser, syncInfo);
                }
                this.thirdAccountSaveOrUpdate(sysThirdAccount, updateSysUser.getId(), qwUser.getUserid());
                continue;
            }
            SysUser newSysUser = this.qwUserToSysUser(qwUser);
            try {
                this.sysUserService.save(newSysUser);
                String str = String.format("\u7528\u6237 %s(%s) \u521b\u5efa\u6210\u529f\uff01", newSysUser.getRealname(), newSysUser.getUsername());
                syncInfo.addSuccessInfo(str);
            }
            catch (Exception e) {
                this.syncUserCollectErrInfo(e, qwUser, syncInfo);
            }
            this.thirdAccountSaveOrUpdate(sysThirdAccount, newSysUser.getId(), qwUser.getUserid());
        }
        return syncInfo;
    }

    private void thirdAccountSaveOrUpdate(SysThirdAccount sysThirdAccount, String sysUserId, String qwUserId) {
        if (sysThirdAccount == null) {
            sysThirdAccount = new SysThirdAccount();
            sysThirdAccount.setSysUserId(sysUserId);
            sysThirdAccount.setStatus(1);
            sysThirdAccount.setDelFlag(0);
            sysThirdAccount.setThirdType("WECHAT_ENTERPRISE".toLowerCase());
        }
        sysThirdAccount.setThirdUserId(qwUserId);
        this.sysThirdAccountService.saveOrUpdate(sysThirdAccount);
    }

    private boolean syncUserCollectErrInfo(int errCode, SysUser sysUser, SyncInfoVo syncInfo) {
        if (errCode != 0) {
            String msg = "";
            switch (errCode) {
                case 40003: {
                    msg = "\u65e0\u6548\u7684UserID";
                    break;
                }
                case 60129: {
                    msg = "\u624b\u673a\u548c\u90ae\u7bb1\u4e0d\u80fd\u90fd\u4e3a\u7a7a";
                    break;
                }
                case 60102: {
                    msg = "UserID\u5df2\u5b58\u5728";
                    break;
                }
                case 60103: {
                    msg = "\u624b\u673a\u53f7\u7801\u4e0d\u5408\u6cd5";
                    break;
                }
                case 60104: {
                    msg = "\u624b\u673a\u53f7\u7801\u5df2\u5b58\u5728";
                }
            }
            String str = String.format("\u7528\u6237 %s(%s) \u540c\u6b65\u5931\u8d25\uff01\u9519\u8bef\u7801\uff1a%s\u2014\u2014%s", sysUser.getUsername(), sysUser.getRealname(), errCode, msg);
            syncInfo.addFailInfo(str);
            return false;
        }
        String str = String.format("\u7528\u6237 %s(%s) \u540c\u6b65\u6210\u529f\uff01", sysUser.getUsername(), sysUser.getRealname());
        syncInfo.addSuccessInfo(str);
        return true;
    }

    private boolean syncUserCollectErrInfo(Exception e, User qwUser, SyncInfoVo syncInfo) {
        String msg = e instanceof DuplicateKeyException ? e.getCause().getMessage() : e.getMessage();
        String str = String.format("\u7528\u6237 %s(%s) \u540c\u6b65\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a%s", qwUser.getUserid(), qwUser.getName(), msg);
        syncInfo.addFailInfo(str);
        return false;
    }

    private boolean syncDepartCollectErrInfo(Exception e, Department department, SyncInfoVo syncInfo) {
        String msg = e instanceof DuplicateKeyException ? e.getCause().getMessage() : e.getMessage();
        String str = String.format("\u90e8\u95e8 %s(%s) \u540c\u6b65\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a%s", department.getName(), department.getId(), msg);
        syncInfo.addFailInfo(str);
        return false;
    }

    private User sysUserToQwUser(SysUser sysUser) {
        User user = new User();
        user.setUserid(sysUser.getUsername());
        return this.sysUserToQwUser(sysUser, user);
    }

    private User sysUserToQwUser(SysUser sysUser, User user) {
        SysPosition position;
        user.setName(sysUser.getRealname());
        user.setMobile(sysUser.getPhone());
        List<SysDepart> departList = this.getUserDepart(sysUser);
        if (departList != null) {
            ArrayList<Integer> departmentIdList = new ArrayList<Integer>();
            ArrayList<Integer> isLeaderInDept = new ArrayList<Integer>();
            List<Object> manageDepartIdList = new ArrayList();
            if (oConvertUtils.isNotEmpty((Object)sysUser.getDepartIds())) {
                manageDepartIdList = Arrays.asList(sysUser.getDepartIds().split(","));
            }
            for (SysDepart sysDepart : departList) {
                if (!oConvertUtils.isNotEmpty((Object)sysDepart.getQywxIdentifier())) continue;
                try {
                    departmentIdList.add(Integer.parseInt(sysDepart.getQywxIdentifier()));
                }
                catch (NumberFormatException ignored) {
                    continue;
                }
                if (CommonConstant.USER_IDENTITY_2.equals(sysUser.getUserIdentity())) {
                    isLeaderInDept.add(manageDepartIdList.contains(sysDepart.getId()) ? 1 : 0);
                    continue;
                }
                isLeaderInDept.add(0);
            }
            user.setDepartment(departmentIdList.toArray(new Integer[0]));
            user.setIs_leader_in_dept(isLeaderInDept.toArray(new Integer[0]));
        }
        if (user.getDepartment() == null || user.getDepartment().length == 0) {
            user.setDepartment(new Integer[]{1});
            user.setIs_leader_in_dept(new Integer[]{0});
        }
        if (oConvertUtils.isNotEmpty((Object)sysUser.getPost()) && (position = this.sysPositionService.getByCode(sysUser.getPost())) != null) {
            user.setPosition(position.getName());
        }
        if (sysUser.getSex() != null) {
            user.setGender(sysUser.getSex().toString());
        }
        user.setEmail(sysUser.getEmail());
        if (sysUser.getStatus() != null) {
            if (sysUser.getStatus() == 1 || sysUser.getStatus() == 2) {
                user.setEnable(Integer.valueOf(sysUser.getStatus() == 1 ? 1 : 0));
            } else {
                user.setEnable(Integer.valueOf(1));
            }
        }
        user.setTelephone(sysUser.getTelephone());
        if (CommonConstant.DEL_FLAG_1.equals(sysUser.getDelFlag())) {
            user.setEnable(Integer.valueOf(0));
        }
        return user;
    }

    private List<SysDepart> getUserDepart(SysUser sysUser) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysUserDepart::getUserId, (Object)sysUser.getId());
        List sysUserDepartList = this.sysUserDepartService.list((Wrapper)queryWrapper);
        if (sysUserDepartList.size() == 0) {
            return null;
        }
        LambdaQueryWrapper departQueryWrapper = new LambdaQueryWrapper();
        List departIdList = sysUserDepartList.stream().map(SysUserDepart::getDepId).collect(Collectors.toList());
        departQueryWrapper.in(SysDepart::getId, departIdList);
        List departList = this.sysDepartService.list((Wrapper)departQueryWrapper);
        return departList.size() == 0 ? null : departList;
    }

    private SysUser qwUserToSysUser(User user) {
        SysUser sysUser = new SysUser();
        sysUser.setDelFlag(0);
        sysUser.setUsername(user.getUserid());
        String password = "123456";
        String salt = oConvertUtils.randomGen((int)8);
        String passwordEncode = PasswordUtil.encrypt((String)sysUser.getUsername(), (String)password, (String)salt);
        sysUser.setSalt(salt);
        sysUser.setPassword(passwordEncode);
        return this.qwUserToSysUser(user, sysUser);
    }

    private SysUser qwUserToSysUser(User qwUser, SysUser oldSysUser) {
        SysUser sysUser = new SysUser();
        BeanUtils.copyProperties((Object)oldSysUser, (Object)sysUser);
        sysUser.setRealname(qwUser.getName());
        sysUser.setPost(qwUser.getPosition());
        try {
            sysUser.setSex(Integer.parseInt(qwUser.getGender()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (oConvertUtils.isNotEmpty((Object)qwUser.getEmail()) && !qwUser.getEmail().equals(sysUser.getEmail())) {
            sysUser.setEmail(qwUser.getEmail());
        } else {
            sysUser.setEmail(null);
        }
        if (oConvertUtils.isNotEmpty((Object)qwUser.getMobile()) && !qwUser.getMobile().equals(sysUser.getPhone())) {
            sysUser.setPhone(qwUser.getMobile());
        } else {
            sysUser.setPhone(null);
        }
        if (qwUser.getEnable() != null) {
            sysUser.setStatus(qwUser.getEnable() == 1 ? 1 : 2);
        }
        sysUser.setTelephone(qwUser.getTelephone());
        return sysUser;
    }

    private Department sysDepartToQwDepartment(SysDepartTreeModel departTree, String parentId) {
        Department department = new Department();
        return this.sysDepartToQwDepartment(departTree, department, parentId);
    }

    private Department sysDepartToQwDepartment(SysDepartTreeModel departTree, Department department, String parentId) {
        department.setName(departTree.getDepartName());
        department.setParentid(parentId);
        if (departTree.getDepartOrder() != null) {
            department.setOrder(departTree.getDepartOrder().toString());
        }
        return department;
    }

    private SysDepart qwDepartmentToSysDepart(Department department, SysDepart oldSysDepart) {
        SysDepart sysDepart = new SysDepart();
        if (oldSysDepart != null) {
            BeanUtils.copyProperties((Object)oldSysDepart, (Object)sysDepart);
        }
        sysDepart.setQywxIdentifier(department.getId());
        sysDepart.setDepartName(department.getName());
        try {
            sysDepart.setDepartOrder(Integer.parseInt(department.getOrder()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return sysDepart;
    }

    @Override
    public int removeThirdAppUser(List<String> userIdList) {
        if (!this.thirdAppConfig.isWechatEnterpriseEnabled()) {
            return -1;
        }
        int count = 0;
        if (userIdList != null && userIdList.size() > 0) {
            String accessToken = this.getAccessToken();
            if (accessToken == null) {
                return count;
            }
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysThirdAccount::getThirdType, (Object)"WECHAT_ENTERPRISE".toLowerCase());
            queryWrapper.in(SysThirdAccount::getSysUserId, userIdList);
            List thirdAccountList = this.sysThirdAccountService.list((Wrapper)queryWrapper);
            List thirdUserIdList = thirdAccountList.stream().map(SysThirdAccount::getThirdUserId).collect(Collectors.toList());
            for (String thirdUserId : thirdUserIdList) {
                int err;
                if (!oConvertUtils.isNotEmpty((Object)thirdUserId) || (err = JwUserAPI.deleteUser((String)thirdUserId, (String)accessToken)) != 0) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public boolean sendMessage(MessageDTO message) {
        return this.sendMessage(message, false);
    }

    @Override
    public boolean sendMessage(MessageDTO message, boolean verifyConfig) {
        JSONObject response = this.sendMessageResponse(message, verifyConfig);
        if (response != null) {
            return response.getIntValue("errcode") == 0;
        }
        return false;
    }

    public JSONObject sendMessageResponse(MessageDTO message, boolean verifyConfig) {
        if (verifyConfig && !this.thirdAppConfig.isWechatEnterpriseEnabled()) {
            return null;
        }
        String accessToken = this.getAppAccessToken();
        if (accessToken == null) {
            return null;
        }
        Text text = new Text();
        text.setMsgtype("text");
        text.setTouser(this.getTouser(message.getToUser(), message.isToAll()));
        TextEntity entity = new TextEntity();
        entity.setContent(message.getContent());
        text.setText(entity);
        text.setAgentid(this.thirdAppConfig.getWechatEnterprise().getAgentIdInt());
        return JwMessageAPI.sendTextMessage((Text)text, (String)accessToken);
    }

    public JSONObject sendTextCardMessage(SysAnnouncement announcement, boolean verifyConfig) {
        if (verifyConfig && !this.thirdAppConfig.isWechatEnterpriseEnabled()) {
            return null;
        }
        String accessToken = this.getAppAccessToken();
        if (accessToken == null) {
            return null;
        }
        TextCard textCard = new TextCard();
        textCard.setAgentid(this.thirdAppConfig.getWechatEnterprise().getAgentIdInt());
        boolean isToAll = "ALL".equals(announcement.getMsgType());
        String usernameString = "";
        if (!isToAll) {
            String userId = announcement.getUserIds();
            String[] userIds = null;
            if (oConvertUtils.isNotEmpty((Object)userId)) {
                userIds = userId.substring(0, userId.length() - 1).split(",");
            } else {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(SysAnnouncementSend::getAnntId, (Object)announcement.getId());
                SysAnnouncementSend sysAnnouncementSend = (SysAnnouncementSend)this.sysAnnouncementSendMapper.selectOne((Wrapper)queryWrapper);
                userIds = new String[]{sysAnnouncementSend.getUserId()};
            }
            List<String> usernameList = this.sysUserService.userIdToUsername(Arrays.asList(userIds));
            usernameString = String.join((CharSequence)",", usernameList);
        }
        textCard.setTouser(this.getTouser(usernameString, isToAll));
        TextCardEntity entity = new TextCardEntity();
        entity.setTitle(announcement.getTitile());
        entity.setDescription(oConvertUtils.getString((String)announcement.getMsgAbstract(), (String)"\u7a7a"));
        entity.setUrl(RestUtil.getBaseUrl() + "/sys/annountCement/show/" + announcement.getId());
        textCard.setTextcard(entity);
        return JwMessageAPI.sendTextCardMessage((TextCard)textCard, (String)accessToken);
    }

    private String getTouser(String origin, boolean toAll) {
        if (toAll) {
            return "@all";
        }
        String[] toUsers = origin.split(",");
        List<SysThirdAccount> thirdAccountList = this.sysThirdAccountService.listThirdUserIdByUsername(toUsers, "WECHAT_ENTERPRISE".toLowerCase());
        List toUserList = thirdAccountList.stream().map(SysThirdAccount::getThirdUserId).collect(Collectors.toList());
        return String.join((CharSequence)"|", toUserList);
    }
}

