/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysDepart;
import org.jeecg.modules.system.entity.SysUser;
import org.jeecg.modules.system.entity.SysUserDepart;
import org.jeecg.modules.system.mapper.SysUserDepartMapper;
import org.jeecg.modules.system.model.DepartIdModel;
import org.jeecg.modules.system.service.ISysDepartService;
import org.jeecg.modules.system.service.ISysUserDepartService;
import org.jeecg.modules.system.service.ISysUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysUserDepartServiceImpl
extends ServiceImpl<SysUserDepartMapper, SysUserDepart>
implements ISysUserDepartService {
    @Autowired
    private ISysDepartService sysDepartService;
    @Autowired
    private ISysUserService sysUserService;

    @Override
    public List<DepartIdModel> queryDepartIdsOfUser(String userId) {
        LambdaQueryWrapper queryUDep = new LambdaQueryWrapper();
        LambdaQueryWrapper queryDep = new LambdaQueryWrapper();
        try {
            queryUDep.eq(SysUserDepart::getUserId, (Object)userId);
            ArrayList<String> depIdList = new ArrayList<String>();
            ArrayList<DepartIdModel> depIdModelList = new ArrayList<DepartIdModel>();
            List userDepList = this.list((Wrapper)queryUDep);
            if (userDepList != null && userDepList.size() > 0) {
                for (SysUserDepart userDepart : userDepList) {
                    depIdList.add(userDepart.getDepId());
                }
                queryDep.in(SysDepart::getId, depIdList);
                List depList = this.sysDepartService.list((Wrapper)queryDep);
                if (depList != null || depList.size() > 0) {
                    for (SysDepart depart : depList) {
                        depIdModelList.add(new DepartIdModel().convertByUserDepart(depart));
                    }
                }
                return depIdModelList;
            }
        }
        catch (Exception e) {
            e.fillInStackTrace();
        }
        return null;
    }

    @Override
    public List<SysUser> queryUserByDepId(String depId) {
        LambdaQueryWrapper queryUDep = new LambdaQueryWrapper();
        queryUDep.eq(SysUserDepart::getDepId, (Object)depId);
        ArrayList<String> userIdList = new ArrayList<String>();
        List uDepList = this.list((Wrapper)queryUDep);
        if (uDepList != null && uDepList.size() > 0) {
            for (SysUserDepart uDep : uDepList) {
                userIdList.add(uDep.getUserId());
            }
            List userList = this.sysUserService.listByIds(userIdList);
            for (SysUser sysUser : userList) {
                sysUser.setSalt("");
                sysUser.setPassword("");
            }
            return userList;
        }
        return new ArrayList<SysUser>();
    }

    @Override
    public List<SysUser> queryUserByDepCode(String depCode, String realname) {
        if (oConvertUtils.isNotEmpty((Object)realname)) {
            realname = realname.trim();
        }
        List<SysUser> userList = ((SysUserDepartMapper)this.baseMapper).queryDepartUserList(depCode, realname);
        HashMap<String, SysUser> map = new HashMap<String, SysUser>();
        for (SysUser sysUser : userList) {
            sysUser.setSalt("");
            sysUser.setPassword("");
            map.put(sysUser.getId(), sysUser);
        }
        return new ArrayList<SysUser>(map.values());
    }

    @Override
    public IPage<SysUser> queryDepartUserPageList(String departId, String username, String realname, int pageSize, int pageNo) {
        IPage<SysUser> pageList = null;
        Page page = new Page((long)pageNo, (long)pageSize);
        if (oConvertUtils.isEmpty((Object)departId)) {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            if (oConvertUtils.isNotEmpty((Object)username)) {
                query.like(SysUser::getUsername, (Object)username);
            }
            pageList = this.sysUserService.page((IPage)page, (Wrapper)query);
        } else {
            SysDepart sysDepart = (SysDepart)this.sysDepartService.getById((Serializable)((Object)departId));
            pageList = ((SysUserDepartMapper)this.baseMapper).queryDepartUserPageList((Page<SysUser>)page, sysDepart.getOrgCode(), username, realname);
        }
        List userList = pageList.getRecords();
        if (userList != null && userList.size() > 0) {
            List<String> userIds = userList.stream().map(SysUser::getId).collect(Collectors.toList());
            HashMap map = new HashMap();
            if (userIds != null && userIds.size() > 0) {
                Map<String, String> useDepNames = this.sysUserService.getDepNamesByUserIds(userIds);
                userList.forEach(item -> {
                    item.setOrgCodeTxt((String)useDepNames.get(item.getId()));
                    item.setSalt("");
                    item.setPassword("");
                    map.put(item.getId(), item);
                });
            }
            pageList.setRecords(new ArrayList(map.values()));
        }
        return pageList;
    }
}

