/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.system.vo.DictModel;
import org.jeecg.common.system.vo.DictQuery;
import org.jeecg.common.util.SqlInjectionUtil;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysDict;
import org.jeecg.modules.system.entity.SysDictItem;
import org.jeecg.modules.system.mapper.SysDictItemMapper;
import org.jeecg.modules.system.mapper.SysDictMapper;
import org.jeecg.modules.system.model.TreeSelectModel;
import org.jeecg.modules.system.service.ISysDictService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysDictServiceImpl
extends ServiceImpl<SysDictMapper, SysDict>
implements ISysDictService {
    private static final Logger log = LoggerFactory.getLogger(SysDictServiceImpl.class);
    @Autowired
    private SysDictMapper sysDictMapper;
    @Autowired
    private SysDictItemMapper sysDictItemMapper;

    @Override
    @Cacheable(value={"sys:cache:dict"}, key="#code", unless="#result == null ")
    public List<DictModel> queryDictItemsByCode(String code) {
        log.debug("\u65e0\u7f13\u5b58dictCache\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
        return this.sysDictMapper.queryDictItemsByCode(code);
    }

    @Override
    public Map<String, List<DictModel>> queryAllDictItems() {
        HashMap<String, List<DictModel>> res = new HashMap<String, List<DictModel>>();
        List ls = this.sysDictMapper.selectList(null);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysDictItem::getStatus, (Object)1);
        queryWrapper.orderByAsc(SysDictItem::getSortOrder);
        List sysDictItemList = this.sysDictItemMapper.selectList((Wrapper)queryWrapper);
        for (SysDict d : ls) {
            List dictModelList = sysDictItemList.stream().filter(s -> d.getId().equals(s.getDictId())).map(item -> {
                DictModel dictModel = new DictModel();
                dictModel.setText(item.getItemText());
                dictModel.setValue(item.getItemValue());
                return dictModel;
            }).collect(Collectors.toList());
            res.put(d.getDictCode(), dictModelList);
        }
        log.debug("-------\u767b\u5f55\u52a0\u8f7d\u7cfb\u7edf\u5b57\u5178-----" + ((Object)res).toString());
        return res;
    }

    @Override
    @Cacheable(value={"sys:cache:dict"}, key="#code+':'+#key", unless="#result == null ")
    public String queryDictTextByKey(String code, String key) {
        log.debug("\u65e0\u7f13\u5b58dictText\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
        return this.sysDictMapper.queryDictTextByKey(code, key);
    }

    @Override
    public List<DictModel> queryTableDictItemsByCode(String table, String text, String code) {
        log.debug("\u65e0\u7f13\u5b58dictTableList\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
        return this.sysDictMapper.queryTableDictItemsByCode(table, text, code);
    }

    @Override
    public List<DictModel> queryTableDictItemsByCodeAndFilter(String table, String text, String code, String filterSql) {
        log.debug("\u65e0\u7f13\u5b58dictTableList\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
        return this.sysDictMapper.queryTableDictItemsByCodeAndFilter(table, text, code, filterSql);
    }

    @Override
    @Cacheable(value={"sys:cache:dictTable"}, unless="#result == null ")
    public String queryTableDictTextByKey(String table, String text, String code, String key) {
        log.debug("\u65e0\u7f13\u5b58dictTable\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
        return this.sysDictMapper.queryTableDictTextByKey(table, text, code, key);
    }

    @Override
    public List<String> queryTableDictByKeys(String table, String text, String code, String keys) {
        return this.queryTableDictByKeys(table, text, code, keys, true);
    }

    @Override
    public List<String> queryTableDictByKeys(String table, String text, String code, String keys, boolean delNotExist) {
        if (oConvertUtils.isEmpty((Object)keys)) {
            return null;
        }
        String[] keyArray = keys.split(",");
        List<DictModel> dicts = this.sysDictMapper.queryTableDictByKeys(table, text, code, keyArray);
        ArrayList<String> texts = new ArrayList<String>(dicts.size());
        for (String key : keyArray) {
            List res = dicts.stream().filter(i -> key.equals(i.getValue())).collect(Collectors.toList());
            if (res.size() > 0) {
                texts.add(((DictModel)res.get(0)).getText());
                continue;
            }
            if (delNotExist) continue;
            texts.add(key);
        }
        return texts;
    }

    @Override
    public boolean deleteByDictId(SysDict sysDict) {
        sysDict.setDelFlag(CommonConstant.DEL_FLAG_1);
        return this.updateById(sysDict);
    }

    @Override
    @Transactional
    public Integer saveMain(SysDict sysDict, List<SysDictItem> sysDictItemList) {
        int insert = 0;
        try {
            insert = this.sysDictMapper.insert(sysDict);
            if (sysDictItemList != null) {
                for (SysDictItem entity : sysDictItemList) {
                    entity.setDictId(sysDict.getId());
                    entity.setStatus(1);
                    this.sysDictItemMapper.insert(entity);
                }
            }
        }
        catch (Exception e) {
            return insert;
        }
        return insert;
    }

    @Override
    public List<DictModel> queryAllDepartBackDictModel() {
        return ((SysDictMapper)this.baseMapper).queryAllDepartBackDictModel();
    }

    @Override
    public List<DictModel> queryAllUserBackDictModel() {
        return ((SysDictMapper)this.baseMapper).queryAllUserBackDictModel();
    }

    @Override
    public List<DictModel> queryTableDictItems(String table, String text, String code, String keyword) {
        return ((SysDictMapper)this.baseMapper).queryTableDictItems(table, text, code, "%" + keyword + "%");
    }

    @Override
    public List<DictModel> queryLittleTableDictItems(String table, String text, String code, String condition, String keyword, int pageSize) {
        Page page = new Page(1L, (long)pageSize);
        page.setSearchCount(false);
        String filterSql = this.getFilterSql(text, code, condition, keyword);
        IPage<DictModel> pageList = ((SysDictMapper)this.baseMapper).queryTableDictWithFilter((Page<DictModel>)page, table, text, code, filterSql);
        return pageList.getRecords();
    }

    private String getFilterSql(String text, String code, String condition, String keyword) {
        String keywordSql = null;
        String filterSql = "";
        String sql_where = " where ";
        if (oConvertUtils.isNotEmpty((Object)keyword)) {
            if (keyword.contains(",")) {
                String inKeywords = "\"" + keyword.replaceAll(",", "\",\"") + "\"";
                keywordSql = "(" + text + " in (" + inKeywords + ") or " + code + " in (" + inKeywords + "))";
            } else {
                keywordSql = "(" + text + " like '%" + keyword + "%' or " + code + " like '%" + keyword + "%')";
            }
        }
        if (oConvertUtils.isNotEmpty((Object)condition) && oConvertUtils.isNotEmpty(keywordSql)) {
            filterSql = filterSql + sql_where + condition + " and " + keywordSql;
        } else if (oConvertUtils.isNotEmpty((Object)condition)) {
            filterSql = filterSql + sql_where + condition;
        } else if (oConvertUtils.isNotEmpty(keywordSql)) {
            filterSql = filterSql + sql_where + keywordSql;
        }
        return filterSql;
    }

    @Override
    public List<DictModel> queryAllTableDictItems(String table, String text, String code, String condition, String keyword) {
        String filterSql = this.getFilterSql(text, code, condition, keyword);
        List<DictModel> ls = ((SysDictMapper)this.baseMapper).queryAllTableDictItems(table, text, code, filterSql);
        return ls;
    }

    @Override
    public List<TreeSelectModel> queryTreeList(Map<String, String> query, String table, String text, String code, String pidField, String pid, String hasChildField) {
        return ((SysDictMapper)this.baseMapper).queryTreeList(query, table, text, code, pidField, pid, hasChildField);
    }

    @Override
    public void deleteOneDictPhysically(String id) {
        ((SysDictMapper)this.baseMapper).deleteOneById(id);
        this.sysDictItemMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysDictItem::getDictId, (Object)id));
    }

    @Override
    public void updateDictDelFlag(int delFlag, String id) {
        ((SysDictMapper)this.baseMapper).updateDictDelFlag(delFlag, id);
    }

    @Override
    public List<SysDict> queryDeleteList() {
        return ((SysDictMapper)this.baseMapper).queryDeleteList();
    }

    @Override
    public List<DictModel> queryDictTablePageList(DictQuery query, int pageSize, int pageNo) {
        Page page = new Page((long)pageNo, (long)pageSize, false);
        Page<DictModel> pageList = ((SysDictMapper)this.baseMapper).queryDictTablePageList(page, query);
        return pageList.getRecords();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<DictModel> getDictItems(String dictCode) {
        if (!dictCode.contains(",")) return this.queryDictItemsByCode(dictCode);
        String[] params = dictCode.split(",");
        if (params.length < 3) {
            return null;
        }
        String[] sqlInjCheck = new String[]{params[0], params[1], params[2]};
        SqlInjectionUtil.filterContent((String[])sqlInjCheck);
        if (params.length == 4) {
            SqlInjectionUtil.specialFilterContent((String)params[3]);
            return this.queryTableDictItemsByCodeAndFilter(params[0], params[1], params[2], params[3]);
        }
        if (params.length != 3) return null;
        return this.queryTableDictItemsByCode(params[0], params[1], params[2]);
    }

    @Override
    public List<DictModel> loadDict(String dictCode, String keyword, Integer pageSize) {
        if (dictCode.contains(",")) {
            String[] params = dictCode.split(",");
            String condition = null;
            if (params.length != 3 && params.length != 4) {
                return null;
            }
            if (params.length == 4) {
                condition = params[3];
            }
            List<DictModel> ls = pageSize != null ? this.queryLittleTableDictItems(params[0], params[1], params[2], condition, keyword, pageSize) : this.queryAllTableDictItems(params[0], params[1], params[2], condition, keyword);
            return ls;
        }
        return null;
    }
}

