/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import com.alibaba.fastjson.JSONObject;
import com.jeecg.dingtalk.api.core.response.Response;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.jeecg.common.api.dto.message.MessageDTO;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.config.thirdapp.ThirdAppConfig;
import org.jeecg.modules.system.service.impl.ThirdAppDingtalkServiceImpl;
import org.jeecg.modules.system.service.impl.ThirdAppWechatEnterpriseServiceImpl;
import org.jeecg.modules.system.vo.thirdapp.SyncInfoVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="thirdAppController")
@RequestMapping(value={"/sys/thirdApp"})
public class ThirdAppController {
    private static final Logger log = LoggerFactory.getLogger(ThirdAppController.class);
    @Autowired
    ThirdAppConfig thirdAppConfig;
    @Autowired
    ThirdAppWechatEnterpriseServiceImpl wechatEnterpriseService;
    @Autowired
    ThirdAppDingtalkServiceImpl dingtalkService;

    @GetMapping(value={"/getEnabledType"})
    public Result getEnabledType() {
        HashMap<String, Boolean> enabledMap = new HashMap<String, Boolean>();
        enabledMap.put("wechatEnterprise", this.thirdAppConfig.isWechatEnterpriseEnabled());
        enabledMap.put("dingtalk", this.thirdAppConfig.isDingtalkEnabled());
        return Result.OK(enabledMap);
    }

    @GetMapping(value={"/sync/wechatEnterprise/user/toApp"})
    public Result syncWechatEnterpriseUserToApp(@RequestParam(value="ids", required=false) String ids) {
        if (this.thirdAppConfig.isWechatEnterpriseEnabled()) {
            SyncInfoVo syncInfo = this.wechatEnterpriseService.syncLocalUserToThirdApp(ids);
            if (syncInfo.getFailInfo().size() == 0) {
                return Result.OK((String)"\u540c\u6b65\u6210\u529f", (Object)syncInfo);
            }
            return Result.error((String)"\u540c\u6b65\u5931\u8d25", (Object)syncInfo);
        }
        return Result.error((String)"\u4f01\u4e1a\u5fae\u4fe1\u540c\u6b65\u529f\u80fd\u5df2\u7981\u7528");
    }

    @GetMapping(value={"/sync/wechatEnterprise/user/toLocal"})
    public Result syncWechatEnterpriseUserToLocal(@RequestParam(value="ids", required=false) String ids) {
        if (this.thirdAppConfig.isWechatEnterpriseEnabled()) {
            SyncInfoVo syncInfo = this.wechatEnterpriseService.syncThirdAppUserToLocal();
            if (syncInfo.getFailInfo().size() == 0) {
                return Result.OK((String)"\u540c\u6b65\u6210\u529f", (Object)syncInfo);
            }
            return Result.error((String)"\u540c\u6b65\u5931\u8d25", (Object)syncInfo);
        }
        return Result.error((String)"\u4f01\u4e1a\u5fae\u4fe1\u540c\u6b65\u529f\u80fd\u5df2\u7981\u7528");
    }

    @GetMapping(value={"/sync/wechatEnterprise/depart/toApp"})
    public Result syncWechatEnterpriseDepartToApp(@RequestParam(value="ids", required=false) String ids) {
        if (this.thirdAppConfig.isWechatEnterpriseEnabled()) {
            boolean flag = this.wechatEnterpriseService.syncLocalDepartmentToThirdApp(ids);
            return flag ? Result.OK((String)"\u540c\u6b65\u6210\u529f", null) : Result.error((String)"\u540c\u6b65\u5931\u8d25");
        }
        return Result.error((String)"\u4f01\u4e1a\u5fae\u4fe1\u540c\u6b65\u529f\u80fd\u5df2\u7981\u7528");
    }

    @GetMapping(value={"/sync/wechatEnterprise/depart/toLocal"})
    public Result syncWechatEnterpriseDepartToLocal(@RequestParam(value="ids", required=false) String ids) {
        if (this.thirdAppConfig.isWechatEnterpriseEnabled()) {
            SyncInfoVo syncInfo = this.wechatEnterpriseService.syncThirdAppDepartmentToLocal(ids);
            if (syncInfo.getFailInfo().size() == 0) {
                return Result.OK((String)"\u540c\u6b65\u6210\u529f", (Object)syncInfo);
            }
            return Result.error((String)"\u540c\u6b65\u5931\u8d25", (Object)syncInfo);
        }
        return Result.error((String)"\u4f01\u4e1a\u5fae\u4fe1\u540c\u6b65\u529f\u80fd\u5df2\u7981\u7528");
    }

    @GetMapping(value={"/sync/dingtalk/depart/toApp"})
    public Result syncDingtalkDepartToApp(@RequestParam(value="ids", required=false) String ids) {
        if (this.thirdAppConfig.isDingtalkEnabled()) {
            boolean flag = this.dingtalkService.syncLocalDepartmentToThirdApp(ids);
            return flag ? Result.OK((String)"\u540c\u6b65\u6210\u529f", null) : Result.error((String)"\u540c\u6b65\u5931\u8d25");
        }
        return Result.error((String)"\u9489\u9489\u540c\u6b65\u529f\u80fd\u5df2\u7981\u7528");
    }

    @GetMapping(value={"/sync/dingtalk/depart/toLocal"})
    public Result syncDingtalkDepartToLocal(@RequestParam(value="ids", required=false) String ids) {
        if (this.thirdAppConfig.isDingtalkEnabled()) {
            SyncInfoVo syncInfo = this.dingtalkService.syncThirdAppDepartmentToLocal(ids);
            if (syncInfo.getFailInfo().size() == 0) {
                return Result.OK((String)"\u540c\u6b65\u6210\u529f", (Object)syncInfo);
            }
            return Result.error((String)"\u540c\u6b65\u5931\u8d25", (Object)syncInfo);
        }
        return Result.error((String)"\u9489\u9489\u540c\u6b65\u529f\u80fd\u5df2\u7981\u7528");
    }

    @GetMapping(value={"/sync/dingtalk/user/toApp"})
    public Result syncDingtalkUserToApp(@RequestParam(value="ids", required=false) String ids) {
        if (this.thirdAppConfig.isDingtalkEnabled()) {
            SyncInfoVo syncInfo = this.dingtalkService.syncLocalUserToThirdApp(ids);
            if (syncInfo.getFailInfo().size() == 0) {
                return Result.OK((String)"\u540c\u6b65\u6210\u529f", (Object)syncInfo);
            }
            return Result.error((String)"\u540c\u6b65\u5931\u8d25", (Object)syncInfo);
        }
        return Result.error((String)"\u9489\u9489\u540c\u6b65\u529f\u80fd\u5df2\u7981\u7528");
    }

    @GetMapping(value={"/sync/dingtalk/user/toLocal"})
    public Result syncDingtalkUserToLocal(@RequestParam(value="ids", required=false) String ids) {
        if (this.thirdAppConfig.isDingtalkEnabled()) {
            SyncInfoVo syncInfo = this.dingtalkService.syncThirdAppUserToLocal();
            if (syncInfo.getFailInfo().size() == 0) {
                return Result.OK((String)"\u540c\u6b65\u6210\u529f", (Object)syncInfo);
            }
            return Result.error((String)"\u540c\u6b65\u5931\u8d25", (Object)syncInfo);
        }
        return Result.error((String)"\u9489\u9489\u540c\u6b65\u529f\u80fd\u5df2\u7981\u7528");
    }

    @PostMapping(value={"/sendMessageTest"})
    public Result sendMessageTest(@RequestBody JSONObject params, HttpServletRequest request) {
        String app = params.getString("app");
        boolean sendAll = params.getBooleanValue("sendAll");
        String receiver = params.getString("receiver");
        String content = params.getString("content");
        String fromUser = JwtUtil.getUserNameByToken((HttpServletRequest)request);
        String title = "\u7b2c\u4e09\u65b9APP\u6d88\u606f\u6d4b\u8bd5";
        MessageDTO message = new MessageDTO(fromUser, receiver, title, content);
        message.setToAll(sendAll);
        if ("WECHAT_ENTERPRISE".equals(app)) {
            if (this.thirdAppConfig.isWechatEnterpriseEnabled()) {
                JSONObject response = this.wechatEnterpriseService.sendMessageResponse(message, false);
                return Result.OK((Object)response);
            }
            return Result.error((String)"\u4f01\u4e1a\u5fae\u4fe1\u5df2\u88ab\u7981\u7528");
        }
        if ("DINGTALK".equals(app)) {
            if (this.thirdAppConfig.isDingtalkEnabled()) {
                Response<String> response = this.dingtalkService.sendMessageResponse(message, false);
                return Result.OK(response);
            }
            return Result.error((String)"\u9489\u9489\u5df2\u88ab\u7981\u7528");
        }
        return Result.error((String)"\u4e0d\u8bc6\u522b\u7684\u7b2c\u4e09\u65b9APP");
    }

    @PostMapping(value={"/recallMessageTest"})
    public Result recallMessageTest(@RequestBody JSONObject params) {
        String app = params.getString("app");
        String msg_task_id = params.getString("msg_task_id");
        if ("WECHAT_ENTERPRISE".equals(app)) {
            if (this.thirdAppConfig.isWechatEnterpriseEnabled()) {
                return Result.error((String)"\u4f01\u4e1a\u5fae\u4fe1\u4e0d\u652f\u6301\u64a4\u56de\u6d88\u606f");
            }
            return Result.error((String)"\u4f01\u4e1a\u5fae\u4fe1\u5df2\u88ab\u7981\u7528");
        }
        if ("DINGTALK".equals(app)) {
            if (this.thirdAppConfig.isDingtalkEnabled()) {
                Response<JSONObject> response = this.dingtalkService.recallMessageResponse(msg_task_id);
                if (response.isSuccess()) {
                    return Result.OK((String)"\u64a4\u56de\u6210\u529f", response);
                }
                return Result.error((String)("\u64a4\u56de\u5931\u8d25\uff1a" + response.getErrcode() + "\u2014\u2014" + response.getErrmsg()), response);
            }
            return Result.error((String)"\u9489\u9489\u5df2\u88ab\u7981\u7528");
        }
        return Result.error((String)"\u4e0d\u8bc6\u522b\u7684\u7b2c\u4e09\u65b9APP");
    }
}

