/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.system.entity.SysUserAgent;
import org.jeecg.modules.system.service.ISysUserAgentService;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@RestController
@RequestMapping(value={"/sys/sysUserAgent"})
public class SysUserAgentController {
    private static final Logger log = LoggerFactory.getLogger(SysUserAgentController.class);
    @Autowired
    private ISysUserAgentService sysUserAgentService;
    @Value(value="${jeecg.path.upload}")
    private String upLoadPath;

    @GetMapping(value={"/list"})
    public Result<IPage<SysUserAgent>> queryPageList(SysUserAgent sysUserAgent, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result result = new Result();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysUserAgent, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.sysUserAgentService.page((IPage)page, (Wrapper)queryWrapper);
        result.setSuccess(true);
        result.setResult((Object)pageList);
        return result;
    }

    @PostMapping(value={"/add"})
    public Result<SysUserAgent> add(@RequestBody SysUserAgent sysUserAgent) {
        Result result = new Result();
        try {
            this.sysUserAgentService.save(sysUserAgent);
            result.success("\u4ee3\u7406\u4eba\u8bbe\u7f6e\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @PutMapping(value={"/edit"})
    public Result<SysUserAgent> edit(@RequestBody SysUserAgent sysUserAgent) {
        Result result = new Result();
        SysUserAgent sysUserAgentEntity = (SysUserAgent)this.sysUserAgentService.getById((Serializable)((Object)sysUserAgent.getId()));
        if (sysUserAgentEntity == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            boolean ok = this.sysUserAgentService.updateById(sysUserAgent);
            if (ok) {
                result.success("\u4ee3\u7406\u4eba\u8bbe\u7f6e\u6210\u529f!");
            }
        }
        return result;
    }

    @DeleteMapping(value={"/delete"})
    public Result<SysUserAgent> delete(@RequestParam(name="id", required=true) String id) {
        Result result = new Result();
        SysUserAgent sysUserAgent = (SysUserAgent)this.sysUserAgentService.getById((Serializable)((Object)id));
        if (sysUserAgent == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            boolean ok = this.sysUserAgentService.removeById((Serializable)((Object)id));
            if (ok) {
                result.success("\u5220\u9664\u6210\u529f!");
            }
        }
        return result;
    }

    @DeleteMapping(value={"/deleteBatch"})
    public Result<SysUserAgent> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        Result result = new Result();
        if (ids == null || "".equals(ids.trim())) {
            result.error500("\u53c2\u6570\u4e0d\u8bc6\u522b\uff01");
        } else {
            this.sysUserAgentService.removeByIds(Arrays.asList(ids.split(",")));
            result.success("\u5220\u9664\u6210\u529f!");
        }
        return result;
    }

    @GetMapping(value={"/queryById"})
    public Result<SysUserAgent> queryById(@RequestParam(name="id", required=true) String id) {
        Result result = new Result();
        SysUserAgent sysUserAgent = (SysUserAgent)this.sysUserAgentService.getById((Serializable)((Object)id));
        if (sysUserAgent == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            result.setResult((Object)sysUserAgent);
            result.setSuccess(true);
        }
        return result;
    }

    @GetMapping(value={"/queryByUserName"})
    public Result<SysUserAgent> queryByUserName(@RequestParam(name="userName", required=true) String userName) {
        Result result = new Result();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysUserAgent::getUserName, (Object)userName);
        SysUserAgent sysUserAgent = (SysUserAgent)this.sysUserAgentService.getOne((Wrapper)queryWrapper);
        if (sysUserAgent == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            result.setResult((Object)sysUserAgent);
            result.setSuccess(true);
        }
        return result;
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(SysUserAgent sysUserAgent, HttpServletRequest request) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysUserAgent, (Map)request.getParameterMap());
        ModelAndView mv = new ModelAndView((View)new JeecgEntityExcelView());
        List pageList = this.sysUserAgentService.list((Wrapper)queryWrapper);
        mv.addObject("fileName", (Object)"\u7528\u6237\u4ee3\u7406\u4eba\u8bbe\u7f6e\u5217\u8868");
        mv.addObject("entity", SysUserAgent.class);
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        ExportParams exportParams = new ExportParams("\u7528\u6237\u4ee3\u7406\u4eba\u8bbe\u7f6e\u5217\u8868\u6570\u636e", "\u5bfc\u51fa\u4eba:" + user.getRealname(), "\u5bfc\u51fa\u4fe1\u606f");
        exportParams.setImageBasePath(this.upLoadPath);
        mv.addObject("params", (Object)exportParams);
        mv.addObject("data", (Object)pageList);
        return mv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Iterator iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entity = iterator.next();
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                List listSysUserAgents = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), SysUserAgent.class, (ImportParams)params);
                for (SysUserAgent sysUserAgentExcel : listSysUserAgents) {
                    this.sysUserAgentService.save(sysUserAgentExcel);
                }
                Result result = Result.ok((String)("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01\u6570\u636e\u884c\u6570\uff1a" + listSysUserAgents.size()));
                return result;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Result result = Result.error((String)"\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
                return result;
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return Result.error((String)"\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
    }
}

