/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.base.service.BaseCommonService;
import org.jeecg.modules.system.service.ISysUserService;
import org.jeecg.modules.system.vo.SysOnlineVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/online"})
public class SysOnlineController {
    private static final Logger log = LoggerFactory.getLogger(SysOnlineController.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    public RedisTemplate redisTemplate;
    @Autowired
    public ISysUserService userService;
    @Autowired
    private ISysBaseAPI sysBaseAPI;
    @Resource
    private BaseCommonService baseCommonService;

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public Result<Page<SysOnlineVO>> list(@RequestParam(name="username", required=false) String username, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        Set keys = this.redisTemplate.keys((Object)"prefix_user_token_*");
        ArrayList<SysOnlineVO> onlineList = new ArrayList<SysOnlineVO>();
        for (String key : keys) {
            SysOnlineVO online = new SysOnlineVO();
            String token = (String)this.redisUtil.get(key);
            if (StringUtils.isEmpty((String)token)) continue;
            online.setToken(token);
            LoginUser loginUser = this.sysBaseAPI.getUserByName(JwtUtil.getUsername((String)token));
            BeanUtils.copyProperties((Object)loginUser, (Object)online);
            if (StringUtils.isNotEmpty((String)username)) {
                if (!StringUtils.equals((String)username, (String)online.getUsername())) continue;
                onlineList.add(online);
                continue;
            }
            onlineList.add(online);
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        int count = onlineList.size();
        ArrayList<SysOnlineVO> pages = new ArrayList<SysOnlineVO>();
        int currId = pageNo > 1 ? (pageNo - 1) * pageSize : 0;
        for (int i = 0; i < pageSize && i < count - currId; ++i) {
            pages.add((SysOnlineVO)onlineList.get(currId + i));
        }
        page.setSize((long)pageSize.intValue());
        page.setCurrent((long)pageNo.intValue());
        page.setTotal((long)count);
        page.setPages(count % 10 == 0 ? (long)(count / 10) : (long)(count / 10 + 1));
        page.setRecords(pages);
        Collections.reverse(onlineList);
        onlineList.removeAll(Collections.singleton(null));
        Result result = new Result();
        result.setSuccess(true);
        result.setResult((Object)page);
        return result;
    }

    @RequestMapping(value={"/forceLogout"}, method={RequestMethod.POST})
    public Result<Object> forceLogout(@RequestBody SysOnlineVO online) {
        if (oConvertUtils.isEmpty((Object)online.getToken())) {
            return Result.error((String)"\u9000\u51fa\u767b\u5f55\u5931\u8d25\uff01");
        }
        String username = JwtUtil.getUsername((String)online.getToken());
        LoginUser sysUser = this.sysBaseAPI.getUserByName(username);
        if (sysUser != null) {
            this.baseCommonService.addLog("\u5f3a\u5236: " + sysUser.getRealname() + "\u9000\u51fa\u6210\u529f\uff01", Integer.valueOf(1), null, sysUser);
            log.info(" \u5f3a\u5236  " + sysUser.getRealname() + "\u9000\u51fa\u6210\u529f\uff01 ");
            this.redisUtil.del(new String[]{"prefix_user_token_" + online.getToken()});
            this.redisUtil.del(new String[]{"shiro:cache:org.jeecg.config.shiro.ShiroRealm.authorizationCache:" + sysUser.getId()});
            this.redisUtil.del(new String[]{String.format("%s::%s", "sys:cache:user", sysUser.getUsername())});
            SecurityUtils.getSubject().logout();
            return Result.ok((String)"\u9000\u51fa\u767b\u5f55\u6210\u529f\uff01");
        }
        return Result.error((String)"Token\u65e0\u6548!");
    }
}

