/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysDepartPermission;
import org.jeecg.modules.system.entity.SysDepartRolePermission;
import org.jeecg.modules.system.entity.SysPermission;
import org.jeecg.modules.system.entity.SysPermissionDataRule;
import org.jeecg.modules.system.model.TreeModel;
import org.jeecg.modules.system.service.ISysDepartPermissionService;
import org.jeecg.modules.system.service.ISysDepartRolePermissionService;
import org.jeecg.modules.system.service.ISysPermissionDataRuleService;
import org.jeecg.modules.system.service.ISysPermissionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u90e8\u95e8\u6743\u9650\u8868"})
@RestController
@RequestMapping(value={"/sys/sysDepartPermission"})
public class SysDepartPermissionController
extends JeecgController<SysDepartPermission, ISysDepartPermissionService> {
    private static final Logger log = LoggerFactory.getLogger(SysDepartPermissionController.class);
    @Autowired
    private ISysDepartPermissionService sysDepartPermissionService;
    @Autowired
    private ISysPermissionDataRuleService sysPermissionDataRuleService;
    @Autowired
    private ISysPermissionService sysPermissionService;
    @Autowired
    private ISysDepartRolePermissionService sysDepartRolePermissionService;

    @ApiOperation(value="\u90e8\u95e8\u6743\u9650\u8868-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u90e8\u95e8\u6743\u9650\u8868-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(SysDepartPermission sysDepartPermission, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysDepartPermission, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.sysDepartPermissionService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u90e8\u95e8\u6743\u9650\u8868-\u6dfb\u52a0", notes="\u90e8\u95e8\u6743\u9650\u8868-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody SysDepartPermission sysDepartPermission) {
        this.sysDepartPermissionService.save(sysDepartPermission);
        return Result.ok((String)"\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u90e8\u95e8\u6743\u9650\u8868-\u7f16\u8f91", notes="\u90e8\u95e8\u6743\u9650\u8868-\u7f16\u8f91")
    @PutMapping(value={"/edit"})
    public Result<?> edit(@RequestBody SysDepartPermission sysDepartPermission) {
        this.sysDepartPermissionService.updateById(sysDepartPermission);
        return Result.ok((String)"\u7f16\u8f91\u6210\u529f!");
    }

    @ApiOperation(value="\u90e8\u95e8\u6743\u9650\u8868-\u901a\u8fc7id\u5220\u9664", notes="\u90e8\u95e8\u6743\u9650\u8868-\u901a\u8fc7id\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.sysDepartPermissionService.removeById((Serializable)((Object)id));
        return Result.ok((String)"\u5220\u9664\u6210\u529f!");
    }

    @ApiOperation(value="\u90e8\u95e8\u6743\u9650\u8868-\u6279\u91cf\u5220\u9664", notes="\u90e8\u95e8\u6743\u9650\u8868-\u6279\u91cf\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.sysDepartPermissionService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.ok((String)"\u6279\u91cf\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u90e8\u95e8\u6743\u9650\u8868-\u901a\u8fc7id\u67e5\u8be2", notes="\u90e8\u95e8\u6743\u9650\u8868-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        SysDepartPermission sysDepartPermission = (SysDepartPermission)this.sysDepartPermissionService.getById((Serializable)((Object)id));
        return Result.ok((Object)sysDepartPermission);
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, SysDepartPermission sysDepartPermission) {
        return super.exportXls(request, (Object)sysDepartPermission, SysDepartPermission.class, "\u90e8\u95e8\u6743\u9650\u8868");
    }

    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, SysDepartPermission.class);
    }

    @GetMapping(value={"/datarule/{permissionId}/{departId}"})
    public Result<?> loadDatarule(@PathVariable(value="permissionId") String permissionId, @PathVariable(value="departId") String departId) {
        String drChecked;
        List<SysPermissionDataRule> list = this.sysPermissionDataRuleService.getPermRuleListByPermId(permissionId);
        if (list == null || list.size() == 0) {
            return Result.error((String)"\u672a\u627e\u5230\u6743\u9650\u914d\u7f6e\u4fe1\u606f");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("datarule", list);
        LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysDepartPermission::getPermissionId, (Object)permissionId)).eq(SysDepartPermission::getDepartId, (Object)departId);
        SysDepartPermission sysDepartPermission = (SysDepartPermission)this.sysDepartPermissionService.getOne((Wrapper)query);
        if (sysDepartPermission != null && oConvertUtils.isNotEmpty((Object)(drChecked = sysDepartPermission.getDataRuleIds()))) {
            map.put("drChecked", drChecked.endsWith(",") ? drChecked.substring(0, drChecked.length() - 1) : drChecked);
        }
        return Result.ok(map);
    }

    @PostMapping(value={"/datarule"})
    public Result<?> saveDatarule(@RequestBody JSONObject jsonObject) {
        try {
            String permissionId = jsonObject.getString("permissionId");
            String departId = jsonObject.getString("departId");
            String dataRuleIds = jsonObject.getString("dataRuleIds");
            log.info("\u4fdd\u5b58\u6570\u636e\u89c4\u5219>>\u83dc\u5355ID:" + permissionId + "\u90e8\u95e8ID:" + departId + "\u6570\u636e\u6743\u9650ID:" + dataRuleIds);
            LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysDepartPermission::getPermissionId, (Object)permissionId)).eq(SysDepartPermission::getDepartId, (Object)departId);
            SysDepartPermission sysDepartPermission = (SysDepartPermission)this.sysDepartPermissionService.getOne((Wrapper)query);
            if (sysDepartPermission == null) {
                return Result.error((String)"\u8bf7\u5148\u4fdd\u5b58\u90e8\u95e8\u83dc\u5355\u6743\u9650!");
            }
            sysDepartPermission.setDataRuleIds(dataRuleIds);
            this.sysDepartPermissionService.updateById(sysDepartPermission);
        }
        catch (Exception e) {
            log.error("SysDepartPermissionController.saveDatarule()\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            return Result.error((String)"\u4fdd\u5b58\u5931\u8d25");
        }
        return Result.ok((String)"\u4fdd\u5b58\u6210\u529f!");
    }

    @RequestMapping(value={"/queryDeptRolePermission"}, method={RequestMethod.GET})
    public Result<List<String>> queryDeptRolePermission(@RequestParam(name="roleId", required=true) String roleId) {
        Result result = new Result();
        try {
            List list = this.sysDepartRolePermissionService.list((Wrapper)new QueryWrapper().lambda().eq(SysDepartRolePermission::getRoleId, (Object)roleId));
            result.setResult(list.stream().map(SysDepartRolePermission2 -> String.valueOf(SysDepartRolePermission2.getPermissionId())).collect(Collectors.toList()));
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/saveDeptRolePermission"}, method={RequestMethod.POST})
    public Result<String> saveDeptRolePermission(@RequestBody JSONObject json) {
        long start = System.currentTimeMillis();
        Result result = new Result();
        try {
            String roleId = json.getString("roleId");
            String permissionIds = json.getString("permissionIds");
            String lastPermissionIds = json.getString("lastpermissionIds");
            this.sysDepartRolePermissionService.saveDeptRolePermission(roleId, permissionIds, lastPermissionIds);
            result.success("\u4fdd\u5b58\u6210\u529f\uff01");
            log.info("======\u90e8\u95e8\u89d2\u8272\u6388\u6743\u6210\u529f=====\u8017\u65f6:" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
        }
        catch (Exception e) {
            result.error500("\u6388\u6743\u5931\u8d25\uff01");
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/queryTreeListForDeptRole"}, method={RequestMethod.GET})
    public Result<Map<String, Object>> queryTreeListForDeptRole(@RequestParam(name="departId", required=true) String departId, HttpServletRequest request) {
        Result result = new Result();
        ArrayList<String> ids = new ArrayList<String>();
        try {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(SysPermission::getDelFlag, (Object)CommonConstant.DEL_FLAG_0);
            query.orderByAsc(SysPermission::getSortNo);
            query.inSql(SysPermission::getId, "select permission_id  from sys_depart_permission where depart_id='" + departId + "'");
            List list = this.sysPermissionService.list((Wrapper)query);
            for (SysPermission sysPer : list) {
                ids.add(sysPer.getId());
            }
            ArrayList<TreeModel> treeList = new ArrayList<TreeModel>();
            this.getTreeModelList(treeList, list, null);
            HashMap<String, ArrayList<Object>> resMap = new HashMap<String, ArrayList<Object>>();
            resMap.put("treeList", treeList);
            resMap.put("ids", ids);
            result.setResult(resMap);
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void getTreeModelList(List<TreeModel> treeList, List<SysPermission> metaList, TreeModel temp) {
        for (SysPermission permission : metaList) {
            String tempPid = permission.getParentId();
            TreeModel tree = new TreeModel(permission.getId(), tempPid, permission.getName(), permission.getRuleFlag(), permission.isLeaf());
            if (temp == null && oConvertUtils.isEmpty((Object)tempPid)) {
                treeList.add(tree);
                if (tree.getIsLeaf()) continue;
                this.getTreeModelList(treeList, metaList, tree);
                continue;
            }
            if (temp == null || tempPid == null || !tempPid.equals(temp.getKey())) continue;
            temp.getChildren().add(tree);
            if (tree.getIsLeaf()) continue;
            this.getTreeModelList(treeList, metaList, tree);
        }
    }
}

