/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.system.entity.SysCheckRule;
import org.jeecg.modules.system.service.ISysCheckRuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u7f16\u7801\u6821\u9a8c\u89c4\u5219"})
@RestController
@RequestMapping(value={"/sys/checkRule"})
public class SysCheckRuleController
extends JeecgController<SysCheckRule, ISysCheckRuleService> {
    private static final Logger log = LoggerFactory.getLogger(SysCheckRuleController.class);
    @Autowired
    private ISysCheckRuleService sysCheckRuleService;

    @AutoLog(value="\u7f16\u7801\u6821\u9a8c\u89c4\u5219-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @ApiOperation(value="\u7f16\u7801\u6821\u9a8c\u89c4\u5219-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u7f16\u7801\u6821\u9a8c\u89c4\u5219-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result queryPageList(SysCheckRule sysCheckRule, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest request) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysCheckRule, (Map)request.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.sysCheckRuleService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u7f16\u7801\u6821\u9a8c\u89c4\u5219-\u901a\u8fc7Code\u6821\u9a8c\u4f20\u5165\u7684\u503c")
    @ApiOperation(value="\u7f16\u7801\u6821\u9a8c\u89c4\u5219-\u901a\u8fc7Code\u6821\u9a8c\u4f20\u5165\u7684\u503c", notes="\u7f16\u7801\u6821\u9a8c\u89c4\u5219-\u901a\u8fc7Code\u6821\u9a8c\u4f20\u5165\u7684\u503c")
    @GetMapping(value={"/checkByCode"})
    public Result checkByCode(@RequestParam(name="ruleCode") String ruleCode, @RequestParam(name="value") String value) throws UnsupportedEncodingException {
        SysCheckRule sysCheckRule = this.sysCheckRuleService.getByCode(ruleCode);
        if (sysCheckRule == null) {
            return Result.error((String)"\u8be5\u7f16\u7801\u4e0d\u5b58\u5728");
        }
        JSONObject errorResult = this.sysCheckRuleService.checkValue(sysCheckRule, URLDecoder.decode(value, "UTF-8"));
        if (errorResult == null) {
            return Result.ok();
        }
        Result r = Result.error((String)errorResult.getString("message"));
        r.setResult((Object)errorResult);
        return r;
    }

    @AutoLog(value="\u7f16\u7801\u6821\u9a8c\u89c4\u5219-\u6dfb\u52a0")
    @ApiOperation(value="\u7f16\u7801\u6821\u9a8c\u89c4\u5219-\u6dfb\u52a0", notes="\u7f16\u7801\u6821\u9a8c\u89c4\u5219-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result add(@RequestBody SysCheckRule sysCheckRule) {
        this.sysCheckRuleService.save(sysCheckRule);
        return Result.ok((String)"\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @AutoLog(value="\u7f16\u7801\u6821\u9a8c\u89c4\u5219-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u7801\u6821\u9a8c\u89c4\u5219-\u7f16\u8f91", notes="\u7f16\u7801\u6821\u9a8c\u89c4\u5219-\u7f16\u8f91")
    @PutMapping(value={"/edit"})
    public Result edit(@RequestBody SysCheckRule sysCheckRule) {
        this.sysCheckRuleService.updateById(sysCheckRule);
        return Result.ok((String)"\u7f16\u8f91\u6210\u529f!");
    }

    @AutoLog(value="\u7f16\u7801\u6821\u9a8c\u89c4\u5219-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u7f16\u7801\u6821\u9a8c\u89c4\u5219-\u901a\u8fc7id\u5220\u9664", notes="\u7f16\u7801\u6821\u9a8c\u89c4\u5219-\u901a\u8fc7id\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result delete(@RequestParam(name="id", required=true) String id) {
        this.sysCheckRuleService.removeById((Serializable)((Object)id));
        return Result.ok((String)"\u5220\u9664\u6210\u529f!");
    }

    @AutoLog(value="\u7f16\u7801\u6821\u9a8c\u89c4\u5219-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u7f16\u7801\u6821\u9a8c\u89c4\u5219-\u6279\u91cf\u5220\u9664", notes="\u7f16\u7801\u6821\u9a8c\u89c4\u5219-\u6279\u91cf\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.sysCheckRuleService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.ok((String)"\u6279\u91cf\u5220\u9664\u6210\u529f\uff01");
    }

    @AutoLog(value="\u7f16\u7801\u6821\u9a8c\u89c4\u5219-\u901a\u8fc7id\u67e5\u8be2")
    @ApiOperation(value="\u7f16\u7801\u6821\u9a8c\u89c4\u5219-\u901a\u8fc7id\u67e5\u8be2", notes="\u7f16\u7801\u6821\u9a8c\u89c4\u5219-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result queryById(@RequestParam(name="id", required=true) String id) {
        SysCheckRule sysCheckRule = (SysCheckRule)this.sysCheckRuleService.getById((Serializable)((Object)id));
        return Result.ok((Object)sysCheckRule);
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, SysCheckRule sysCheckRule) {
        return super.exportXls(request, (Object)sysCheckRule, SysCheckRule.class, "\u7f16\u7801\u6821\u9a8c\u89c4\u5219");
    }

    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, SysCheckRule.class);
    }
}

