/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysAnnouncementSend;
import org.jeecg.modules.system.model.AnnouncementSendModel;
import org.jeecg.modules.system.service.ISysAnnouncementSendService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/sysAnnouncementSend"})
public class SysAnnouncementSendController {
    private static final Logger log = LoggerFactory.getLogger(SysAnnouncementSendController.class);
    @Autowired
    private ISysAnnouncementSendService sysAnnouncementSendService;

    @GetMapping(value={"/list"})
    public Result<IPage<SysAnnouncementSend>> queryPageList(SysAnnouncementSend sysAnnouncementSend, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result result = new Result();
        QueryWrapper queryWrapper = new QueryWrapper((Object)sysAnnouncementSend);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        String column = req.getParameter("column");
        String order = req.getParameter("order");
        if (oConvertUtils.isNotEmpty((Object)column) && oConvertUtils.isNotEmpty((Object)order)) {
            if ("asc".equals(order)) {
                queryWrapper.orderByAsc((Object)oConvertUtils.camelToUnderline((String)column));
            } else {
                queryWrapper.orderByDesc((Object)oConvertUtils.camelToUnderline((String)column));
            }
        }
        IPage pageList = this.sysAnnouncementSendService.page((IPage)page, (Wrapper)queryWrapper);
        result.setSuccess(true);
        result.setResult((Object)pageList);
        return result;
    }

    @PostMapping(value={"/add"})
    public Result<SysAnnouncementSend> add(@RequestBody SysAnnouncementSend sysAnnouncementSend) {
        Result result = new Result();
        try {
            this.sysAnnouncementSendService.save(sysAnnouncementSend);
            result.success("\u6dfb\u52a0\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @PutMapping(value={"/edit"})
    public Result<SysAnnouncementSend> eidt(@RequestBody SysAnnouncementSend sysAnnouncementSend) {
        Result result = new Result();
        SysAnnouncementSend sysAnnouncementSendEntity = (SysAnnouncementSend)this.sysAnnouncementSendService.getById((Serializable)((Object)sysAnnouncementSend.getId()));
        if (sysAnnouncementSendEntity == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            boolean ok = this.sysAnnouncementSendService.updateById(sysAnnouncementSend);
            if (ok) {
                result.success("\u4fee\u6539\u6210\u529f!");
            }
        }
        return result;
    }

    @DeleteMapping(value={"/delete"})
    public Result<SysAnnouncementSend> delete(@RequestParam(name="id", required=true) String id) {
        Result result = new Result();
        SysAnnouncementSend sysAnnouncementSend = (SysAnnouncementSend)this.sysAnnouncementSendService.getById((Serializable)((Object)id));
        if (sysAnnouncementSend == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            boolean ok = this.sysAnnouncementSendService.removeById((Serializable)((Object)id));
            if (ok) {
                result.success("\u5220\u9664\u6210\u529f!");
            }
        }
        return result;
    }

    @DeleteMapping(value={"/deleteBatch"})
    public Result<SysAnnouncementSend> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        Result result = new Result();
        if (ids == null || "".equals(ids.trim())) {
            result.error500("\u53c2\u6570\u4e0d\u8bc6\u522b\uff01");
        } else {
            this.sysAnnouncementSendService.removeByIds(Arrays.asList(ids.split(",")));
            result.success("\u5220\u9664\u6210\u529f!");
        }
        return result;
    }

    @GetMapping(value={"/queryById"})
    public Result<SysAnnouncementSend> queryById(@RequestParam(name="id", required=true) String id) {
        Result result = new Result();
        SysAnnouncementSend sysAnnouncementSend = (SysAnnouncementSend)this.sysAnnouncementSendService.getById((Serializable)((Object)id));
        if (sysAnnouncementSend == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            result.setResult((Object)sysAnnouncementSend);
            result.setSuccess(true);
        }
        return result;
    }

    @PutMapping(value={"/editByAnntIdAndUserId"})
    public Result<SysAnnouncementSend> editById(@RequestBody JSONObject json) {
        Result result = new Result();
        String anntId = json.getString("anntId");
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String userId = sysUser.getId();
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(SysAnnouncementSend::getReadFlag, (Object)"1");
        updateWrapper.set(SysAnnouncementSend::getReadTime, (Object)new Date());
        updateWrapper.last("where annt_id ='" + anntId + "' and user_id ='" + userId + "'");
        SysAnnouncementSend announcementSend = new SysAnnouncementSend();
        this.sysAnnouncementSendService.update(announcementSend, (Wrapper)updateWrapper);
        result.setSuccess(true);
        return result;
    }

    @GetMapping(value={"/getMyAnnouncementSend"})
    public Result<IPage<AnnouncementSendModel>> getMyAnnouncementSend(AnnouncementSendModel announcementSendModel, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        Result result = new Result();
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String userId = sysUser.getId();
        announcementSendModel.setUserId(userId);
        announcementSendModel.setPageNo((pageNo - 1) * pageSize);
        announcementSendModel.setPageSize(pageSize);
        Page<AnnouncementSendModel> pageList = new Page<AnnouncementSendModel>((long)pageNo.intValue(), (long)pageSize.intValue());
        pageList = this.sysAnnouncementSendService.getMyAnnouncementSendPage(pageList, announcementSendModel);
        result.setResult(pageList);
        result.setSuccess(true);
        return result;
    }

    @PutMapping(value={"/readAll"})
    public Result<SysAnnouncementSend> readAll() {
        Result result = new Result();
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String userId = sysUser.getId();
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(SysAnnouncementSend::getReadFlag, (Object)"1");
        updateWrapper.set(SysAnnouncementSend::getReadTime, (Object)new Date());
        updateWrapper.last("where user_id ='" + userId + "'");
        SysAnnouncementSend announcementSend = new SysAnnouncementSend();
        this.sysAnnouncementSendService.update(announcementSend, (Wrapper)updateWrapper);
        result.setSuccess(true);
        result.setMessage("\u5168\u90e8\u5df2\u8bfb");
        return result;
    }
}

