/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.oss.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.oss.entity.OSSFile;
import org.jeecg.modules.oss.service.IOSSFileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/sys/oss/file"})
public class OSSFileController {
    private static final Logger log = LoggerFactory.getLogger(OSSFileController.class);
    @Autowired
    private IOSSFileService ossFileService;

    @ResponseBody
    @GetMapping(value={"/list"})
    public Result<IPage<OSSFile>> queryPageList(OSSFile file, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result result = new Result();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)file), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.ossFileService.page((IPage)page, (Wrapper)queryWrapper);
        result.setSuccess(true);
        result.setResult((Object)pageList);
        return result;
    }

    @ResponseBody
    @PostMapping(value={"/upload"})
    public Result upload(@RequestParam(value="file") MultipartFile multipartFile) {
        Result result = new Result();
        try {
            this.ossFileService.upload(multipartFile);
            result.success("\u4e0a\u4f20\u6210\u529f\uff01");
        }
        catch (Exception ex) {
            log.info(ex.getMessage(), (Throwable)ex);
            result.error500("\u4e0a\u4f20\u5931\u8d25");
        }
        return result;
    }

    @ResponseBody
    @DeleteMapping(value={"/delete"})
    public Result delete(@RequestParam(name="id") String id) {
        Result result = new Result();
        OSSFile file = (OSSFile)((Object)this.ossFileService.getById((Serializable)((Object)id)));
        if (file == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            boolean ok = this.ossFileService.delete(file);
            if (ok) {
                result.success("\u5220\u9664\u6210\u529f!");
            }
        }
        return result;
    }

    @ResponseBody
    @GetMapping(value={"/queryById"})
    public Result<OSSFile> queryById(@RequestParam(name="id") String id) {
        Result result = new Result();
        OSSFile file = (OSSFile)((Object)this.ossFileService.getById((Serializable)((Object)id)));
        if (file == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            result.setResult((Object)file);
            result.setSuccess(true);
        }
        return result;
    }
}

