/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.monitor.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.monitor.domain.RedisInfo;
import org.jeecg.modules.monitor.exception.RedisConnectException;
import org.jeecg.modules.monitor.service.RedisService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.stereotype.Service;

@Service(value="redisService")
public class RedisServiceImpl
implements RedisService {
    private static final Logger log = LoggerFactory.getLogger(RedisServiceImpl.class);
    @Resource
    private RedisConnectionFactory redisConnectionFactory;

    @Override
    public List<RedisInfo> getRedisInfo() throws RedisConnectException {
        Properties info = this.redisConnectionFactory.getConnection().info();
        ArrayList<RedisInfo> infoList = new ArrayList<RedisInfo>();
        RedisInfo redisInfo = null;
        for (Map.Entry<Object, Object> entry : info.entrySet()) {
            redisInfo = new RedisInfo();
            redisInfo.setKey(oConvertUtils.getString((Object)entry.getKey()));
            redisInfo.setValue(oConvertUtils.getString((Object)entry.getValue()));
            infoList.add(redisInfo);
        }
        return infoList;
    }

    @Override
    public Map<String, Object> getKeysSize() throws RedisConnectException {
        Long dbSize = this.redisConnectionFactory.getConnection().dbSize();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("create_time", System.currentTimeMillis());
        map.put("dbSize", dbSize);
        log.info("--getKeysSize--: " + ((Object)map).toString());
        return map;
    }

    @Override
    public Map<String, Object> getMemoryInfo() throws RedisConnectException {
        HashMap<String, Object> map = null;
        Properties info = this.redisConnectionFactory.getConnection().info();
        for (Map.Entry<Object, Object> entry : info.entrySet()) {
            String key = oConvertUtils.getString((Object)entry.getKey());
            if (!"used_memory".equals(key)) continue;
            map = new HashMap<String, Object>();
            map.put("used_memory", entry.getValue());
            map.put("create_time", System.currentTimeMillis());
        }
        log.info("--getMemoryInfo--: " + ((Object)map).toString());
        return map;
    }

    @Override
    public Map<String, JSONArray> getMapForReport(String type) throws RedisConnectException {
        HashMap<String, JSONArray> mapJson = new HashMap<String, JSONArray>();
        JSONArray json = new JSONArray();
        if ("3".equals(type)) {
            List<RedisInfo> redisInfo = this.getRedisInfo();
            for (RedisInfo info : redisInfo) {
                HashMap map = Maps.newHashMap();
                BeanMap beanMap = BeanMap.create((Object)info);
                for (Object key : beanMap.keySet()) {
                    map.put(key + "", beanMap.get(key));
                }
                json.add((Object)map);
            }
            mapJson.put("data", json);
            return mapJson;
        }
        for (int i = 0; i < 5; ++i) {
            Map<String, Object> map;
            JSONObject jo = new JSONObject();
            if ("1".equals(type)) {
                map = this.getKeysSize();
                jo.put("value", map.get("dbSize"));
            } else {
                map = this.getMemoryInfo();
                Integer used_memory = Integer.valueOf(map.get("used_memory").toString());
                jo.put("value", (Object)(used_memory / 1000));
            }
            String create_time = DateUtil.formatTime((Date)DateUtil.date((long)((Long)map.get("create_time") - (long)((4 - i) * 1000))));
            jo.put("name", (Object)create_time);
            json.add((Object)jo);
        }
        mapJson.put("data", json);
        return mapJson;
    }
}

