/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.message.job;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.List;
import org.jeecg.common.util.DateUtils;
import org.jeecg.modules.message.entity.SysMessage;
import org.jeecg.modules.message.handle.ISendMsgHandle;
import org.jeecg.modules.message.handle.enums.SendMsgStatusEnum;
import org.jeecg.modules.message.handle.enums.SendMsgTypeEnum;
import org.jeecg.modules.message.service.ISysMessageService;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SendMsgJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(SendMsgJob.class);
    @Autowired
    private ISysMessageService sysMessageService;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        log.info(String.format(" Jeecg-Boot \u53d1\u9001\u6d88\u606f\u4efb\u52a1 SendMsgJob !  \u65f6\u95f4:" + DateUtils.getTimestamp(), new Object[0]));
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"es_send_status", (Object)SendMsgStatusEnum.WAIT.getCode())).or(i -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.eq((Object)"es_send_status", (Object)SendMsgStatusEnum.FAIL.getCode())).lt((Object)"es_send_num", (Object)6);
        });
        List sysMessages = this.sysMessageService.list((Wrapper)queryWrapper);
        System.out.println(sysMessages);
        for (SysMessage sysMessage : sysMessages) {
            ISendMsgHandle sendMsgHandle = null;
            try {
                if (sysMessage.getEsType().equals(SendMsgTypeEnum.EMAIL.getType())) {
                    sendMsgHandle = (ISendMsgHandle)Class.forName(SendMsgTypeEnum.EMAIL.getImplClass()).newInstance();
                } else if (sysMessage.getEsType().equals(SendMsgTypeEnum.SMS.getType())) {
                    sendMsgHandle = (ISendMsgHandle)Class.forName(SendMsgTypeEnum.SMS.getImplClass()).newInstance();
                } else if (sysMessage.getEsType().equals(SendMsgTypeEnum.WX.getType())) {
                    sendMsgHandle = (ISendMsgHandle)Class.forName(SendMsgTypeEnum.WX.getImplClass()).newInstance();
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            Integer sendNum = sysMessage.getEsSendNum();
            try {
                sendMsgHandle.SendMsg(sysMessage.getEsReceiver(), sysMessage.getEsTitle(), sysMessage.getEsContent().toString());
                sysMessage.setEsSendStatus(SendMsgStatusEnum.SUCCESS.getCode());
            }
            catch (Exception e) {
                e.printStackTrace();
                sysMessage.setEsSendStatus(SendMsgStatusEnum.FAIL.getCode());
            }
            sendNum = sendNum + 1;
            sysMessage.setEsSendNum(sendNum);
            this.sysMessageService.updateById((Object)sysMessage);
        }
    }
}

