/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.api.controller;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jeecg.common.api.dto.OnlineAuthDTO;
import org.jeecg.common.api.dto.message.BusMessageDTO;
import org.jeecg.common.api.dto.message.BusTemplateMessageDTO;
import org.jeecg.common.api.dto.message.MessageDTO;
import org.jeecg.common.api.dto.message.TemplateDTO;
import org.jeecg.common.api.dto.message.TemplateMessageDTO;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.vo.ComboModel;
import org.jeecg.common.system.vo.DictModel;
import org.jeecg.common.system.vo.DynamicDataSourceModel;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.system.vo.SysCategoryModel;
import org.jeecg.common.system.vo.SysDepartModel;
import org.jeecg.common.system.vo.SysPermissionDataRuleModel;
import org.jeecg.common.system.vo.SysUserCacheInfo;
import org.jeecg.modules.system.service.ISysUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/api"})
public class SystemAPIController {
    @Autowired
    private ISysBaseAPI sysBaseAPI;
    @Autowired
    private ISysUserService sysUserService;

    @PostMapping(value={"/sendSysAnnouncement"})
    public void sendSysAnnouncement(@RequestBody MessageDTO message) {
        this.sysBaseAPI.sendSysAnnouncement(message);
    }

    @PostMapping(value={"/sendBusAnnouncement"})
    public void sendBusAnnouncement(@RequestBody BusMessageDTO message) {
        this.sysBaseAPI.sendBusAnnouncement(message);
    }

    @PostMapping(value={"/sendTemplateAnnouncement"})
    public void sendTemplateAnnouncement(@RequestBody TemplateMessageDTO message) {
        this.sysBaseAPI.sendTemplateAnnouncement(message);
    }

    @PostMapping(value={"/sendBusTemplateAnnouncement"})
    public void sendBusTemplateAnnouncement(@RequestBody BusTemplateMessageDTO message) {
        this.sysBaseAPI.sendBusTemplateAnnouncement(message);
    }

    @PostMapping(value={"/parseTemplateByCode"})
    public String parseTemplateByCode(@RequestBody TemplateDTO templateDTO) {
        return this.sysBaseAPI.parseTemplateByCode(templateDTO);
    }

    @GetMapping(value={"/updateSysAnnounReadFlag"})
    public void updateSysAnnounReadFlag(@RequestParam(value="busType") String busType, @RequestParam(value="busId") String busId) {
        this.sysBaseAPI.updateSysAnnounReadFlag(busType, busId);
    }

    @GetMapping(value={"/getUserByName"})
    public LoginUser getUserByName(@RequestParam(value="username") String username) {
        return this.sysBaseAPI.getUserByName(username);
    }

    @GetMapping(value={"/getUserById"})
    LoginUser getUserById(@RequestParam(value="id") String id) {
        return this.sysBaseAPI.getUserById(id);
    }

    @GetMapping(value={"/getRolesByUsername"})
    List<String> getRolesByUsername(@RequestParam(value="username") String username) {
        return this.sysBaseAPI.getRolesByUsername(username);
    }

    @GetMapping(value={"/getDepartIdsByUsername"})
    List<String> getDepartIdsByUsername(@RequestParam(value="username") String username) {
        return this.sysBaseAPI.getDepartIdsByUsername(username);
    }

    @GetMapping(value={"/getDepartNamesByUsername"})
    List<String> getDepartNamesByUsername(@RequestParam(value="username") String username) {
        return this.sysBaseAPI.getDepartNamesByUsername(username);
    }

    @GetMapping(value={"/queryDictItemsByCode"})
    List<DictModel> queryDictItemsByCode(@RequestParam(value="code") String code) {
        return this.sysBaseAPI.queryDictItemsByCode(code);
    }

    @GetMapping(value={"/queryAllDict"})
    List<DictModel> queryAllDict() {
        return this.sysBaseAPI.queryAllDict();
    }

    @GetMapping(value={"/queryAllDSysCategory"})
    List<SysCategoryModel> queryAllDSysCategory() {
        return this.sysBaseAPI.queryAllDSysCategory();
    }

    @GetMapping(value={"/queryTableDictItemsByCode"})
    List<DictModel> queryTableDictItemsByCode(@RequestParam(value="table") String table, @RequestParam(value="text") String text, @RequestParam(value="code") String code) {
        return this.sysBaseAPI.queryTableDictItemsByCode(table, text, code);
    }

    @GetMapping(value={"/queryAllDepartBackDictModel"})
    List<DictModel> queryAllDepartBackDictModel() {
        return this.sysBaseAPI.queryAllDepartBackDictModel();
    }

    @GetMapping(value={"/queryFilterTableDictInfo"})
    List<DictModel> queryFilterTableDictInfo(@RequestParam(value="table") String table, @RequestParam(value="text") String text, @RequestParam(value="code") String code, @RequestParam(value="filterSql") String filterSql) {
        return this.sysBaseAPI.queryFilterTableDictInfo(table, text, code, filterSql);
    }

    @Deprecated
    @GetMapping(value={"/queryTableDictByKeys"})
    public List<String> queryTableDictByKeys(@RequestParam(value="table") String table, @RequestParam(value="text") String text, @RequestParam(value="code") String code, @RequestParam(value="keyArray") String[] keyArray) {
        return this.sysBaseAPI.queryTableDictByKeys(table, text, code, keyArray);
    }

    @GetMapping(value={"/queryAllRole"})
    public List<ComboModel> queryAllRole(@RequestParam(name="roleIds", required=false) String[] roleIds) {
        if (roleIds == null || roleIds.length == 0) {
            return this.sysBaseAPI.queryAllRole();
        }
        return this.sysBaseAPI.queryAllRole(roleIds);
    }

    @GetMapping(value={"/getRoleIdsByUsername"})
    public List<String> getRoleIdsByUsername(@RequestParam(value="username") String username) {
        return this.sysBaseAPI.getRoleIdsByUsername(username);
    }

    @GetMapping(value={"/getDepartIdsByOrgCode"})
    public String getDepartIdsByOrgCode(@RequestParam(value="orgCode") String orgCode) {
        return this.sysBaseAPI.getDepartIdsByOrgCode(orgCode);
    }

    @GetMapping(value={"/getAllSysDepart"})
    public List<SysDepartModel> getAllSysDepart() {
        return this.sysBaseAPI.getAllSysDepart();
    }

    @GetMapping(value={"/getDynamicDbSourceById"})
    DynamicDataSourceModel getDynamicDbSourceById(@RequestParam(value="dbSourceId") String dbSourceId) {
        return this.sysBaseAPI.getDynamicDbSourceById(dbSourceId);
    }

    @GetMapping(value={"/getDeptHeadByDepId"})
    public List<String> getDeptHeadByDepId(@RequestParam(value="deptId") String deptId) {
        return this.sysBaseAPI.getDeptHeadByDepId(deptId);
    }

    @GetMapping(value={"/getParentDepartId"})
    public DictModel getParentDepartId(@RequestParam(value="departId") String departId) {
        return this.sysBaseAPI.getParentDepartId(departId);
    }

    @GetMapping(value={"/getDynamicDbSourceByCode"})
    public DynamicDataSourceModel getDynamicDbSourceByCode(@RequestParam(value="dbSourceCode") String dbSourceCode) {
        return this.sysBaseAPI.getDynamicDbSourceByCode(dbSourceCode);
    }

    @GetMapping(value={"/sendWebSocketMsg"})
    public void sendWebSocketMsg(String[] userIds, String cmd) {
        this.sysBaseAPI.sendWebSocketMsg(userIds, cmd);
    }

    @GetMapping(value={"/queryAllUserByIds"})
    public List<LoginUser> queryAllUserByIds(@RequestParam(value="userIds") String[] userIds) {
        return this.sysBaseAPI.queryAllUserByIds(userIds);
    }

    @GetMapping(value={"/queryAllUserBackCombo"})
    public List<ComboModel> queryAllUserBackCombo() {
        return this.sysBaseAPI.queryAllUserBackCombo();
    }

    @GetMapping(value={"/queryAllUser"})
    public JSONObject queryAllUser(@RequestParam(name="userIds", required=false) String userIds, @RequestParam(name="pageNo", required=false) Integer pageNo, @RequestParam(name="pageSize", required=false) int pageSize) {
        return this.sysBaseAPI.queryAllUser(userIds, pageNo, Integer.valueOf(pageSize));
    }

    @GetMapping(value={"/meetingSignWebsocket"})
    public void meetingSignWebsocket(@RequestParam(value="userId") String userId) {
        this.sysBaseAPI.meetingSignWebsocket(userId);
    }

    @GetMapping(value={"/queryUserByNames"})
    public List<LoginUser> queryUserByNames(@RequestParam(value="userNames") String[] userNames) {
        return this.sysBaseAPI.queryUserByNames(userNames);
    }

    @GetMapping(value={"/getUserRoleSet"})
    public Set<String> getUserRoleSet(@RequestParam(value="username") String username) {
        return this.sysBaseAPI.getUserRoleSet(username);
    }

    @GetMapping(value={"/getUserPermissionSet"})
    public Set<String> getUserPermissionSet(@RequestParam(value="username") String username) {
        return this.sysBaseAPI.getUserPermissionSet(username);
    }

    @PostMapping(value={"/hasOnlineAuth"})
    public boolean hasOnlineAuth(@RequestBody OnlineAuthDTO onlineAuthDTO) {
        return this.sysBaseAPI.hasOnlineAuth(onlineAuthDTO);
    }

    @GetMapping(value={"/queryUserRoles"})
    public Set<String> queryUserRoles(@RequestParam(value="username") String username) {
        return this.sysUserService.getUserRolesSet(username);
    }

    @GetMapping(value={"/queryUserAuths"})
    public Set<String> queryUserAuths(@RequestParam(value="username") String username) {
        return this.sysUserService.getUserPermissionsSet(username);
    }

    @GetMapping(value={"/selectAllById"})
    public SysDepartModel selectAllById(@RequestParam(value="id") String id) {
        return this.sysBaseAPI.selectAllById(id);
    }

    @GetMapping(value={"/queryDeptUsersByUserId"})
    public List<String> queryDeptUsersByUserId(@RequestParam(value="userId") String userId) {
        return this.sysBaseAPI.queryDeptUsersByUserId(userId);
    }

    @GetMapping(value={"/queryPermissionDataRule"})
    public List<SysPermissionDataRuleModel> queryPermissionDataRule(@RequestParam(value="component") String component, @RequestParam(value="requestPath") String requestPath, @RequestParam(value="username") String username) {
        return this.sysBaseAPI.queryPermissionDataRule(component, requestPath, username);
    }

    @GetMapping(value={"/getCacheUser"})
    public SysUserCacheInfo getCacheUser(@RequestParam(value="username") String username) {
        return this.sysBaseAPI.getCacheUser(username);
    }

    @GetMapping(value={"/translateDictFromTable"})
    public String translateDictFromTable(@RequestParam(value="table") String table, @RequestParam(value="text") String text, @RequestParam(value="code") String code, @RequestParam(value="key") String key) {
        return this.sysBaseAPI.translateDictFromTable(table, text, code, key);
    }

    @GetMapping(value={"/translateDict"})
    public String translateDict(@RequestParam(value="code") String code, @RequestParam(value="key") String key) {
        return this.sysBaseAPI.translateDict(code, key);
    }

    @GetMapping(value={"/queryUsersByUsernames"})
    List<JSONObject> queryUsersByUsernames(String usernames) {
        return this.sysBaseAPI.queryUsersByUsernames(usernames);
    }

    @GetMapping(value={"/queryUsersByIds"})
    List<JSONObject> queryUsersByIds(String ids) {
        return this.sysBaseAPI.queryUsersByIds(ids);
    }

    @GetMapping(value={"/queryDepartsByOrgcodes"})
    List<JSONObject> queryDepartsByOrgcodes(String orgCodes) {
        return this.sysBaseAPI.queryDepartsByOrgcodes(orgCodes);
    }

    @GetMapping(value={"/queryDepartsByIds"})
    List<JSONObject> queryDepartsByIds(String orgCodes) {
        return this.sysBaseAPI.queryDepartsByIds(orgCodes);
    }

    @GetMapping(value={"/sendEmailMsg"})
    public void sendEmailMsg(@RequestParam(value="email") String email, @RequestParam(value="title") String title, @RequestParam(value="content") String content) {
        this.sysBaseAPI.sendEmailMsg(email, title, content);
    }

    @GetMapping(value={"/getDeptUserByOrgCode"})
    List<Map> getDeptUserByOrgCode(@RequestParam(value="orgCode") String orgCode) {
        return this.sysBaseAPI.getDeptUserByOrgCode(orgCode);
    }
}

