/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config.jimureport;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jeecg.common.api.CommonAPI;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.SysUserCacheInfo;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.TokenUtils;
import org.jeecg.modules.jmreport.api.JmReportTokenServiceI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class JimuReportTokenService
implements JmReportTokenServiceI {
    @Autowired
    private ISysBaseAPI sysBaseAPI;
    @Autowired
    @Lazy
    private RedisUtil redisUtil;

    public String getToken(HttpServletRequest request) {
        return TokenUtils.getTokenByRequest((HttpServletRequest)request);
    }

    public String getUsername(String token) {
        return JwtUtil.getUsername((String)token);
    }

    public Boolean verifyToken(String token) {
        return TokenUtils.verifyToken((String)token, (CommonAPI)this.sysBaseAPI, (RedisUtil)this.redisUtil);
    }

    public Map<String, Object> getUserInfo(String token) {
        String username = JwtUtil.getUsername((String)token);
        SysUserCacheInfo userInfo = this.sysBaseAPI.getCacheUser(username);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sysUserCode", userInfo.getSysUserCode());
        map.put("sysOrgCode", userInfo.getSysOrgCode());
        return map;
    }
}

