/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysPermission;
import org.jeecg.modules.system.entity.SysPermissionDataRule;
import org.jeecg.modules.system.mapper.SysPermissionDataRuleMapper;
import org.jeecg.modules.system.mapper.SysPermissionMapper;
import org.jeecg.modules.system.service.ISysPermissionDataRuleService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysPermissionDataRuleImpl
extends ServiceImpl<SysPermissionDataRuleMapper, SysPermissionDataRule>
implements ISysPermissionDataRuleService {
    @Resource
    private SysPermissionMapper sysPermissionMapper;

    public List<SysPermissionDataRule> getPermRuleListByPermId(String permissionId) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysPermissionDataRule::getPermissionId, (Object)permissionId);
        query.orderByDesc(SysPermissionDataRule::getCreateTime);
        List permRuleList = this.list((Wrapper)query);
        return permRuleList;
    }

    public List<SysPermissionDataRule> queryPermissionRule(SysPermissionDataRule permRule) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)permRule, null);
        return this.list((Wrapper)queryWrapper);
    }

    public List<SysPermissionDataRule> queryPermissionDataRules(String username, String permissionId) {
        List idsList = ((SysPermissionDataRuleMapper)this.baseMapper).queryDataRuleIds(username, permissionId);
        if (idsList == null || idsList.size() == 0) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        for (String ids : idsList) {
            String[] arr;
            if (oConvertUtils.isEmpty((Object)ids)) continue;
            for (String id : arr = ids.split(",")) {
                if (!oConvertUtils.isNotEmpty((Object)id) || set.contains(id)) continue;
                set.add(id);
            }
        }
        if (set.size() == 0) {
            return null;
        }
        return ((SysPermissionDataRuleMapper)this.baseMapper).selectList((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"id", set)).eq((Object)"status", (Object)"1"));
    }

    @Transactional
    public void savePermissionDataRule(SysPermissionDataRule sysPermissionDataRule) {
        this.save((Object)sysPermissionDataRule);
        SysPermission permission = (SysPermission)this.sysPermissionMapper.selectById((Serializable)((Object)sysPermissionDataRule.getPermissionId()));
        if (permission != null && (permission.getRuleFlag() == null || permission.getRuleFlag().equals(CommonConstant.RULE_FLAG_0))) {
            permission.setRuleFlag(CommonConstant.RULE_FLAG_1);
            this.sysPermissionMapper.updateById((Object)permission);
        }
    }

    @Transactional
    public void deletePermissionDataRule(String dataRuleId) {
        SysPermissionDataRule dataRule = (SysPermissionDataRule)((SysPermissionDataRuleMapper)this.baseMapper).selectById((Serializable)((Object)dataRuleId));
        if (dataRule != null) {
            SysPermission permission;
            this.removeById((Serializable)((Object)dataRuleId));
            Integer count = ((SysPermissionDataRuleMapper)this.baseMapper).selectCount((Wrapper)new LambdaQueryWrapper().eq(SysPermissionDataRule::getPermissionId, (Object)dataRule.getPermissionId()));
            if ((count == null || count == 0) && (permission = (SysPermission)this.sysPermissionMapper.selectById((Serializable)((Object)dataRule.getPermissionId()))) != null && permission.getRuleFlag().equals(CommonConstant.RULE_FLAG_1)) {
                permission.setRuleFlag(CommonConstant.RULE_FLAG_0);
                this.sysPermissionMapper.updateById((Object)permission);
            }
        }
    }
}

