/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.system.vo.DictModel;
import org.jeecg.common.system.vo.DictQuery;
import org.jeecg.modules.system.entity.SysDict;
import org.jeecg.modules.system.entity.SysDictItem;
import org.jeecg.modules.system.mapper.SysDictItemMapper;
import org.jeecg.modules.system.mapper.SysDictMapper;
import org.jeecg.modules.system.model.TreeSelectModel;
import org.jeecg.modules.system.service.ISysDictService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysDictServiceImpl
extends ServiceImpl<SysDictMapper, SysDict>
implements ISysDictService {
    private static final Logger log = LoggerFactory.getLogger(SysDictServiceImpl.class);
    @Autowired
    private SysDictMapper sysDictMapper;
    @Autowired
    private SysDictItemMapper sysDictItemMapper;

    @Cacheable(value={"sys:cache:dict"}, key="#code")
    public List<DictModel> queryDictItemsByCode(String code) {
        log.info("\u65e0\u7f13\u5b58dictCache\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
        return this.sysDictMapper.queryDictItemsByCode(code);
    }

    public Map<String, List<DictModel>> queryAllDictItems() {
        HashMap<String, List<DictModel>> res = new HashMap<String, List<DictModel>>();
        List ls = this.sysDictMapper.selectList(null);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysDictItem::getStatus, (Object)1);
        queryWrapper.orderByAsc(SysDictItem::getSortOrder);
        List sysDictItemList = this.sysDictItemMapper.selectList((Wrapper)queryWrapper);
        for (SysDict d : ls) {
            List dictModelList = sysDictItemList.stream().filter(s -> d.getId().equals(s.getDictId())).map(item -> {
                DictModel dictModel = new DictModel();
                dictModel.setText(item.getItemText());
                dictModel.setValue(item.getItemValue());
                return dictModel;
            }).collect(Collectors.toList());
            res.put(d.getDictCode(), dictModelList);
        }
        log.debug("-------\u767b\u5f55\u52a0\u8f7d\u7cfb\u7edf\u5b57\u5178-----" + ((Object)res).toString());
        return res;
    }

    @Cacheable(value={"sys:cache:dict"}, key="#code+':'+#key")
    public String queryDictTextByKey(String code, String key) {
        log.info("\u65e0\u7f13\u5b58dictText\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
        return this.sysDictMapper.queryDictTextByKey(code, key);
    }

    public List<DictModel> queryTableDictItemsByCode(String table, String text, String code) {
        log.info("\u65e0\u7f13\u5b58dictTableList\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
        return this.sysDictMapper.queryTableDictItemsByCode(table, text, code);
    }

    public List<DictModel> queryTableDictItemsByCodeAndFilter(String table, String text, String code, String filterSql) {
        log.info("\u65e0\u7f13\u5b58dictTableList\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
        return this.sysDictMapper.queryTableDictItemsByCodeAndFilter(table, text, code, filterSql);
    }

    @Cacheable(value={"sys:cache:dictTable"})
    public String queryTableDictTextByKey(String table, String text, String code, String key) {
        log.info("\u65e0\u7f13\u5b58dictTable\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
        return this.sysDictMapper.queryTableDictTextByKey(table, text, code, key);
    }

    @Cacheable(value={"sys:cache:dictTable"})
    public List<String> queryTableDictByKeys(String table, String text, String code, String[] keyArray) {
        List dicts = this.sysDictMapper.queryTableDictByKeys(table, text, code, keyArray);
        ArrayList<String> texts = new ArrayList<String>(dicts.size());
        block0: for (String key : keyArray) {
            for (DictModel dict : dicts) {
                if (!key.equals(dict.getValue())) continue;
                texts.add(dict.getText());
                continue block0;
            }
        }
        return texts;
    }

    public boolean deleteByDictId(SysDict sysDict) {
        sysDict.setDelFlag(CommonConstant.DEL_FLAG_1);
        return this.updateById((Object)sysDict);
    }

    @Transactional
    public Integer saveMain(SysDict sysDict, List<SysDictItem> sysDictItemList) {
        int insert = 0;
        try {
            insert = this.sysDictMapper.insert((Object)sysDict);
            if (sysDictItemList != null) {
                for (SysDictItem entity : sysDictItemList) {
                    entity.setDictId(sysDict.getId());
                    entity.setStatus(Integer.valueOf(1));
                    this.sysDictItemMapper.insert((Object)entity);
                }
            }
        }
        catch (Exception e) {
            return insert;
        }
        return insert;
    }

    public List<DictModel> queryAllDepartBackDictModel() {
        return ((SysDictMapper)this.baseMapper).queryAllDepartBackDictModel();
    }

    public List<DictModel> queryAllUserBackDictModel() {
        return ((SysDictMapper)this.baseMapper).queryAllUserBackDictModel();
    }

    public List<DictModel> queryTableDictItems(String table, String text, String code, String keyword) {
        return ((SysDictMapper)this.baseMapper).queryTableDictItems(table, text, code, "%" + keyword + "%");
    }

    public List<TreeSelectModel> queryTreeList(Map<String, String> query, String table, String text, String code, String pidField, String pid, String hasChildField) {
        return ((SysDictMapper)this.baseMapper).queryTreeList(query, table, text, code, pidField, pid, hasChildField);
    }

    public void deleteOneDictPhysically(String id) {
        ((SysDictMapper)this.baseMapper).deleteOneById(id);
        this.sysDictItemMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysDictItem::getDictId, (Object)id));
    }

    public void updateDictDelFlag(int delFlag, String id) {
        ((SysDictMapper)this.baseMapper).updateDictDelFlag(delFlag, id);
    }

    public List<SysDict> queryDeleteList() {
        return ((SysDictMapper)this.baseMapper).queryDeleteList();
    }

    public List<DictModel> queryDictTablePageList(DictQuery query, int pageSize, int pageNo) {
        Page page = new Page((long)pageNo, (long)pageSize, false);
        Page pageList = ((SysDictMapper)this.baseMapper).queryDictTablePageList(page, query);
        return pageList.getRecords();
    }
}

