/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysDepartRole;
import org.jeecg.modules.system.entity.SysDepartRoleUser;
import org.jeecg.modules.system.mapper.SysDepartRoleMapper;
import org.jeecg.modules.system.mapper.SysDepartRoleUserMapper;
import org.jeecg.modules.system.service.ISysDepartRoleUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysDepartRoleUserServiceImpl
extends ServiceImpl<SysDepartRoleUserMapper, SysDepartRoleUser>
implements ISysDepartRoleUserService {
    @Autowired
    private SysDepartRoleMapper sysDepartRoleMapper;

    public void deptRoleUserAdd(String userId, String newRoleId, String oldRoleId) {
        List remove;
        List add = this.getDiff(oldRoleId, newRoleId);
        if (add != null && add.size() > 0) {
            ArrayList<SysDepartRoleUser> list = new ArrayList<SysDepartRoleUser>();
            for (String roleId : add) {
                if (!oConvertUtils.isNotEmpty((Object)roleId)) continue;
                SysDepartRoleUser rolepms = new SysDepartRoleUser(userId, roleId);
                list.add(rolepms);
            }
            this.saveBatch(list);
        }
        if ((remove = this.getDiff(newRoleId, oldRoleId)) != null && remove.size() > 0) {
            for (String roleId : remove) {
                this.remove((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysDepartRoleUser::getUserId, (Object)userId)).eq(SysDepartRoleUser::getDroleId, (Object)roleId));
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void removeDeptRoleUser(List<String> userIds, String depId) {
        for (String userId : userIds) {
            List sysDepartRoleList = this.sysDepartRoleMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"depart_id", (Object)depId));
            List roleIds = sysDepartRoleList.stream().map(SysDepartRole::getId).collect(Collectors.toList());
            if (roleIds == null || roleIds.size() <= 0) continue;
            QueryWrapper query = new QueryWrapper();
            ((QueryWrapper)query.eq((Object)"user_id", (Object)userId)).in((Object)"drole_id", roleIds);
            this.remove((Wrapper)query);
        }
    }

    private List<String> getDiff(String main, String diff) {
        if (oConvertUtils.isEmpty((Object)diff)) {
            return null;
        }
        if (oConvertUtils.isEmpty((Object)main)) {
            return Arrays.asList(diff.split(","));
        }
        String[] mainArr = main.split(",");
        String[] diffArr = diff.split(",");
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String string : mainArr) {
            map.put(string, 1);
        }
        ArrayList<String> res = new ArrayList<String>();
        for (String key : diffArr) {
            if (!oConvertUtils.isNotEmpty((Object)key) || map.containsKey(key)) continue;
            res.add(key);
        }
        return res;
    }
}

