/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysDepartPermission;
import org.jeecg.modules.system.entity.SysDepartRole;
import org.jeecg.modules.system.entity.SysDepartRolePermission;
import org.jeecg.modules.system.entity.SysPermissionDataRule;
import org.jeecg.modules.system.mapper.SysDepartPermissionMapper;
import org.jeecg.modules.system.mapper.SysDepartRoleMapper;
import org.jeecg.modules.system.mapper.SysDepartRolePermissionMapper;
import org.jeecg.modules.system.mapper.SysPermissionDataRuleMapper;
import org.jeecg.modules.system.service.ISysDepartPermissionService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysDepartPermissionServiceImpl
extends ServiceImpl<SysDepartPermissionMapper, SysDepartPermission>
implements ISysDepartPermissionService {
    @Resource
    private SysPermissionDataRuleMapper ruleMapper;
    @Resource
    private SysDepartRoleMapper sysDepartRoleMapper;
    @Resource
    private SysDepartRolePermissionMapper departRolePermissionMapper;

    @Transactional(rollbackFor={Exception.class})
    public void saveDepartPermission(String departId, String permissionIds, String lastPermissionIds) {
        List delete;
        List add = this.getDiff(lastPermissionIds, permissionIds);
        if (add != null && add.size() > 0) {
            ArrayList<SysDepartPermission> list = new ArrayList<SysDepartPermission>();
            for (String p : add) {
                if (!oConvertUtils.isNotEmpty((Object)p)) continue;
                SysDepartPermission rolepms = new SysDepartPermission(departId, p);
                list.add(rolepms);
            }
            this.saveBatch(list);
        }
        if ((delete = this.getDiff(permissionIds, lastPermissionIds)) != null && delete.size() > 0) {
            for (String permissionId : delete) {
                this.remove((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysDepartPermission::getDepartId, (Object)departId)).eq(SysDepartPermission::getPermissionId, (Object)permissionId));
                List sysDepartRoleList = this.sysDepartRoleMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysDepartRole::getDepartId, (Object)departId));
                List roleIds = sysDepartRoleList.stream().map(SysDepartRole::getId).collect(Collectors.toList());
                if (roleIds == null || roleIds.size() <= 0) continue;
                this.departRolePermissionMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysDepartRolePermission::getPermissionId, (Object)permissionId));
            }
        }
    }

    public List<SysPermissionDataRule> getPermRuleListByDeptIdAndPermId(String departId, String permissionId) {
        SysDepartPermission departPermission = (SysDepartPermission)this.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysDepartPermission::getDepartId, (Object)departId)).eq(SysDepartPermission::getPermissionId, (Object)permissionId));
        if (departPermission != null) {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.in(SysPermissionDataRule::getId, Arrays.asList(departPermission.getDataRuleIds().split(",")));
            query.orderByDesc(SysPermissionDataRule::getCreateTime);
            List permRuleList = this.ruleMapper.selectList((Wrapper)query);
            return permRuleList;
        }
        return null;
    }

    private List<String> getDiff(String main, String diff) {
        if (oConvertUtils.isEmpty((Object)diff)) {
            return null;
        }
        if (oConvertUtils.isEmpty((Object)main)) {
            return Arrays.asList(diff.split(","));
        }
        String[] mainArr = main.split(",");
        String[] diffArr = diff.split(",");
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String string : mainArr) {
            map.put(string, 1);
        }
        ArrayList<String> res = new ArrayList<String>();
        for (String key : diffArr) {
            if (!oConvertUtils.isNotEmpty((Object)key) || map.containsKey(key)) continue;
            res.add(key);
        }
        return res;
    }
}

