/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.vo.ComboModel;
import org.jeecg.common.system.vo.DictModel;
import org.jeecg.common.system.vo.DynamicDataSourceModel;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.system.vo.SysCategoryModel;
import org.jeecg.common.system.vo.SysDepartModel;
import org.jeecg.common.util.IPUtils;
import org.jeecg.common.util.MinioUtil;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.SysAnnmentTypeEnum;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.common.util.oss.OssBootUtil;
import org.jeecg.modules.message.entity.SysMessageTemplate;
import org.jeecg.modules.message.service.ISysMessageTemplateService;
import org.jeecg.modules.message.websocket.WebSocket;
import org.jeecg.modules.system.entity.SysAnnouncement;
import org.jeecg.modules.system.entity.SysAnnouncementSend;
import org.jeecg.modules.system.entity.SysDataSource;
import org.jeecg.modules.system.entity.SysDepart;
import org.jeecg.modules.system.entity.SysDict;
import org.jeecg.modules.system.entity.SysLog;
import org.jeecg.modules.system.entity.SysRole;
import org.jeecg.modules.system.entity.SysUser;
import org.jeecg.modules.system.mapper.SysAnnouncementMapper;
import org.jeecg.modules.system.mapper.SysAnnouncementSendMapper;
import org.jeecg.modules.system.mapper.SysCategoryMapper;
import org.jeecg.modules.system.mapper.SysDepartMapper;
import org.jeecg.modules.system.mapper.SysLogMapper;
import org.jeecg.modules.system.mapper.SysRoleMapper;
import org.jeecg.modules.system.mapper.SysUserMapper;
import org.jeecg.modules.system.mapper.SysUserRoleMapper;
import org.jeecg.modules.system.service.ISysDataSourceService;
import org.jeecg.modules.system.service.ISysDepartService;
import org.jeecg.modules.system.service.ISysDictService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SysBaseApiImpl
implements ISysBaseAPI {
    private static final Logger log = LoggerFactory.getLogger(SysBaseApiImpl.class);
    private static String DB_TYPE = "";
    @Autowired
    private ISysMessageTemplateService sysMessageTemplateService;
    @Resource
    private SysLogMapper sysLogMapper;
    @Autowired
    private SysUserMapper userMapper;
    @Autowired
    private SysUserRoleMapper sysUserRoleMapper;
    @Autowired
    private ISysDepartService sysDepartService;
    @Autowired
    private ISysDictService sysDictService;
    @Resource
    private SysAnnouncementMapper sysAnnouncementMapper;
    @Resource
    private SysAnnouncementSendMapper sysAnnouncementSendMapper;
    @Resource
    private WebSocket webSocket;
    @Resource
    private SysRoleMapper roleMapper;
    @Resource
    private SysDepartMapper departMapper;
    @Resource
    private SysCategoryMapper categoryMapper;
    @Autowired
    private ISysDataSourceService dataSourceService;

    public void addLog(String LogContent, Integer logType, Integer operatetype) {
        SysLog sysLog = new SysLog();
        sysLog.setLogContent(LogContent);
        sysLog.setLogType(logType);
        sysLog.setOperateType(operatetype);
        try {
            HttpServletRequest request = SpringContextUtils.getHttpServletRequest();
            sysLog.setIp(IPUtils.getIpAddr((HttpServletRequest)request));
        }
        catch (Exception e) {
            sysLog.setIp("127.0.0.1");
        }
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        if (sysUser != null) {
            sysLog.setUserid(sysUser.getUsername());
            sysLog.setUsername(sysUser.getRealname());
        }
        sysLog.setCreateTime(new Date());
        this.sysLogMapper.insert((Object)sysLog);
    }

    @Cacheable(cacheNames={"sys:cache:user"}, key="#username")
    public LoginUser getUserByName(String username) {
        if (oConvertUtils.isEmpty((Object)username)) {
            return null;
        }
        LoginUser loginUser = new LoginUser();
        SysUser sysUser = this.userMapper.getUserByName(username);
        if (sysUser == null) {
            return null;
        }
        BeanUtils.copyProperties((Object)sysUser, (Object)loginUser);
        return loginUser;
    }

    public LoginUser getUserById(String id) {
        if (oConvertUtils.isEmpty((Object)id)) {
            return null;
        }
        LoginUser loginUser = new LoginUser();
        SysUser sysUser = (SysUser)this.userMapper.selectById((Serializable)((Object)id));
        if (sysUser == null) {
            return null;
        }
        BeanUtils.copyProperties((Object)sysUser, (Object)loginUser);
        return loginUser;
    }

    public List<String> getRolesByUsername(String username) {
        return this.sysUserRoleMapper.getRoleByUserName(username);
    }

    public List<String> getDepartIdsByUsername(String username) {
        List list = this.sysDepartService.queryDepartsByUsername(username);
        ArrayList<String> result = new ArrayList<String>(list.size());
        for (SysDepart depart : list) {
            result.add(depart.getId());
        }
        return result;
    }

    public List<String> getDepartNamesByUsername(String username) {
        List list = this.sysDepartService.queryDepartsByUsername(username);
        ArrayList<String> result = new ArrayList<String>(list.size());
        for (SysDepart depart : list) {
            result.add(depart.getDepartName());
        }
        return result;
    }

    public String getDatabaseType() throws SQLException {
        if (oConvertUtils.isNotEmpty((Object)DB_TYPE)) {
            return DB_TYPE;
        }
        DataSource dataSource = (DataSource)SpringContextUtils.getApplicationContext().getBean(DataSource.class);
        return this.getDatabaseTypeByDataSource(dataSource);
    }

    @Cacheable(value={"sys:cache:dict"}, key="#code")
    public List<DictModel> queryDictItemsByCode(String code) {
        return this.sysDictService.queryDictItemsByCode(code);
    }

    public List<DictModel> queryTableDictItemsByCode(String table, String text, String code) {
        return this.sysDictService.queryTableDictItemsByCode(table, text, code);
    }

    public List<DictModel> queryAllDepartBackDictModel() {
        return this.sysDictService.queryAllDepartBackDictModel();
    }

    public List<JSONObject> queryAllDepart(Wrapper wrapper) {
        return JSON.parseArray((String)JSON.toJSONString((Object)this.sysDepartService.list(wrapper))).toJavaList(JSONObject.class);
    }

    public void sendSysAnnouncement(String fromUser, String toUser, String title, String msgContent) {
        this.sendSysAnnouncement(fromUser, toUser, title, msgContent, "2");
    }

    public void sendSysAnnouncement(String fromUser, String toUser, String title, String msgContent, String setMsgCategory) {
        SysAnnouncement announcement = new SysAnnouncement();
        announcement.setTitile(title);
        announcement.setMsgContent(msgContent);
        announcement.setSender(fromUser);
        announcement.setPriority("M");
        announcement.setMsgType("USER");
        announcement.setSendStatus("1");
        announcement.setSendTime(new Date());
        announcement.setMsgCategory(setMsgCategory);
        announcement.setDelFlag(String.valueOf(CommonConstant.DEL_FLAG_0));
        this.sysAnnouncementMapper.insert((Object)announcement);
        String userId = toUser;
        String[] userIds = userId.split(",");
        String anntId = announcement.getId();
        for (int i = 0; i < userIds.length; ++i) {
            SysUser sysUser;
            if (!oConvertUtils.isNotEmpty((Object)userIds[i]) || (sysUser = this.userMapper.getUserByName(userIds[i])) == null) continue;
            SysAnnouncementSend announcementSend = new SysAnnouncementSend();
            announcementSend.setAnntId(anntId);
            announcementSend.setUserId(sysUser.getId());
            announcementSend.setReadFlag("0");
            this.sysAnnouncementSendMapper.insert((Object)announcementSend);
            JSONObject obj = new JSONObject();
            obj.put("cmd", (Object)"user");
            obj.put("userId", (Object)sysUser.getId());
            obj.put("msgId", (Object)announcement.getId());
            obj.put("msgTxt", (Object)announcement.getTitile());
            this.webSocket.sendOneMessage(sysUser.getId(), obj.toJSONString());
        }
    }

    public void sendSysAnnouncement(String fromUser, String toUser, String title, String msgContent, String setMsgCategory, String busType, String busId) {
        SysAnnouncement announcement = new SysAnnouncement();
        announcement.setTitile(title);
        announcement.setMsgContent(msgContent);
        announcement.setSender(fromUser);
        announcement.setPriority("M");
        announcement.setMsgType("USER");
        announcement.setSendStatus("1");
        announcement.setSendTime(new Date());
        announcement.setMsgCategory(setMsgCategory);
        announcement.setDelFlag(String.valueOf(CommonConstant.DEL_FLAG_0));
        announcement.setBusId(busId);
        announcement.setBusType(busType);
        announcement.setOpenType(SysAnnmentTypeEnum.getByType((String)busType).getOpenType());
        announcement.setOpenPage(SysAnnmentTypeEnum.getByType((String)busType).getOpenPage());
        this.sysAnnouncementMapper.insert((Object)announcement);
        String userId = toUser;
        String[] userIds = userId.split(",");
        String anntId = announcement.getId();
        for (int i = 0; i < userIds.length; ++i) {
            SysUser sysUser;
            if (!oConvertUtils.isNotEmpty((Object)userIds[i]) || (sysUser = this.userMapper.getUserByName(userIds[i])) == null) continue;
            SysAnnouncementSend announcementSend = new SysAnnouncementSend();
            announcementSend.setAnntId(anntId);
            announcementSend.setUserId(sysUser.getId());
            announcementSend.setReadFlag("0");
            this.sysAnnouncementSendMapper.insert((Object)announcementSend);
            JSONObject obj = new JSONObject();
            obj.put("cmd", (Object)"user");
            obj.put("userId", (Object)sysUser.getId());
            obj.put("msgId", (Object)announcement.getId());
            obj.put("msgTxt", (Object)announcement.getTitile());
            this.webSocket.sendOneMessage(sysUser.getId(), obj.toJSONString());
        }
    }

    public void updateSysAnnounReadFlag(String busType, String busId) {
        SysAnnouncement announcement = (SysAnnouncement)this.sysAnnouncementMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"bus_type", (Object)busType)).eq((Object)"bus_id", (Object)busId));
        if (announcement != null) {
            LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            String userId = sysUser.getId();
            LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
            updateWrapper.set(SysAnnouncementSend::getReadFlag, (Object)"1");
            updateWrapper.set(SysAnnouncementSend::getReadTime, (Object)new Date());
            updateWrapper.last("where annt_id ='" + announcement.getId() + "' and user_id ='" + userId + "'");
            SysAnnouncementSend announcementSend = new SysAnnouncementSend();
            this.sysAnnouncementSendMapper.update((Object)announcementSend, (Wrapper)updateWrapper);
        }
    }

    public String parseTemplateByCode(String templateCode, Map<String, String> map) {
        List sysSmsTemplates = this.sysMessageTemplateService.selectByCode(templateCode);
        if (sysSmsTemplates == null || sysSmsTemplates.size() == 0) {
            throw new JeecgBootException("\u6d88\u606f\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u6a21\u677f\u7f16\u7801\uff1a" + templateCode);
        }
        SysMessageTemplate sysSmsTemplate = (SysMessageTemplate)sysSmsTemplates.get(0);
        String content = sysSmsTemplate.getTemplateContent();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String str = "${" + entry.getKey() + "}";
                content = content.replace(str, entry.getValue());
            }
        }
        return content;
    }

    public void sendSysAnnouncement(String fromUser, String toUser, String title, Map<String, String> map, String templateCode) {
        List sysSmsTemplates = this.sysMessageTemplateService.selectByCode(templateCode);
        if (sysSmsTemplates == null || sysSmsTemplates.size() == 0) {
            throw new JeecgBootException("\u6d88\u606f\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u6a21\u677f\u7f16\u7801\uff1a" + templateCode);
        }
        SysMessageTemplate sysSmsTemplate = (SysMessageTemplate)sysSmsTemplates.get(0);
        title = title == null ? sysSmsTemplate.getTemplateName() : title;
        String content = sysSmsTemplate.getTemplateContent();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String str = "${" + entry.getKey() + "}";
                title = title.replace(str, entry.getValue());
                content = content.replace(str, entry.getValue());
            }
        }
        SysAnnouncement announcement = new SysAnnouncement();
        announcement.setTitile(title);
        announcement.setMsgContent(content);
        announcement.setSender(fromUser);
        announcement.setPriority("M");
        announcement.setMsgType("USER");
        announcement.setSendStatus("1");
        announcement.setSendTime(new Date());
        announcement.setMsgCategory("2");
        announcement.setDelFlag(String.valueOf(CommonConstant.DEL_FLAG_0));
        this.sysAnnouncementMapper.insert((Object)announcement);
        String userId = toUser;
        String[] userIds = userId.split(",");
        String anntId = announcement.getId();
        for (int i = 0; i < userIds.length; ++i) {
            SysUser sysUser;
            if (!oConvertUtils.isNotEmpty((Object)userIds[i]) || (sysUser = this.userMapper.getUserByName(userIds[i])) == null) continue;
            SysAnnouncementSend announcementSend = new SysAnnouncementSend();
            announcementSend.setAnntId(anntId);
            announcementSend.setUserId(sysUser.getId());
            announcementSend.setReadFlag("0");
            this.sysAnnouncementSendMapper.insert((Object)announcementSend);
            JSONObject obj = new JSONObject();
            obj.put("cmd", (Object)"user");
            obj.put("userId", (Object)sysUser.getId());
            obj.put("msgId", (Object)announcement.getId());
            obj.put("msgTxt", (Object)announcement.getTitile());
            this.webSocket.sendOneMessage(sysUser.getId(), obj.toJSONString());
        }
    }

    public void sendSysAnnouncement(String fromUser, String toUser, String title, Map<String, String> map, String templateCode, String busType, String busId) {
        List sysSmsTemplates = this.sysMessageTemplateService.selectByCode(templateCode);
        if (sysSmsTemplates == null || sysSmsTemplates.size() == 0) {
            throw new JeecgBootException("\u6d88\u606f\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u6a21\u677f\u7f16\u7801\uff1a" + templateCode);
        }
        SysMessageTemplate sysSmsTemplate = (SysMessageTemplate)sysSmsTemplates.get(0);
        title = title == null ? sysSmsTemplate.getTemplateName() : title;
        String content = sysSmsTemplate.getTemplateContent();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String str = "${" + entry.getKey() + "}";
                title = title.replace(str, entry.getValue());
                content = content.replace(str, entry.getValue());
            }
        }
        SysAnnouncement announcement = new SysAnnouncement();
        announcement.setTitile(title);
        announcement.setMsgContent(content);
        announcement.setSender(fromUser);
        announcement.setPriority("M");
        announcement.setMsgType("USER");
        announcement.setSendStatus("1");
        announcement.setSendTime(new Date());
        announcement.setMsgCategory("2");
        announcement.setDelFlag(String.valueOf(CommonConstant.DEL_FLAG_0));
        announcement.setBusId(busId);
        announcement.setBusType(busType);
        announcement.setOpenType(SysAnnmentTypeEnum.getByType((String)busType).getOpenType());
        announcement.setOpenPage(SysAnnmentTypeEnum.getByType((String)busType).getOpenPage());
        this.sysAnnouncementMapper.insert((Object)announcement);
        String userId = toUser;
        String[] userIds = userId.split(",");
        String anntId = announcement.getId();
        for (int i = 0; i < userIds.length; ++i) {
            SysUser sysUser;
            if (!oConvertUtils.isNotEmpty((Object)userIds[i]) || (sysUser = this.userMapper.getUserByName(userIds[i])) == null) continue;
            SysAnnouncementSend announcementSend = new SysAnnouncementSend();
            announcementSend.setAnntId(anntId);
            announcementSend.setUserId(sysUser.getId());
            announcementSend.setReadFlag("0");
            this.sysAnnouncementSendMapper.insert((Object)announcementSend);
            JSONObject obj = new JSONObject();
            obj.put("cmd", (Object)"user");
            obj.put("userId", (Object)sysUser.getId());
            obj.put("msgId", (Object)announcement.getId());
            obj.put("msgTxt", (Object)announcement.getTitile());
            this.webSocket.sendOneMessage(sysUser.getId(), obj.toJSONString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDatabaseTypeByDataSource(DataSource dataSource) throws SQLException {
        block10: {
            if ("".equals(DB_TYPE)) {
                try (Connection connection = dataSource.getConnection();){
                    DatabaseMetaData md = connection.getMetaData();
                    String dbType = md.getDatabaseProductName().toLowerCase();
                    if (dbType.indexOf("mysql") >= 0) {
                        DB_TYPE = "MYSQL";
                        break block10;
                    }
                    if (dbType.indexOf("oracle") >= 0) {
                        DB_TYPE = "ORACLE";
                        break block10;
                    }
                    if (dbType.indexOf("sqlserver") >= 0 || dbType.indexOf("sql server") >= 0) {
                        DB_TYPE = "SQLSERVER";
                        break block10;
                    }
                    if (dbType.indexOf("postgresql") >= 0) {
                        DB_TYPE = "POSTGRESQL";
                        break block10;
                    }
                    throw new JeecgBootException("\u6570\u636e\u5e93\u7c7b\u578b:[" + dbType + "]\u4e0d\u8bc6\u522b!");
                }
            }
        }
        return DB_TYPE;
    }

    public List<DictModel> queryAllDict() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByAsc((Object)"create_time");
        List dicts = this.sysDictService.list((Wrapper)queryWrapper);
        ArrayList<DictModel> list = new ArrayList<DictModel>();
        for (SysDict dict : dicts) {
            list.add(new DictModel(dict.getDictCode(), dict.getDictName()));
        }
        return list;
    }

    public List<SysCategoryModel> queryAllDSysCategory() {
        List ls = this.categoryMapper.selectList(null);
        List res = oConvertUtils.entityListToModelList((List)ls, SysCategoryModel.class);
        return res;
    }

    public List<DictModel> queryFilterTableDictInfo(String table, String text, String code, String filterSql) {
        return this.sysDictService.queryTableDictItemsByCodeAndFilter(table, text, code, filterSql);
    }

    public List<String> queryTableDictByKeys(String table, String text, String code, String[] keyArray) {
        return this.sysDictService.queryTableDictByKeys(table, text, code, keyArray);
    }

    public List<ComboModel> queryAllUser() {
        ArrayList<ComboModel> list = new ArrayList<ComboModel>();
        List userList = this.userMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"status", (Object)1)).eq((Object)"del_flag", (Object)0));
        for (SysUser user : userList) {
            ComboModel model = new ComboModel();
            model.setTitle(user.getRealname());
            model.setId(user.getId());
            model.setUsername(user.getUsername());
            list.add(model);
        }
        return list;
    }

    public JSONObject queryAllUser(String[] userIds, int pageNo, int pageSize) {
        JSONObject json = new JSONObject();
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"status", (Object)1)).eq((Object)"del_flag", (Object)0);
        ArrayList<ComboModel> list = new ArrayList<ComboModel>();
        Page page = new Page((long)pageNo, (long)pageSize);
        IPage pageList = this.userMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        for (SysUser user : pageList.getRecords()) {
            ComboModel model = new ComboModel();
            model.setUsername(user.getUsername());
            model.setTitle(user.getRealname());
            model.setId(user.getId());
            model.setEmail(user.getEmail());
            if (oConvertUtils.isNotEmpty((Object)userIds)) {
                for (int i = 0; i < userIds.length; ++i) {
                    if (!userIds[i].equals(user.getId())) continue;
                    model.setChecked(true);
                }
            }
            list.add(model);
        }
        json.put("list", list);
        json.put("total", (Object)pageList.getTotal());
        return json;
    }

    public List<JSONObject> queryAllUser(Wrapper wrapper) {
        return JSON.parseArray((String)JSON.toJSONString((Object)this.userMapper.selectList(wrapper))).toJavaList(JSONObject.class);
    }

    public List<ComboModel> queryAllRole() {
        ArrayList<ComboModel> list = new ArrayList<ComboModel>();
        List roleList = this.roleMapper.selectList((Wrapper)new QueryWrapper());
        for (SysRole role : roleList) {
            ComboModel model = new ComboModel();
            model.setTitle(role.getRoleName());
            model.setId(role.getId());
            list.add(model);
        }
        return list;
    }

    public List<ComboModel> queryAllRole(String[] roleIds) {
        ArrayList<ComboModel> list = new ArrayList<ComboModel>();
        List roleList = this.roleMapper.selectList((Wrapper)new QueryWrapper());
        for (SysRole role : roleList) {
            ComboModel model = new ComboModel();
            model.setTitle(role.getRoleName());
            model.setId(role.getId());
            model.setRoleCode(role.getRoleCode());
            if (oConvertUtils.isNotEmpty((Object)roleIds)) {
                for (int i = 0; i < roleIds.length; ++i) {
                    if (!roleIds[i].equals(role.getId())) continue;
                    model.setChecked(true);
                }
            }
            list.add(model);
        }
        return list;
    }

    public List<String> getRoleIdsByUsername(String username) {
        return this.sysUserRoleMapper.getRoleIdByUserName(username);
    }

    public String getDepartIdsByOrgCode(String orgCode) {
        return this.departMapper.queryDepartIdByOrgCode(orgCode);
    }

    public DictModel getParentDepartId(String departId) {
        SysDepart depart = this.departMapper.getParentDepartId(departId);
        DictModel model = new DictModel(depart.getId(), depart.getParentId());
        return model;
    }

    public List<SysDepartModel> getAllSysDepart() {
        ArrayList<SysDepartModel> departModelList = new ArrayList<SysDepartModel>();
        List departList = this.departMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"del_flag", (Object)"0"));
        for (SysDepart depart : departList) {
            SysDepartModel model = new SysDepartModel();
            BeanUtils.copyProperties((Object)depart, (Object)model);
            departModelList.add(model);
        }
        return departModelList;
    }

    public DynamicDataSourceModel getDynamicDbSourceById(String dbSourceId) {
        SysDataSource dbSource = (SysDataSource)this.dataSourceService.getById((Serializable)((Object)dbSourceId));
        return new DynamicDataSourceModel((Object)dbSource);
    }

    public DynamicDataSourceModel getDynamicDbSourceByCode(String dbSourceCode) {
        SysDataSource dbSource = (SysDataSource)this.dataSourceService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysDataSource::getCode, (Object)dbSourceCode));
        return new DynamicDataSourceModel((Object)dbSource);
    }

    public List<String> getDeptHeadByDepId(String deptId) {
        List userList = this.userMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().like((Object)"depart_ids", (Object)deptId)).eq((Object)"status", (Object)1)).eq((Object)"del_flag", (Object)0));
        ArrayList<String> list = new ArrayList<String>();
        for (SysUser user : userList) {
            list.add(user.getUsername());
        }
        return list;
    }

    public String upload(MultipartFile file, String bizPath, String uploadType) {
        String url = "";
        url = "minio".equals(uploadType) ? MinioUtil.upload((MultipartFile)file, (String)bizPath) : OssBootUtil.upload((MultipartFile)file, (String)bizPath);
        return url;
    }

    public String upload(MultipartFile file, String bizPath, String uploadType, String customBucket) {
        String url = "";
        url = "minio".equals(uploadType) ? MinioUtil.upload((MultipartFile)file, (String)bizPath, (String)customBucket) : OssBootUtil.upload((MultipartFile)file, (String)bizPath, (String)customBucket);
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void viewAndDownload(String filePath, String uploadpath, String uploadType, HttpServletResponse response) {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            if (filePath.startsWith("http")) {
                String objectName;
                String bucketName;
                String fileName = filePath.substring(filePath.lastIndexOf("/") + 1);
                if ("minio".equals(uploadType)) {
                    bucketName = filePath.replace(MinioUtil.getMinioUrl(), "").split("/")[0];
                    inputStream = MinioUtil.getMinioFile((String)bucketName, (String)(objectName = filePath.replace(MinioUtil.getMinioUrl() + bucketName, "")));
                    if (inputStream == null) {
                        bucketName = "eoafile";
                        objectName = filePath.replace(OssBootUtil.getStaticDomain() + "/", "");
                        inputStream = OssBootUtil.getOssFile((String)objectName, (String)bucketName);
                    }
                } else {
                    bucketName = "eoafile";
                    objectName = filePath.replace(OssBootUtil.getStaticDomain() + "/", "");
                    inputStream = OssBootUtil.getOssFile((String)objectName, (String)bucketName);
                    if (inputStream == null) {
                        bucketName = filePath.replace(MinioUtil.getMinioUrl(), "").split("/")[0];
                        objectName = filePath.replace(MinioUtil.getMinioUrl() + bucketName, "");
                        inputStream = MinioUtil.getMinioFile((String)bucketName, (String)objectName);
                    }
                }
                response.addHeader("Content-Disposition", "attachment;fileName=" + new String(fileName.getBytes("UTF-8"), "iso-8859-1"));
            } else {
                if ((filePath = filePath.replace("..", "")).endsWith(",")) {
                    filePath = filePath.substring(0, filePath.length() - 1);
                }
                String fullPath = uploadpath + File.separator + filePath;
                String downloadFilePath = uploadpath + File.separator + fullPath;
                File file = new File(downloadFilePath);
                inputStream = new BufferedInputStream(new FileInputStream(fullPath));
                response.addHeader("Content-Disposition", "attachment;fileName=" + new String(file.getName().getBytes("UTF-8"), "iso-8859-1"));
            }
            response.setContentType("application/force-download");
            outputStream = response.getOutputStream();
            if (inputStream != null) {
                int len;
                byte[] buf = new byte[1024];
                while ((len = inputStream.read(buf)) > 0) {
                    outputStream.write(buf, 0, len);
                }
                response.flushBuffer();
            }
        }
        catch (IOException e) {
            response.setStatus(404);
            log.error("\u9884\u89c8\u6587\u4ef6\u5931\u8d25" + e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void sendWebSocketMsg(String[] userIds, String cmd) {
        JSONObject obj = new JSONObject();
        obj.put("cmd", (Object)cmd);
        this.webSocket.sendMoreMessage(userIds, obj.toJSONString());
    }

    public List<LoginUser> queryAllUserByIds(String[] userIds) {
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"status", (Object)1)).eq((Object)"del_flag", (Object)0);
        queryWrapper.in((Object)"id", (Object[])userIds);
        ArrayList<LoginUser> loginUsers = new ArrayList<LoginUser>();
        List sysUsers = this.userMapper.selectList((Wrapper)queryWrapper);
        for (SysUser user : sysUsers) {
            LoginUser loginUser = new LoginUser();
            BeanUtils.copyProperties((Object)user, (Object)loginUser);
            loginUsers.add(loginUser);
        }
        return loginUsers;
    }

    public void meetingSignWebsocket(String userId) {
        JSONObject obj = new JSONObject();
        obj.put("cmd", (Object)"sign");
        obj.put("userId", (Object)userId);
        this.webSocket.sendAllMessage(obj.toJSONString());
    }

    public List<LoginUser> queryUserByNames(String[] userNames) {
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"status", (Object)1)).eq((Object)"del_flag", (Object)0);
        queryWrapper.in((Object)"username", (Object[])userNames);
        ArrayList<LoginUser> loginUsers = new ArrayList<LoginUser>();
        List sysUsers = this.userMapper.selectList((Wrapper)queryWrapper);
        for (SysUser user : sysUsers) {
            LoginUser loginUser = new LoginUser();
            BeanUtils.copyProperties((Object)user, (Object)loginUser);
            loginUsers.add(loginUser);
        }
        return loginUsers;
    }
}

