/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.ImportExcelUtil;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysDepart;
import org.jeecg.modules.system.model.DepartIdModel;
import org.jeecg.modules.system.model.SysDepartTreeModel;
import org.jeecg.modules.system.service.ISysDepartService;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@RestController
@RequestMapping(value={"/sys/sysDepart"})
public class SysDepartController {
    private static final Logger log = LoggerFactory.getLogger(SysDepartController.class);
    @Autowired
    private ISysDepartService sysDepartService;
    @Autowired
    public RedisTemplate<String, Object> redisTemplate;

    @RequestMapping(value={"/queryMyDeptTreeList"}, method={RequestMethod.GET})
    public Result<List<SysDepartTreeModel>> queryMyDeptTreeList() {
        Result result = new Result();
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        try {
            if (oConvertUtils.isNotEmpty((Object)user.getUserIdentity()) && user.getUserIdentity().equals(CommonConstant.USER_IDENTITY_2)) {
                List list = this.sysDepartService.queryMyDeptTreeList(user.getDepartIds());
                result.setResult((Object)list);
                result.setMessage(CommonConstant.USER_IDENTITY_2.toString());
                result.setSuccess(true);
            } else {
                result.setMessage(CommonConstant.USER_IDENTITY_1.toString());
                result.setSuccess(true);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/queryTreeList"}, method={RequestMethod.GET})
    public Result<List<SysDepartTreeModel>> queryTreeList() {
        Result result = new Result();
        try {
            List list = this.sysDepartService.queryTreeList();
            result.setResult((Object)list);
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    @CacheEvict(value={"sys:cache:depart:alldata", "sys:cache:depart:allids"}, allEntries=true)
    public Result<SysDepart> add(@RequestBody SysDepart sysDepart, HttpServletRequest request) {
        Result result = new Result();
        String username = JwtUtil.getUserNameByToken((HttpServletRequest)request);
        try {
            sysDepart.setCreateBy(username);
            this.sysDepartService.saveDepartData(sysDepart, username);
            result.success("\u6dfb\u52a0\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.PUT})
    @CacheEvict(value={"sys:cache:depart:alldata", "sys:cache:depart:allids"}, allEntries=true)
    public Result<SysDepart> edit(@RequestBody SysDepart sysDepart, HttpServletRequest request) {
        String username = JwtUtil.getUserNameByToken((HttpServletRequest)request);
        sysDepart.setUpdateBy(username);
        Result result = new Result();
        SysDepart sysDepartEntity = (SysDepart)this.sysDepartService.getById((Serializable)((Object)sysDepart.getId()));
        if (sysDepartEntity == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            boolean ok = this.sysDepartService.updateDepartDataById(sysDepart, username);
            if (ok) {
                result.success("\u4fee\u6539\u6210\u529f!");
            }
        }
        return result;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.DELETE})
    @CacheEvict(value={"sys:cache:depart:alldata", "sys:cache:depart:allids"}, allEntries=true)
    public Result<SysDepart> delete(@RequestParam(name="id", required=true) String id) {
        Result result = new Result();
        SysDepart sysDepart = (SysDepart)this.sysDepartService.getById((Serializable)((Object)id));
        if (sysDepart == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            boolean ok = this.sysDepartService.delete(id);
            if (ok) {
                result.success("\u5220\u9664\u6210\u529f!");
            }
        }
        return result;
    }

    @RequestMapping(value={"/deleteBatch"}, method={RequestMethod.DELETE})
    @CacheEvict(value={"sys:cache:depart:alldata", "sys:cache:depart:allids"}, allEntries=true)
    public Result<SysDepart> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        Result result = new Result();
        if (ids == null || "".equals(ids.trim())) {
            result.error500("\u53c2\u6570\u4e0d\u8bc6\u522b\uff01");
        } else {
            this.sysDepartService.deleteBatchWithChildren(Arrays.asList(ids.split(",")));
            result.success("\u5220\u9664\u6210\u529f!");
        }
        return result;
    }

    @RequestMapping(value={"/queryIdTree"}, method={RequestMethod.GET})
    public Result<List<DepartIdModel>> queryIdTree() {
        Result result = new Result();
        try {
            List list = this.sysDepartService.queryDepartIdTreeList();
            result.setResult((Object)list);
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/searchBy"}, method={RequestMethod.GET})
    public Result<List<SysDepartTreeModel>> searchBy(@RequestParam(name="keyWord", required=true) String keyWord, @RequestParam(name="myDeptSearch", required=false) String myDeptSearch) {
        List treeList;
        Result result = new Result();
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String departIds = null;
        if (oConvertUtils.isNotEmpty((Object)user.getUserIdentity()) && user.getUserIdentity().equals(CommonConstant.USER_IDENTITY_2)) {
            departIds = user.getDepartIds();
        }
        if ((treeList = this.sysDepartService.searhBy(keyWord, myDeptSearch, departIds)) == null || treeList.size() == 0) {
            result.setSuccess(false);
            result.setMessage("\u672a\u67e5\u8be2\u5339\u914d\u6570\u636e\uff01");
            return result;
        }
        result.setResult((Object)treeList);
        return result;
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(SysDepart sysDepart, HttpServletRequest request) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysDepart, (Map)request.getParameterMap());
        ModelAndView mv = new ModelAndView((View)new JeecgEntityExcelView());
        List pageList = this.sysDepartService.list((Wrapper)queryWrapper);
        Collections.sort(pageList, new /* Unavailable Anonymous Inner Class!! */);
        mv.addObject("fileName", (Object)"\u90e8\u95e8\u5217\u8868");
        mv.addObject("entity", SysDepart.class);
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        mv.addObject("params", (Object)new ExportParams("\u90e8\u95e8\u5217\u8868\u6570\u636e", "\u5bfc\u51fa\u4eba:" + user.getRealname(), "\u5bfc\u51fa\u4fe1\u606f"));
        mv.addObject("data", (Object)pageList);
        return mv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    @CacheEvict(value={"sys:cache:depart:alldata", "sys:cache:depart:allids"}, allEntries=true)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        ArrayList errorMessageList = new ArrayList();
        List listSysDeparts = null;
        Map fileMap = multipartRequest.getFileMap();
        Iterator iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entity = iterator.next();
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                int codeLength = 3;
                listSysDeparts = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), SysDepart.class, (ImportParams)params);
                Collections.sort(listSysDeparts, new /* Unavailable Anonymous Inner Class!! */);
                int num = 0;
                for (SysDepart sysDepart : listSysDeparts) {
                    block18: {
                        String orgCode = sysDepart.getOrgCode();
                        if (orgCode.length() > codeLength) {
                            String parentCode = orgCode.substring(0, orgCode.length() - codeLength);
                            QueryWrapper queryWrapper = new QueryWrapper();
                            queryWrapper.eq((Object)"org_code", (Object)parentCode);
                            try {
                                SysDepart parentDept = (SysDepart)this.sysDepartService.getOne((Wrapper)queryWrapper);
                                if (!parentDept.equals(null)) {
                                    sysDepart.setParentId(parentDept.getId());
                                    break block18;
                                }
                                sysDepart.setParentId("");
                            }
                            catch (Exception exception) {}
                        } else {
                            sysDepart.setParentId("");
                        }
                    }
                    sysDepart.setDelFlag(CommonConstant.DEL_FLAG_0.toString());
                    ImportExcelUtil.importDateSaveOne((Object)sysDepart, ISysDepartService.class, errorMessageList, (int)num, (String)"uniq_depart_org_code");
                    ++num;
                }
                Set keys3 = this.redisTemplate.keys((Object)"sys:cache:depart:alldata*");
                Set keys4 = this.redisTemplate.keys((Object)"sys:cache:depart:allids*");
                this.redisTemplate.delete((Collection)keys3);
                this.redisTemplate.delete((Collection)keys4);
                Result result = ImportExcelUtil.imporReturnRes((int)errorMessageList.size(), (int)(listSysDeparts.size() - errorMessageList.size()), errorMessageList);
                return result;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Result result = Result.error((String)("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:" + e.getMessage()));
                return result;
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return Result.error((String)"\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
    }

    @GetMapping(value={"listAll"})
    public Result<List<SysDepart>> listAll(@RequestParam(name="id", required=false) String id) {
        Result result = new Result();
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.orderByAsc(SysDepart::getOrgCode);
        if (oConvertUtils.isNotEmpty((Object)id)) {
            Object[] arr = id.split(",");
            query.in(SysDepart::getId, arr);
        }
        List ls = this.sysDepartService.list((Wrapper)query);
        result.setSuccess(true);
        result.setResult((Object)ls);
        return result;
    }
}

