/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.quartz.job;

import java.io.File;
import org.jeecg.common.util.DateUtils;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class CopyDbJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(CopyDbJob.class);
    @Value(value="${jeecg.path.upload}")
    private String uploadpath;
    @Value(value="${spring.datasource.dynamic.datasource.master.username}")
    private String username;
    @Value(value="${spring.datasource.dynamic.datasource.master.password}")
    private String password;
    @Value(value="${spring.datasource.dynamic.datasource.master.ip}")
    private String host;
    @Value(value="${spring.datasource.dynamic.datasource.master.dbname}")
    private String exportDatabaseName;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        log.info(String.format(" \u6570\u636e\u5e93\u5907\u4efd \u666e\u901a\u5b9a\u65f6\u4efb\u52a1,\u5f00\u59cb!  \u65f6\u95f4:" + DateUtils.getTimestamp(), new Object[0]));
        Runtime runtime = Runtime.getRuntime();
        String command = this.getExportCommand();
        try {
            Process process = runtime.exec(command);
        }
        catch (Exception e) {
            log.error(" \u6570\u636e\u5e93\u5907\u4efd \u666e\u901a\u5b9a\u65f6\u4efb\u52a1,\u9519\u8bef!", (Throwable)e);
        }
        log.info(String.format(" \u6570\u636e\u5e93\u5907\u4efd \u666e\u901a\u5b9a\u65f6\u4efb\u52a1,\u7ed3\u675f!  \u65f6\u95f4:" + DateUtils.getTimestamp(), new Object[0]));
    }

    private String getExportCommand() {
        StringBuffer command = new StringBuffer();
        String port = "3306";
        String date = DateUtils.getDate((String)"yyyy-MM-dd--hhmmss");
        String exportPath = this.uploadpath + "/dbSql";
        String path = exportPath + "/" + this.exportDatabaseName + date + ".sql";
        File filePath = new File(exportPath);
        if (!filePath.exists()) {
            filePath.mkdirs();
        }
        File file = new File(exportPath);
        if (!filePath.exists()) {
            file.mkdir();
        }
        String MysqlPath = "";
        command.append(MysqlPath).append("mysqldump -u").append(this.username).append(" -p").append(this.password).append(" -h").append(this.host).append(" -P").append(port).append(" ").append(this.exportDatabaseName).append(" -r ").append(path);
        log.info(command.toString());
        return command.toString();
    }
}

