/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.ngalain.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.ngalain.mapper.NgAlainMapper;
import org.jeecg.modules.ngalain.service.NgAlainService;
import org.jeecg.modules.system.entity.SysPermission;
import org.jeecg.modules.system.service.ISysPermissionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="ngAlainService")
@Transactional
public class NgAlainServiceImpl
implements NgAlainService {
    @Autowired
    private ISysPermissionService sysPermissionService;
    @Autowired
    private NgAlainMapper mapper;

    public JSONArray getMenu(String id) throws Exception {
        return this.getJeecgMenu(id);
    }

    public JSONArray getJeecgMenu(String id) throws Exception {
        List metaList = this.sysPermissionService.queryByUser(id);
        JSONArray jsonArray = new JSONArray();
        this.getPermissionJsonArray(jsonArray, metaList, null);
        JSONArray menulist = this.parseNgAlain(jsonArray);
        JSONObject jeecgMenu = new JSONObject();
        jeecgMenu.put("text", (Object)"jeecg\u83dc\u5355");
        jeecgMenu.put("group", (Object)true);
        jeecgMenu.put("children", (Object)menulist);
        JSONArray jeecgMenuList = new JSONArray();
        jeecgMenuList.add((Object)jeecgMenu);
        return jeecgMenuList;
    }

    public List<Map<String, String>> getDictByTable(String table, String key, String value) {
        return this.mapper.getDictByTable(table, key, value);
    }

    private JSONArray parseNgAlain(JSONArray jsonArray) {
        JSONArray menulist = new JSONArray();
        for (Object object : jsonArray) {
            JSONObject jsonObject = (JSONObject)object;
            String path = (String)jsonObject.get((Object)"path");
            JSONObject meta = (JSONObject)jsonObject.get((Object)"meta");
            JSONObject menu = new JSONObject();
            menu.put("text", meta.get((Object)"title"));
            menu.put("reuse", (Object)true);
            if (jsonObject.get((Object)"children") != null) {
                JSONArray child = this.parseNgAlain((JSONArray)jsonObject.get((Object)"children"));
                menu.put("children", (Object)child);
                JSONObject icon = new JSONObject();
                icon.put("type", (Object)"icon");
                icon.put("value", meta.get((Object)"icon"));
                menu.put("icon", (Object)icon);
            } else {
                menu.put("link", (Object)path);
            }
            menulist.add((Object)menu);
        }
        return menulist;
    }

    private void getPermissionJsonArray(JSONArray jsonArray, List<SysPermission> metaList, JSONObject parentJson) {
        for (SysPermission permission : metaList) {
            if (permission.getMenuType() == null) continue;
            String tempPid = permission.getParentId();
            JSONObject json = this.getPermissionJsonObject(permission);
            if (parentJson == null && oConvertUtils.isEmpty((Object)tempPid)) {
                jsonArray.add((Object)json);
                if (permission.isLeaf()) continue;
                this.getPermissionJsonArray(jsonArray, metaList, json);
                continue;
            }
            if (parentJson == null || !oConvertUtils.isNotEmpty((Object)tempPid) || !tempPid.equals(parentJson.getString("id"))) continue;
            if (permission.getMenuType() == 0) {
                JSONObject metaJson = parentJson.getJSONObject("meta");
                if (metaJson.containsKey((Object)"permissionList")) {
                    metaJson.getJSONArray("permissionList").add((Object)json);
                    continue;
                }
                JSONArray permissionList = new JSONArray();
                permissionList.add((Object)json);
                metaJson.put("permissionList", (Object)permissionList);
                continue;
            }
            if (permission.getMenuType() != 1) continue;
            if (parentJson.containsKey((Object)"children")) {
                parentJson.getJSONArray("children").add((Object)json);
            } else {
                JSONArray children = new JSONArray();
                children.add((Object)json);
                parentJson.put("children", (Object)children);
            }
            if (permission.isLeaf()) continue;
            this.getPermissionJsonArray(jsonArray, metaList, json);
        }
    }

    private JSONObject getPermissionJsonObject(SysPermission permission) {
        JSONObject json = new JSONObject();
        if (permission.getMenuType() == 2) {
            json.put("action", (Object)permission.getPerms());
            json.put("describe", (Object)permission.getName());
        } else if (permission.getMenuType() == 0 || permission.getMenuType() == 1) {
            json.put("id", (Object)permission.getId());
            if (permission.getUrl() != null && (permission.getUrl().startsWith("http://") || permission.getUrl().startsWith("https://"))) {
                String url = new String(Base64.getUrlEncoder().encode(permission.getUrl().getBytes()));
                json.put("path", (Object)("/sys/link/" + url.replaceAll("=", "")));
            } else {
                json.put("path", (Object)permission.getUrl());
            }
            json.put("name", (Object)this.urlToRouteName(permission.getUrl()));
            if (permission.isHidden()) {
                json.put("hidden", (Object)true);
            }
            if (permission.isAlwaysShow()) {
                json.put("alwaysShow", (Object)true);
            }
            json.put("component", (Object)permission.getComponent());
            JSONObject meta = new JSONObject();
            meta.put("title", (Object)permission.getName());
            if (oConvertUtils.isEmpty((Object)permission.getParentId())) {
                json.put("redirect", (Object)permission.getRedirect());
                meta.put("icon", (Object)oConvertUtils.getString((String)permission.getIcon(), (String)""));
            } else {
                meta.put("icon", (Object)oConvertUtils.getString((String)permission.getIcon(), (String)""));
            }
            if (permission.getUrl() != null && (permission.getUrl().startsWith("http://") || permission.getUrl().startsWith("https://"))) {
                meta.put("url", (Object)permission.getUrl());
            }
            json.put("meta", (Object)meta);
        }
        return json;
    }

    private String urlToRouteName(String url) {
        if (oConvertUtils.isNotEmpty((Object)url)) {
            if (url.startsWith("/")) {
                url = url.substring(1);
            }
            url = url.replace("/", "-");
            return url;
        }
        return null;
    }
}

