/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.demo.test.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.demo.test.entity.JoaDemo;
import org.jeecg.modules.demo.test.service.IJoaDemoService;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@RestController
@RequestMapping(value={"/test/joaDemo"})
public class JoaDemoController {
    private static final Logger log = LoggerFactory.getLogger(JoaDemoController.class);
    @Autowired
    private IJoaDemoService joaDemoService;

    @GetMapping(value={"/list"})
    public Result<IPage<JoaDemo>> queryPageList(JoaDemo joaDemo, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result result = new Result();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)joaDemo, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.joaDemoService.page((IPage)page, (Wrapper)queryWrapper);
        result.setSuccess(true);
        result.setResult((Object)pageList);
        return result;
    }

    @PostMapping(value={"/add"})
    public Result<JoaDemo> add(@RequestBody JoaDemo joaDemo) {
        Result result = new Result();
        try {
            this.joaDemoService.save((Object)joaDemo);
            result.success("\u6dfb\u52a0\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @PutMapping(value={"/edit"})
    public Result<JoaDemo> edit(@RequestBody JoaDemo joaDemo) {
        Result result = new Result();
        JoaDemo joaDemoEntity = (JoaDemo)this.joaDemoService.getById((Serializable)((Object)joaDemo.getId()));
        if (joaDemoEntity == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            boolean ok = this.joaDemoService.updateById((Object)joaDemo);
            if (ok) {
                result.success("\u4fee\u6539\u6210\u529f!");
            }
        }
        return result;
    }

    @DeleteMapping(value={"/delete"})
    public Result<JoaDemo> delete(@RequestParam(name="id", required=true) String id) {
        Result result = new Result();
        JoaDemo joaDemo = (JoaDemo)this.joaDemoService.getById((Serializable)((Object)id));
        if (joaDemo == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            boolean ok = this.joaDemoService.removeById((Serializable)((Object)id));
            if (ok) {
                result.success("\u5220\u9664\u6210\u529f!");
            }
        }
        return result;
    }

    @DeleteMapping(value={"/deleteBatch"})
    public Result<JoaDemo> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        Result result = new Result();
        if (ids == null || "".equals(ids.trim())) {
            result.error500("\u53c2\u6570\u4e0d\u8bc6\u522b\uff01");
        } else {
            this.joaDemoService.removeByIds(Arrays.asList(ids.split(",")));
            result.success("\u5220\u9664\u6210\u529f!");
        }
        return result;
    }

    @GetMapping(value={"/queryById"})
    public Result<JoaDemo> queryById(@RequestParam(name="id", required=true) String id) {
        Result result = new Result();
        JoaDemo joaDemo = (JoaDemo)this.joaDemoService.getById((Serializable)((Object)id));
        if (joaDemo == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            result.setResult((Object)joaDemo);
            result.setSuccess(true);
        }
        return result;
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, HttpServletResponse response) {
        QueryWrapper queryWrapper = null;
        try {
            String paramsStr = request.getParameter("paramsStr");
            if (oConvertUtils.isNotEmpty((Object)paramsStr)) {
                String deString = URLDecoder.decode(paramsStr, "UTF-8");
                JoaDemo joaDemo = (JoaDemo)JSON.parseObject((String)deString, JoaDemo.class);
                queryWrapper = QueryGenerator.initQueryWrapper((Object)joaDemo, (Map)request.getParameterMap());
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        ModelAndView mv = new ModelAndView((View)new JeecgEntityExcelView());
        List pageList = this.joaDemoService.list(queryWrapper);
        mv.addObject("fileName", (Object)"\u6d41\u7a0b\u6d4b\u8bd5\u5217\u8868");
        mv.addObject("entity", JoaDemo.class);
        mv.addObject("params", (Object)new ExportParams("\u6d41\u7a0b\u6d4b\u8bd5\u5217\u8868\u6570\u636e", "\u5bfc\u51fa\u4eba:Jeecg", "\u5bfc\u51fa\u4fe1\u606f"));
        mv.addObject("data", (Object)pageList);
        return mv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Iterator iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entity = iterator.next();
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                List listJoaDemos = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), JoaDemo.class, (ImportParams)params);
                for (JoaDemo joaDemoExcel : listJoaDemos) {
                    this.joaDemoService.save((Object)joaDemoExcel);
                }
                Result result = Result.ok((String)("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01\u6570\u636e\u884c\u6570:" + listJoaDemos.size()));
                return result;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Result result = Result.error((String)("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:" + e.getMessage()));
                return result;
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return Result.ok((String)"\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
    }
}

