/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.cas.util;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jeecg.modules.cas.util.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

/*
 * Exception performing whole class analysis ignored.
 */
public final class XmlUtils {
    private static final Logger log = LoggerFactory.getLogger(XmlUtils.class);

    public static Document newDocument(String xml) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        HashMap<String, Boolean> features = new HashMap<String, Boolean>();
        features.put("http://javax.xml.XMLConstants/feature/secure-processing", true);
        features.put("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        for (Map.Entry entry : features.entrySet()) {
            try {
                factory.setFeature((String)entry.getKey(), (Boolean)entry.getValue());
            }
            catch (ParserConfigurationException e) {
                log.warn("Failed setting XML feature {}: {}", entry.getKey(), (Object)e);
            }
        }
        factory.setNamespaceAware(true);
        try {
            return factory.newDocumentBuilder().parse(new InputSource(new StringReader(xml)));
        }
        catch (Exception e) {
            throw new RuntimeException("XML parsing error: " + e);
        }
    }

    public static XMLReader getXmlReader() {
        try {
            XMLReader reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            reader.setFeature("http://xml.org/sax/features/namespaces", true);
            reader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            return reader;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create XMLReader", e);
        }
    }

    public static List<String> getTextForElements(String xmlAsString, String element) {
        ArrayList<String> elements = new ArrayList<String>(2);
        XMLReader reader = XmlUtils.getXmlReader();
        1 handler = new /* Unavailable Anonymous Inner Class!! */;
        reader.setContentHandler((ContentHandler)handler);
        reader.setErrorHandler((ErrorHandler)handler);
        try {
            reader.parse(new InputSource(new StringReader(xmlAsString)));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return elements;
    }

    public static String getTextForElement(String xmlAsString, String element) {
        XMLReader reader = XmlUtils.getXmlReader();
        StringBuilder builder = new StringBuilder();
        2 handler = new /* Unavailable Anonymous Inner Class!! */;
        reader.setContentHandler((ContentHandler)handler);
        reader.setErrorHandler((ErrorHandler)handler);
        try {
            reader.parse(new InputSource(new StringReader(xmlAsString)));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return builder.toString();
    }

    public static Map<String, Object> extractCustomAttributes(String xml) {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        spf.setValidating(false);
        try {
            SAXParser saxParser = spf.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            CustomAttributeHandler handler = new CustomAttributeHandler(null);
            xmlReader.setContentHandler((ContentHandler)handler);
            xmlReader.parse(new InputSource(new StringReader(xml)));
            return handler.getAttributes();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public static void main(String[] args) {
        String result = "<cas:serviceResponse xmlns:cas='http://www.yale.edu/tp/cas'>\r\n    <cas:authenticationSuccess>\r\n        <cas:user>admin</cas:user>\r\n        <cas:attributes>\r\n            <cas:credentialType>UsernamePasswordCredential</cas:credentialType>\r\n            <cas:isFromNewLogin>true</cas:isFromNewLogin>\r\n            <cas:authenticationDate>2019-08-01T19:33:21.527+08:00[Asia/Shanghai]</cas:authenticationDate>\r\n            <cas:authenticationMethod>RestAuthenticationHandler</cas:authenticationMethod>\r\n            <cas:successfulAuthenticationHandlers>RestAuthenticationHandler</cas:successfulAuthenticationHandlers>\r\n            <cas:longTermAuthenticationRequestTokenUsed>false</cas:longTermAuthenticationRequestTokenUsed>\r\n        </cas:attributes>\r\n    </cas:authenticationSuccess>\r\n</cas:serviceResponse>";
        String errorRes = "<cas:serviceResponse xmlns:cas='http://www.yale.edu/tp/cas'>\r\n    <cas:authenticationFailure code=\"INVALID_TICKET\">\u672a\u80fd\u591f\u8bc6\u522b\u51fa\u76ee\u6807 &#39;ST-5-1g-9cNES6KXNRwq-GuRET103sm0-DESKTOP-VKLS8B3&#39;\u7968\u6839</cas:authenticationFailure>\r\n</cas:serviceResponse>";
        String error = XmlUtils.getTextForElement((String)errorRes, (String)"authenticationFailure");
        System.out.println("------" + error);
        String error2 = XmlUtils.getTextForElement((String)result, (String)"authenticationFailure");
        System.out.println("------" + error2);
        String principal = XmlUtils.getTextForElement((String)result, (String)"user");
        System.out.println("---principal---" + principal);
        Map attributes = XmlUtils.extractCustomAttributes((String)result);
        System.out.println("---attributes---" + attributes);
    }
}

