/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.append.xd_schedule.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.stream.Collectors;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.modules.append.xd_schedule.entity.XdSchedule;
import org.jeecg.modules.append.xd_schedule.mapper.XdScheduleMapper;
import org.jeecg.modules.append.xd_schedule.service.IXdScheduleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class XdScheduleServiceImpl
extends ServiceImpl<XdScheduleMapper, XdSchedule>
implements IXdScheduleService {
    private static final Logger log = LoggerFactory.getLogger(XdScheduleServiceImpl.class);
    @Autowired
    RedisUtil redisUtil;
    private List<XdSchedule> ScheduleList;
    private Date ScheduleListDate = new Date();

    public List<XdSchedule> getDays() {
        if (CollectionUtil.isEmpty((Collection)this.ScheduleList) || this.ScheduleListDate.getTime() < new Date().getTime()) {
            this.ScheduleList = this.list((Wrapper)new QueryWrapper().orderByAsc((Object)"day"));
            this.ScheduleListDate = DateUtils.getDate((long)(new Date().getTime() + 60000L));
        }
        return this.ScheduleList;
    }

    public List<XdSchedule> getDays(String weeknum) {
        this.getDays();
        List<XdSchedule> weekFilter = this.ScheduleList.stream().filter(o -> StrUtil.equals((CharSequence)(o.getWeeknum() + ""), (CharSequence)weeknum)).collect(Collectors.toList());
        return weekFilter;
    }

    public List<XdSchedule> getDays(Integer yyyyMM) {
        this.getDays();
        if (yyyyMM == null) {
            return this.ScheduleList;
        }
        return this.ScheduleList.stream().filter(d -> {
            String formatDate = DateUtils.formatDate((Date)d.getDay(), (String)"yyyyMM");
            return formatDate.equals(yyyyMM + "");
        }).collect(Collectors.toList());
    }

    public String getDateRange(String weeknum, String pattern, String span) {
        try {
            List weekFilter = this.getDays(weeknum);
            Date start = ((XdSchedule)weekFilter.get(0)).getDay();
            Date end = ((XdSchedule)weekFilter.get(weekFilter.size() - 1)).getDay();
            return String.format("%s %s %s", DateUtils.formatDate((Date)start, (String)pattern), span, DateUtils.formatDate((Date)end, (String)pattern));
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u5468\u65f6\u95f4\u8303\u56f4 : " + e.getMessage());
            return String.format("\u8bf7\u68c0\u67e5\u65f6\u95f4\u8868\u9884\u8bbe\u6570\u636e\u662f\u5426\u6b63\u786e\uff1a%s \u5468", weeknum);
        }
    }

    public void aotuData(String yyyy, String body) {
        if (StrUtil.isBlank((CharSequence)yyyy)) {
            throw new RuntimeException("\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        log.info("\u8bf7\u6c42\u83b7\u53d6\u5230\u7684body\u6570\u636e \uff1a " + body);
        JSONObject apiData = null;
        if (StrUtil.isNotBlank((CharSequence)body)) {
            try {
                apiData = JSON.parseObject((String)body);
            }
            catch (Exception e) {
                throw new RuntimeException("\u8282\u5047\u65e5\u7684\u6570\u636e\u6709\u8bef\uff01");
            }
        }
        int year = Convert.toInt((Object)yyyy);
        GregorianCalendar calendar = new GregorianCalendar();
        GregorianCalendar calendarEnd = new GregorianCalendar();
        calendar.set(1, year);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendarEnd.set(1, year);
        calendarEnd.set(2, 11);
        calendarEnd.set(5, 31);
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd");
        ArrayList addDays = Lists.newArrayList();
        while (calendar.getTime().getTime() <= calendarEnd.getTime().getTime()) {
            String weekNum;
            String week;
            Integer dayType;
            boolean isworking;
            Date date = calendar.getTime();
            String format = sf.format(date);
            int weekOfYear = calendar.get(3);
            int dayOfYear = calendar.get(6);
            int dayOfWeek = calendar.get(7);
            int month = calendar.get(2) + 1;
            boolean bl = isworking = dayOfWeek != 1 && dayOfWeek != 7;
            if (StrUtil.isNotBlank((CharSequence)body) && (dayType = apiData.getInteger(format)) != null) {
                if (dayType == 1) {
                    isworking = true;
                }
                if (dayType == 2) {
                    isworking = false;
                }
            }
            if (dayOfWeek == 1) {
                --weekOfYear;
            }
            yyyy = year + "";
            if (month == 12 && weekOfYear == 1) {
                yyyy = year + 1 + "";
            }
            if (month == 1 && weekOfYear > 50) {
                yyyy = year - 1 + "";
            }
            if (weekOfYear < 10) {
                week = String.format("%s\u5e740%s\u5468", yyyy, weekOfYear);
                weekNum = String.format("%s0%s", yyyy, weekOfYear);
            } else {
                week = String.format("%s\u5e74%s\u5468", yyyy, weekOfYear);
                weekNum = String.format("%s%s", yyyy, weekOfYear);
            }
            XdSchedule xdSchedule = new XdSchedule();
            xdSchedule.init();
            xdSchedule.setWeek(week);
            xdSchedule.setWeeknum(Convert.toInt((Object)weekNum));
            xdSchedule.setYear(Convert.toInt((Object)year));
            xdSchedule.setMonth(Convert.toInt((Object)month));
            if (dayOfWeek == 1) {
                xdSchedule.setDayofweek(Convert.toInt((Object)7));
            } else {
                xdSchedule.setDayofweek(Convert.toInt((Object)(dayOfWeek - 1)));
            }
            xdSchedule.setDay(date);
            xdSchedule.setCreateTime(new Date());
            xdSchedule.setIsworking(isworking ? "1" : "0");
            addDays.add(xdSchedule);
            ((Calendar)calendar).add(5, 1);
        }
        this.remove((Wrapper)new LambdaQueryWrapper().likeRight(XdSchedule::getYear, (Object)year));
        this.saveBatch((Collection)addDays);
    }
}

