/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import io.netty.util.internal.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.util.FillRuleUtil;
import org.jeecg.common.util.YouBianCodeUtil;
import org.jeecg.modules.system.entity.SysDepart;
import org.jeecg.modules.system.entity.SysDepartPermission;
import org.jeecg.modules.system.entity.SysDepartRole;
import org.jeecg.modules.system.entity.SysDepartRolePermission;
import org.jeecg.modules.system.entity.SysDepartRoleUser;
import org.jeecg.modules.system.entity.SysUserDepart;
import org.jeecg.modules.system.mapper.SysDepartMapper;
import org.jeecg.modules.system.mapper.SysDepartPermissionMapper;
import org.jeecg.modules.system.mapper.SysDepartRoleMapper;
import org.jeecg.modules.system.mapper.SysDepartRolePermissionMapper;
import org.jeecg.modules.system.mapper.SysDepartRoleUserMapper;
import org.jeecg.modules.system.mapper.SysUserDepartMapper;
import org.jeecg.modules.system.model.DepartIdModel;
import org.jeecg.modules.system.model.SysDepartTreeModel;
import org.jeecg.modules.system.service.ISysDepartService;
import org.jeecg.modules.system.util.FindsDepartsChildrenUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysDepartServiceImpl
extends ServiceImpl<SysDepartMapper, SysDepart>
implements ISysDepartService {
    @Autowired
    private SysUserDepartMapper userDepartMapper;
    @Autowired
    private SysDepartRoleMapper sysDepartRoleMapper;
    @Autowired
    private SysDepartPermissionMapper departPermissionMapper;
    @Autowired
    private SysDepartRolePermissionMapper departRolePermissionMapper;
    @Autowired
    private SysDepartRoleUserMapper departRoleUserMapper;

    public List<SysDepartTreeModel> queryMyDeptTreeList(String departIds) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        String[] codeArr = this.getMyDeptParentOrgCode(departIds);
        for (int i = 0; i < codeArr.length; ++i) {
            ((LambdaQueryWrapper)query.or()).likeRight(SysDepart::getOrgCode, (Object)codeArr[i]);
        }
        query.eq(SysDepart::getDelFlag, (Object)CommonConstant.DEL_FLAG_0.toString());
        query.orderByAsc(SysDepart::getDepartOrder);
        List listDepts = this.list((Wrapper)query);
        for (int i = 0; i < codeArr.length; ++i) {
            for (SysDepart dept : listDepts) {
                if (!dept.getOrgCode().equals(codeArr[i])) continue;
                dept.setParentId(null);
            }
        }
        List listResult = FindsDepartsChildrenUtil.wrapTreeDataToTreeList((List)listDepts);
        return listResult;
    }

    @Cacheable(value={"sys:cache:depart:alldata"})
    public List<SysDepartTreeModel> queryTreeList() {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysDepart::getDelFlag, (Object)CommonConstant.DEL_FLAG_0.toString());
        query.orderByAsc(SysDepart::getDepartOrder);
        List list = this.list((Wrapper)query);
        List listResult = FindsDepartsChildrenUtil.wrapTreeDataToTreeList((List)list);
        return listResult;
    }

    @Cacheable(value={"sys:cache:depart:allids"})
    public List<DepartIdModel> queryDepartIdTreeList() {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysDepart::getDelFlag, (Object)CommonConstant.DEL_FLAG_0.toString());
        query.orderByAsc(SysDepart::getDepartOrder);
        List list = this.list((Wrapper)query);
        List listResult = FindsDepartsChildrenUtil.wrapTreeDataToDepartIdTreeList((List)list);
        return listResult;
    }

    @Transactional
    public void saveDepartData(SysDepart sysDepart, String username) {
        if (sysDepart != null && username != null) {
            if (sysDepart.getParentId() == null) {
                sysDepart.setParentId("");
            }
            String s = UUID.randomUUID().toString().replace("-", "");
            sysDepart.setId(s);
            String parentId = sysDepart.getParentId();
            JSONObject formData = new JSONObject();
            formData.put("parentId", (Object)parentId);
            String[] codeArray = (String[])FillRuleUtil.executeRule((String)"org_num_role", (JSONObject)formData);
            sysDepart.setOrgCode(codeArray[0]);
            String orgType = codeArray[1];
            sysDepart.setOrgType(String.valueOf(orgType));
            sysDepart.setCreateTime(new Date());
            sysDepart.setDelFlag(CommonConstant.DEL_FLAG_0.toString());
            this.save((Object)sysDepart);
        }
    }

    private String[] generateOrgCode(String parentId) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        LambdaQueryWrapper query1 = new LambdaQueryWrapper();
        String[] strArray = new String[2];
        List departList = new ArrayList();
        String newOrgCode = "";
        String oldOrgCode = "";
        String orgType = "";
        if (StringUtil.isNullOrEmpty((String)parentId)) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)query1.eq(SysDepart::getParentId, (Object)"")).or()).isNull(SysDepart::getParentId);
            query1.orderByDesc(SysDepart::getOrgCode);
            departList = this.list((Wrapper)query1);
            if (departList == null || departList.size() == 0) {
                strArray[0] = YouBianCodeUtil.getNextYouBianCode(null);
                strArray[1] = "1";
                return strArray;
            }
            SysDepart depart = (SysDepart)departList.get(0);
            oldOrgCode = depart.getOrgCode();
            orgType = depart.getOrgType();
            newOrgCode = YouBianCodeUtil.getNextYouBianCode((String)oldOrgCode);
        } else {
            query.eq(SysDepart::getParentId, (Object)parentId);
            query.orderByDesc(SysDepart::getOrgCode);
            List parentList = this.list((Wrapper)query);
            SysDepart depart = (SysDepart)this.getById((Serializable)((Object)parentId));
            String parentCode = depart.getOrgCode();
            orgType = String.valueOf(Integer.valueOf(depart.getOrgType()) + 1);
            if (parentList == null || parentList.size() == 0) {
                newOrgCode = YouBianCodeUtil.getSubYouBianCode((String)parentCode, null);
            } else {
                String subCode = ((SysDepart)parentList.get(0)).getOrgCode();
                newOrgCode = YouBianCodeUtil.getSubYouBianCode((String)parentCode, (String)subCode);
            }
        }
        strArray[0] = newOrgCode;
        strArray[1] = orgType;
        return strArray;
    }

    @Transactional
    public Boolean updateDepartDataById(SysDepart sysDepart, String username) {
        if (sysDepart != null && username != null) {
            sysDepart.setUpdateTime(new Date());
            sysDepart.setUpdateBy(username);
            this.updateById((Object)sysDepart);
            return true;
        }
        return false;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteBatchWithChildren(List<String> ids) {
        ArrayList<String> idList = new ArrayList<String>();
        for (String id : ids) {
            idList.add(id);
            this.checkChildrenExists(id, idList);
        }
        this.removeByIds(idList);
        ArrayList<String> roleIdList = new ArrayList<String>();
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.select(new SFunction[]{SysDepartRole::getId}).in(SysDepartRole::getDepartId, idList);
        List depRoleList = this.sysDepartRoleMapper.selectList((Wrapper)query);
        for (SysDepartRole deptRole : depRoleList) {
            roleIdList.add(deptRole.getId());
        }
        this.userDepartMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysUserDepart::getDepId, idList));
        this.departPermissionMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysDepartPermission::getDepartId, idList));
        this.sysDepartRoleMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysDepartRole::getDepartId, idList));
        if (roleIdList != null && roleIdList.size() > 0) {
            this.departRolePermissionMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysDepartRolePermission::getRoleId, roleIdList));
            this.departRoleUserMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysDepartRoleUser::getDroleId, roleIdList));
        }
    }

    public List<String> getSubDepIdsByDepId(String departId) {
        return ((SysDepartMapper)this.baseMapper).getSubDepIdsByDepId(departId);
    }

    public List<String> getMySubDepIdsByDepId(String departIds) {
        String[] codeArr = this.getMyDeptParentOrgCode(departIds);
        return ((SysDepartMapper)this.baseMapper).getSubDepIdsByOrgCodes(codeArr);
    }

    public List<SysDepartTreeModel> searhBy(String keyWord, String myDeptSearch, String departIds) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        ArrayList<SysDepartTreeModel> newList = new ArrayList<SysDepartTreeModel>();
        if (!StringUtil.isNullOrEmpty((String)myDeptSearch)) {
            if (StringUtil.isNullOrEmpty((String)departIds)) {
                return newList;
            }
            String[] codeArr = this.getMyDeptParentOrgCode(departIds);
            for (int i = 0; i < codeArr.length; ++i) {
                ((LambdaQueryWrapper)query.or()).likeRight(SysDepart::getOrgCode, (Object)codeArr[i]);
            }
            query.eq(SysDepart::getDelFlag, (Object)CommonConstant.DEL_FLAG_0.toString());
        }
        query.like(SysDepart::getDepartName, (Object)keyWord);
        SysDepartTreeModel model = new SysDepartTreeModel();
        List departList = this.list((Wrapper)query);
        if (departList.size() > 0) {
            for (SysDepart depart : departList) {
                model = new SysDepartTreeModel(depart);
                model.setChildren(null);
                newList.add(model);
            }
            return newList;
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean delete(String id) {
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(id);
        this.checkChildrenExists(id, idList);
        boolean ok = this.removeByIds(idList);
        ArrayList<String> roleIdList = new ArrayList<String>();
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.select(new SFunction[]{SysDepartRole::getId}).in(SysDepartRole::getDepartId, idList);
        List depRoleList = this.sysDepartRoleMapper.selectList((Wrapper)query);
        for (SysDepartRole deptRole : depRoleList) {
            roleIdList.add(deptRole.getId());
        }
        this.userDepartMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysUserDepart::getDepId, idList));
        this.departPermissionMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysDepartPermission::getDepartId, idList));
        this.sysDepartRoleMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysDepartRole::getDepartId, idList));
        if (roleIdList != null && roleIdList.size() > 0) {
            this.departRolePermissionMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysDepartRolePermission::getRoleId, roleIdList));
            this.departRoleUserMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysDepartRoleUser::getDroleId, roleIdList));
        }
        return ok;
    }

    private void checkChildrenExists(String id, List<String> idList) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysDepart::getParentId, (Object)id);
        List departList = this.list((Wrapper)query);
        if (departList != null && departList.size() > 0) {
            for (SysDepart depart : departList) {
                idList.add(depart.getId());
                this.checkChildrenExists(depart.getId(), idList);
            }
        }
    }

    public List<SysDepart> queryUserDeparts(String userId) {
        return ((SysDepartMapper)this.baseMapper).queryUserDeparts(userId);
    }

    public List<SysDepart> queryDepartsByUsername(String username) {
        return ((SysDepartMapper)this.baseMapper).queryDepartsByUsername(username);
    }

    private String[] getMyDeptParentOrgCode(String departIds) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysDepart::getDelFlag, (Object)CommonConstant.DEL_FLAG_0.toString());
        query.in(SysDepart::getId, Arrays.asList(departIds.split(",")));
        query.orderByAsc(SysDepart::getOrgCode);
        List list = this.list((Wrapper)query);
        if (list == null || list.size() == 0) {
            return null;
        }
        String orgCode = this.getMyDeptParentNode(list);
        String[] codeArr = orgCode.split(",");
        return codeArr;
    }

    private String getMyDeptParentNode(List<SysDepart> list) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (SysDepart dept : list) {
            String code = dept.getOrgCode().substring(0, 3);
            if (map.containsKey(code)) {
                String mapCode = (String)map.get(code) + "," + dept.getOrgCode();
                map.put(code, mapCode);
                continue;
            }
            map.put(code, dept.getOrgCode());
        }
        StringBuffer parentOrgCode = new StringBuffer();
        for (String str : map.values()) {
            String[] arrStr = str.split(",");
            parentOrgCode.append(",").append(this.getMinLengthNode(arrStr));
        }
        return parentOrgCode.substring(1);
    }

    private String getMinLengthNode(String[] str) {
        int min = str[0].length();
        String orgCode = str[0];
        for (int i = 1; i < str.length; ++i) {
            if (str[i].length() > min) continue;
            min = str[i].length();
            orgCode = orgCode + "," + str[i];
        }
        return orgCode;
    }
}

