/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.xkcoding.justauth.AuthRequestFactory;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.request.AuthRequest;
import me.zhyd.oauth.utils.AuthStateUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.util.PasswordUtil;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysUser;
import org.jeecg.modules.system.service.ISysUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/thirdLogin"})
public class ThirdLoginController {
    private static final Logger log = LoggerFactory.getLogger(ThirdLoginController.class);
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private ISysBaseAPI sysBaseAPI;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private AuthRequestFactory factory;

    @RequestMapping(value={"/render/{source}"})
    public void render(@PathVariable(value="source") String source, HttpServletResponse response) throws IOException {
        log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165render\uff1a" + source);
        AuthRequest authRequest = this.factory.get(source);
        String authorizeUrl = authRequest.authorize(AuthStateUtils.createState());
        log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8ba4\u8bc1\u5730\u5740\uff1a" + authorizeUrl);
        response.sendRedirect(authorizeUrl);
    }

    @RequestMapping(value={"/{source}/callback"})
    public String login(@PathVariable(value="source") String source, AuthCallback callback, ModelMap modelMap) {
        log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165callback\uff1a" + source + " params\uff1a" + JSONObject.toJSONString((Object)callback));
        AuthRequest authRequest = this.factory.get(source);
        AuthResponse response = authRequest.login(callback);
        log.info(JSONObject.toJSONString((Object)response));
        Result result = new Result();
        if (response.getCode() == 2000) {
            JSONObject data = JSONObject.parseObject((String)JSONObject.toJSONString((Object)response.getData()));
            String username = data.getString("username");
            String avatar = data.getString("avatar");
            String uuid = data.getString("uuid");
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(SysUser::getThirdId, (Object)uuid);
            query.eq(SysUser::getThirdType, (Object)source);
            List thridList = this.sysUserService.list((Wrapper)query);
            SysUser user = null;
            if (thridList == null || thridList.size() == 0) {
                user = new SysUser();
                user.setActivitiSync(CommonConstant.ACT_SYNC_0);
                user.setDelFlag(CommonConstant.DEL_FLAG_0);
                user.setStatus(Integer.valueOf(1));
                user.setThirdId(uuid);
                user.setThirdType(source);
                user.setAvatar(avatar);
                user.setUsername(uuid);
                user.setRealname(username);
                String salt = oConvertUtils.randomGen((int)8);
                user.setSalt(salt);
                String passwordEncode = PasswordUtil.encrypt((String)user.getUsername(), (String)"123456", (String)salt);
                user.setPassword(passwordEncode);
                this.sysUserService.saveThirdUser(user);
            } else {
                user = (SysUser)thridList.get(0);
            }
            String token = JwtUtil.sign((String)user.getUsername(), (String)user.getPassword());
            this.redisUtil.set("prefix_user_token_" + token, (Object)token);
            this.redisUtil.expire("prefix_user_token_" + token, 28800L);
            modelMap.addAttribute("token", (Object)token);
        }
        result.setSuccess(false);
        result.setMessage("\u7b2c\u4e09\u65b9\u767b\u5f55\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        return "thirdLogin";
    }

    @RequestMapping(value={"/getLoginUser/{token}"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<JSONObject> getLoginUser(@PathVariable(value="token") String token) throws Exception {
        Result result = new Result();
        String username = JwtUtil.getUsername((String)token);
        SysUser sysUser = this.sysUserService.getUserByName(username);
        result = this.sysUserService.checkUserIsEffective(sysUser);
        if (!result.isSuccess()) {
            return result;
        }
        JSONObject obj = new JSONObject();
        obj.put("userInfo", (Object)sysUser);
        obj.put("token", (Object)token);
        result.setResult((Object)obj);
        result.setSuccess(true);
        result.setCode(Integer.valueOf(200));
        this.sysBaseAPI.addLog("\u7528\u6237\u540d: " + username + ",\u767b\u5f55\u6210\u529f[\u7b2c\u4e09\u65b9\u7528\u6237]\uff01", Integer.valueOf(1), null);
        return result;
    }
}

