/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.util.MD5Util;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysDepartPermission;
import org.jeecg.modules.system.entity.SysPermission;
import org.jeecg.modules.system.entity.SysPermissionDataRule;
import org.jeecg.modules.system.entity.SysRolePermission;
import org.jeecg.modules.system.model.SysPermissionTree;
import org.jeecg.modules.system.model.TreeModel;
import org.jeecg.modules.system.service.ISysDepartPermissionService;
import org.jeecg.modules.system.service.ISysPermissionDataRuleService;
import org.jeecg.modules.system.service.ISysPermissionService;
import org.jeecg.modules.system.service.ISysRolePermissionService;
import org.jeecg.modules.system.util.PermissionDataUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/permission"})
public class SysPermissionController {
    private static final Logger log = LoggerFactory.getLogger(SysPermissionController.class);
    @Autowired
    private ISysPermissionService sysPermissionService;
    @Autowired
    private ISysRolePermissionService sysRolePermissionService;
    @Autowired
    private ISysPermissionDataRuleService sysPermissionDataRuleService;
    @Autowired
    private ISysDepartPermissionService sysDepartPermissionService;

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public Result<List<SysPermissionTree>> list() {
        long start = System.currentTimeMillis();
        Result result = new Result();
        try {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(SysPermission::getDelFlag, (Object)CommonConstant.DEL_FLAG_0);
            query.orderByAsc(SysPermission::getSortNo);
            List list = this.sysPermissionService.list((Wrapper)query);
            ArrayList treeList = new ArrayList();
            this.getTreeList(treeList, list, null);
            result.setResult(treeList);
            result.setSuccess(true);
            log.info("======\u83b7\u53d6\u5168\u90e8\u83dc\u5355\u6570\u636e=====\u8017\u65f6:" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/getSystemMenuList"}, method={RequestMethod.GET})
    public Result<List<SysPermissionTree>> getSystemMenuList() {
        long start = System.currentTimeMillis();
        Result result = new Result();
        try {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(SysPermission::getMenuType, (Object)CommonConstant.MENU_TYPE_0);
            query.eq(SysPermission::getDelFlag, (Object)CommonConstant.DEL_FLAG_0);
            query.orderByAsc(SysPermission::getSortNo);
            List list = this.sysPermissionService.list((Wrapper)query);
            ArrayList<SysPermissionTree> sysPermissionTreeList = new ArrayList<SysPermissionTree>();
            for (SysPermission sysPermission : list) {
                SysPermissionTree sysPermissionTree = new SysPermissionTree(sysPermission);
                sysPermissionTreeList.add(sysPermissionTree);
            }
            result.setResult(sysPermissionTreeList);
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        log.info("======\u83b7\u53d6\u4e00\u7ea7\u83dc\u5355\u6570\u636e=====\u8017\u65f6:" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
        return result;
    }

    @RequestMapping(value={"/getSystemSubmenu"}, method={RequestMethod.GET})
    public Result<List<SysPermissionTree>> getSystemSubmenu(@RequestParam(value="parentId") String parentId) {
        Result result = new Result();
        try {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(SysPermission::getParentId, (Object)parentId);
            query.eq(SysPermission::getDelFlag, (Object)CommonConstant.DEL_FLAG_0);
            query.orderByAsc(SysPermission::getSortNo);
            List list = this.sysPermissionService.list((Wrapper)query);
            ArrayList<SysPermissionTree> sysPermissionTreeList = new ArrayList<SysPermissionTree>();
            for (SysPermission sysPermission : list) {
                SysPermissionTree sysPermissionTree = new SysPermissionTree(sysPermission);
                sysPermissionTreeList.add(sysPermissionTree);
            }
            result.setResult(sysPermissionTreeList);
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @GetMapping(value={"/getSystemSubmenuBatch"})
    public Result getSystemSubmenuBatch(@RequestParam(value="parentIds") String parentIds) {
        try {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            List<String> parentIdList = Arrays.asList(parentIds.split(","));
            query.in(SysPermission::getParentId, parentIdList);
            query.eq(SysPermission::getDelFlag, (Object)CommonConstant.DEL_FLAG_0);
            query.orderByAsc(SysPermission::getSortNo);
            List list = this.sysPermissionService.list((Wrapper)query);
            HashMap<String, ArrayList<SysPermissionTree>> listMap = new HashMap<String, ArrayList<SysPermissionTree>>();
            for (SysPermission item : list) {
                String pid = item.getParentId();
                if (!parentIdList.contains(pid)) continue;
                ArrayList<SysPermissionTree> mapList = (ArrayList<SysPermissionTree>)listMap.get(pid);
                if (mapList == null) {
                    mapList = new ArrayList<SysPermissionTree>();
                }
                mapList.add(new SysPermissionTree(item));
                listMap.put(pid, mapList);
            }
            return Result.ok(listMap);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)("\u6279\u91cf\u67e5\u8be2\u5b50\u83dc\u5355\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @RequestMapping(value={"/getUserPermissionByToken"}, method={RequestMethod.GET})
    public Result<?> getUserPermissionByToken(@RequestParam(name="token", required=true) String token) {
        Result result = new Result();
        try {
            if (oConvertUtils.isEmpty((Object)token)) {
                return Result.error((String)"TOKEN\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
            }
            log.info(" ------ \u901a\u8fc7\u4ee4\u724c\u83b7\u53d6\u7528\u6237\u62e5\u6709\u7684\u8bbf\u95ee\u83dc\u5355 ---- TOKEN ------ " + token);
            String username = JwtUtil.getUsername((String)token);
            List metaList = this.sysPermissionService.queryByUser(username);
            if (!PermissionDataUtil.hasIndexPage((List)metaList)) {
                SysPermission indexMenu = (SysPermission)this.sysPermissionService.list((Wrapper)new LambdaQueryWrapper().eq(SysPermission::getName, (Object)"\u9996\u9875")).get(0);
                metaList.add(0, indexMenu);
            }
            JSONObject json = new JSONObject();
            JSONArray menujsonArray = new JSONArray();
            this.getPermissionJsonArray(menujsonArray, metaList, null);
            JSONArray authjsonArray = new JSONArray();
            this.getAuthJsonArray(authjsonArray, metaList);
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(SysPermission::getDelFlag, (Object)CommonConstant.DEL_FLAG_0);
            query.eq(SysPermission::getMenuType, (Object)CommonConstant.MENU_TYPE_2);
            List allAuthList = this.sysPermissionService.list((Wrapper)query);
            JSONArray allauthjsonArray = new JSONArray();
            this.getAllAuthJsonArray(allauthjsonArray, allAuthList);
            json.put("menu", (Object)menujsonArray);
            json.put("auth", (Object)authjsonArray);
            json.put("allAuth", (Object)allauthjsonArray);
            result.setResult((Object)json);
            result.success("\u67e5\u8be2\u6210\u529f");
        }
        catch (Exception e) {
            result.error500("\u67e5\u8be2\u5931\u8d25:" + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public Result<SysPermission> add(@RequestBody SysPermission permission) {
        Result result = new Result();
        try {
            permission = PermissionDataUtil.intelligentProcessData((SysPermission)permission);
            this.sysPermissionService.addPermission(permission);
            result.success("\u6dfb\u52a0\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.PUT, RequestMethod.POST})
    public Result<SysPermission> edit(@RequestBody SysPermission permission) {
        Result result = new Result();
        try {
            permission = PermissionDataUtil.intelligentProcessData((SysPermission)permission);
            this.sysPermissionService.editPermission(permission);
            result.success("\u4fee\u6539\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.DELETE})
    public Result<SysPermission> delete(@RequestParam(name="id", required=true) String id) {
        Result result = new Result();
        try {
            this.sysPermissionService.deletePermission(id);
            result.success("\u5220\u9664\u6210\u529f!");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500(e.getMessage());
        }
        return result;
    }

    @RequestMapping(value={"/deleteBatch"}, method={RequestMethod.DELETE})
    public Result<SysPermission> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        Result result = new Result();
        try {
            String[] arr;
            for (String id : arr = ids.split(",")) {
                if (!oConvertUtils.isNotEmpty((Object)id)) continue;
                this.sysPermissionService.deletePermission(id);
            }
            result.success("\u5220\u9664\u6210\u529f!");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u5220\u9664\u6210\u529f!");
        }
        return result;
    }

    @RequestMapping(value={"/queryTreeList"}, method={RequestMethod.GET})
    public Result<Map<String, Object>> queryTreeList() {
        Result result = new Result();
        ArrayList<String> ids = new ArrayList<String>();
        try {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(SysPermission::getDelFlag, (Object)CommonConstant.DEL_FLAG_0);
            query.orderByAsc(SysPermission::getSortNo);
            List list = this.sysPermissionService.list((Wrapper)query);
            for (SysPermission sysPer : list) {
                ids.add(sysPer.getId());
            }
            ArrayList treeList = new ArrayList();
            this.getTreeModelList(treeList, list, null);
            HashMap resMap = new HashMap();
            resMap.put("treeList", treeList);
            resMap.put("ids", ids);
            result.setResult(resMap);
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/queryListAsync"}, method={RequestMethod.GET})
    public Result<List<TreeModel>> queryAsync(@RequestParam(name="pid", required=false) String parentId) {
        Result result = new Result();
        try {
            List list = this.sysPermissionService.queryListByParentId(parentId);
            if (list == null || list.size() <= 0) {
                result.error500("\u672a\u627e\u5230\u89d2\u8272\u4fe1\u606f");
            } else {
                result.setResult((Object)list);
                result.setSuccess(true);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/queryRolePermission"}, method={RequestMethod.GET})
    public Result<List<String>> queryRolePermission(@RequestParam(name="roleId", required=true) String roleId) {
        Result result = new Result();
        try {
            List list = this.sysRolePermissionService.list((Wrapper)new QueryWrapper().lambda().eq(SysRolePermission::getRoleId, (Object)roleId));
            result.setResult(list.stream().map(SysRolePermission2 -> String.valueOf(SysRolePermission2.getPermissionId())).collect(Collectors.toList()));
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/saveRolePermission"}, method={RequestMethod.POST})
    public Result<String> saveRolePermission(@RequestBody JSONObject json) {
        long start = System.currentTimeMillis();
        Result result = new Result();
        try {
            String roleId = json.getString("roleId");
            String permissionIds = json.getString("permissionIds");
            String lastPermissionIds = json.getString("lastpermissionIds");
            this.sysRolePermissionService.saveRolePermission(roleId, permissionIds, lastPermissionIds);
            result.success("\u4fdd\u5b58\u6210\u529f\uff01");
            log.info("======\u89d2\u8272\u6388\u6743\u6210\u529f=====\u8017\u65f6:" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
        }
        catch (Exception e) {
            result.error500("\u6388\u6743\u5931\u8d25\uff01");
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void getTreeList(List<SysPermissionTree> treeList, List<SysPermission> metaList, SysPermissionTree temp) {
        for (SysPermission permission : metaList) {
            String tempPid = permission.getParentId();
            SysPermissionTree tree = new SysPermissionTree(permission);
            if (temp == null && oConvertUtils.isEmpty((Object)tempPid)) {
                treeList.add(tree);
                if (tree.getIsLeaf()) continue;
                this.getTreeList(treeList, metaList, tree);
                continue;
            }
            if (temp == null || tempPid == null || !tempPid.equals(temp.getId())) continue;
            temp.getChildren().add(tree);
            if (tree.getIsLeaf()) continue;
            this.getTreeList(treeList, metaList, tree);
        }
    }

    private void getTreeModelList(List<TreeModel> treeList, List<SysPermission> metaList, TreeModel temp) {
        for (SysPermission permission : metaList) {
            String tempPid = permission.getParentId();
            TreeModel tree = new TreeModel(permission);
            if (temp == null && oConvertUtils.isEmpty((Object)tempPid)) {
                treeList.add(tree);
                if (tree.getIsLeaf()) continue;
                this.getTreeModelList(treeList, metaList, tree);
                continue;
            }
            if (temp == null || tempPid == null || !tempPid.equals(temp.getKey())) continue;
            temp.getChildren().add(tree);
            if (tree.getIsLeaf()) continue;
            this.getTreeModelList(treeList, metaList, tree);
        }
    }

    private void getAllAuthJsonArray(JSONArray jsonArray, List<SysPermission> allList) {
        JSONObject json = null;
        for (SysPermission permission : allList) {
            json = new JSONObject();
            json.put("action", (Object)permission.getPerms());
            json.put("status", (Object)permission.getStatus());
            json.put("type", (Object)permission.getPermsType());
            json.put("describe", (Object)permission.getName());
            jsonArray.add((Object)json);
        }
    }

    private void getAuthJsonArray(JSONArray jsonArray, List<SysPermission> metaList) {
        for (SysPermission permission : metaList) {
            if (permission.getMenuType() == null) continue;
            JSONObject json = null;
            if (!permission.getMenuType().equals(CommonConstant.MENU_TYPE_2) || !"1".equals(permission.getStatus())) continue;
            json = new JSONObject();
            json.put("action", (Object)permission.getPerms());
            json.put("type", (Object)permission.getPermsType());
            json.put("describe", (Object)permission.getName());
            jsonArray.add((Object)json);
        }
    }

    private void getPermissionJsonArray(JSONArray jsonArray, List<SysPermission> metaList, JSONObject parentJson) {
        for (SysPermission permission : metaList) {
            if (permission.getMenuType() == null) continue;
            String tempPid = permission.getParentId();
            JSONObject json = this.getPermissionJsonObject(permission);
            if (json == null) continue;
            if (parentJson == null && oConvertUtils.isEmpty((Object)tempPid)) {
                jsonArray.add((Object)json);
                if (permission.isLeaf()) continue;
                this.getPermissionJsonArray(jsonArray, metaList, json);
                continue;
            }
            if (parentJson == null || !oConvertUtils.isNotEmpty((Object)tempPid) || !tempPid.equals(parentJson.getString("id"))) continue;
            if (permission.getMenuType().equals(CommonConstant.MENU_TYPE_2)) {
                JSONObject metaJson = parentJson.getJSONObject("meta");
                if (metaJson.containsKey((Object)"permissionList")) {
                    metaJson.getJSONArray("permissionList").add((Object)json);
                    continue;
                }
                JSONArray permissionList = new JSONArray();
                permissionList.add((Object)json);
                metaJson.put("permissionList", (Object)permissionList);
                continue;
            }
            if (!permission.getMenuType().equals(CommonConstant.MENU_TYPE_1) && !permission.getMenuType().equals(CommonConstant.MENU_TYPE_0)) continue;
            if (parentJson.containsKey((Object)"children")) {
                parentJson.getJSONArray("children").add((Object)json);
            } else {
                JSONArray children = new JSONArray();
                children.add((Object)json);
                parentJson.put("children", (Object)children);
            }
            if (permission.isLeaf()) continue;
            this.getPermissionJsonArray(jsonArray, metaList, json);
        }
    }

    private JSONObject getPermissionJsonObject(SysPermission permission) {
        JSONObject json = new JSONObject();
        if (permission.getMenuType().equals(CommonConstant.MENU_TYPE_2)) {
            return null;
        }
        if (permission.getMenuType().equals(CommonConstant.MENU_TYPE_0) || permission.getMenuType().equals(CommonConstant.MENU_TYPE_1)) {
            json.put("id", (Object)permission.getId());
            if (permission.isRoute()) {
                json.put("route", (Object)"1");
            } else {
                json.put("route", (Object)"0");
            }
            if (this.isWWWHttpUrl(permission.getUrl())) {
                json.put("path", (Object)MD5Util.MD5Encode((String)permission.getUrl(), (String)"utf-8"));
            } else {
                json.put("path", (Object)permission.getUrl());
            }
            if (oConvertUtils.isNotEmpty((Object)permission.getComponentName())) {
                json.put("name", (Object)permission.getComponentName());
            } else {
                json.put("name", (Object)this.urlToRouteName(permission.getUrl()));
            }
            if (permission.isHidden()) {
                json.put("hidden", (Object)true);
            }
            if (permission.isAlwaysShow()) {
                json.put("alwaysShow", (Object)true);
            }
            json.put("component", (Object)permission.getComponent());
            JSONObject meta = new JSONObject();
            if (permission.isKeepAlive()) {
                meta.put("keepAlive", (Object)true);
            } else {
                meta.put("keepAlive", (Object)false);
            }
            if (permission.isInternalOrExternal()) {
                meta.put("internalOrExternal", (Object)true);
            } else {
                meta.put("internalOrExternal", (Object)false);
            }
            meta.put("title", (Object)permission.getName());
            if (oConvertUtils.isEmpty((Object)permission.getParentId())) {
                json.put("redirect", (Object)permission.getRedirect());
                if (oConvertUtils.isNotEmpty((Object)permission.getIcon())) {
                    meta.put("icon", (Object)permission.getIcon());
                }
            } else if (oConvertUtils.isNotEmpty((Object)permission.getIcon())) {
                meta.put("icon", (Object)permission.getIcon());
            }
            if (this.isWWWHttpUrl(permission.getUrl())) {
                meta.put("url", (Object)permission.getUrl());
            }
            json.put("meta", (Object)meta);
        }
        return json;
    }

    private boolean isWWWHttpUrl(String url) {
        return url != null && (url.startsWith("http://") || url.startsWith("https://") || url.startsWith("{{"));
    }

    private String urlToRouteName(String url) {
        if (oConvertUtils.isNotEmpty((Object)url)) {
            if (url.startsWith("/")) {
                url = url.substring(1);
            }
            url = url.replace("/", "-");
            url = url.replace(":", "@");
            return url;
        }
        return null;
    }

    @RequestMapping(value={"/getPermRuleListByPermId"}, method={RequestMethod.GET})
    public Result<List<SysPermissionDataRule>> getPermRuleListByPermId(SysPermissionDataRule sysPermissionDataRule) {
        List permRuleList = this.sysPermissionDataRuleService.getPermRuleListByPermId(sysPermissionDataRule.getPermissionId());
        Result result = new Result();
        result.setSuccess(true);
        result.setResult((Object)permRuleList);
        return result;
    }

    @RequestMapping(value={"/addPermissionRule"}, method={RequestMethod.POST})
    public Result<SysPermissionDataRule> addPermissionRule(@RequestBody SysPermissionDataRule sysPermissionDataRule) {
        Result result = new Result();
        try {
            sysPermissionDataRule.setCreateTime(new Date());
            this.sysPermissionDataRuleService.savePermissionDataRule(sysPermissionDataRule);
            result.success("\u6dfb\u52a0\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/editPermissionRule"}, method={RequestMethod.PUT, RequestMethod.POST})
    public Result<SysPermissionDataRule> editPermissionRule(@RequestBody SysPermissionDataRule sysPermissionDataRule) {
        Result result = new Result();
        try {
            this.sysPermissionDataRuleService.saveOrUpdate((Object)sysPermissionDataRule);
            result.success("\u66f4\u65b0\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/deletePermissionRule"}, method={RequestMethod.DELETE})
    public Result<SysPermissionDataRule> deletePermissionRule(@RequestParam(name="id", required=true) String id) {
        Result result = new Result();
        try {
            this.sysPermissionDataRuleService.deletePermissionDataRule(id);
            result.success("\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/queryPermissionRule"}, method={RequestMethod.GET})
    public Result<List<SysPermissionDataRule>> queryPermissionRule(SysPermissionDataRule sysPermissionDataRule) {
        Result result = new Result();
        try {
            List permRuleList = this.sysPermissionDataRuleService.queryPermissionRule(sysPermissionDataRule);
            result.setResult((Object)permRuleList);
            result.success("\u67e5\u8be2\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/queryDepartPermission"}, method={RequestMethod.GET})
    public Result<List<String>> queryDepartPermission(@RequestParam(name="departId", required=true) String departId) {
        Result result = new Result();
        try {
            List list = this.sysDepartPermissionService.list((Wrapper)new QueryWrapper().lambda().eq(SysDepartPermission::getDepartId, (Object)departId));
            result.setResult(list.stream().map(SysDepartPermission2 -> String.valueOf(SysDepartPermission2.getPermissionId())).collect(Collectors.toList()));
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/saveDepartPermission"}, method={RequestMethod.POST})
    public Result<String> saveDepartPermission(@RequestBody JSONObject json) {
        long start = System.currentTimeMillis();
        Result result = new Result();
        try {
            String departId = json.getString("departId");
            String permissionIds = json.getString("permissionIds");
            String lastPermissionIds = json.getString("lastpermissionIds");
            this.sysDepartPermissionService.saveDepartPermission(departId, permissionIds, lastPermissionIds);
            result.success("\u4fdd\u5b58\u6210\u529f\uff01");
            log.info("======\u90e8\u95e8\u6388\u6743\u6210\u529f=====\u8017\u65f6:" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
        }
        catch (Exception e) {
            result.error500("\u6388\u6743\u5931\u8d25\uff01");
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

