/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysLog;
import org.jeecg.modules.system.entity.SysRole;
import org.jeecg.modules.system.service.ISysLogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/log"})
public class SysLogController {
    private static final Logger log = LoggerFactory.getLogger(SysLogController.class);
    @Autowired
    private ISysLogService sysLogService;

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public Result<IPage<SysLog>> queryPageList(SysLog syslog, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result result = new Result();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)syslog, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        String keyWord = req.getParameter("keyWord");
        if (oConvertUtils.isNotEmpty((Object)keyWord)) {
            queryWrapper.like((Object)"log_content", (Object)keyWord);
        }
        IPage pageList = this.sysLogService.page((IPage)page, (Wrapper)queryWrapper);
        log.info("\u67e5\u8be2\u5f53\u524d\u9875\uff1a" + pageList.getCurrent());
        log.info("\u67e5\u8be2\u5f53\u524d\u9875\u6570\u91cf\uff1a" + pageList.getSize());
        log.info("\u67e5\u8be2\u7ed3\u679c\u6570\u91cf\uff1a" + pageList.getRecords().size());
        log.info("\u6570\u636e\u603b\u6570\uff1a" + pageList.getTotal());
        result.setSuccess(true);
        result.setResult((Object)pageList);
        return result;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.DELETE})
    public Result<SysLog> delete(@RequestParam(name="id", required=true) String id) {
        Result result = new Result();
        SysLog sysLog = (SysLog)this.sysLogService.getById((Serializable)((Object)id));
        if (sysLog == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            boolean ok = this.sysLogService.removeById((Serializable)((Object)id));
            if (ok) {
                result.success("\u5220\u9664\u6210\u529f!");
            }
        }
        return result;
    }

    @RequestMapping(value={"/deleteBatch"}, method={RequestMethod.DELETE})
    public Result<SysRole> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        Result result = new Result();
        if (ids == null || "".equals(ids.trim())) {
            result.error500("\u53c2\u6570\u4e0d\u8bc6\u522b\uff01");
        } else {
            if ("allclear".equals(ids)) {
                this.sysLogService.removeAll();
                result.success("\u6e05\u9664\u6210\u529f!");
            }
            this.sysLogService.removeByIds(Arrays.asList(ids.split(",")));
            result.success("\u5220\u9664\u6210\u529f!");
        }
        return result;
    }
}

