/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.aspect;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.jeecg.common.aspect.annotation.PermissionData;
import org.jeecg.common.system.util.JeecgDataAutorUtils;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.SysPermissionDataRuleModel;
import org.jeecg.common.system.vo.SysUserCacheInfo;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.aspect.UrlMatchEnum;
import org.jeecg.modules.system.entity.SysPermission;
import org.jeecg.modules.system.service.ISysPermissionDataRuleService;
import org.jeecg.modules.system.service.ISysPermissionService;
import org.jeecg.modules.system.service.ISysUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;

@Aspect
@Component
public class PermissionDataAspect {
    private static final Logger log = LoggerFactory.getLogger(PermissionDataAspect.class);
    @Autowired
    private ISysPermissionService sysPermissionService;
    @Autowired
    private ISysPermissionDataRuleService sysPermissionDataRuleService;
    @Autowired
    private ISysUserService sysUserService;

    @Pointcut(value="@annotation(org.jeecg.common.aspect.annotation.PermissionData)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object arround(ProceedingJoinPoint point) throws Throwable {
        HttpServletRequest request = SpringContextUtils.getHttpServletRequest();
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        PermissionData pd = method.getAnnotation(PermissionData.class);
        String component = pd.pageComponent();
        List currentSyspermission = null;
        if (oConvertUtils.isNotEmpty((Object)component)) {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(SysPermission::getDelFlag, (Object)0);
            query.eq(SysPermission::getComponent, (Object)component);
            currentSyspermission = this.sysPermissionService.list((Wrapper)query);
        } else {
            String regUrl;
            String requestMethod = request.getMethod();
            String requestPath = request.getRequestURI().substring(request.getContextPath().length());
            requestPath = this.filterUrl(requestPath);
            log.info("\u62e6\u622a\u8bf7\u6c42 >> " + requestPath + ";\u8bf7\u6c42\u7c7b\u578b >> " + requestMethod);
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(SysPermission::getMenuType, (Object)2);
            query.eq(SysPermission::getDelFlag, (Object)0);
            query.eq(SysPermission::getUrl, (Object)requestPath);
            currentSyspermission = this.sysPermissionService.list((Wrapper)query);
            if (currentSyspermission == null || currentSyspermission.size() == 0) {
                String userMatchUrl = UrlMatchEnum.getMatchResultByUrl((String)requestPath);
                LambdaQueryWrapper queryQserMatch = new LambdaQueryWrapper();
                queryQserMatch.eq(SysPermission::getMenuType, (Object)1);
                queryQserMatch.eq(SysPermission::getDelFlag, (Object)0);
                queryQserMatch.eq(SysPermission::getUrl, (Object)userMatchUrl);
                if (oConvertUtils.isNotEmpty((Object)userMatchUrl)) {
                    currentSyspermission = this.sysPermissionService.list((Wrapper)queryQserMatch);
                }
            }
            if ((currentSyspermission == null || currentSyspermission.size() == 0) && (regUrl = this.getRegexpUrl(requestPath)) != null) {
                currentSyspermission = this.sysPermissionService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPermission::getMenuType, (Object)2)).eq(SysPermission::getUrl, (Object)regUrl)).eq(SysPermission::getDelFlag, (Object)0));
            }
        }
        if (currentSyspermission != null && currentSyspermission.size() > 0) {
            String username = JwtUtil.getUserNameByToken((HttpServletRequest)request);
            List dataRules = new ArrayList();
            for (SysPermission sysPermission : currentSyspermission) {
                List temp = this.sysPermissionDataRuleService.queryPermissionDataRules(username, sysPermission.getId());
                if (temp == null || temp.size() <= 0) continue;
                dataRules = oConvertUtils.entityListToModelList((List)temp, SysPermissionDataRuleModel.class);
            }
            if (dataRules != null && dataRules.size() > 0) {
                JeecgDataAutorUtils.installDataSearchConditon((HttpServletRequest)request, dataRules);
                SysUserCacheInfo userinfo = this.sysUserService.getCacheUser(username);
                JeecgDataAutorUtils.installUserInfo((HttpServletRequest)request, (SysUserCacheInfo)userinfo);
            }
        }
        return point.proceed();
    }

    private String filterUrl(String requestPath) {
        String url = "";
        if (oConvertUtils.isNotEmpty((Object)requestPath)) {
            url = requestPath.replace("\\", "/");
            url = requestPath.replace("//", "/");
            if (url.indexOf("//") >= 0) {
                url = this.filterUrl(url);
            }
        }
        return url;
    }

    private String getJgAuthRequsetPath(HttpServletRequest request) {
        String queryString = request.getQueryString();
        String requestPath = request.getRequestURI();
        if (oConvertUtils.isNotEmpty((Object)queryString)) {
            requestPath = requestPath + "?" + queryString;
        }
        if (requestPath.indexOf("&") > -1) {
            requestPath = requestPath.substring(0, requestPath.indexOf("&"));
        }
        if (requestPath.indexOf("=") != -1) {
            requestPath = requestPath.indexOf(".do") != -1 ? requestPath.substring(0, requestPath.indexOf(".do") + 3) : requestPath.substring(0, requestPath.indexOf("?"));
        }
        requestPath = requestPath.substring(request.getContextPath().length() + 1);
        return this.filterUrl(requestPath);
    }

    private boolean moHuContain(List<String> list, String key) {
        for (String str : list) {
            if (!key.contains(str)) continue;
            return true;
        }
        return false;
    }

    private String getRegexpUrl(String url) {
        List list = this.sysPermissionService.queryPermissionUrlWithStar();
        if (list != null && list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                AntPathMatcher matcher = new AntPathMatcher();
                String p = (String)iterator.next();
                if (!matcher.match(p, url)) continue;
                return p;
            }
        }
        return null;
    }
}

