/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.shiro.authc.interceptor;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.OnlineAuth;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysPermission;
import org.jeecg.modules.system.service.ISysPermissionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class OnlineInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(OnlineInterceptor.class);
    @Autowired
    private ISysPermissionService sysPermissionService;
    private static final String ONLINE_FORM = "/online/cgform";
    private static final String[] ONLINE_TEST_PRE = new String[]{"/online/cgformErpList", "/online/cgformList", "/online/cgformTreeList"};

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        OnlineAuth onlineAuth;
        boolean anno = handler.getClass().isAssignableFrom(HandlerMethod.class);
        if (anno && (onlineAuth = (OnlineAuth)((HandlerMethod)handler).getMethodAnnotation(OnlineAuth.class)) != null) {
            String requestPath = request.getRequestURI().substring(request.getContextPath().length());
            requestPath = this.filterUrl(requestPath);
            String authKey = onlineAuth.value();
            String code = requestPath.substring(requestPath.lastIndexOf(authKey) + authKey.length());
            log.info("\u62e6\u622a\u8bf7\u6c42(" + request.getMethod() + ")\uff1a" + requestPath + ",");
            if ("form".equals(authKey) && "DELETE".equals(request.getMethod())) {
                code = code.substring(0, code.lastIndexOf("/"));
            }
            ArrayList<String> possibleUrl = new ArrayList<String>();
            for (String pre : ONLINE_TEST_PRE) {
                possibleUrl.add(pre + code);
            }
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(SysPermission::getDelFlag, (Object)0);
            query.in(SysPermission::getUrl, possibleUrl);
            List permissionList = this.sysPermissionService.list((Wrapper)query);
            String username = JwtUtil.getUserNameByToken((HttpServletRequest)request);
            if (permissionList == null || permissionList.size() == 0) {
                boolean hasPermission = this.sysPermissionService.hasPermission(username, ONLINE_FORM);
                if (!hasPermission) {
                    this.backError(response, authKey);
                    return false;
                }
            } else {
                boolean has = false;
                for (SysPermission p : permissionList) {
                    has = has || this.sysPermissionService.hasPermission(username, p);
                }
                if (!has) {
                    this.backError(response, authKey);
                    return false;
                }
            }
        }
        return true;
    }

    private String filterUrl(String requestPath) {
        String url = "";
        if (oConvertUtils.isNotEmpty((Object)requestPath)) {
            url = requestPath.replace("\\", "/");
            url = requestPath.replace("//", "/");
            if (url.indexOf("//") >= 0) {
                url = this.filterUrl(url);
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backError(HttpServletResponse response, String authKey) {
        PrintWriter writer = null;
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        response.setHeader("auth", "fail");
        try {
            writer = response.getWriter();
            if ("exportXls".equals(authKey)) {
                writer.print("");
            } else {
                Result result = Result.error((String)"\u65e0\u6743\u9650\u8bbf\u95ee(\u64cd\u4f5c)");
                writer.print(JSON.toJSON((Object)result));
            }
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }
}

