/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.ngalain.controller;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.vo.DictModel;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.ngalain.service.NgAlainService;
import org.jeecg.modules.system.service.ISysDictService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/ng-alain"})
public class NgAlainController {
    private static final Logger log = LoggerFactory.getLogger(NgAlainController.class);
    @Autowired
    private NgAlainService ngAlainService;
    @Autowired
    private ISysDictService sysDictService;

    @RequestMapping(value={"/getAppData"})
    @ResponseBody
    public JSONObject getAppData(HttpServletRequest request) throws Exception {
        String token = request.getHeader("X-Access-Token");
        JSONObject j = new JSONObject();
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        JSONObject userObjcet = new JSONObject();
        userObjcet.put("name", (Object)user.getUsername());
        userObjcet.put("avatar", (Object)user.getAvatar());
        userObjcet.put("email", (Object)user.getEmail());
        userObjcet.put("token", (Object)token);
        j.put("user", (Object)userObjcet);
        j.put("menu", (Object)this.ngAlainService.getMenu(user.getUsername()));
        JSONObject app = new JSONObject();
        app.put("name", (Object)"jeecg-boot-angular");
        app.put("description", (Object)"jeecg+ng-alain\u6574\u5408\u7248\u672c");
        j.put("app", (Object)app);
        return j;
    }

    @RequestMapping(value={"/getDictItems/{dictCode}"}, method={RequestMethod.GET})
    public Object getDictItems(@PathVariable String dictCode) {
        log.info(" dictCode : " + dictCode);
        Result result = new Result();
        List ls = null;
        try {
            ls = this.sysDictService.queryDictItemsByCode(dictCode);
            result.setSuccess(true);
            result.setResult((Object)ls);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
            return result;
        }
        ArrayList<JSONObject> dictlist = new ArrayList<JSONObject>();
        for (DictModel l : ls) {
            JSONObject dict = new JSONObject();
            try {
                dict.put("value", (Object)Integer.parseInt(l.getValue()));
            }
            catch (NumberFormatException e) {
                dict.put("value", (Object)l.getValue());
            }
            dict.put("label", (Object)l.getText());
            dictlist.add(dict);
        }
        return dictlist;
    }

    @RequestMapping(value={"/getDictItemsByTable/{table}/{key}/{value}"}, method={RequestMethod.GET})
    public Object getDictItemsByTable(@PathVariable String table, @PathVariable String key, @PathVariable String value) {
        return this.ngAlainService.getDictByTable(table, key, value);
    }
}

