/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config.mybatis;

import java.lang.reflect.Field;
import java.util.Date;
import java.util.Properties;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.oConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class MybatisInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(MybatisInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        Field[] fields;
        LoginUser sysUser;
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        String sqlId = mappedStatement.getId();
        log.debug("------sqlId------" + sqlId);
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        Object parameter = invocation.getArgs()[1];
        log.debug("------sqlCommandType------" + sqlCommandType);
        if (parameter == null) {
            return invocation.proceed();
        }
        if (SqlCommandType.INSERT == sqlCommandType) {
            sysUser = this.getLoginUser();
            for (Field field : fields = oConvertUtils.getAllFields((Object)parameter)) {
                log.debug("------field.name------" + field.getName());
                try {
                    if ("createBy".equals(field.getName())) {
                        field.setAccessible(true);
                        Object local_createBy = field.get(parameter);
                        field.setAccessible(false);
                        if ((local_createBy == null || local_createBy.equals("")) && sysUser != null) {
                            field.setAccessible(true);
                            field.set(parameter, sysUser.getUsername());
                            field.setAccessible(false);
                        }
                    }
                    if ("createTime".equals(field.getName())) {
                        field.setAccessible(true);
                        Object local_createDate = field.get(parameter);
                        field.setAccessible(false);
                        if (local_createDate == null || local_createDate.equals("")) {
                            field.setAccessible(true);
                            field.set(parameter, new Date());
                            field.setAccessible(false);
                        }
                    }
                    if (!"sysOrgCode".equals(field.getName())) continue;
                    field.setAccessible(true);
                    Object local_sysOrgCode = field.get(parameter);
                    field.setAccessible(false);
                    if (local_sysOrgCode != null && !local_sysOrgCode.equals("") || sysUser == null) continue;
                    field.setAccessible(true);
                    field.set(parameter, sysUser.getOrgCode());
                    field.setAccessible(false);
                }
                catch (Exception local_sysOrgCode) {
                    // empty catch block
                }
            }
        }
        if (SqlCommandType.UPDATE == sqlCommandType) {
            sysUser = this.getLoginUser();
            fields = null;
            if (parameter instanceof MapperMethod.ParamMap) {
                MapperMethod.ParamMap p = (MapperMethod.ParamMap)parameter;
                if ((parameter = p.containsKey((Object)"et") ? p.get((Object)"et") : p.get((Object)"param1")) == null) {
                    return invocation.proceed();
                }
                fields = oConvertUtils.getAllFields((Object)parameter);
            } else {
                fields = oConvertUtils.getAllFields((Object)parameter);
            }
            for (Field field : fields) {
                log.debug("------field.name------" + field.getName());
                try {
                    if ("updateBy".equals(field.getName()) && sysUser != null) {
                        field.setAccessible(true);
                        field.set(parameter, sysUser.getUsername());
                        field.setAccessible(false);
                    }
                    if (!"updateTime".equals(field.getName())) continue;
                    field.setAccessible(true);
                    field.set(parameter, new Date());
                    field.setAccessible(false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    private LoginUser getLoginUser() {
        LoginUser sysUser = null;
        try {
            sysUser = SecurityUtils.getSubject().getPrincipal() != null ? (LoginUser)SecurityUtils.getSubject().getPrincipal() : null;
        }
        catch (Exception e) {
            sysUser = null;
        }
        return sysUser;
    }
}

