/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config;

import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.mgt.DefaultSessionStorageEvaluator;
import org.apache.shiro.mgt.DefaultSubjectDAO;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SessionStorageEvaluator;
import org.apache.shiro.mgt.SubjectDAO;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.spring.LifecycleBeanPostProcessor;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.crazycake.shiro.IRedisManager;
import org.crazycake.shiro.RedisCacheManager;
import org.crazycake.shiro.RedisManager;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.shiro.authc.ShiroRealm;
import org.jeecg.modules.shiro.authc.aop.JwtFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.util.StringUtils;

@Configuration
public class ShiroConfig {
    private static final Logger log = LoggerFactory.getLogger(ShiroConfig.class);
    @Value(value="${jeecg.shiro.excludeUrls}")
    private String excludeUrls;
    @Value(value="${spring.redis.port}")
    private String port;
    @Value(value="${spring.redis.host}")
    private String host;
    @Value(value="${spring.redis.password}")
    private String redisPassword;

    @Bean(value={"shiroFilter"})
    public ShiroFilterFactoryBean shiroFilter(SecurityManager securityManager) {
        ShiroFilterFactoryBean shiroFilterFactoryBean = new ShiroFilterFactoryBean();
        shiroFilterFactoryBean.setSecurityManager(securityManager);
        LinkedHashMap<String, String> filterChainDefinitionMap = new LinkedHashMap<String, String>();
        if (oConvertUtils.isNotEmpty((Object)this.excludeUrls)) {
            String[] permissionUrl;
            for (String url : permissionUrl = this.excludeUrls.split(",")) {
                filterChainDefinitionMap.put(url, "anon");
            }
        }
        filterChainDefinitionMap.put("/cas/client/validateLogin", "anon");
        filterChainDefinitionMap.put("/sys/randomImage/**", "anon");
        filterChainDefinitionMap.put("/sys/checkCaptcha", "anon");
        filterChainDefinitionMap.put("/sys/login", "anon");
        filterChainDefinitionMap.put("/sys/mLogin", "anon");
        filterChainDefinitionMap.put("/sys/logout", "anon");
        filterChainDefinitionMap.put("/thirdLogin/**", "anon");
        filterChainDefinitionMap.put("/sys/getEncryptedString", "anon");
        filterChainDefinitionMap.put("/sys/sms", "anon");
        filterChainDefinitionMap.put("/sys/phoneLogin", "anon");
        filterChainDefinitionMap.put("/sys/user/checkOnlyUser", "anon");
        filterChainDefinitionMap.put("/sys/user/register", "anon");
        filterChainDefinitionMap.put("/sys/user/querySysUser", "anon");
        filterChainDefinitionMap.put("/sys/user/phoneVerification", "anon");
        filterChainDefinitionMap.put("/sys/user/passwordChange", "anon");
        filterChainDefinitionMap.put("/auth/2step-code", "anon");
        filterChainDefinitionMap.put("/sys/common/static/**", "anon");
        filterChainDefinitionMap.put("/sys/common/pdf/**", "anon");
        filterChainDefinitionMap.put("/generic/**", "anon");
        filterChainDefinitionMap.put("/", "anon");
        filterChainDefinitionMap.put("/doc.html", "anon");
        filterChainDefinitionMap.put("/**/*.js", "anon");
        filterChainDefinitionMap.put("/**/*.css", "anon");
        filterChainDefinitionMap.put("/**/*.html", "anon");
        filterChainDefinitionMap.put("/**/*.svg", "anon");
        filterChainDefinitionMap.put("/**/*.pdf", "anon");
        filterChainDefinitionMap.put("/**/*.jpg", "anon");
        filterChainDefinitionMap.put("/**/*.png", "anon");
        filterChainDefinitionMap.put("/**/*.ico", "anon");
        filterChainDefinitionMap.put("/**/*.ttf", "anon");
        filterChainDefinitionMap.put("/**/*.woff", "anon");
        filterChainDefinitionMap.put("/**/*.woff2", "anon");
        filterChainDefinitionMap.put("/druid/**", "anon");
        filterChainDefinitionMap.put("/swagger-ui.html", "anon");
        filterChainDefinitionMap.put("/swagger**/**", "anon");
        filterChainDefinitionMap.put("/webjars/**", "anon");
        filterChainDefinitionMap.put("/v2/**", "anon");
        filterChainDefinitionMap.put("/activiti/**", "anon");
        filterChainDefinitionMap.put("/diagram-viewer/**", "anon");
        filterChainDefinitionMap.put("/editor-app/**", "anon");
        filterChainDefinitionMap.put("/actuator/metrics/**", "anon");
        filterChainDefinitionMap.put("/actuator/httptrace/**", "anon");
        filterChainDefinitionMap.put("/actuator/redis/**", "anon");
        filterChainDefinitionMap.put("/big/screen/**", "anon");
        filterChainDefinitionMap.put("/test/jeecgDemo/html", "anon");
        filterChainDefinitionMap.put("/test/jeecgDemo/redis/**", "anon");
        filterChainDefinitionMap.put("/websocket/**", "anon");
        HashMap<String, JwtFilter> filterMap = new HashMap<String, JwtFilter>(1);
        filterMap.put("jwt", new JwtFilter());
        shiroFilterFactoryBean.setFilters(filterMap);
        filterChainDefinitionMap.put("/**", "jwt");
        shiroFilterFactoryBean.setUnauthorizedUrl("/sys/common/403");
        shiroFilterFactoryBean.setLoginUrl("/sys/common/403");
        shiroFilterFactoryBean.setFilterChainDefinitionMap(filterChainDefinitionMap);
        return shiroFilterFactoryBean;
    }

    @Bean(value={"securityManager"})
    public DefaultWebSecurityManager securityManager(ShiroRealm myRealm) {
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        securityManager.setRealm((Realm)myRealm);
        DefaultSubjectDAO subjectDAO = new DefaultSubjectDAO();
        DefaultSessionStorageEvaluator defaultSessionStorageEvaluator = new DefaultSessionStorageEvaluator();
        defaultSessionStorageEvaluator.setSessionStorageEnabled(false);
        subjectDAO.setSessionStorageEvaluator((SessionStorageEvaluator)defaultSessionStorageEvaluator);
        securityManager.setSubjectDAO((SubjectDAO)subjectDAO);
        securityManager.setCacheManager((CacheManager)this.redisCacheManager());
        return securityManager;
    }

    @Bean
    @DependsOn(value={"lifecycleBeanPostProcessor"})
    public DefaultAdvisorAutoProxyCreator defaultAdvisorAutoProxyCreator() {
        DefaultAdvisorAutoProxyCreator defaultAdvisorAutoProxyCreator = new DefaultAdvisorAutoProxyCreator();
        defaultAdvisorAutoProxyCreator.setProxyTargetClass(true);
        defaultAdvisorAutoProxyCreator.setUsePrefix(true);
        defaultAdvisorAutoProxyCreator.setAdvisorBeanNamePrefix("_no_advisor");
        return defaultAdvisorAutoProxyCreator;
    }

    @Bean
    public static LifecycleBeanPostProcessor lifecycleBeanPostProcessor() {
        return new LifecycleBeanPostProcessor();
    }

    @Bean
    public AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor(DefaultWebSecurityManager securityManager) {
        AuthorizationAttributeSourceAdvisor advisor = new AuthorizationAttributeSourceAdvisor();
        advisor.setSecurityManager((SecurityManager)securityManager);
        return advisor;
    }

    public RedisCacheManager redisCacheManager() {
        log.info("===============(1)\u521b\u5efa\u7f13\u5b58\u7ba1\u7406\u5668RedisCacheManager");
        RedisCacheManager redisCacheManager = new RedisCacheManager();
        redisCacheManager.setRedisManager((IRedisManager)this.redisManager());
        redisCacheManager.setPrincipalIdFieldName("id");
        redisCacheManager.setExpire(200000);
        return redisCacheManager;
    }

    @Bean
    public RedisManager redisManager() {
        log.info("===============(2)\u521b\u5efaRedisManager,\u8fde\u63a5Redis..URL= " + this.host + ":" + this.port);
        RedisManager redisManager = new RedisManager();
        redisManager.setHost(this.host);
        redisManager.setPort(oConvertUtils.getInt((String)this.port));
        redisManager.setTimeout(0);
        if (!StringUtils.isEmpty((Object)this.redisPassword)) {
            redisManager.setPassword(this.redisPassword);
        }
        return redisManager;
    }
}

