/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.activiti.web;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.editor.language.json.converter.BpmnJsonConverter;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ProcessDefinition;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.activiti.entity.ActNode;
import org.jeecg.modules.activiti.entity.ActZprocess;
import org.jeecg.modules.activiti.entity.ProcessNodeVo;
import org.jeecg.modules.activiti.service.Impl.ActBusinessServiceImpl;
import org.jeecg.modules.activiti.service.Impl.ActNodeServiceImpl;
import org.jeecg.modules.activiti.service.Impl.ActZprocessServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/activiti_process"})
@Transactional
public class ActivitiProcessController {
    private static final Logger log = LoggerFactory.getLogger(ActivitiProcessController.class);
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private ActZprocessServiceImpl actZprocessService;
    @Autowired
    private ActNodeServiceImpl actNodeService;
    @Autowired
    private ActBusinessServiceImpl actBusinessService;

    @RequestMapping(value={"/listData"})
    public Result listData(HttpServletRequest request) {
        log.info("-------------\u6d41\u7a0b\u5217\u8868-------------");
        String lcmc = request.getParameter("lcmc");
        String lckey = request.getParameter("lckey");
        String zx = request.getParameter("zx");
        String status = request.getParameter("status");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.orderByAsc(ActZprocess::getProcessKey)).orderByDesc(ActZprocess::getVersion);
        if (StrUtil.isNotBlank((CharSequence)lcmc)) {
            wrapper.like(ActZprocess::getName, (Object)lcmc);
        }
        if (StrUtil.isNotBlank((CharSequence)lckey)) {
            wrapper.like(ActZprocess::getProcessKey, (Object)lckey);
        }
        if (StrUtil.equals((CharSequence)zx, (CharSequence)"true")) {
            wrapper.eq(ActZprocess::getLatest, (Object)1);
        }
        if (StrUtil.isNotBlank((CharSequence)status)) {
            wrapper.eq(ActZprocess::getStatus, (Object)status);
        }
        List list = this.actZprocessService.list((Wrapper)wrapper);
        if (StrUtil.isNotBlank((CharSequence)request.getParameter("roles"))) {
            LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            List<String> roleByUserName = this.actNodeService.getRoleByUserName(sysUser.getUsername());
            list = list.stream().filter(p -> {
                String[] split;
                String roles = p.getRoles();
                if (StrUtil.isBlank((CharSequence)roles)) {
                    return true;
                }
                for (String role : split = roles.split(",")) {
                    if (!roleByUserName.contains(role)) continue;
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
        }
        return Result.ok((Object)list);
    }

    @RequestMapping(value={"/updateStatus"})
    public Result updateStatus(String id, Integer status) {
        ActZprocess actProcess = (ActZprocess)this.actZprocessService.getById((Serializable)((Object)id));
        if (status == 1) {
            String routeName = actProcess.getRouteName();
            String businessTable = actProcess.getBusinessTable();
            if (StrUtil.isBlank((CharSequence)routeName) || StrUtil.isBlank((CharSequence)businessTable)) {
                return Result.error((String)"\u672a\u8bbe\u7f6e\u5173\u8054\u8868\u5355\uff0c\u70b9\u51fb\u7f16\u8f91\u8bbe\u7f6e\u3002");
            }
            this.repositoryService.activateProcessDefinitionById(id, true, new Date());
        } else {
            this.repositoryService.suspendProcessDefinitionById(id, true, new Date());
        }
        actProcess.setStatus(status);
        this.actZprocessService.updateById(actProcess);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/delByIds"})
    public Result<Object> delByIds(String ids) {
        for (String id : ids.split(",")) {
            if (CollectionUtil.isNotEmpty(this.actBusinessService.findByProcDefId(id))) {
                return Result.error((String)"\u5305\u542b\u5df2\u53d1\u8d77\u7533\u8bf7\u7684\u6d41\u7a0b\uff0c\u65e0\u6cd5\u5220\u9664");
            }
            ActZprocess actProcess = (ActZprocess)this.actZprocessService.getById((Serializable)((Object)id));
            if (actProcess == null) {
                return Result.error((String)"\u8be5\u6570\u636e\u5df2\u5220\u9664\uff01");
            }
            if (actProcess.getVersion() == 1) {
                this.deleteNodeUsers(id);
            }
            this.repositoryService.deleteDeployment(actProcess.getDeploymentId(), true);
            this.actZprocessService.removeById((Serializable)((Object)id));
            this.actZprocessService.setLatestByProcessKey(actProcess.getProcessKey());
        }
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    public void deleteNodeUsers(String processId) {
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processId);
        List processes = bpmnModel.getProcesses();
        for (Process process : processes) {
            Collection elements = process.getFlowElements();
            for (FlowElement element : elements) {
                this.actNodeService.deleteByNodeId(element.getId());
            }
        }
    }

    @RequestMapping(value={"/convertToModel"})
    public Result convertToModel(String id) {
        ProcessDefinition pd = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(id).singleResult();
        InputStream bpmnStream = this.repositoryService.getResourceAsStream(pd.getDeploymentId(), pd.getResourceName());
        ActZprocess actProcess = (ActZprocess)this.actZprocessService.getById((Serializable)((Object)id));
        try {
            XMLInputFactory xif = XMLInputFactory.newInstance();
            InputStreamReader in = new InputStreamReader(bpmnStream, "UTF-8");
            XMLStreamReader xtr = xif.createXMLStreamReader(in);
            BpmnModel bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
            BpmnJsonConverter converter = new BpmnJsonConverter();
            ObjectNode modelNode = converter.convertToJson(bpmnModel);
            Model modelData = this.repositoryService.newModel();
            modelData.setKey(pd.getKey());
            modelData.setName(pd.getResourceName());
            ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
            modelObjectNode.put("name", actProcess.getName());
            modelObjectNode.put("revision", modelData.getVersion());
            modelObjectNode.put("description", actProcess.getDescription());
            modelData.setMetaInfo(modelObjectNode.toString());
            this.repositoryService.saveModel(modelData);
            this.repositoryService.addModelEditorSource(modelData.getId(), modelNode.toString().getBytes("utf-8"));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)"\u8f6c\u5316\u6d41\u7a0b\u4e3a\u6a21\u578b\u5931\u8d25");
        }
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @RequestMapping(value={"/updateInfo"}, method={RequestMethod.POST})
    public Result<Object> updateInfo(ActZprocess actProcess) {
        ProcessDefinition pd = this.repositoryService.getProcessDefinition(actProcess.getId());
        if (pd == null) {
            return Result.error((String)"\u6d41\u7a0b\u5b9a\u4e49\u4e0d\u5b58\u5728");
        }
        if (StrUtil.isNotBlank((CharSequence)actProcess.getCategoryId())) {
            this.repositoryService.setProcessDefinitionCategory(actProcess.getId(), actProcess.getCategoryId());
            this.repositoryService.setDeploymentCategory(pd.getDeploymentId(), actProcess.getCategoryId());
        }
        this.actZprocessService.updateById(actProcess);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @RequestMapping(value={"/getProcessNode"})
    public Result getProcessNode(String id) {
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(id);
        ArrayList<ProcessNodeVo> list = new ArrayList<ProcessNodeVo>();
        List processes = bpmnModel.getProcesses();
        if (processes == null || processes.size() == 0) {
            return Result.ok();
        }
        for (Process process : processes) {
            Collection elements = process.getFlowElements();
            for (FlowElement element : elements) {
                ProcessNodeVo node = new ProcessNodeVo();
                node.setId(element.getId());
                node.setTitle(element.getName());
                if (element instanceof StartEvent) {
                    node.setType(0);
                } else if (element instanceof UserTask) {
                    node.setType(1);
                    node.setUsers(this.actNodeService.findUserByNodeId(element.getId()));
                    node.setRoles(this.actNodeService.findRoleByNodeId(element.getId()));
                    node.setDepartments(this.actNodeService.findDepartmentByNodeId(element.getId()));
                    node.setChooseDepHeader(this.actNodeService.hasChooseDepHeader(element.getId()));
                    node.setChooseSponsor(this.actNodeService.hasChooseSponsor(element.getId()));
                } else {
                    if (!(element instanceof EndEvent)) continue;
                    node.setType(2);
                }
                list.add(node);
            }
        }
        list.sort(Comparator.comparing(ProcessNodeVo::getType));
        return Result.ok(list);
    }

    @RequestMapping(value={"/editNodeUser"}, method={RequestMethod.POST})
    public Result editNodeUser(String nodeId, String userIds, String roleIds, String departmentIds, Boolean chooseDepHeader, Boolean chooseSponsor) {
        ActNode actNode;
        ActNode actNode2;
        this.actNodeService.deleteByNodeId(nodeId);
        for (String userId : userIds.split(",")) {
            actNode2 = new ActNode();
            actNode2.setNodeId(nodeId);
            actNode2.setRelateId(userId);
            actNode2.setType(1);
            this.actNodeService.save(actNode2);
        }
        for (String roleId : roleIds.split(",")) {
            actNode2 = new ActNode();
            actNode2.setNodeId(nodeId);
            actNode2.setRelateId(roleId);
            actNode2.setType(0);
            this.actNodeService.save(actNode2);
        }
        for (String departmentId : departmentIds.split(",")) {
            actNode2 = new ActNode();
            actNode2.setNodeId(nodeId);
            actNode2.setRelateId(departmentId);
            actNode2.setType(2);
            this.actNodeService.save(actNode2);
        }
        if (chooseDepHeader != null && chooseDepHeader.booleanValue()) {
            actNode = new ActNode();
            actNode.setNodeId(nodeId);
            actNode.setType(4);
            this.actNodeService.save(actNode);
        }
        if (chooseSponsor != null && chooseSponsor.booleanValue()) {
            actNode = new ActNode();
            actNode.setNodeId(nodeId);
            actNode.setType(3);
            this.actNodeService.save(actNode);
        }
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"/getNextNode"}, method={RequestMethod.GET})
    @ApiOperation(value="\u901a\u8fc7\u5f53\u524d\u8282\u70b9\u5b9a\u4e49id\u83b7\u53d6\u4e0b\u4e00\u4e2a\u8282\u70b9")
    public Result getNextNode(@ApiParam(value="\u5f53\u524d\u8282\u70b9\u5b9a\u4e49id") String procDefId, @ApiParam(value="\u5f53\u524d\u8282\u70b9\u5b9a\u4e49id") String currActId) {
        ProcessNodeVo node = this.actZprocessService.getNextNode(procDefId, currActId);
        return Result.ok((Object)node);
    }

    @RequestMapping(value={"/getNode/{nodeId}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u901a\u8fc7\u8282\u70b9nodeId\u83b7\u53d6\u5ba1\u6279\u4eba")
    public Result getNode(@ApiParam(value="\u8282\u70b9nodeId") @PathVariable String nodeId) {
        ProcessNodeVo node = this.actZprocessService.getNode(nodeId);
        return Result.ok((Object)node);
    }
}

