/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.activiti.web;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.editor.language.json.converter.BpmnJsonConverter;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngineConfiguration;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ModelQuery;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.activiti.image.ProcessDiagramGenerator;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.modules.activiti.entity.ActZprocess;
import org.jeecg.modules.activiti.service.Impl.ActZprocessServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/activiti/models"})
public class ActivitiModelController {
    private static final Logger log = LoggerFactory.getLogger(ActivitiModelController.class);
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private ProcessEngineConfiguration processEngineConfiguration;
    @Autowired
    private TaskService taskService;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private ActZprocessServiceImpl actZprocessService;

    @RequestMapping(value={"/modelListData"})
    @ResponseBody
    public Result modelListData(HttpServletRequest request) {
        log.info("-------------\u6a21\u578b\u5217\u8868-------------");
        ModelQuery modelQuery = this.repositoryService.createModelQuery();
        String keyWord = request.getParameter("keyWord");
        if (StrUtil.isNotBlank((CharSequence)keyWord)) {
            modelQuery.modelNameLike("%" + keyWord + "%");
        }
        List models = ((ModelQuery)modelQuery.orderByCreateTime().desc()).list();
        return Result.ok((Object)models);
    }

    @RequestMapping(value={"/create"})
    public void newModel(HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException {
        try {
            Model model = this.repositoryService.newModel();
            int revision = 1;
            String name = request.getParameter("name");
            String description = request.getParameter("description");
            String key = request.getParameter("key");
            if (StrUtil.isBlank((CharSequence)name)) {
                name = "new-process";
            }
            if (StrUtil.isBlank((CharSequence)description)) {
                description = "description";
            }
            if (StrUtil.isBlank((CharSequence)key)) {
                key = "processKey";
            }
            ObjectNode modelNode = this.objectMapper.createObjectNode();
            modelNode.put("name", name);
            modelNode.put("description", description);
            modelNode.put("revision", revision);
            model.setName(name);
            model.setKey(key);
            model.setMetaInfo(modelNode.toString());
            this.repositoryService.saveModel(model);
            String id = model.getId();
            ObjectNode editorNode = this.objectMapper.createObjectNode();
            editorNode.put("id", "canvas");
            editorNode.put("resourceId", "canvas");
            ObjectNode stencilSetNode = this.objectMapper.createObjectNode();
            stencilSetNode.put("namespace", "http://b3mn.org/stencilset/bpmn2.0#");
            editorNode.put("stencilset", (JsonNode)stencilSetNode);
            this.repositoryService.addModelEditorSource(id, editorNode.toString().getBytes("utf-8"));
            response.sendRedirect(request.getContextPath() + "/activiti/modeler.html?modelId=" + id);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.info("\u6a21\u578b\u521b\u5efa\u5931\u8d25\uff01");
        }
    }

    @RequestMapping(value={"/delete/{id}"})
    @ResponseBody
    public Result deleteModel(@PathVariable(value="id") String id) {
        this.repositoryService.deleteModel(id);
        return Result.ok((String)"\u5220\u9664\u6210\u529f\u3002");
    }

    @RequestMapping(value={"/deployment/{id}"})
    @ResponseBody
    public Result deploy(@PathVariable(value="id") String id) {
        Model modelData = this.repositoryService.getModel(id);
        byte[] bytes = this.repositoryService.getModelEditorSource(modelData.getId());
        if (bytes == null) {
            return Result.error((String)"\u6a21\u578b\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u6210\u529f\u8bbe\u8ba1\u6d41\u7a0b\u5e76\u4fdd\u5b58");
        }
        try {
            JsonNode modelNode = new ObjectMapper().readTree(bytes);
            BpmnModel model = new BpmnJsonConverter().convertToBpmnModel(modelNode);
            if (model.getProcesses().size() == 0) {
                return Result.error((String)"\u6a21\u578b\u4e0d\u7b26\u8981\u6c42\uff0c\u8bf7\u81f3\u5c11\u8bbe\u8ba1\u4e00\u6761\u4e3b\u7ebf\u6d41\u7a0b");
            }
            byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(model);
            String processName = modelData.getName() + ".bpmn20.xml";
            Deployment deployment = this.repositoryService.createDeployment().name(modelData.getName()).addString(processName, new String(bpmnBytes, "UTF-8")).deploy();
            String metaInfo = modelData.getMetaInfo();
            JSONObject metaInfoMap = JSON.parseObject((String)metaInfo);
            List list = this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).list();
            for (ProcessDefinition pd : list) {
                ActZprocess actZprocess = new ActZprocess();
                actZprocess.setId(pd.getId());
                actZprocess.setName(modelData.getName());
                actZprocess.setProcessKey(modelData.getKey());
                actZprocess.setDeploymentId(deployment.getId());
                actZprocess.setDescription(metaInfoMap.getString("description"));
                actZprocess.setVersion(pd.getVersion());
                actZprocess.setDiagramName(pd.getDiagramResourceName());
                this.actZprocessService.setAllOldByProcessKey(modelData.getKey());
                actZprocess.setLatest(true);
                this.actZprocessService.save(actZprocess);
            }
        }
        catch (Exception e) {
            String err = e.toString();
            log.error(e.getMessage(), (Throwable)e);
            if (err.indexOf("NCName") > -1) {
                return Result.error((String)"\u90e8\u7f72\u5931\u8d25\uff1a\u6d41\u7a0b\u8bbe\u8ba1\u4e2d\u7684\u6d41\u7a0b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u4e3a\u6570\u5b57\u4ee5\u53ca\u7279\u6b8a\u5b57\u7b26\u5f00\u5934\uff01");
            }
            if (err.indexOf("PRIMARY") > -1) {
                return Result.error((String)"\u90e8\u7f72\u5931\u8d25\uff1a\u8be5\u6a21\u578b\u5df2\u53d1\u5e03\uff0ckey\u552f\u4e00\uff01");
            }
            return Result.error((String)"\u90e8\u7f72\u5931\u8d25\uff01");
        }
        return Result.ok((String)"\u90e8\u7f72\u6210\u529f");
    }

    @RequestMapping(value={"/getHighlightImg/{id}"}, method={RequestMethod.GET})
    public void getHighlightImg(@PathVariable String id, HttpServletResponse response) {
        InputStream inputStream = null;
        ProcessInstance pi = null;
        String picName = "";
        HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(id).singleResult();
        if (hpi.getEndTime() != null) {
            ProcessDefinition pd = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(hpi.getProcessDefinitionId()).singleResult();
            picName = pd.getDiagramResourceName();
            inputStream = this.repositoryService.getResourceAsStream(pd.getDeploymentId(), pd.getDiagramResourceName());
        } else {
            pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(id).singleResult();
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(pi.getProcessDefinitionId());
            ArrayList<String> highLightedActivities = new ArrayList<String>();
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(id)).list();
            for (Task task : tasks) {
                highLightedActivities.add(task.getTaskDefinitionKey());
            }
            ArrayList highLightedFlows = new ArrayList();
            ProcessDiagramGenerator diagramGenerator = this.processEngineConfiguration.getProcessDiagramGenerator();
            inputStream = diagramGenerator.generateDiagram(bpmnModel, "png", highLightedActivities, highLightedFlows, "\u5b8b\u4f53", "\u5b8b\u4f53", "\u5b8b\u4f53", null, 1.0);
            picName = pi.getName() + ".png";
        }
        try {
            response.setContentType("application/octet-stream;charset=UTF-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(picName, "UTF-8"));
            byte[] b = new byte[1024];
            int len = -1;
            while ((len = inputStream.read(b, 0, 1024)) != -1) {
                response.getOutputStream().write(b, 0, len);
            }
            response.flushBuffer();
        }
        catch (IOException e) {
            log.error(e.toString());
            throw new JeecgBootException("\u8bfb\u53d6\u6d41\u7a0b\u56fe\u7247\u5931\u8d25");
        }
    }

    @RequestMapping(value={"/export"}, method={RequestMethod.GET})
    public void exportResource(@RequestParam String id, HttpServletResponse response) {
        ProcessDefinition pd = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(id).singleResult();
        String resourceName = pd.getDiagramResourceName();
        InputStream inputStream = this.repositoryService.getResourceAsStream(pd.getDeploymentId(), resourceName);
        try {
            response.setContentType("application/octet-stream;charset=UTF-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(resourceName, "UTF-8"));
            byte[] b = new byte[1024];
            int len = -1;
            while ((len = inputStream.read(b, 0, 1024)) != -1) {
                response.getOutputStream().write(b, 0, len);
            }
            response.flushBuffer();
        }
        catch (IOException e) {
            log.error(e.toString());
        }
    }
}

