/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.activiti.web;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ManagementService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricIdentityLink;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.vo.ComboModel;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.activiti.entity.ActBusiness;
import org.jeecg.modules.activiti.entity.ActZprocess;
import org.jeecg.modules.activiti.entity.ActivitiConstant;
import org.jeecg.modules.activiti.entity.Assignee;
import org.jeecg.modules.activiti.entity.HistoricTaskVo;
import org.jeecg.modules.activiti.entity.TaskVo;
import org.jeecg.modules.activiti.service.Impl.ActBusinessServiceImpl;
import org.jeecg.modules.activiti.service.Impl.ActZprocessServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/actTask"})
@Transactional
public class ActTaskController {
    private static final Logger log = LoggerFactory.getLogger(ActTaskController.class);
    @Autowired
    private TaskService taskService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ManagementService managementService;
    @Autowired
    private ActZprocessServiceImpl actZprocessService;
    @Autowired
    private ActBusinessServiceImpl actBusinessService;
    @Autowired
    ISysBaseAPI sysBaseAPI;

    @RequestMapping(value={"/todoList"})
    public Result<Object> todoList(String name, String categoryId, Integer priority, HttpServletRequest request) {
        ArrayList list = new ArrayList();
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String userId = sysUser.getUsername();
        TaskQuery query = this.taskService.createTaskQuery().taskCandidateOrAssigned(userId);
        ((TaskQuery)query.orderByTaskPriority()).desc();
        ((TaskQuery)query.orderByTaskCreateTime()).desc();
        if (StrUtil.isNotBlank((CharSequence)name)) {
            query.taskNameLike("%" + name + "%");
        }
        if (StrUtil.isNotBlank((CharSequence)categoryId)) {
            query.taskCategory(categoryId);
        }
        if (priority != null) {
            query.taskPriority(priority);
        }
        String createTime_begin = request.getParameter("createTime_begin");
        String createTime_end = request.getParameter("createTime_end");
        if (StrUtil.isNotBlank((CharSequence)createTime_begin) && StrUtil.isNotBlank((CharSequence)createTime_end)) {
            DateTime start = DateUtil.parse((CharSequence)createTime_begin);
            DateTime end = DateUtil.parse((CharSequence)createTime_end);
            query.taskCreatedAfter((Date)start);
            query.taskCreatedBefore((Date)DateUtil.endOfDay((Date)end));
        }
        List taskList = query.list();
        taskList.forEach(e -> {
            TaskVo tv = new TaskVo((Task)e);
            if (StrUtil.isNotBlank((CharSequence)tv.getOwner())) {
                String realname = this.sysBaseAPI.getUserByName(tv.getOwner()).getRealname();
                tv.setOwner(realname);
            }
            List identityLinks = this.runtimeService.getIdentityLinksForProcessInstance(tv.getProcInstId());
            for (IdentityLink ik : identityLinks) {
                if (!"starter".equals(ik.getType()) || !StrUtil.isNotBlank((CharSequence)ik.getUserId())) continue;
                tv.setApplyer(this.sysBaseAPI.getUserByName(ik.getUserId()).getRealname());
            }
            ActZprocess actProcess = (ActZprocess)this.actZprocessService.getById((Serializable)((Object)tv.getProcDefId()));
            if (actProcess != null) {
                tv.setProcessName(actProcess.getName());
                tv.setRouteName(actProcess.getRouteName());
            }
            ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(tv.getProcInstId()).singleResult();
            tv.setBusinessKey(pi.getBusinessKey());
            ActBusiness actBusiness = (ActBusiness)this.actBusinessService.getById((Serializable)((Object)pi.getBusinessKey()));
            if (actBusiness != null) {
                tv.setTableId(actBusiness.getTableId());
                tv.setTableName(actBusiness.getTableName());
            }
            list.add(tv);
        });
        return Result.ok(list);
    }

    @RequestMapping(value={"/getBackList/{procInstId}"}, method={RequestMethod.GET})
    public Result<Object> getBackList(@PathVariable String procInstId) {
        ArrayList list = new ArrayList();
        List taskInstanceList = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(procInstId)).finished().list();
        taskInstanceList.forEach(e -> {
            HistoricTaskVo htv = new HistoricTaskVo((HistoricTaskInstance)e);
            list.add(htv);
        });
        LinkedHashSet set = new LinkedHashSet(list.size());
        ArrayList newList = new ArrayList();
        list.forEach(e -> {
            if (set.add(e.getName())) {
                newList.add(e);
            }
        });
        return Result.ok(newList);
    }

    @RequestMapping(value={"/back"}, method={RequestMethod.POST})
    public Result<Object> back(@ApiParam(value="\u4efb\u52a1id") @RequestParam String id, @ApiParam(value="\u6d41\u7a0b\u5b9e\u4f8bid") @RequestParam String procInstId, @ApiParam(value="\u610f\u89c1\u8bc4\u8bba") @RequestParam(required=false) String comment, @ApiParam(value="\u662f\u5426\u53d1\u9001\u7ad9\u5185\u6d88\u606f") @RequestParam(defaultValue="false") Boolean sendMessage, @ApiParam(value="\u662f\u5426\u53d1\u9001\u77ed\u4fe1\u901a\u77e5") @RequestParam(defaultValue="false") Boolean sendSms, @ApiParam(value="\u662f\u5426\u53d1\u9001\u90ae\u4ef6\u901a\u77e5") @RequestParam(defaultValue="false") Boolean sendEmail) {
        if (StrUtil.isBlank((CharSequence)comment)) {
            comment = "";
        }
        this.taskService.addComment(id, procInstId, comment);
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(procInstId).singleResult();
        this.runtimeService.deleteProcessInstance(procInstId, "backed");
        ActBusiness actBusiness = (ActBusiness)this.actBusinessService.getById((Serializable)((Object)pi.getBusinessKey()));
        actBusiness.setStatus(ActivitiConstant.STATUS_FINISH);
        actBusiness.setResult(ActivitiConstant.RESULT_FAIL);
        this.actBusinessService.updateById(actBusiness);
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        this.actZprocessService.sendMessage(sysUser, this.sysBaseAPI.getUserByName(actBusiness.getUserId()), "\u7533\u8bf7\u6d41\u7a0b\u5df2\u9a73\u56de", String.format("\u60a8\u7684 \u3010%s\u3011 \u7533\u8bf7\u5df2\u88ab\u9a73\u56de\uff01", actBusiness.getTitle()), sendMessage, sendSms, sendEmail);
        this.actBusinessService.insertHI_IDENTITYLINK(IdUtil.simpleUUID(), "actualExecutor", sysUser.getUsername(), id, procInstId);
        this.actBusinessService.updateBusinessStatus(actBusiness.getTableName(), actBusiness.getTableId(), "\u9a73\u56de");
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"/historicFlow/{id}"}, method={RequestMethod.GET})
    public Result<Object> historicFlow(@PathVariable String id) {
        ArrayList list = new ArrayList();
        List taskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(id)).orderByHistoricTaskInstanceEndTime().asc()).list();
        taskList.forEach(e -> {
            HistoricTaskVo htv = new HistoricTaskVo((HistoricTaskInstance)e);
            ArrayList<Assignee> assignees = new ArrayList<Assignee>();
            if (StrUtil.isNotBlank((CharSequence)htv.getAssignee())) {
                String assignee = this.sysBaseAPI.getUserByName(htv.getAssignee()).getRealname();
                String owner = this.sysBaseAPI.getUserByName(htv.getOwner()).getRealname();
                assignees.add(new Assignee(assignee + "(\u53d7" + owner + "\u59d4\u6258)", true));
            }
            List identityLinks = this.historyService.getHistoricIdentityLinksForTask(e.getId());
            String userId = this.actBusinessService.findUserIdByTypeAndTaskId("actualExecutor", e.getId());
            for (HistoricIdentityLink hik : identityLinks) {
                if (!"candidate".equals(hik.getType()) || !StrUtil.isNotBlank((CharSequence)hik.getUserId())) continue;
                String username = this.sysBaseAPI.getUserByName(hik.getUserId()).getRealname();
                Assignee assignee = new Assignee(username, false);
                if (StrUtil.isNotBlank((CharSequence)userId) && userId.equals(hik.getUserId())) {
                    assignee.setIsExecutor(true);
                }
                assignees.add(assignee);
            }
            htv.setAssignees(assignees);
            List comments = this.taskService.getTaskComments(htv.getId(), "comment");
            if (comments != null && comments.size() > 0) {
                htv.setComment(((Comment)comments.get(0)).getFullMessage());
            }
            list.add(htv);
        });
        return Result.ok(list);
    }

    @RequestMapping(value={"/pass"}, method={RequestMethod.POST})
    @ApiOperation(value="\u4efb\u52a1\u8282\u70b9\u5ba1\u6279\u901a\u8fc7")
    public Result<Object> pass(@ApiParam(value="\u4efb\u52a1id") @RequestParam String id, @ApiParam(value="\u6d41\u7a0b\u5b9e\u4f8bid") @RequestParam String procInstId, @ApiParam(value="\u4e0b\u4e2a\u8282\u70b9\u5ba1\u6279\u4eba") @RequestParam(required=false) String assignees, @ApiParam(value="\u4f18\u5148\u7ea7") @RequestParam(required=false) Integer priority, @ApiParam(value="\u610f\u89c1\u8bc4\u8bba") @RequestParam(required=false) String comment, @ApiParam(value="\u662f\u5426\u53d1\u9001\u7ad9\u5185\u6d88\u606f") @RequestParam(defaultValue="false") Boolean sendMessage, @ApiParam(value="\u662f\u5426\u53d1\u9001\u77ed\u4fe1\u901a\u77e5") @RequestParam(defaultValue="false") Boolean sendSms, @ApiParam(value="\u662f\u5426\u53d1\u9001\u90ae\u4ef6\u901a\u77e5") @RequestParam(defaultValue="false") Boolean sendEmail) {
        if (StrUtil.isBlank((CharSequence)comment)) {
            comment = "";
        }
        this.taskService.addComment(id, procInstId, comment);
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(procInstId).singleResult();
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(id)).singleResult();
        if (StrUtil.isNotBlank((CharSequence)task.getOwner()) && !"RESOLVED".equals(task.getDelegationState().toString())) {
            String oldAssignee = task.getAssignee();
            this.taskService.resolveTask(id);
            this.taskService.setAssignee(id, oldAssignee);
        }
        this.taskService.complete(id);
        ActBusiness actBusiness = (ActBusiness)this.actBusinessService.getById((Serializable)((Object)pi.getBusinessKey()));
        this.actBusinessService.updateBusinessStatus(actBusiness.getTableName(), actBusiness.getTableId(), "\u5ba1\u6279\u4e2d-" + task.getName());
        task.getName();
        LoginUser loginUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(procInstId)).list();
        if (tasks != null && tasks.size() > 0) {
            for (Task t : tasks) {
                if (StrUtil.isBlank((CharSequence)assignees)) {
                    List<LoginUser> users = this.actZprocessService.getNode(t.getTaskDefinitionKey()).getUsers();
                    if (users == null || users.size() == 0) {
                        this.runtimeService.deleteProcessInstance(procInstId, "canceled-\u5ba1\u6279\u8282\u70b9\u672a\u5206\u914d\u5ba1\u6279\u4eba\uff0c\u6d41\u7a0b\u81ea\u52a8\u4e2d\u65ad\u53d6\u6d88");
                        actBusiness.setStatus(ActivitiConstant.STATUS_CANCELED);
                        actBusiness.setResult(ActivitiConstant.RESULT_TO_SUBMIT);
                        this.actBusinessService.updateById(actBusiness);
                        this.actBusinessService.updateBusinessStatus(actBusiness.getTableName(), actBusiness.getTableId(), "\u5ba1\u6279\u5f02\u5e38-" + task.getName() + "-\u5ba1\u6279\u8282\u70b9\u672a\u5206\u914d\u5ba1\u6279\u4eba\uff0c\u6d41\u7a0b\u81ea\u52a8\u4e2d\u65ad\u53d6\u6d88");
                        break;
                    }
                    List<String> list = this.actBusinessService.selectIRunIdentity(t.getId(), "candidate");
                    if (list != null && list.size() != 0) continue;
                    for (LoginUser user : users) {
                        this.taskService.addCandidateUser(t.getId(), user.getId());
                        this.actZprocessService.sendActMessage(loginUser, user, actBusiness, task.getName(), sendMessage, sendSms, sendEmail);
                    }
                    this.taskService.setPriority(t.getId(), task.getPriority());
                    continue;
                }
                List<String> list = this.actBusinessService.selectIRunIdentity(t.getId(), "candidate");
                if (list != null && list.size() != 0) continue;
                for (String assignee : assignees.split(",")) {
                    this.taskService.addCandidateUser(t.getId(), assignee);
                    LoginUser user = this.sysBaseAPI.getUserByName(assignee);
                    this.actZprocessService.sendActMessage(loginUser, user, actBusiness, task.getName(), sendMessage, sendSms, sendEmail);
                    this.taskService.setPriority(t.getId(), priority.intValue());
                }
            }
        } else {
            actBusiness.setStatus(ActivitiConstant.STATUS_FINISH);
            actBusiness.setResult(ActivitiConstant.RESULT_PASS);
            this.actBusinessService.updateById(actBusiness);
            LoginUser user = this.sysBaseAPI.getUserByName(actBusiness.getUserId());
            this.actZprocessService.sendMessage(loginUser, user, "\u7533\u8bf7\u6d41\u7a0b\u5df2\u901a\u8fc7", String.format("\u60a8\u7684 \u3010%s\u3011 \u7533\u8bf7\u5df2\u901a\u8fc7\uff01", actBusiness.getTitle()), sendMessage, sendSms, sendEmail);
            this.actBusinessService.updateBusinessStatus(actBusiness.getTableName(), actBusiness.getTableId(), "\u5ba1\u6279\u901a\u8fc7");
        }
        this.actBusinessService.insertHI_IDENTITYLINK(IdUtil.simpleUUID(), "actualExecutor", loginUser.getUsername(), id, procInstId);
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"/delegate"}, method={RequestMethod.POST})
    @ApiOperation(value="\u59d4\u6258\u4ed6\u4eba\u4ee3\u529e")
    public Result<Object> delegate(@ApiParam(value="\u4efb\u52a1id") @RequestParam String id, @ApiParam(value="\u59d4\u6258\u7528\u6237id") @RequestParam String userId, @ApiParam(value="\u6d41\u7a0b\u5b9e\u4f8bid") @RequestParam String procInstId, @ApiParam(value="\u610f\u89c1\u8bc4\u8bba") @RequestParam(required=false) String comment, @ApiParam(value="\u662f\u5426\u53d1\u9001\u7ad9\u5185\u6d88\u606f") @RequestParam(defaultValue="false") Boolean sendMessage, @ApiParam(value="\u662f\u5426\u53d1\u9001\u77ed\u4fe1\u901a\u77e5") @RequestParam(defaultValue="false") Boolean sendSms, @ApiParam(value="\u662f\u5426\u53d1\u9001\u90ae\u4ef6\u901a\u77e5") @RequestParam(defaultValue="false") Boolean sendEmail) {
        if (StrUtil.isBlank((CharSequence)comment)) {
            comment = "";
        }
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        this.taskService.addComment(id, procInstId, comment);
        this.taskService.delegateTask(id, userId);
        this.taskService.setOwner(id, sysUser.getUsername());
        this.actZprocessService.sendMessage(sysUser, this.sysBaseAPI.getUserByName(userId), "\u88ab\u59d4\u6258\u5f85\u5ba1\u6279", String.format("\u60a8\u6709\u4e00\u4e2a\u6765\u81ea %s \u7684\u59d4\u6258\u9700\u8981\u5904\u7406\uff01", sysUser.getRealname()), sendMessage, sendSms, sendEmail);
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"/backToTask"}, method={RequestMethod.POST})
    @ApiOperation(value="\u4efb\u52a1\u8282\u70b9\u5ba1\u6279\u9a73\u56de\u81f3\u6307\u5b9a\u5386\u53f2\u8282\u70b9")
    public Result<Object> backToTask(@ApiParam(value="\u4efb\u52a1id") @RequestParam String id, @ApiParam(value="\u9a73\u56de\u6307\u5b9a\u8282\u70b9key") @RequestParam String backTaskKey, @ApiParam(value="\u6d41\u7a0b\u5b9e\u4f8bid") @RequestParam String procInstId, @ApiParam(value="\u6d41\u7a0b\u5b9a\u4e49id") @RequestParam String procDefId, @ApiParam(value="\u539f\u8282\u70b9\u5ba1\u6279\u4eba") @RequestParam(required=false) String assignees, @ApiParam(value="\u4f18\u5148\u7ea7") @RequestParam(required=false) Integer priority, @ApiParam(value="\u610f\u89c1\u8bc4\u8bba") @RequestParam(required=false) String comment, @ApiParam(value="\u662f\u5426\u53d1\u9001\u7ad9\u5185\u6d88\u606f") @RequestParam(defaultValue="false") Boolean sendMessage, @ApiParam(value="\u662f\u5426\u53d1\u9001\u77ed\u4fe1\u901a\u77e5") @RequestParam(defaultValue="false") Boolean sendSms, @ApiParam(value="\u662f\u5426\u53d1\u9001\u90ae\u4ef6\u901a\u77e5") @RequestParam(defaultValue="false") Boolean sendEmail) {
        if (StrUtil.isBlank((CharSequence)comment)) {
            comment = "";
        }
        LoginUser loginUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        this.taskService.addComment(id, procInstId, comment);
        ProcessDefinitionEntity definition = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(procDefId);
        ActivityImpl hisActivity = definition.findActivity(backTaskKey);
        this.managementService.executeCommand((Command)new JumpTask(procInstId, hisActivity.getId()));
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(procInstId)).list();
        if (tasks != null && tasks.size() > 0) {
            tasks.forEach(e -> {
                for (String assignee : assignees.split(",")) {
                    this.taskService.addCandidateUser(e.getId(), assignee);
                    this.actZprocessService.sendMessage(loginUser, this.sysBaseAPI.getUserByName(assignee), "\u5f85\u5ba1\u6279", "\u60a8\u6709\u4e00\u4e2a\u4efb\u52a1\u5f85\u5ba1\u6279\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\uff01", sendMessage, sendSms, sendEmail);
                }
                if (priority != null) {
                    this.taskService.setPriority(e.getId(), priority.intValue());
                }
            });
        }
        this.actBusinessService.insertHI_IDENTITYLINK(IdUtil.simpleUUID(), "actualExecutor", loginUser.getUsername(), id, procInstId);
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"/doneList"})
    public Result<Object> doneList(String name, String categoryId, Integer priority, HttpServletRequest req) {
        ArrayList list = new ArrayList();
        LoginUser loginUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String userId = loginUser.getUsername();
        HistoricTaskInstanceQuery query = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().or()).taskCandidateUser(userId)).taskAssignee(userId)).endOr()).finished();
        ((HistoricTaskInstanceQuery)query.orderByTaskCreateTime()).desc();
        if (StrUtil.isNotBlank((CharSequence)name)) {
            query.taskNameLike("%" + name + "%");
        }
        if (StrUtil.isNotBlank((CharSequence)categoryId)) {
            query.taskCategory(categoryId);
        }
        if (priority != null) {
            query.taskPriority(priority);
        }
        List taskList = query.list();
        List allUser = this.sysBaseAPI.queryAllUser();
        Map<String, String> userMap = allUser.stream().collect(Collectors.toMap(ComboModel::getUsername, ComboModel::getTitle));
        taskList.forEach(e -> {
            ActZprocess actProcess;
            HistoricTaskVo htv = new HistoricTaskVo((HistoricTaskInstance)e);
            if (StrUtil.isNotBlank((CharSequence)htv.getOwner())) {
                htv.setOwner((String)userMap.get(htv.getOwner()));
            }
            List identityLinks = this.historyService.getHistoricIdentityLinksForProcessInstance(htv.getProcInstId());
            for (HistoricIdentityLink hik : identityLinks) {
                if (!"starter".equals(hik.getType()) || !StrUtil.isNotBlank((CharSequence)hik.getUserId())) continue;
                htv.setApplyer((String)userMap.get(hik.getUserId()));
            }
            List comments = this.taskService.getTaskComments(htv.getId(), "comment");
            if (comments != null && comments.size() > 0) {
                htv.setComment(((Comment)comments.get(0)).getFullMessage());
            }
            if ((actProcess = (ActZprocess)this.actZprocessService.getById((Serializable)((Object)htv.getProcDefId()))) != null) {
                htv.setProcessName(actProcess.getName());
                htv.setRouteName(actProcess.getRouteName());
            }
            HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(htv.getProcInstId()).singleResult();
            htv.setBusinessKey(hpi.getBusinessKey());
            ActBusiness actBusiness = (ActBusiness)this.actBusinessService.getById((Serializable)((Object)hpi.getBusinessKey()));
            if (actBusiness != null) {
                htv.setTableId(actBusiness.getTableId());
                htv.setTableName(actBusiness.getTableName());
            }
            list.add(htv);
        });
        return Result.ok(list);
    }

    @RequestMapping(value={"/deleteHistoric/{ids}"}, method={RequestMethod.POST})
    public Result<Object> deleteHistoric(@PathVariable String ids) {
        for (String id : ids.split(",")) {
            this.historyService.deleteHistoricTaskInstance(id);
        }
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
    }

    public class JumpTask
    implements Command<ExecutionEntity> {
        private String procInstId;
        private String activityId;

        public JumpTask(String procInstId, String activityId) {
            this.procInstId = procInstId;
            this.activityId = activityId;
        }

        public ExecutionEntity execute(CommandContext commandContext) {
            ExecutionEntity executionEntity = commandContext.getExecutionEntityManager().findExecutionById(this.procInstId);
            executionEntity.destroyScope("backed");
            ProcessDefinitionImpl processDefinition = executionEntity.getProcessDefinition();
            ActivityImpl activity = processDefinition.findActivity(this.activityId);
            executionEntity.executeActivity((PvmActivity)activity);
            return executionEntity;
        }
    }
}

